/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.runtime;

import com.kingdee.bos.web.anole.runtime.DeviceCapsConfig;
import com.kingdee.bos.web.anole.utils.RegEx;
import java.util.Iterator;
import java.util.Map;

public class UserAgent {
    private String platform = "Unknown";
    private String browser = "Unknown";
    private String version = "0";
    private int majorversion = 0;
    private float minorversion = 0.0f;
    private boolean beta = false;
    private boolean mobileDevice = false;
    private boolean win32 = false;
    private boolean win16 = false;

    public UserAgent(String agent, DeviceCapsConfig deviceCapsConfig) {
        this.analyseUserAgent(agent, deviceCapsConfig.getPlatforms(), deviceCapsConfig.getBits(), deviceCapsConfig.getDevices());
    }

    public boolean isWin16() {
        return this.win16;
    }

    public boolean isWin32() {
        return this.win32;
    }

    public boolean isMobileDevice() {
        return this.mobileDevice;
    }

    public boolean isBeta() {
        return this.beta;
    }

    public String getBrowser() {
        return this.browser;
    }

    public int getMajorversion() {
        return this.majorversion;
    }

    public float getMinorversion() {
        return this.minorversion;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getVersion() {
        return this.version;
    }

    private void analyseUserAgent(String agent, Map platforms, Map bits, Map devices) {
        this.platform = this.locateInMap(agent, platforms);
        String bit = this.locateInMap(agent, bits);
        if (bit.equals("win32")) {
            this.win32 = true;
        }
        if (bit.equals("win16")) {
            this.win16 = true;
        }
        this.locateDevice(agent, devices);
        if (!RegEx.match("Win[^(CE)]+|Mac|UNIX|WebTV", this.platform)) {
            this.mobileDevice = true;
        }
    }

    private void locateDevice(String agent, Map devices) {
        if (!devices.isEmpty()) {
            Iterator values = devices.values().iterator();
            Iterator keys = devices.keySet().iterator();
            while (values.hasNext()) {
                String strValue = (String)values.next();
                String strKey = (String)keys.next();
                String[] matches = RegEx.matchGroup(strValue, agent);
                if (matches == null || matches.length <= 1) continue;
                this.browser = strKey;
                this.version = matches[1];
                this.majorversion = Integer.parseInt(matches[2]);
                float f = this.minorversion = matches.length < 4 ? 0.0f : Float.parseFloat(matches[3]);
                if (!RegEx.match("b", this.version)) break;
                this.beta = true;
                break;
            }
        }
    }

    private String locateInMap(String agent, Map maps) {
        if (!maps.isEmpty()) {
            Iterator values = maps.values().iterator();
            Iterator keys = maps.keySet().iterator();
            while (values.hasNext()) {
                String strValue = (String)values.next();
                String strKey = (String)keys.next();
                if (!RegEx.match(strValue, agent)) continue;
                return strKey;
            }
        }
        return "win32";
    }
}

