/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.utils;

import com.kingdee.bos.web.anole.utils.UuidException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;

public class Uuid
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long high;
    private long low;
    private transient String str36 = null;
    private static int UUID_HOST_LOCK_PORT = 5504;
    private static final int MAX_RETRYS = 1200;
    private static final int INTERVAL_TIME = 100;
    private static ServerSocket lockSocket;
    private static long timeStamp;
    private static long adapterAddress;
    private static int instanceCounter;
    private static final long versionMask = 4096L;
    private static final long reserveMask = -2305843009213693952L;
    private static final long randomMask = 0x1FFFFFFFL;
    private static final char[] hexDigits;

    static {
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    public static synchronized Uuid create() throws UuidException {
        int count;
        if (timeStamp == 0L) {
            Uuid.setTimeStamp();
        }
        if (adapterAddress == 0L) {
            Uuid.setAdapterAddress();
        }
        Uuid uuid = new Uuid();
        long midTime = timeStamp >> 32 & 0xFFFFFFFFL;
        uuid.high = timeStamp << 32 | midTime << 16 & 0xFFFF0000L | 0x1000L | timeStamp >> 48 & 0xFFFL;
        if ((count = instanceCounter++) == 0x1FFFFFFF) {
            instanceCounter = 0;
            Uuid.setTimeStamp();
        }
        uuid.low = ((long)count & 0x1FFFFFFFL) << 32 | 0xE000000000000000L | adapterAddress;
        return uuid;
    }

    private Uuid() {
    }

    private Uuid(long high, long low) {
        this.high = high;
        this.low = low;
    }

    private static void setAdapterAddress() throws UuidException {
        try {
            byte[] addr = InetAddress.getLocalHost().getAddress();
            int raw = addr[3] & 0xFF | addr[2] << 8 & 0xFF00 | addr[1] << 16 & 0xFF0000 | addr[0] << 24 & 0xFF000000;
            adapterAddress = (long)raw & 0xFFFFFFFFL;
        }
        catch (UnknownHostException e) {
            throw new UuidException("Unexpected failure");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void setTimeStamp() throws UuidException {
        Uuid.acquireHostLock();
        try {
            long newTime = System.currentTimeMillis();
            if (timeStamp != 0L) {
                if (newTime < timeStamp) {
                    throw new UuidException("Unique identifier clock failure");
                }
                if (newTime == timeStamp) {
                    Uuid.letClockTick(newTime);
                    newTime = System.currentTimeMillis();
                }
            }
            timeStamp = newTime;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            Uuid.releaseHostLock();
            throw throwable;
        }
        {
            Object var2_3 = null;
        }
        Uuid.releaseHostLock();
    }

    private static void letClockTick(long curTime) throws UuidException {
        int timeoutCounter = 0;
        long sleepTime = 1L;
        long newTime = System.currentTimeMillis();
        while (newTime == curTime) {
            ++timeoutCounter;
            sleepTime *= 2L;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (sleepTime > 60000L) {
                throw new UuidException("Unique identifier unexpected failure");
            }
            newTime = System.currentTimeMillis();
        }
    }

    private static void acquireHostLock() throws UuidException {
        String portProperty = null;
        try {
            portProperty = System.getProperty("bluewater.uuid.hostLockPort");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (portProperty != null) {
            try {
                UUID_HOST_LOCK_PORT = Integer.parseInt(portProperty);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int numberOfRetrys = 0;
        while (lockSocket == null) {
            try {
                lockSocket = new ServerSocket(UUID_HOST_LOCK_PORT);
                return;
            }
            catch (BindException e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException e2) {
                throw new UuidException("Unique identifier unexpected failure");
            }
            if (numberOfRetrys == 1200) {
                throw new UuidException("Unique identifier lock failure");
            }
            ++numberOfRetrys;
        }
    }

    private static void releaseHostLock() {
        if (lockSocket != null) {
            try {
                lockSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            lockSocket = null;
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Uuid) {
            return this.high == ((Uuid)obj).high && this.low == ((Uuid)obj).low;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.low << 24) & 0xFF000000 | (int)(this.high >> 20) & 0xFFF000 | (int)(this.low >> 32) & 0xFFF;
    }

    public String toString() {
        if (this.str36 != null) {
            return this.str36;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(Uuid.toHexString(this.high >>> 32, 8)).append("-");
        buf.append(Uuid.toHexString(this.high >>> 16, 4)).append("-");
        buf.append(Uuid.toHexString(this.high, 4)).append("-");
        buf.append(Uuid.toHexString(this.low >>> 48, 4)).append("-");
        buf.append(Uuid.toHexString(this.low, 12));
        this.str36 = buf.toString();
        return this.str36;
    }

    private static String toHexString(long x, int chars) {
        char[] buf = new char[chars];
        int charPos = chars;
        while (--charPos >= 0) {
            buf[charPos] = hexDigits[(int)(x & 0xFL)];
            x >>>= 4;
        }
        return new String(buf);
    }

    public byte[] toByteArray() {
        byte[] array = new byte[16];
        this.toBytes(this.high, array, 0);
        this.toBytes(this.low, array, 8);
        return array;
    }

    private void toBytes(long x, byte[] array, int startPos) {
        int bytePos = 8;
        while (--bytePos >= 0) {
            array[startPos + bytePos] = (byte)(x & 0xFFL);
            x >>>= 8;
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.high);
        out.writeLong(this.low);
    }

    public static Uuid read(DataInput in) throws IOException {
        long high = in.readLong();
        long low = in.readLong();
        return new Uuid(high, low);
    }

    public static Uuid read(String id) throws UuidException {
        try {
            String part = id.substring(0, 8);
            long high = 0L;
            high = Long.parseLong(part, 16) << 32;
            part = id.substring(9, 13);
            high |= Long.parseLong(part, 16) << 16;
            part = id.substring(14, 18);
            high |= Long.parseLong(part, 16);
            long low = 0L;
            part = id.substring(19, 23);
            low = Long.parseLong(part, 16) << 48;
            part = id.substring(24, 36);
            Uuid uuid = new Uuid(high, low |= Long.parseLong(part, 16));
            return uuid;
        }
        catch (Exception ex) {
            throw new UuidException("Invalid uuid String.");
        }
    }

    public static void main(String[] args) {
        try {
            Uuid uuid = Uuid.create();
            long begin = System.currentTimeMillis();
            int i = 0;
            while (i < 1000000) {
                uuid.toString();
                ++i;
            }
            long end = System.currentTimeMillis();
            System.out.println("total=" + (end - begin) + "ms," + (end - begin) / 1000L + " second");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

