/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.xmlparser;

import com.kingdee.bos.web.anole.utils.Log4j;
import com.kingdee.bos.web.anole.xmlparser.TreeNode;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParserUtils {
    private static final boolean validating = false;
    private static Logger logger = Log4j.getInstance();

    public static TreeNode parseXMLDocument(InputStream is) {
        TreeNode rootNode = null;
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(is);
        }
        catch (ParserConfigurationException ex) {
            logger.error((Object)ex);
        }
        catch (SAXParseException ex) {
            logger.error((Object)ex);
        }
        catch (SAXException sx) {
            logger.error((Object)sx);
        }
        catch (IOException io) {
            logger.error((Object)io);
        }
        if (document != null) {
            rootNode = ParserUtils.convertToTreeNode(null, document.getDocumentElement());
        }
        return rootNode;
    }

    private static TreeNode convertToTreeNode(TreeNode parent, Node node) {
        NodeList children;
        TreeNode treeNode = new TreeNode(node.getNodeName(), parent);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int n = attributes.getLength();
            int i = 0;
            while (i < n) {
                Node attribute = attributes.item(i);
                treeNode.addAttribute(attribute.getNodeName(), attribute.getNodeValue());
                ++i;
            }
        }
        if ((children = node.getChildNodes()) != null) {
            int n = children.getLength();
            int i = 0;
            while (i < n) {
                Node child = children.item(i);
                if (!(child instanceof Comment)) {
                    if (child instanceof Text) {
                        String body = ((Text)child).getData();
                        if (body != null && (body = body.trim()).length() > 0) {
                            treeNode.setBody(body);
                        }
                    } else {
                        TreeNode treeNode2 = ParserUtils.convertToTreeNode(treeNode, child);
                    }
                }
                ++i;
            }
        }
        return treeNode;
    }
}

