/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.bos.jdbc.base;

import com.apusic.bos.jdbc.base.BaseExceptions;
import java.io.IOException;
import java.io.Reader;

class BaseCharacterStreamWrapper
extends Reader {
    private static String footprint = "$Revision:   1.2  $";
    Object synchronizer;
    Reader rdr;
    boolean closed;
    int numTotalCharsInReader;
    int numCharsReturned;
    BaseExceptions exceptions;

    BaseCharacterStreamWrapper(Reader reader, int i, BaseExceptions baseexceptions) {
        this.rdr = reader;
        this.exceptions = baseexceptions;
        this.numTotalCharsInReader = i;
        this.numCharsReturned = 0;
        this.closed = false;
        this.synchronizer = this;
    }

    public void close() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                this.rdr.close();
                this.closed = true;
            }
        }
    }

    public synchronized void mark(int i) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.closed) {
                this.rdr.mark(i);
            }
        }
    }

    public boolean markSupported() {
        Object object = this.synchronizer;
        synchronized (object) {
            boolean flag1;
            if (!this.closed) {
                boolean flag;
                boolean bl = flag = this.rdr.markSupported();
                return bl;
            }
            boolean bl = flag1 = false;
            return bl;
        }
    }

    public int read() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            int i;
            this.validateClosedState();
            int j = this.rdr.read();
            if (this.numTotalCharsInReader != -1) {
                boolean flag = false;
                if (j != -1) {
                    ++this.numCharsReturned;
                    if (this.numCharsReturned > this.numTotalCharsInReader) {
                        flag = true;
                    }
                } else if (this.numCharsReturned != this.numTotalCharsInReader) {
                    flag = true;
                }
                if (flag) {
                    int byte0;
                    int n = byte0 = -2;
                    return n;
                }
            }
            int n = i = j;
            return n;
        }
    }

    public int read(char[] ac) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            int i;
            int n = i = this.read(ac, 0, ac.length);
            return n;
        }
    }

    public int read(char[] ac, int i, int j) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            int k;
            this.validateClosedState();
            int l = this.rdr.read(ac, i, j);
            if (this.numTotalCharsInReader != -1) {
                boolean flag = false;
                if (l != -1) {
                    this.numCharsReturned += l;
                    if (this.numCharsReturned > this.numTotalCharsInReader) {
                        flag = true;
                    }
                } else if (this.numCharsReturned != this.numTotalCharsInReader) {
                    flag = true;
                }
                if (flag) {
                    int byte0;
                    int n = byte0 = -2;
                    return n;
                }
            }
            int n = k = l;
            return n;
        }
    }

    public synchronized void reset() throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateClosedState();
            this.rdr.reset();
        }
    }

    void setSynchronizer(Object obj) {
        this.synchronizer = obj;
    }

    public long skip(long l) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            long l1;
            this.validateClosedState();
            long l2 = l1 = this.rdr.skip(l);
            return l2;
        }
    }

    void validateClosedState() throws IOException {
        if (this.closed) {
            throw new IOException(this.exceptions.getException(6010).getMessage());
        }
    }
}

