/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.bos.jdbc.base;

import com.apusic.bos.jdbc.base.BaseColumn;
import com.apusic.bos.jdbc.base.BaseData;
import java.util.Vector;

public class BaseColumns {
    private static String footprint = "$Revision:   1.12  $";
    private Vector columns = new Vector();
    public static final int COUNT_ALL = 0;
    public static final int COUNT_EXPOSED = 1;
    public static final int COUNT_HIDDEN = 2;
    public static final int COUNT_KEY = 3;
    public static final int COUNT_AUTOINCREMENT = 4;
    private boolean countsValid = false;
    private int hiddenCount;
    private int exposedCount;
    private int allCount;
    private int keyCount;
    private int autoincrementCount;

    public void add(BaseColumn basecolumn) {
        this.columns.addElement(basecolumn);
        this.countsValid = false;
    }

    private void calculateCounts() {
        this.allCount = this.columns.size();
        this.hiddenCount = 0;
        this.exposedCount = 0;
        this.keyCount = 0;
        this.autoincrementCount = 0;
        for (int i = 0; i < this.allCount; ++i) {
            BaseColumn basecolumn = (BaseColumn)this.columns.elementAt(i);
            if (basecolumn.isHidden) {
                ++this.hiddenCount;
            } else {
                ++this.exposedCount;
            }
            if (basecolumn.isKey) {
                ++this.keyCount;
            }
            if (!basecolumn.isAutoIncrement || basecolumn.isHidden) continue;
            ++this.autoincrementCount;
        }
        this.countsValid = true;
    }

    public int count(int i) {
        if (!this.countsValid) {
            this.calculateCounts();
        }
        if (i == 0) {
            return this.allCount;
        }
        if (i == 1) {
            return this.exposedCount;
        }
        if (i == 2) {
            return this.hiddenCount;
        }
        if (i == 3) {
            return this.keyCount;
        }
        if (i == 4) {
            return this.autoincrementCount;
        }
        return 0;
    }

    public BaseColumn get(int i) {
        BaseColumn basecolumn = (BaseColumn)this.columns.elementAt(i - 1);
        return basecolumn;
    }

    public int getOrdinal(String s) {
        int i = this.count(0);
        for (int j = 1; j <= i; ++j) {
            if (!s.equalsIgnoreCase(this.get((int)j).name)) continue;
            return j;
        }
        return 0;
    }

    public boolean isValidColumnOrdinal(int i) {
        return i > 0 && i <= this.count(1);
    }

    public void markAllColumnsAsKey() {
        this.allCount = this.columns.size();
        for (int i = 0; i < this.allCount; ++i) {
            BaseColumn basecolumn = (BaseColumn)this.columns.elementAt(i);
            if (!basecolumn.isSearchable || basecolumn.isHidden || BaseData.isInputStream(basecolumn.baseDataType)) continue;
            basecolumn.isKey = true;
        }
        this.countsValid = false;
    }

    public void reset() {
        if (this.columns != null) {
            this.columns.setSize(0);
        }
        this.countsValid = false;
    }

    public void resetCount() {
        this.countsValid = false;
    }

    static {
        COUNT_ALL = 0;
        COUNT_EXPOSED = 1;
        COUNT_HIDDEN = 2;
        COUNT_KEY = 3;
        COUNT_AUTOINCREMENT = 4;
    }
}

