/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.bos.jdbc.base;

import com.apusic.bos.jdbc.base.BaseCallableStatement;
import com.apusic.bos.jdbc.base.BaseClassUtility;
import com.apusic.bos.jdbc.base.BaseConnectionPool;
import com.apusic.bos.jdbc.base.BaseConnectionProperties;
import com.apusic.bos.jdbc.base.BaseConnectionStartup;
import com.apusic.bos.jdbc.base.BaseDatabaseMetaData;
import com.apusic.bos.jdbc.base.BaseDriverPropertyInfos;
import com.apusic.bos.jdbc.base.BaseEscapeTranslator;
import com.apusic.bos.jdbc.base.BaseExceptions;
import com.apusic.bos.jdbc.base.BaseImplConnection;
import com.apusic.bos.jdbc.base.BaseImplDatabaseMetaData;
import com.apusic.bos.jdbc.base.BaseLicenseUtility;
import com.apusic.bos.jdbc.base.BasePreparedStatement;
import com.apusic.bos.jdbc.base.BasePropertiesFile;
import com.apusic.bos.jdbc.base.BaseStatement;
import com.apusic.bos.jdbc.base.BaseWarnings;
import com.apusic.bos.jdbc.extensions.ExtEmbeddedConnection;
import com.apusic.bos.util.UtilDebug;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public abstract class BaseConnection
implements Connection,
ExtEmbeddedConnection {
    private static String footprint = "$Revision:   1.51  $";
    protected String driverName;
    BaseConnectionProperties connectProps;
    UtilDebug debug;
    private BaseImplConnection primaryImplConnection;
    private int numberOpenObjectsPerConnection;
    private BaseConnectionPool secondaryImplConnections;
    private int maxConnections;
    private Vector statements;
    private BaseDatabaseMetaData databaseMetaData;
    private boolean inManualTransactionMode;
    private boolean readOnlyMode;
    private String currentCatalog;
    private String originalCatalog;
    private int currentTransactionIsolation = -1;
    private int originalTransactionIsolation = -1;
    protected BaseWarnings warnings;
    protected BaseExceptions exceptions;
    protected boolean lockedEmbedding;

    public final synchronized void clearWarnings() throws SQLException {
        this.warnings.clear();
    }

    public final synchronized void close() throws SQLException {
        if (!this.isClosed() && !this.lockedEmbedding) {
            this.commonCloseReset();
            this.primaryImplConnection.removeReference();
            this.primaryImplConnection.close();
            this.primaryImplConnection = null;
            this.secondaryImplConnections.close();
        }
    }

    private final void closeStatements() throws SQLException {
        int i = this.statements.size();
        for (int j = 0; j < i; ++j) {
            BaseStatement basestatement = (BaseStatement)this.statements.elementAt(j);
            if (basestatement == null) continue;
            basestatement.close();
        }
        this.statements = new Vector();
    }

    public final synchronized void commit() throws SQLException {
        this.validateClosedState();
        if (this.inManualTransactionMode) {
            this.primaryImplConnection.commitTransaction();
        }
    }

    final void commonCloseReset() throws SQLException {
        this.clearWarnings();
        this.closeStatements();
        if (this.databaseMetaData != null) {
            this.databaseMetaData.setOwnerConnection(null);
            this.databaseMetaData = null;
        }
        if (this.inManualTransactionMode) {
            try {
                this.primaryImplConnection.rollbackTransaction();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public BaseEscapeTranslator createEscapeTranslator() throws SQLException {
        return null;
    }

    protected abstract BaseImplConnection createImplConnection(BaseConnectionProperties var1) throws SQLException;

    public abstract BaseImplDatabaseMetaData createImplDatabaseMetaData(BaseConnectionProperties var1) throws SQLException;

    public final Statement createStatement() throws SQLException {
        this.validateClosedState();
        return this.createStatement(1003, 1007);
    }

    public final synchronized Statement createStatement(int i, int j) throws SQLException {
        this.validateClosedState();
        this.validateTypeAndConcurrency("createStatement", i, j);
        BaseStatement basestatement = new BaseStatement(this, i, j);
        this.postDownGradeWarnings(basestatement, i, j);
        this.statementOpened(basestatement);
        return basestatement;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public final synchronized boolean getAutoCommit() throws SQLException {
        this.validateClosedState();
        return this.inManualTransactionMode ^ true;
    }

    public boolean getBatchIsJDBCCompliant() {
        return true;
    }

    public final synchronized String getCatalog() throws SQLException {
        this.validateClosedState();
        if (this.currentCatalog == null) {
            this.currentCatalog = this.primaryImplConnection.getCatalog();
            if (this.originalCatalog == null) {
                this.originalCatalog = this.currentCatalog;
            }
        }
        return this.currentCatalog;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final synchronized BaseImplConnection getImplConnection(boolean flag) throws SQLException {
        BaseImplConnection baseimplconnection = null;
        if (this.primaryImplConnection.getReferenceCount() <= this.numberOpenObjectsPerConnection) {
            baseimplconnection = this.primaryImplConnection;
        } else if (this.inManualTransactionMode) {
            if (this.primaryImplConnection.getReferenceCount() != 1 || this.secondaryImplConnections.countActiveConnections() != 0) throw this.exceptions.getException(6022, "08007");
            baseimplconnection = this.primaryImplConnection;
        } else if (this.secondaryImplConnections.countUseableConnections(this.numberOpenObjectsPerConnection) > 0) {
            baseimplconnection = this.secondaryImplConnections.getUseableConnection(this.numberOpenObjectsPerConnection);
        } else {
            if (this.maxConnections != 0 && this.maxConnections <= this.secondaryImplConnections.count() + 2) throw this.exceptions.getException(6024);
            baseimplconnection = this.getNewImplConnection(flag, 0);
            if (this.currentCatalog != null && this.originalCatalog != null) {
                if (!this.currentCatalog.equals(this.originalCatalog)) {
                    baseimplconnection.setCatalog(this.currentCatalog);
                }
                if (this.originalTransactionIsolation != -1 && this.originalTransactionIsolation != this.currentTransactionIsolation) {
                    baseimplconnection.setTransactionIsolation(this.currentTransactionIsolation);
                }
            }
            this.secondaryImplConnections.add(baseimplconnection);
        }
        baseimplconnection.addReference();
        return baseimplconnection;
    }

    protected abstract void getImplPropertyInfo(BaseDriverPropertyInfos var1);

    public final synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.validateClosedState();
        if (this.databaseMetaData == null) {
            BaseImplDatabaseMetaData baseimpldatabasemetadata = this.createImplDatabaseMetaData(this.connectProps);
            baseimpldatabasemetadata.setup(this);
            this.databaseMetaData = new BaseDatabaseMetaData(this, baseimpldatabasemetadata);
        }
        return this.databaseMetaData;
    }

    private BaseImplConnection getNewImplConnection(boolean flag, int i) throws SQLException {
        BaseImplConnection baseimplconnection;
        block4: {
            String s;
            baseimplconnection = this.createImplConnection(this.connectProps);
            baseimplconnection.setup(this.connectProps, this.warnings, this.exceptions, this.debug);
            baseimplconnection.setReadOnly(this.readOnlyMode);
            this.lockedEmbedding = false;
            if (this.isClosed() && (s = this.connectProps.get("embedded")) != null) {
                this.lockedEmbedding = s.equals("true");
            }
            if (!flag || this.lockedEmbedding) break block4;
            if (this.isClosed()) {
                BaseLicenseUtility baselicenseutility = new BaseLicenseUtility();
                baselicenseutility.checkDriverLicense(baseimplconnection);
            }
            if (i > 0) {
                BaseConnectionStartup baseconnectionstartup = new BaseConnectionStartup(baseimplconnection, i, this.exceptions);
            } else {
                baseimplconnection.open();
            }
        }
        return baseimplconnection;
    }

    public final BaseDriverPropertyInfos getPropertyInfo() {
        BaseDriverPropertyInfos basedriverpropertyinfos = new BaseDriverPropertyInfos();
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            this.getImplPropertyInfo(basedriverpropertyinfos);
        }
        if (!this.getBatchIsJDBCCompliant()) {
            basedriverpropertyinfos.put("batchPerformanceWorkaround", "Batch Performance Workaround", "false", null, false);
        }
        return basedriverpropertyinfos;
    }

    public final synchronized int getTransactionIsolation() throws SQLException {
        this.validateClosedState();
        if (this.currentTransactionIsolation == -1) {
            this.currentTransactionIsolation = this.primaryImplConnection.getTransactionIsolation();
            if (this.originalTransactionIsolation == -1) {
                this.originalTransactionIsolation = this.currentTransactionIsolation;
            }
        }
        return this.currentTransactionIsolation;
    }

    public final Map getTypeMap() throws SQLException {
        return new HashMap();
    }

    public final synchronized SQLWarning getWarnings() {
        return this.warnings.get();
    }

    public final synchronized boolean isClosed() {
        boolean flag = this.primaryImplConnection == null;
        return flag;
    }

    public final synchronized boolean isReadOnly() throws SQLException {
        this.validateClosedState();
        return this.readOnlyMode;
    }

    public final String nativeSQL(String s) throws SQLException {
        this.validateClosedState();
        return s;
    }

    public final void open(BaseConnectionProperties baseconnectionproperties, BaseExceptions baseexceptions, UtilDebug utildebug) throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            this.driverName = BaseClassUtility.getRootName(this);
            this.connectProps = baseconnectionproperties;
            this.exceptions = baseexceptions;
            this.debug = utildebug;
            this.warnings = new BaseWarnings(this.driverName);
            this.statements = new Vector();
            this.secondaryImplConnections = new BaseConnectionPool();
            int i = 0;
            if (baseconnectionproperties.get("loginTimeout") != null) {
                i = Integer.valueOf(baseconnectionproperties.get("loginTimeout"));
            }
            this.primaryImplConnection = this.getNewImplConnection(true, i);
            this.primaryImplConnection.addReference();
            if (!this.lockedEmbedding) {
                this.setupNumberObjectsPerConnection();
            }
            this.maxConnections = 0;
            this.readOnlyMode = false;
            this.inManualTransactionMode = false;
        }
    }

    boolean performsConnectionCloning() {
        return this.numberOpenObjectsPerConnection != Integer.MAX_VALUE;
    }

    private void postDownGradeWarnings(BaseStatement basestatement, int i, int j) throws SQLException {
        if (i != basestatement.getResultSetType()) {
            this.warnings.add(6047, "01000");
        }
        if (j != basestatement.getResultSetConcurrency()) {
            this.warnings.add(6048, "01000");
        }
    }

    public final synchronized CallableStatement prepareCall(String s) throws SQLException {
        this.validateClosedState();
        BaseCallableStatement basecallablestatement = new BaseCallableStatement(this, s, 1003, 1007);
        this.statementOpened(basecallablestatement);
        return basecallablestatement;
    }

    public final synchronized CallableStatement prepareCall(String s, int i, int j) throws SQLException {
        this.validateClosedState();
        this.validateTypeAndConcurrency("prepareCall", i, j);
        BaseCallableStatement basecallablestatement = new BaseCallableStatement(this, s, i, j);
        this.postDownGradeWarnings(basecallablestatement, i, j);
        this.statementOpened(basecallablestatement);
        return basecallablestatement;
    }

    public final synchronized PreparedStatement prepareStatement(String s) throws SQLException {
        this.validateClosedState();
        BasePreparedStatement basepreparedstatement = new BasePreparedStatement(this, s, 1003, 1007);
        this.statementOpened(basepreparedstatement);
        return basepreparedstatement;
    }

    public final synchronized PreparedStatement prepareStatement(String s, int i, int j) throws SQLException {
        this.validateClosedState();
        this.validateTypeAndConcurrency("prepareStatement", i, j);
        BasePreparedStatement basepreparedstatement = new BasePreparedStatement(this, s, i, j);
        this.postDownGradeWarnings(basepreparedstatement, i, j);
        this.statementOpened(basepreparedstatement);
        return basepreparedstatement;
    }

    public final synchronized void reset() throws SQLException {
        if (!this.isClosed()) {
            this.commonCloseReset();
            if (this.originalCatalog != null && this.currentCatalog != null && !this.originalCatalog.equals(this.currentCatalog)) {
                this.setCatalog(this.originalCatalog);
            }
            if (this.originalTransactionIsolation != -1 && this.originalTransactionIsolation != this.currentTransactionIsolation) {
                this.setTransactionIsolation(this.originalTransactionIsolation);
            }
            if (this.inManualTransactionMode) {
                this.setAutoCommit(true);
            }
            this.setReadOnly(false);
            this.primaryImplConnection.reset();
            this.secondaryImplConnections.reset();
        }
    }

    public final synchronized void rollback() throws SQLException {
        this.validateClosedState();
        if (this.inManualTransactionMode) {
            this.primaryImplConnection.rollbackTransaction();
        }
    }

    public final synchronized void setAutoCommit(boolean flag) throws SQLException {
        this.validateClosedState();
        if (flag) {
            if (this.inManualTransactionMode) {
                this.primaryImplConnection.stopManualTransactionMode();
                this.inManualTransactionMode = false;
            }
        } else if (!this.inManualTransactionMode) {
            if (this.secondaryImplConnections.countActiveConnections() > 0) {
                throw this.exceptions.getException(6027);
            }
            this.primaryImplConnection.startManualTransactionMode();
            this.inManualTransactionMode = true;
        }
    }

    public final synchronized void setCatalog(String s) throws SQLException {
        this.validateClosedState();
        if (this.currentCatalog != null && this.currentCatalog.equals(s)) {
            return;
        }
        this.closeStatements();
        if (this.originalCatalog == null) {
            this.originalCatalog = this.getCatalog();
        }
        this.primaryImplConnection.setCatalog(s);
        this.secondaryImplConnections.setCatalog(s);
        this.currentCatalog = new String(s);
    }

    public final synchronized void setReadOnly(boolean flag) throws SQLException {
        this.validateClosedState();
        this.readOnlyMode = flag;
        this.primaryImplConnection.setReadOnly(flag);
    }

    public final synchronized void setTransactionIsolation(int i) throws SQLException {
        this.validateClosedState();
        if (this.currentTransactionIsolation != -1 && this.currentTransactionIsolation == i) {
            return;
        }
        if (this.originalTransactionIsolation == -1) {
            this.originalTransactionIsolation = this.primaryImplConnection.getTransactionIsolation();
        }
        this.primaryImplConnection.setTransactionIsolation(i);
        this.secondaryImplConnections.setTransactionIsolation(i);
        this.currentTransactionIsolation = i;
    }

    public final void setTypeMap(Map map) throws SQLException {
    }

    private final void setupNumberObjectsPerConnection() throws SQLException {
        this.numberOpenObjectsPerConnection = 1;
        BaseImplDatabaseMetaData baseimpldatabasemetadata = this.createImplDatabaseMetaData(this.connectProps);
        baseimpldatabasemetadata.setup(this);
        if (baseimpldatabasemetadata.maxStatements == null) {
            baseimpldatabasemetadata.initializeNonResultSetMetaData(101);
        }
        this.numberOpenObjectsPerConnection = baseimpldatabasemetadata.maxStatements;
        if (this.numberOpenObjectsPerConnection == 0) {
            this.numberOpenObjectsPerConnection = Integer.MAX_VALUE;
        }
    }

    protected final void statementClosed(BaseStatement basestatement) {
        this.statements.setElementAt(null, this.statements.indexOf(basestatement));
    }

    private final void statementOpened(BaseStatement basestatement) {
        int i = this.statements.size();
        for (int j = 0; j < i; ++j) {
            BaseStatement basestatement1 = (BaseStatement)this.statements.elementAt(j);
            if (basestatement1 != null) continue;
            this.statements.setElementAt(basestatement, j);
            basestatement = null;
            j = i;
        }
        if (basestatement != null) {
            this.statements.addElement(basestatement);
        }
    }

    public final boolean unlock(String s) throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            boolean flag;
            boolean flag1 = false;
            if (this.lockedEmbedding) {
                BasePropertiesFile basepropertiesfile = new BasePropertiesFile();
                String s1 = basepropertiesfile.getProperty("applicationKey");
                if (s1 != null && s1.equals(s)) {
                    this.lockedEmbedding = false;
                    flag1 = true;
                    int i = 0;
                    String s2 = this.connectProps.get("loginTimeout");
                    if (s2 != null) {
                        i = Integer.valueOf(s2);
                    }
                    if (i > 0) {
                        BaseConnectionStartup baseconnectionstartup = new BaseConnectionStartup(this.primaryImplConnection, i, this.exceptions);
                    } else {
                        this.primaryImplConnection.open();
                    }
                    this.setupNumberObjectsPerConnection();
                }
            } else {
                flag1 = true;
            }
            boolean bl = flag = flag1;
            return bl;
        }
    }

    final synchronized void validateClosedState() throws SQLException {
        if (this.isClosed()) {
            throw this.exceptions.getException(6010);
        }
        if (this.lockedEmbedding) {
            throw this.exceptions.getException(6051);
        }
    }

    final void validateTypeAndConcurrency(String s, int i, int j) throws SQLException {
        boolean flag = false;
        switch (i) {
            default: {
                flag = true;
            }
            case 1003: 
            case 1004: 
            case 1005: 
        }
        switch (j) {
            default: {
                flag = true;
            }
            case 1007: 
            case 1008: 
        }
        if (flag) {
            String[] as = new String[]{s};
            throw this.exceptions.getException(6003, as);
        }
    }
}

