/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.bos.jdbc.base;

import com.apusic.bos.jdbc.base.BaseColumn;
import com.apusic.bos.jdbc.base.BaseColumns;
import com.apusic.bos.jdbc.base.BaseConnection;
import com.apusic.bos.jdbc.base.BaseExceptions;
import com.apusic.bos.jdbc.base.BaseImplDatabaseMetaData;
import com.apusic.bos.jdbc.base.BaseResultSetFilterDescriptor;
import com.apusic.bos.jdbc.base.BaseResultSetSortDescriptor;
import com.apusic.bos.jdbc.base.BaseStatement;
import com.apusic.bos.jdbc.base.BaseTableTypes;
import com.apusic.bos.jdbc.base.BaseTypeInfos;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;

public final class BaseDatabaseMetaData
implements DatabaseMetaData {
    private static String footprint = "$Revision:   1.42  $";
    static final int driverMajorVersion = 2;
    protected static final int driverMinorVersion = 1;
    protected BaseConnection connection;
    protected Connection ownerConnection;
    protected BaseImplDatabaseMetaData implDatabaseMetaData;
    protected BaseExceptions exceptions;

    BaseDatabaseMetaData() {
    }

    public BaseDatabaseMetaData(BaseConnection baseconnection, BaseImplDatabaseMetaData baseimpldatabasemetadata) throws SQLException {
        this.exceptions = baseconnection.exceptions;
        this.connection = baseconnection;
        this.ownerConnection = baseconnection;
        this.implDatabaseMetaData = baseimpldatabasemetadata;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.allProceduresAreCallable == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(1);
            }
            boolean bl = flag = this.implDatabaseMetaData.allProceduresAreCallable.booleanValue();
            return bl;
        }
    }

    public boolean allTablesAreSelectable() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.allTablesAreSelectable == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(2);
            }
            boolean bl = flag = this.implDatabaseMetaData.allTablesAreSelectable.booleanValue();
            return bl;
        }
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.dataDefinitionCausesTransactionCommit == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(113);
            }
            boolean bl = flag = this.implDatabaseMetaData.dataDefinitionCausesTransactionCommit.booleanValue();
            return bl;
        }
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.dataDefinitionIgnoredInTransactions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(114);
            }
            boolean bl = flag = this.implDatabaseMetaData.dataDefinitionIgnoredInTransactions.booleanValue();
            return bl;
        }
    }

    public boolean deletesAreDetected(int i) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            boolean flag1 = false;
            switch (i) {
                case 1003: {
                    if (this.implDatabaseMetaData.deletesAreDetectedForwardOnly == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(138);
                    }
                    flag1 = this.implDatabaseMetaData.deletesAreDetectedForwardOnly;
                    break;
                }
                case 1004: {
                    if (this.implDatabaseMetaData.deletesAreDetectedScrollInsensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(139);
                    }
                    flag1 = this.implDatabaseMetaData.deletesAreDetectedScrollInsensitive;
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.deletesAreDetectedScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(140);
                    }
                    flag1 = this.implDatabaseMetaData.deletesAreDetectedScrollSensitive;
                    break;
                }
                default: {
                    String[] as = new String[]{"deletesAreDetected"};
                    throw this.exceptions.getException(6003, as);
                }
            }
            boolean bl = flag = flag1;
            return bl;
        }
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.doesMaxRowSizeIncludeBlobs == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(99);
            }
            boolean bl = flag = this.implDatabaseMetaData.doesMaxRowSizeIncludeBlobs.booleanValue();
            return bl;
        }
    }

    public ResultSet getBestRowIdentifier(String s, String s1, String s2, int i, boolean flag) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            ResultSet resultset;
            this.validateClosedState();
            if (i != 0 && i != 1 && i != 2 || s == null && s2 == null && s1 == null) {
                String[] as = new String[]{"getBestRowIdentifier"};
                throw this.exceptions.getException(6003, as);
            }
            int[] ai = new int[]{9, 10, 11, 1, 12};
            Object[] aobj = new Object[]{s, s1, s2, new Integer(i), new Boolean(flag)};
            boolean[] aflag = new boolean[5];
            BaseResultSetFilterDescriptor baseresultsetfilterdescriptor = new BaseResultSetFilterDescriptor(ai, aobj, aflag);
            int[] ai1 = new int[]{1};
            BaseResultSetSortDescriptor baseresultsetsortdescriptor = new BaseResultSetSortDescriptor(ai1);
            String s3 = this.implDatabaseMetaData.getResultSetSQL(7, baseresultsetfilterdescriptor, baseresultsetsortdescriptor);
            BaseColumns basecolumns = new BaseColumns();
            BaseColumn basecolumn = new BaseColumn(5);
            basecolumn.label = "SCOPE";
            basecolumn.name = "SCOPE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "COLUMN_NAME";
            basecolumn.name = "COLUMN_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "DATA_TYPE";
            basecolumn.name = "DATA_TYPE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "TYPE_NAME";
            basecolumn.name = "TYPE_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            basecolumn.label = "COLUMN_SIZE";
            basecolumn.name = "COLUMN_SIZE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            basecolumn.label = "BUFFER_LENGTH";
            basecolumn.name = "BUFFER_LENGTH";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "DECIMAL_DIGITS";
            basecolumn.name = "DECIMAL_DIGITS";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "PSEUDO_COLUMN";
            basecolumn.name = "PSEUDO_COLUMN";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            if (!baseresultsetfilterdescriptor.allRestrictionsSatified()) {
                BaseColumn basecolumn1 = new BaseColumn(12);
                basecolumn1.label = "TABLE_CAT";
                basecolumn1.name = "TABLE_CAT";
                this.setCommonResultSetMetaData(basecolumn1);
                basecolumns.add(basecolumn1);
                basecolumn1 = new BaseColumn(12);
                basecolumn1.label = "TABLE_SCHEM";
                basecolumn1.name = "TABLE_SCHEM";
                this.setCommonResultSetMetaData(basecolumn1);
                basecolumns.add(basecolumn1);
                basecolumn1 = new BaseColumn(12);
                basecolumn1.label = "TABLE_NAME";
                basecolumn1.name = "TABLE_NAME";
                this.setCommonResultSetMetaData(basecolumn1);
                basecolumns.add(basecolumn1);
                basecolumn1 = new BaseColumn(-7);
                basecolumn1.label = "NULLABLE";
                basecolumn1.name = "NULLABLE";
                this.setCommonResultSetMetaData(basecolumn1);
                basecolumns.add(basecolumn1);
            }
            BaseStatement basestatement = (BaseStatement)this.connection.createStatement();
            basestatement.setupForDatabaseMetaData(basecolumns, 7, baseresultsetfilterdescriptor, baseresultsetsortdescriptor, null);
            ResultSet resultSet = resultset = basestatement.executeQuery(s3);
            return resultSet;
        }
    }

    public String getCatalogSeparator() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String s;
            this.validateClosedState();
            if (this.implDatabaseMetaData.catalogSeparator == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(58);
            }
            String string = s = this.implDatabaseMetaData.catalogSeparator;
            return string;
        }
    }

    public String getCatalogTerm() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String s;
            this.validateClosedState();
            if (this.implDatabaseMetaData.catalogTerm == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(56);
            }
            String string = s = this.implDatabaseMetaData.catalogTerm;
            return string;
        }
    }

    public ResultSet getCatalogs() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            ResultSet resultset;
            this.validateClosedState();
            int[] ai = new int[]{1};
            BaseResultSetSortDescriptor baseresultsetsortdescriptor = new BaseResultSetSortDescriptor(ai);
            String s = this.implDatabaseMetaData.getResultSetSQL(8, null, baseresultsetsortdescriptor);
            BaseColumns basecolumns = new BaseColumns();
            BaseColumn basecolumn = new BaseColumn(12);
            basecolumn.label = "TABLE_CAT";
            basecolumn.name = "TABLE_CAT";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            BaseStatement basestatement = (BaseStatement)this.connection.createStatement();
            basestatement.setupForDatabaseMetaData(basecolumns, 8, null, baseresultsetsortdescriptor, null);
            ResultSet resultSet = resultset = basestatement.executeQuery(s);
            return resultSet;
        }
    }

    public ResultSet getColumnPrivileges(String s, String s1, String s2, String s3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            ResultSet resultset;
            this.validateClosedState();
            if (s == null && s2 == null && s1 == null && s3 == null) {
                String[] as = new String[]{"getColumnPrivileges"};
                throw this.exceptions.getException(6003, as);
            }
            int[] ai = new int[]{1, 2, 3, 4};
            Object[] aobj = new Object[]{s, s1, s2, s3};
            boolean[] aflag = new boolean[]{false, false, false, true};
            BaseResultSetFilterDescriptor baseresultsetfilterdescriptor = new BaseResultSetFilterDescriptor(ai, aobj, aflag);
            int[] ai1 = new int[]{4, 7};
            BaseResultSetSortDescriptor baseresultsetsortdescriptor = new BaseResultSetSortDescriptor(ai1);
            String s4 = this.implDatabaseMetaData.getResultSetSQL(9, baseresultsetfilterdescriptor, baseresultsetsortdescriptor);
            BaseColumns basecolumns = new BaseColumns();
            BaseColumn basecolumn = new BaseColumn(12);
            basecolumn.label = "TABLE_CAT";
            basecolumn.name = "TABLE_CAT";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "TABLE_SCHEM";
            basecolumn.name = "TABLE_SCHEM";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "TABLE_NAME";
            basecolumn.name = "TABLE_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "COLUMN_NAME";
            basecolumn.name = "COLUMN_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "GRANTOR";
            basecolumn.name = "GRANTOR";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "GRANTEE";
            basecolumn.name = "GRANTEE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "PRIVILEGE";
            basecolumn.name = "PRIVILEGE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "IS_GRANTABLE";
            basecolumn.name = "IS_GRANTABLE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            BaseStatement basestatement = (BaseStatement)this.connection.createStatement();
            basestatement.setupForDatabaseMetaData(basecolumns, 9, baseresultsetfilterdescriptor, baseresultsetsortdescriptor, null);
            ResultSet resultSet = resultset = basestatement.executeQuery(s4);
            return resultSet;
        }
    }

    public ResultSet getColumns(String s, String s1, String s2, String s3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            ResultSet resultset;
            this.validateClosedState();
            int[] ai = new int[]{1, 2, 3, 4};
            Object[] aobj = new Object[]{s, s1, s2, s3};
            boolean[] aflag = new boolean[]{false, true, true, true};
            BaseResultSetFilterDescriptor baseresultsetfilterdescriptor = new BaseResultSetFilterDescriptor(ai, aobj, aflag);
            int[] ai1 = new int[]{2, 3, 17};
            BaseResultSetSortDescriptor baseresultsetsortdescriptor = new BaseResultSetSortDescriptor(ai1);
            String s4 = this.implDatabaseMetaData.getResultSetSQL(2, baseresultsetfilterdescriptor, baseresultsetsortdescriptor);
            BaseColumns basecolumns = new BaseColumns();
            BaseColumn basecolumn = new BaseColumn(12);
            basecolumn.label = "TABLE_CAT";
            basecolumn.name = "TABLE_CAT";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "TABLE_SCHEM";
            basecolumn.name = "TABLE_SCHEM";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "TABLE_NAME";
            basecolumn.name = "TABLE_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "COLUMN_NAME";
            basecolumn.name = "COLUMN_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "DATA_TYPE";
            basecolumn.name = "DATA_TYPE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "TYPE_NAME";
            basecolumn.name = "TYPE_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            basecolumn.label = "COLUMN_SIZE";
            basecolumn.name = "COLUMN_SIZE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            basecolumn.label = "BUFFER_LENGTH";
            basecolumn.name = "BUFFER_LENGTH";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            basecolumn.label = "DECIMAL_DIGITS";
            basecolumn.name = "DECIMAL_DIGITS";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            basecolumn.label = "NUM_PREC_RADIX";
            basecolumn.name = "NUM_PREC_RADIX";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            basecolumn.label = "NULLABLE";
            basecolumn.name = "NULLABLE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "REMARKS";
            basecolumn.name = "REMARKS";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "COLUMN_DEF";
            basecolumn.name = "COLUMN_DEF";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            basecolumn.label = "SQL_DATA_TYPE";
            basecolumn.name = "SQL_DATA_TYPE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            basecolumn.label = "SQL_DATETIME_SUB";
            basecolumn.name = "SQL_DATETIME_SUB";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            basecolumn.label = "CHAR_OCTET_LENGTH";
            basecolumn.name = "CHAR_OCTET_LENGTH";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            basecolumn.label = "ORDINAL_POSITION";
            basecolumn.name = "ORDINAL_POSITION";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "IS_NULLABLE";
            basecolumn.name = "IS_NULLABLE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            BaseStatement basestatement = (BaseStatement)this.connection.createStatement();
            basestatement.setupForDatabaseMetaData(basecolumns, 2, baseresultsetfilterdescriptor, baseresultsetsortdescriptor, null);
            ResultSet resultSet = resultset = basestatement.executeQuery(s4);
            return resultSet;
        }
    }

    public Connection getConnection() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            Connection connection1;
            this.validateClosedState();
            Connection connection = connection1 = this.ownerConnection;
            return connection;
        }
    }

    public ResultSet getCrossReference(String s, String s1, String s2, String s3, String s4, String s5) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            ResultSet resultset;
            this.validateClosedState();
            if (s2 == null || s5 == null) {
                String[] as = new String[]{"getCrossReference"};
                throw this.exceptions.getException(6003, as);
            }
            int[] ai = new int[]{1, 2, 3, 4, 5, 6};
            Object[] aobj = new Object[]{s, s1, s2, s3, s4, s5};
            boolean[] aflag = new boolean[6];
            BaseResultSetFilterDescriptor baseresultsetfilterdescriptor = new BaseResultSetFilterDescriptor(ai, aobj, aflag);
            int[] ai1 = new int[]{5, 6, 7, 9};
            BaseResultSetSortDescriptor baseresultsetsortdescriptor = new BaseResultSetSortDescriptor(ai1);
            String s6 = this.implDatabaseMetaData.getResultSetSQL(10, baseresultsetfilterdescriptor, baseresultsetsortdescriptor);
            BaseColumns basecolumns = new BaseColumns();
            BaseColumn basecolumn = new BaseColumn(12);
            basecolumn.label = "PKTABLE_CAT";
            basecolumn.name = "PKTABLE_CAT";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "PKTABLE_SCHEM";
            basecolumn.name = "PKTABLE_SCHEM";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "PKTABLE_NAME";
            basecolumn.name = "PKTABLE_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "PKCOLUMN_NAME";
            basecolumn.name = "PKCOLUMN_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "FKTABLE_CAT";
            basecolumn.name = "FKTABLE_CAT";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "FKTABLE_SCHEM";
            basecolumn.name = "FKTABLE_SCHEM";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "FKTABLE_NAME";
            basecolumn.name = "FKTABLE_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "FKCOLUMN_NAME";
            basecolumn.name = "FKCOLUMN_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "KEY_SEQ";
            basecolumn.name = "KEY_SEQ";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "UPDATE_RULE";
            basecolumn.name = "UPDATE_RULE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "DELETE_RULE";
            basecolumn.name = "DELETE_RULE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "FK_NAME";
            basecolumn.name = "FK_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "PK_NAME";
            basecolumn.name = "PK_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "DEFERRABILITY";
            basecolumn.name = "DEFERRABILITY";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            BaseStatement basestatement = (BaseStatement)this.connection.createStatement();
            basestatement.setupForDatabaseMetaData(basecolumns, 10, baseresultsetfilterdescriptor, baseresultsetsortdescriptor, null);
            ResultSet resultSet = resultset = basestatement.executeQuery(s6);
            return resultSet;
        }
    }

    public String getDatabaseProductName() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String s;
            this.validateClosedState();
            if (this.implDatabaseMetaData.databaseProductName == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(8);
            }
            String string = s = this.implDatabaseMetaData.databaseProductName;
            return string;
        }
    }

    public String getDatabaseProductVersion() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String s;
            this.validateClosedState();
            if (this.implDatabaseMetaData.databaseProductVersion == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(9);
            }
            String string = s = this.implDatabaseMetaData.databaseProductVersion;
            return string;
        }
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int i;
            this.validateClosedState();
            if (this.implDatabaseMetaData.defaultTransactionIsolation == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(105);
            }
            int n = i = this.implDatabaseMetaData.defaultTransactionIsolation.intValue();
            return n;
        }
    }

    public int getDriverMajorVersion() {
        return 2;
    }

    public int getDriverMinorVersion() {
        return 1;
    }

    public String getDriverName() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String s;
            this.validateClosedState();
            String string = s = this.connection.driverName;
            return string;
        }
    }

    public String getDriverVersion() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String s;
            this.validateClosedState();
            String string = s = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Integer.toString(2)))).append(".").append(Integer.toString(1)).append(".").append("0003")));
            return string;
        }
    }

    public ResultSet getExportedKeys(String s, String s1, String s2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            ResultSet resultset;
            this.validateClosedState();
            if (s == null && s2 == null && s1 == null) {
                String[] as = new String[]{"getExportedKeys"};
                throw this.exceptions.getException(6003, as);
            }
            int[] ai = new int[]{1, 2, 3};
            Object[] aobj = new Object[]{s, s1, s2};
            boolean[] aflag = new boolean[3];
            BaseResultSetFilterDescriptor baseresultsetfilterdescriptor = new BaseResultSetFilterDescriptor(ai, aobj, aflag);
            int[] ai1 = new int[]{5, 6, 7, 9};
            BaseResultSetSortDescriptor baseresultsetsortdescriptor = new BaseResultSetSortDescriptor(ai1);
            String s3 = this.implDatabaseMetaData.getResultSetSQL(11, baseresultsetfilterdescriptor, baseresultsetsortdescriptor);
            BaseColumns basecolumns = new BaseColumns();
            BaseColumn basecolumn = new BaseColumn(12);
            basecolumn.label = "PKTABLE_CAT";
            basecolumn.name = "PKTABLE_CAT";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "PKTABLE_SCHEM";
            basecolumn.name = "PKTABLE_SCHEM";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "PKTABLE_NAME";
            basecolumn.name = "PKTABLE_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "PKCOLUMN_NAME";
            basecolumn.name = "PKCOLUMN_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "FKTABLE_CAT";
            basecolumn.name = "FKTABLE_CAT";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "FKTABLE_SCHEM";
            basecolumn.name = "FKTABLE_SCHEM";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "FKTABLE_NAME";
            basecolumn.name = "FKTABLE_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "FKCOLUMN_NAME";
            basecolumn.name = "FKCOLUMN_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "KEY_SEQ";
            basecolumn.name = "KEY_SEQ";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "UPDATE_RULE";
            basecolumn.name = "UPDATE_RULE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "DELETE_RULE";
            basecolumn.name = "DELETE_RULE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "FK_NAME";
            basecolumn.name = "FK_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "PK_NAME";
            basecolumn.name = "PK_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "DEFERRABILITY";
            basecolumn.name = "DEFERRABILITY";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            BaseStatement basestatement = (BaseStatement)this.connection.createStatement();
            basestatement.setupForDatabaseMetaData(basecolumns, 11, baseresultsetfilterdescriptor, baseresultsetsortdescriptor, null);
            ResultSet resultSet = resultset = basestatement.executeQuery(s3);
            return resultSet;
        }
    }

    public String getExtraNameCharacters() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String s;
            this.validateClosedState();
            if (this.implDatabaseMetaData.extraNameCharacters == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(27);
            }
            String string = s = this.implDatabaseMetaData.extraNameCharacters;
            return string;
        }
    }

    public String getIdentifierQuoteString() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String s;
            this.validateClosedState();
            if (this.implDatabaseMetaData.identifierQuoteString == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(20);
            }
            String string = s = this.implDatabaseMetaData.identifierQuoteString;
            return string;
        }
    }

    public ResultSet getImportedKeys(String s, String s1, String s2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            ResultSet resultset;
            this.validateClosedState();
            if (s2 == null) {
                String[] as = new String[]{"getImportedKeys"};
                throw this.exceptions.getException(6003, as);
            }
            int[] ai = new int[]{1, 2, 3};
            Object[] aobj = new Object[]{s, s1, s2};
            boolean[] aflag = new boolean[3];
            BaseResultSetFilterDescriptor baseresultsetfilterdescriptor = new BaseResultSetFilterDescriptor(ai, aobj, aflag);
            int[] ai1 = new int[]{1, 2, 3, 9};
            BaseResultSetSortDescriptor baseresultsetsortdescriptor = new BaseResultSetSortDescriptor(ai1);
            String s3 = this.implDatabaseMetaData.getResultSetSQL(12, baseresultsetfilterdescriptor, baseresultsetsortdescriptor);
            BaseColumns basecolumns = new BaseColumns();
            BaseColumn basecolumn = new BaseColumn(12);
            basecolumn.label = "PKTABLE_CAT";
            basecolumn.name = "PKTABLE_CAT";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "PKTABLE_SCHEM";
            basecolumn.name = "PKTABLE_SCHEM";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "PKTABLE_NAME";
            basecolumn.name = "PKTABLE_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "PKCOLUMN_NAME";
            basecolumn.name = "PKCOLUMN_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "FKTABLE_CAT";
            basecolumn.name = "FKTABLE_CAT";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "FKTABLE_SCHEM";
            basecolumn.name = "FKTABLE_SCHEM";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "FKTABLE_NAME";
            basecolumn.name = "FKTABLE_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "FKCOLUMN_NAME";
            basecolumn.name = "FKCOLUMN_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "KEY_SEQ";
            basecolumn.name = "KEY_SEQ";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "UPDATE_RULE";
            basecolumn.name = "UPDATE_RULE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "DELETE_RULE";
            basecolumn.name = "DELETE_RULE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "FK_NAME";
            basecolumn.name = "FK_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "PK_NAME";
            basecolumn.name = "PK_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "DEFERRABILITY";
            basecolumn.name = "DEFERRABILITY";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            BaseStatement basestatement = (BaseStatement)this.connection.createStatement();
            basestatement.setupForDatabaseMetaData(basecolumns, 12, baseresultsetfilterdescriptor, baseresultsetsortdescriptor, null);
            ResultSet resultSet = resultset = basestatement.executeQuery(s3);
            return resultSet;
        }
    }

    public ResultSet getIndexInfo(String s, String s1, String s2, boolean flag, boolean flag1) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            ResultSet resultset;
            this.validateClosedState();
            if (s2 == null) {
                throw this.exceptions.getException(6046);
            }
            int[] ai = new int[]{1, 2, 3, 4, 14};
            Object[] aobj = new Object[]{s, s1, s2, new Boolean(flag), new Boolean(flag1)};
            boolean[] aflag = new boolean[5];
            BaseResultSetFilterDescriptor baseresultsetfilterdescriptor = new BaseResultSetFilterDescriptor(ai, aobj, aflag);
            int[] ai1 = new int[]{4, 7, 6, 8};
            BaseResultSetSortDescriptor baseresultsetsortdescriptor = new BaseResultSetSortDescriptor(ai1);
            String s3 = this.implDatabaseMetaData.getResultSetSQL(13, baseresultsetfilterdescriptor, baseresultsetsortdescriptor);
            BaseColumns basecolumns = new BaseColumns();
            BaseColumn basecolumn = new BaseColumn(12);
            basecolumn.label = "TABLE_CAT";
            basecolumn.name = "TABLE_CAT";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "TABLE_SCHEM";
            basecolumn.name = "TABLE_SCHEM";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "TABLE_NAME";
            basecolumn.name = "TABLE_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(-7);
            basecolumn.label = "NON_UNIQUE";
            basecolumn.name = "NON_UNIQUE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "INDEX_QUALIFIER";
            basecolumn.name = "INDEX_QUALIFIER";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "INDEX_NAME";
            basecolumn.name = "INDEX_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "TYPE";
            basecolumn.name = "TYPE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "ORDINAL_POSITION";
            basecolumn.name = "ORDINAL_POSITION";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "COLUMN_NAME";
            basecolumn.name = "COLUMN_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "ASC_OR_DESC";
            basecolumn.name = "ASC_OR_DESC";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            basecolumn.label = "CARDINALITY";
            basecolumn.name = "CARDINALITY";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            basecolumn.label = "PAGES";
            basecolumn.name = "PAGES";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "FILTER_CONDITION";
            basecolumn.name = "FILTER_CONDITION";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            if (!baseresultsetfilterdescriptor.allRestrictionsSatified()) {
                BaseColumn basecolumn1 = new BaseColumn(-7);
                basecolumn1.label = "APPROXIMATE";
                basecolumn1.name = "APPROXIMATE";
                this.setCommonResultSetMetaData(basecolumn1);
                basecolumns.add(basecolumn1);
            }
            BaseStatement basestatement = (BaseStatement)this.connection.createStatement();
            basestatement.setupForDatabaseMetaData(basecolumns, 13, baseresultsetfilterdescriptor, baseresultsetsortdescriptor, null);
            ResultSet resultSet = resultset = basestatement.executeQuery(s3);
            return resultSet;
        }
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int i;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxBinaryLiteralLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(84);
            }
            int n = i = this.implDatabaseMetaData.maxBinaryLiteralLength.intValue();
            return n;
        }
    }

    public int getMaxCatalogNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int i;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxCatalogNameLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(97);
            }
            int n = i = this.implDatabaseMetaData.maxCatalogNameLength.intValue();
            return n;
        }
    }

    public int getMaxCharLiteralLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int i;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxCharLiteralLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(85);
            }
            int n = i = this.implDatabaseMetaData.maxCharLiteralLength.intValue();
            return n;
        }
    }

    public int getMaxColumnNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int i;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxColumnNameLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(86);
            }
            int n = i = this.implDatabaseMetaData.maxColumnNameLength.intValue();
            return n;
        }
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int i;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxColumnsInGroupBy == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(87);
            }
            int n = i = this.implDatabaseMetaData.maxColumnsInGroupBy.intValue();
            return n;
        }
    }

    public int getMaxColumnsInIndex() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int i;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxColumnsInIndex == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(88);
            }
            int n = i = this.implDatabaseMetaData.maxColumnsInIndex.intValue();
            return n;
        }
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int i;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxColumnsInOrderBy == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(89);
            }
            int n = i = this.implDatabaseMetaData.maxColumnsInOrderBy.intValue();
            return n;
        }
    }

    public int getMaxColumnsInSelect() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int i;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxColumnsInSelect == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(90);
            }
            int n = i = this.implDatabaseMetaData.maxColumnsInSelect.intValue();
            return n;
        }
    }

    public int getMaxColumnsInTable() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int i;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxColumnsInTable == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(91);
            }
            int n = i = this.implDatabaseMetaData.maxColumnsInTable.intValue();
            return n;
        }
    }

    public int getMaxConnections() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int i;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxConnections == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(92);
            }
            int n = i = this.implDatabaseMetaData.maxConnections.intValue();
            return n;
        }
    }

    public int getMaxCursorNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int i;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxCursorNameLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(93);
            }
            int n = i = this.implDatabaseMetaData.maxCursorNameLength.intValue();
            return n;
        }
    }

    public int getMaxIndexLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int i;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxIndexLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(94);
            }
            int n = i = this.implDatabaseMetaData.maxIndexLength.intValue();
            return n;
        }
    }

    public int getMaxProcedureNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int i;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxProcedureNameLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(96);
            }
            int n = i = this.implDatabaseMetaData.maxProcedureNameLength.intValue();
            return n;
        }
    }

    public int getMaxRowSize() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int i;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxRowSize == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(98);
            }
            int n = i = this.implDatabaseMetaData.maxRowSize.intValue();
            return n;
        }
    }

    public int getMaxSchemaNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int i;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxSchemaNameLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(95);
            }
            int n = i = this.implDatabaseMetaData.maxSchemaNameLength.intValue();
            return n;
        }
    }

    public int getMaxStatementLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int i;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxStatementLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(100);
            }
            int n = i = this.implDatabaseMetaData.maxStatementLength.intValue();
            return n;
        }
    }

    public int getMaxStatements() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int i;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxStatements == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(101);
            }
            int n = i = 0;
            return n;
        }
    }

    public int getMaxTableNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int i;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxTableNameLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(102);
            }
            int n = i = this.implDatabaseMetaData.maxTableNameLength.intValue();
            return n;
        }
    }

    public int getMaxTablesInSelect() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int i;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxTablesInSelect == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(103);
            }
            int n = i = this.implDatabaseMetaData.maxTablesInSelect.intValue();
            return n;
        }
    }

    public int getMaxUserNameLength() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int i;
            this.validateClosedState();
            if (this.implDatabaseMetaData.maxUserNameLength == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(104);
            }
            int n = i = this.implDatabaseMetaData.maxUserNameLength.intValue();
            return n;
        }
    }

    public String getNumericFunctions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String s;
            this.validateClosedState();
            if (this.implDatabaseMetaData.numericFunctions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(22);
            }
            String string = s = this.implDatabaseMetaData.numericFunctions;
            return string;
        }
    }

    public ResultSet getPrimaryKeys(String s, String s1, String s2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            ResultSet resultset;
            this.validateClosedState();
            if (s == null && s2 == null && s1 == null) {
                String[] as = new String[]{"getColumnPrivileges"};
                throw this.exceptions.getException(6003, as);
            }
            int[] ai = new int[]{1, 2, 3};
            Object[] aobj = new Object[]{s, s1, s2};
            boolean[] aflag = new boolean[3];
            BaseResultSetFilterDescriptor baseresultsetfilterdescriptor = new BaseResultSetFilterDescriptor(ai, aobj, aflag);
            int[] ai1 = new int[]{4};
            BaseResultSetSortDescriptor baseresultsetsortdescriptor = new BaseResultSetSortDescriptor(ai1);
            String s3 = this.implDatabaseMetaData.getResultSetSQL(14, baseresultsetfilterdescriptor, baseresultsetsortdescriptor);
            BaseColumns basecolumns = new BaseColumns();
            BaseColumn basecolumn = new BaseColumn(12);
            basecolumn.label = "TABLE_CAT";
            basecolumn.name = "TABLE_CAT";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "TABLE_SCHEM";
            basecolumn.name = "TABLE_SCHEM";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "TABLE_NAME";
            basecolumn.name = "TABLE_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "COLUMN_NAME";
            basecolumn.name = "COLUMN_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "KEY_SEQ";
            basecolumn.name = "KEY_SEQ";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "PK_NAME";
            basecolumn.name = "PK_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            BaseStatement basestatement = (BaseStatement)this.connection.createStatement();
            basestatement.setupForDatabaseMetaData(basecolumns, 14, baseresultsetfilterdescriptor, baseresultsetsortdescriptor, null);
            ResultSet resultSet = resultset = basestatement.executeQuery(s3);
            return resultSet;
        }
    }

    public ResultSet getProcedureColumns(String s, String s1, String s2, String s3) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            ResultSet resultset;
            this.validateClosedState();
            int[] ai = new int[]{1, 2, 3, 4};
            Object[] aobj = new Object[]{s, s1, s2, s3};
            boolean[] aflag = new boolean[]{false, true, true, true};
            BaseResultSetFilterDescriptor baseresultsetfilterdescriptor = new BaseResultSetFilterDescriptor(ai, aobj, aflag);
            int[] ai1 = new int[]{2, 3};
            BaseResultSetSortDescriptor baseresultsetsortdescriptor = new BaseResultSetSortDescriptor(ai1);
            String s4 = this.implDatabaseMetaData.getResultSetSQL(6, baseresultsetfilterdescriptor, baseresultsetsortdescriptor);
            BaseColumns basecolumns = new BaseColumns();
            BaseColumn basecolumn = new BaseColumn(12);
            basecolumn.label = "PROCEDURE_CAT";
            basecolumn.name = "PROCEDURE_CAT";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "PROCEDURE_SCHEM";
            basecolumn.name = "PROCEDURE_SCHEM";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "PROCEDURE_NAME";
            basecolumn.name = "PROCEDURE_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "COLUMN_NAME";
            basecolumn.name = "COLUMN_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "COLUMN_TYPE";
            basecolumn.name = "COLUMN_TYPE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "DATA_TYPE";
            basecolumn.name = "DATA_TYPE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "TYPE_NAME";
            basecolumn.name = "TYPE_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            basecolumn.label = "PRECISION";
            basecolumn.name = "PRECISION";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            basecolumn.label = "LENGTH";
            basecolumn.name = "LENGTH";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "SCALE";
            basecolumn.name = "SCALE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            basecolumn.label = "RADIX";
            basecolumn.name = "RADIX";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "NULLABLE";
            basecolumn.name = "NULLABLE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "REMARKS";
            basecolumn.name = "REMARKS";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            BaseStatement basestatement = (BaseStatement)this.connection.createStatement();
            basestatement.setupForDatabaseMetaData(basecolumns, 6, baseresultsetfilterdescriptor, baseresultsetsortdescriptor, null);
            ResultSet resultSet = resultset = basestatement.executeQuery(s4);
            return resultSet;
        }
    }

    public String getProcedureTerm() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String s;
            this.validateClosedState();
            if (this.implDatabaseMetaData.procedureTerm == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(55);
            }
            String string = s = this.implDatabaseMetaData.procedureTerm;
            return string;
        }
    }

    public ResultSet getProcedures(String s, String s1, String s2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            ResultSet resultset;
            this.validateClosedState();
            int[] ai = new int[]{1, 2, 3};
            Object[] aobj = new Object[]{s, s1, s2};
            boolean[] aflag = new boolean[]{false, true, true};
            BaseResultSetFilterDescriptor baseresultsetfilterdescriptor = new BaseResultSetFilterDescriptor(ai, aobj, aflag);
            int[] ai1 = new int[]{2, 3};
            BaseResultSetSortDescriptor baseresultsetsortdescriptor = new BaseResultSetSortDescriptor(ai1);
            String s3 = this.implDatabaseMetaData.getResultSetSQL(5, baseresultsetfilterdescriptor, baseresultsetsortdescriptor);
            BaseColumns basecolumns = new BaseColumns();
            BaseColumn basecolumn = new BaseColumn(12);
            basecolumn.label = "PROCEDURE_CAT";
            basecolumn.name = "PROCEDURE_CAT";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "PROCEDURE_SCHEM";
            basecolumn.name = "PROCEDURE_SCHEM";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "PROCEDURE_NAME";
            basecolumn.name = "PROCEDURE_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            basecolumn.label = "RESERVED_1";
            basecolumn.name = "RESERVED_1";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            basecolumn.label = "RESERVED_2";
            basecolumn.name = "RESERVED_2";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            basecolumn.label = "RESERVED_3";
            basecolumn.name = "RESERVED_3";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "REMARKS";
            basecolumn.name = "REMARKS";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "PROCEDURE_TYPE";
            basecolumn.name = "PROCEDURE_TYPE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            BaseStatement basestatement = (BaseStatement)this.connection.createStatement();
            basestatement.setupForDatabaseMetaData(basecolumns, 5, baseresultsetfilterdescriptor, baseresultsetsortdescriptor, null);
            ResultSet resultSet = resultset = basestatement.executeQuery(s3);
            return resultSet;
        }
    }

    public String getSQLKeywords() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String s;
            this.validateClosedState();
            if (this.implDatabaseMetaData.SQLKeywords == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(21);
            }
            String string = s = this.implDatabaseMetaData.SQLKeywords;
            return string;
        }
    }

    public String getSchemaTerm() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String s;
            this.validateClosedState();
            if (this.implDatabaseMetaData.schemaTerm == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(54);
            }
            String string = s = this.implDatabaseMetaData.schemaTerm;
            return string;
        }
    }

    public ResultSet getSchemas() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            ResultSet resultset;
            this.validateClosedState();
            int[] ai = new int[]{1};
            BaseResultSetSortDescriptor baseresultsetsortdescriptor = new BaseResultSetSortDescriptor(ai);
            String s = this.implDatabaseMetaData.getResultSetSQL(15, null, baseresultsetsortdescriptor);
            BaseColumns basecolumns = new BaseColumns();
            BaseColumn basecolumn = new BaseColumn(12);
            basecolumn.label = "TABLE_SCHEM";
            basecolumn.name = "TABLE_SCHEM";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            BaseStatement basestatement = (BaseStatement)this.connection.createStatement();
            basestatement.setupForDatabaseMetaData(basecolumns, 15, null, baseresultsetsortdescriptor, null);
            ResultSet resultSet = resultset = basestatement.executeQuery(s);
            return resultSet;
        }
    }

    public String getSearchStringEscape() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String s;
            this.validateClosedState();
            if (this.implDatabaseMetaData.searchStringEscape == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(26);
            }
            String string = s = this.implDatabaseMetaData.searchStringEscape;
            return string;
        }
    }

    public String getStringFunctions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String s;
            this.validateClosedState();
            if (this.implDatabaseMetaData.stringFunctions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(23);
            }
            String string = s = this.implDatabaseMetaData.stringFunctions;
            return string;
        }
    }

    public String getSystemFunctions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String s;
            this.validateClosedState();
            if (this.implDatabaseMetaData.systemFunctions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(24);
            }
            String string = s = this.implDatabaseMetaData.systemFunctions;
            return string;
        }
    }

    public ResultSet getTablePrivileges(String s, String s1, String s2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            ResultSet resultset;
            this.validateClosedState();
            int[] ai = new int[]{1, 2, 3};
            Object[] aobj = new Object[]{s, s1, s2};
            boolean[] aflag = new boolean[]{false, true, true};
            BaseResultSetFilterDescriptor baseresultsetfilterdescriptor = new BaseResultSetFilterDescriptor(ai, aobj, aflag);
            int[] ai1 = new int[]{2, 3, 6};
            BaseResultSetSortDescriptor baseresultsetsortdescriptor = new BaseResultSetSortDescriptor(ai1);
            String s3 = this.implDatabaseMetaData.getResultSetSQL(16, baseresultsetfilterdescriptor, baseresultsetsortdescriptor);
            BaseColumns basecolumns = new BaseColumns();
            BaseColumn basecolumn = new BaseColumn(12);
            basecolumn.label = "TABLE_CAT";
            basecolumn.name = "TABLE_CAT";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "TABLE_SCHEM";
            basecolumn.name = "TABLE_SCHEM";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "TABLE_NAME";
            basecolumn.name = "TABLE_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "GRANTOR";
            basecolumn.name = "GRANTOR";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "GRANTEE";
            basecolumn.name = "GRANTEE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "PRIVILEGE";
            basecolumn.name = "PRIVILEGE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "IS_GRANTABLE";
            basecolumn.name = "IS_GRANTABLE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            BaseStatement basestatement = (BaseStatement)this.connection.createStatement();
            basestatement.setupForDatabaseMetaData(basecolumns, 16, baseresultsetfilterdescriptor, baseresultsetsortdescriptor, null);
            ResultSet resultSet = resultset = basestatement.executeQuery(s3);
            return resultSet;
        }
    }

    public ResultSet getTableTypes() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            ResultSet resultset;
            this.validateClosedState();
            BaseColumns basecolumns = new BaseColumns();
            BaseColumn basecolumn = new BaseColumn(12);
            this.setCommonResultSetMetaData(basecolumn);
            basecolumn.label = "TABLE_TYPE";
            basecolumn.name = "TABLE_TYPE";
            basecolumn.displaySize = 32;
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            BaseStatement basestatement = (BaseStatement)this.connection.createStatement();
            BaseTableTypes basetabletypes = this.implDatabaseMetaData.getTableTypes();
            basestatement.setupForDatabaseMetaData(basecolumns, 4, null, null, basetabletypes);
            ResultSet resultSet = resultset = basestatement.executeQuery(null);
            return resultSet;
        }
    }

    public ResultSet getTables(String s, String s1, String s2, String[] as) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            ResultSet resultset;
            this.validateClosedState();
            int[] ai = new int[]{1, 2, 3, 4};
            Object[] aobj = new Object[]{s, s1, s2, as};
            boolean[] aflag = new boolean[]{false, true, true, false};
            BaseResultSetFilterDescriptor baseresultsetfilterdescriptor = new BaseResultSetFilterDescriptor(ai, aobj, aflag);
            int[] ai1 = new int[]{4, 2, 3};
            BaseResultSetSortDescriptor baseresultsetsortdescriptor = new BaseResultSetSortDescriptor(ai1);
            String s3 = this.implDatabaseMetaData.getResultSetSQL(1, baseresultsetfilterdescriptor, baseresultsetsortdescriptor);
            BaseColumns basecolumns = new BaseColumns();
            BaseColumn basecolumn = new BaseColumn(12);
            basecolumn.label = "TABLE_CAT";
            basecolumn.name = "TABLE_CAT";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "TABLE_SCHEM";
            basecolumn.name = "TABLE_SCHEM";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "TABLE_NAME";
            basecolumn.name = "TABLE_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "TABLE_TYPE";
            basecolumn.name = "TABLE_TYPE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "REMARKS";
            basecolumn.name = "REMARKS";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            BaseStatement basestatement = (BaseStatement)this.connection.createStatement();
            basestatement.setupForDatabaseMetaData(basecolumns, 1, baseresultsetfilterdescriptor, baseresultsetsortdescriptor, null);
            ResultSet resultSet = resultset = basestatement.executeQuery(s3);
            return resultSet;
        }
    }

    public String getTimeDateFunctions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String s;
            this.validateClosedState();
            if (this.implDatabaseMetaData.timeDateFunctions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(25);
            }
            String string = s = this.implDatabaseMetaData.timeDateFunctions;
            return string;
        }
    }

    public ResultSet getTypeInfo() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            ResultSet resultset;
            this.validateClosedState();
            BaseColumns basecolumns = new BaseColumns();
            BaseColumn basecolumn = new BaseColumn(12);
            this.setCommonResultSetMetaData(basecolumn);
            basecolumn.label = "TYPE_NAME";
            basecolumn.name = "TYPE_NAME";
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            this.setCommonResultSetMetaData(basecolumn);
            basecolumn.label = "DATA_TYPE";
            basecolumn.name = "DATA_TYPE";
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            this.setCommonResultSetMetaData(basecolumn);
            basecolumn.label = "PRECISION";
            basecolumn.name = "PRECISION";
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            this.setCommonResultSetMetaData(basecolumn);
            basecolumn.label = "LITERAL_PREFIX";
            basecolumn.name = "LITERAL_PREFIX";
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            this.setCommonResultSetMetaData(basecolumn);
            basecolumn.label = "LITERAL_SUFFIX";
            basecolumn.name = "LITERAL_SUFFIX";
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            this.setCommonResultSetMetaData(basecolumn);
            basecolumn.label = "CREATE_PARAMS";
            basecolumn.name = "CREATE_PARAMS";
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            this.setCommonResultSetMetaData(basecolumn);
            basecolumn.label = "NULLABLE";
            basecolumn.name = "NULLABLE";
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(-7);
            this.setCommonResultSetMetaData(basecolumn);
            basecolumn.label = "CASE_SENSITIVE";
            basecolumn.name = "CASE_SENSITIVE";
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            this.setCommonResultSetMetaData(basecolumn);
            basecolumn.label = "SEARCHABLE";
            basecolumn.name = "SEARCHABLE";
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(-7);
            this.setCommonResultSetMetaData(basecolumn);
            basecolumn.label = "UNSIGNED_ATTRIBUTE";
            basecolumn.name = "UNSIGNED_ATTRIBUTE";
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(-7);
            this.setCommonResultSetMetaData(basecolumn);
            basecolumn.label = "FIXED_PREC_SCALE";
            basecolumn.name = "FIXED_PREC_SCALE";
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(-7);
            this.setCommonResultSetMetaData(basecolumn);
            basecolumn.label = "AUTO_INCREMENT";
            basecolumn.name = "AUTO_INCREMENT";
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            this.setCommonResultSetMetaData(basecolumn);
            basecolumn.label = "LOCAL_TYPE_NAME";
            basecolumn.name = "LOCAL_TYPE_NAME";
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            this.setCommonResultSetMetaData(basecolumn);
            basecolumn.label = "MINIMUM_SCALE";
            basecolumn.name = "MINIMUM_SCALE";
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            this.setCommonResultSetMetaData(basecolumn);
            basecolumn.label = "MAXIMUM_SCALE";
            basecolumn.name = "MAXIMUM_SCALE";
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            this.setCommonResultSetMetaData(basecolumn);
            basecolumn.label = "SQL_DATA_TYPE";
            basecolumn.name = "SQL_DATA_TYPE";
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            this.setCommonResultSetMetaData(basecolumn);
            basecolumn.label = "SQL_DATETIME_SUB";
            basecolumn.name = "SQL_DATETIME_SUB";
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            this.setCommonResultSetMetaData(basecolumn);
            basecolumn.label = "NUM_PREC_RADIX";
            basecolumn.name = "NUM_PREC_RADIX";
            basecolumns.add(basecolumn);
            BaseStatement basestatement = (BaseStatement)this.connection.createStatement();
            BaseTypeInfos basetypeinfos = this.implDatabaseMetaData.getTypeInfo();
            basestatement.setupForDatabaseMetaData(basecolumns, 3, null, null, basetypeinfos);
            ResultSet resultSet = resultset = basestatement.executeQuery(null);
            return resultSet;
        }
    }

    public ResultSet getUDTs(String s, String s1, String s2, int[] ai) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            ResultSet resultset;
            this.validateClosedState();
            int[] ai1 = new int[]{1, 2, 3, 4};
            Object[] aobj = new Object[]{s, s1, s2, ai};
            boolean[] aflag = new boolean[]{false, true, true, false};
            BaseResultSetFilterDescriptor baseresultsetfilterdescriptor = new BaseResultSetFilterDescriptor(ai1, aobj, aflag);
            int[] ai2 = new int[]{5, 2, 3};
            BaseResultSetSortDescriptor baseresultsetsortdescriptor = new BaseResultSetSortDescriptor(ai2);
            String s3 = this.implDatabaseMetaData.getResultSetSQL(17, baseresultsetfilterdescriptor, baseresultsetsortdescriptor);
            BaseColumns basecolumns = new BaseColumns();
            BaseColumn basecolumn = new BaseColumn(12);
            basecolumn.label = "TYPE_CAT";
            basecolumn.name = "TYPE_CAT";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "TYPE_SCHEM";
            basecolumn.name = "TYPE_SCHEM";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "TYPE_NAME";
            basecolumn.name = "TYPE_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "CLASS_NAME";
            basecolumn.name = "CLASS_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "DATA_TYPE";
            basecolumn.name = "DATA_TYPE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "REMARKS";
            basecolumn.name = "REMARKS";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            BaseStatement basestatement = (BaseStatement)this.connection.createStatement();
            basestatement.setupForDatabaseMetaData(basecolumns, 17, baseresultsetfilterdescriptor, baseresultsetsortdescriptor, null);
            ResultSet resultSet = resultset = basestatement.executeQuery(s3);
            return resultSet;
        }
    }

    public String getURL() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String s;
            this.validateClosedState();
            String s1 = String.valueOf(String.valueOf(new StringBuffer("jdbc:apusic:").append(this.connection.driverName.toLowerCase()).append("://").append(this.connection.connectProps.get("serverName")).append(":").append(this.connection.connectProps.get("portNumber"))));
            Enumeration enumeration = this.connection.connectProps.propertyNames();
            Object obj = null;
            Object obj1 = null;
            while (enumeration.hasMoreElements()) {
                String s2 = (String)enumeration.nextElement();
                if (s2.equals("USER") || s2.equals("PASSWORD") || s2.equals("SERVERNAME") || s2.equals("PORTNUMBER")) continue;
                String s3 = this.connection.connectProps.get(s2);
                s1 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(s1))).append(";").append(s2).append("=").append(s3)));
            }
            String string = s = s1;
            return string;
        }
    }

    public String getUserName() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String s;
            this.validateClosedState();
            String string = s = this.connection.connectProps.get("user");
            return string;
        }
    }

    public ResultSet getVersionColumns(String s, String s1, String s2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            ResultSet resultset;
            this.validateClosedState();
            int[] ai = new int[]{9, 10, 11};
            Object[] aobj = new Object[]{s, s1, s2};
            boolean[] aflag = new boolean[3];
            BaseResultSetFilterDescriptor baseresultsetfilterdescriptor = new BaseResultSetFilterDescriptor(ai, aobj, aflag);
            int[] ai1 = new int[]{};
            BaseResultSetSortDescriptor baseresultsetsortdescriptor = new BaseResultSetSortDescriptor(ai1);
            String s3 = this.implDatabaseMetaData.getResultSetSQL(18, baseresultsetfilterdescriptor, baseresultsetsortdescriptor);
            BaseColumns basecolumns = new BaseColumns();
            BaseColumn basecolumn = new BaseColumn(5);
            basecolumn.label = "SCOPE";
            basecolumn.name = "SCOPE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "COLUMN_NAME";
            basecolumn.name = "COLUMN_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "DATA_TYPE";
            basecolumn.name = "DATA_TYPE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(12);
            basecolumn.label = "TYPE_NAME";
            basecolumn.name = "TYPE_NAME";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            basecolumn.label = "COLUMN_SIZE";
            basecolumn.name = "COLUMN_SIZE";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(4);
            basecolumn.label = "BUFFER_LENGTH";
            basecolumn.name = "BUFFER_LENGTH";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "DECIMAL_DIGITS";
            basecolumn.name = "DECIMAL_DIGITS";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            basecolumn = new BaseColumn(5);
            basecolumn.label = "PSEUDO_COLUMN";
            basecolumn.name = "PSEUDO_COLUMN";
            this.setCommonResultSetMetaData(basecolumn);
            basecolumns.add(basecolumn);
            if (!baseresultsetfilterdescriptor.allRestrictionsSatified()) {
                BaseColumn basecolumn1 = new BaseColumn(12);
                basecolumn1.label = "TABLE_CAT";
                basecolumn1.name = "TABLE_CAT";
                this.setCommonResultSetMetaData(basecolumn1);
                basecolumns.add(basecolumn1);
                basecolumn1 = new BaseColumn(12);
                basecolumn1.label = "TABLE_SCHEM";
                basecolumn1.name = "TABLE_SCHEM";
                this.setCommonResultSetMetaData(basecolumn1);
                basecolumns.add(basecolumn1);
                basecolumn1 = new BaseColumn(12);
                basecolumn1.label = "TABLE_NAME";
                basecolumn1.name = "TABLE_NAME";
                this.setCommonResultSetMetaData(basecolumn1);
                basecolumns.add(basecolumn1);
            }
            BaseStatement basestatement = (BaseStatement)this.connection.createStatement();
            basestatement.setupForDatabaseMetaData(basecolumns, 18, baseresultsetfilterdescriptor, baseresultsetsortdescriptor, null);
            ResultSet resultSet = resultset = basestatement.executeQuery(s3);
            return resultSet;
        }
    }

    public boolean insertsAreDetected(int i) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            boolean flag1 = false;
            switch (i) {
                case 1003: {
                    if (this.implDatabaseMetaData.insertsAreDetectedForwardOnly == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(141);
                    }
                    flag1 = this.implDatabaseMetaData.insertsAreDetectedForwardOnly;
                    break;
                }
                case 1004: {
                    if (this.implDatabaseMetaData.insertsAreDetectedScrollInsensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(142);
                    }
                    flag1 = this.implDatabaseMetaData.insertsAreDetectedScrollInsensitive;
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.insertsAreDetectedScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(143);
                    }
                    flag1 = this.implDatabaseMetaData.insertsAreDetectedScrollSensitive;
                    break;
                }
                default: {
                    String[] as = new String[]{"insertsAreDetected"};
                    throw this.exceptions.getException(6003, as);
                }
            }
            boolean bl = flag = flag1;
            return bl;
        }
    }

    public boolean isCatalogAtStart() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.isCatalogAtStart == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(57);
            }
            boolean bl = flag = this.implDatabaseMetaData.isCatalogAtStart.booleanValue();
            return bl;
        }
    }

    public boolean isReadOnly() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.isReadOnly == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(3);
            }
            boolean bl = flag = this.implDatabaseMetaData.isReadOnly.booleanValue();
            return bl;
        }
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.nullPlusNonNullIsNull == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(31);
            }
            boolean bl = flag = this.implDatabaseMetaData.nullPlusNonNullIsNull.booleanValue();
            return bl;
        }
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.nullsAreSortedAtEnd == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(7);
            }
            boolean bl = flag = this.implDatabaseMetaData.nullsAreSortedAtEnd.booleanValue();
            return bl;
        }
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.nullsAreSortedAtStart == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(6);
            }
            boolean bl = flag = this.implDatabaseMetaData.nullsAreSortedAtStart.booleanValue();
            return bl;
        }
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.nullsAreSortedHigh == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(4);
            }
            boolean bl = flag = this.implDatabaseMetaData.nullsAreSortedHigh.booleanValue();
            return bl;
        }
    }

    public boolean nullsAreSortedLow() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.nullsAreSortedLow == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(5);
            }
            boolean bl = flag = this.implDatabaseMetaData.nullsAreSortedLow.booleanValue();
            return bl;
        }
    }

    public boolean othersDeletesAreVisible(int i) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            boolean flag1 = false;
            switch (i) {
                case 1003: {
                    if (this.implDatabaseMetaData.othersDeletesAreVisibleForwardOnly == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(129);
                    }
                    flag1 = this.implDatabaseMetaData.othersDeletesAreVisibleForwardOnly;
                    flag1 = false;
                    break;
                }
                case 1004: {
                    if (this.implDatabaseMetaData.othersDeletesAreVisibleScrollInsensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(130);
                    }
                    flag1 = this.implDatabaseMetaData.othersDeletesAreVisibleScrollInsensitive;
                    flag1 = false;
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.othersDeletesAreVisibleScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(131);
                    }
                    flag1 = this.implDatabaseMetaData.othersDeletesAreVisibleScrollSensitive;
                    flag1 = false;
                    break;
                }
                default: {
                    String[] as = new String[]{"othersDeletesAreVisible"};
                    throw this.exceptions.getException(6003, as);
                }
            }
            boolean bl = flag = flag1;
            return bl;
        }
    }

    public boolean othersInsertsAreVisible(int i) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            boolean flag1 = false;
            switch (i) {
                case 1003: {
                    if (this.implDatabaseMetaData.othersInsertsAreVisibleForwardOnly == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(132);
                    }
                    flag1 = this.implDatabaseMetaData.othersInsertsAreVisibleForwardOnly;
                    break;
                }
                case 1004: {
                    if (this.implDatabaseMetaData.othersInsertsAreVisibleScrollInsensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(133);
                    }
                    flag1 = this.implDatabaseMetaData.othersInsertsAreVisibleScrollInsensitive;
                    flag1 = false;
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.othersInsertsAreVisibleScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(134);
                    }
                    flag1 = this.implDatabaseMetaData.othersInsertsAreVisibleScrollSensitive;
                    flag1 = false;
                    break;
                }
                default: {
                    String[] as = new String[]{"othersInsertsAreVisible"};
                    throw this.exceptions.getException(6003, as);
                }
            }
            boolean bl = flag = flag1;
            return bl;
        }
    }

    public boolean othersUpdatesAreVisible(int i) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            boolean flag1 = false;
            switch (i) {
                case 1003: {
                    if (this.implDatabaseMetaData.othersUpdatesAreVisibleForwardOnly == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(126);
                    }
                    flag1 = this.implDatabaseMetaData.othersUpdatesAreVisibleForwardOnly;
                    break;
                }
                case 1004: {
                    if (this.implDatabaseMetaData.othersUpdatesAreVisibleScrollInsensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(127);
                    }
                    flag1 = this.implDatabaseMetaData.othersUpdatesAreVisibleScrollInsensitive;
                    flag1 = false;
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.othersUpdatesAreVisibleScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(128);
                    }
                    flag1 = this.implDatabaseMetaData.othersUpdatesAreVisibleScrollSensitive;
                    flag1 = false;
                    break;
                }
                default: {
                    String[] as = new String[]{"othersUpdatesAreVisible"};
                    throw this.exceptions.getException(6003, as);
                }
            }
            boolean bl = flag = flag1;
            return bl;
        }
    }

    public boolean ownDeletesAreVisible(int i) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            boolean flag1 = false;
            switch (i) {
                case 1003: {
                    if (this.implDatabaseMetaData.ownDeletesAreVisibleForwardOnly == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(120);
                    }
                    flag1 = this.implDatabaseMetaData.ownDeletesAreVisibleForwardOnly;
                    break;
                }
                case 1004: {
                    if (this.implDatabaseMetaData.ownDeletesAreVisibleScrollInsensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(121);
                    }
                    flag1 = this.implDatabaseMetaData.ownDeletesAreVisibleScrollInsensitive;
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.ownDeletesAreVisibleScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(122);
                    }
                    flag1 = this.implDatabaseMetaData.ownDeletesAreVisibleScrollSensitive;
                    break;
                }
                default: {
                    String[] as = new String[]{"ownDeletesAreVisible"};
                    throw this.exceptions.getException(6003, as);
                }
            }
            boolean bl = flag = (flag1 = false);
            return bl;
        }
    }

    public boolean ownInsertsAreVisible(int i) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            boolean flag1 = false;
            switch (i) {
                case 1003: {
                    if (this.implDatabaseMetaData.ownInsertsAreVisibleForwardOnly == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(123);
                    }
                    flag1 = this.implDatabaseMetaData.ownInsertsAreVisibleForwardOnly;
                    break;
                }
                case 1004: {
                    if (this.implDatabaseMetaData.ownInsertsAreVisibleScrollInsensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(124);
                    }
                    flag1 = this.implDatabaseMetaData.ownInsertsAreVisibleScrollInsensitive;
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.ownInsertsAreVisibleScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(125);
                    }
                    flag1 = this.implDatabaseMetaData.ownInsertsAreVisibleScrollSensitive;
                    break;
                }
                default: {
                    String[] as = new String[]{"ownInsertsAreVisible"};
                    throw this.exceptions.getException(6003, as);
                }
            }
            boolean bl = flag = (flag1 = false);
            return bl;
        }
    }

    public boolean ownUpdatesAreVisible(int i) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            boolean flag1 = false;
            switch (i) {
                case 1003: {
                    if (this.implDatabaseMetaData.ownUpdatesAreVisibleForwardOnly == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(117);
                    }
                    flag1 = this.implDatabaseMetaData.ownUpdatesAreVisibleForwardOnly;
                    break;
                }
                case 1004: {
                    if (this.implDatabaseMetaData.ownUpdatesAreVisibleScrollInsensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(118);
                    }
                    flag1 = this.implDatabaseMetaData.ownUpdatesAreVisibleScrollInsensitive;
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.ownUpdatesAreVisibleScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(119);
                    }
                    flag1 = this.implDatabaseMetaData.ownUpdatesAreVisibleScrollSensitive;
                    break;
                }
                default: {
                    String[] as = new String[]{"ownUpdatesAreVisible"};
                    throw this.exceptions.getException(6003, as);
                }
            }
            boolean bl = flag = (flag1 = false);
            return bl;
        }
    }

    private void setCommonResultSetMetaData(BaseColumn basecolumn) {
        if (basecolumn.type == 12) {
            basecolumn.displaySize = 128;
        }
        basecolumn.isSigned = false;
        basecolumn.isWritable = false;
        basecolumn.isDefinitelyWritable = false;
        basecolumn.isReadOnly = true;
        basecolumn.isSearchable = false;
    }

    public void setOwnerConnection(Connection connection1) {
        this.ownerConnection = connection1;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.storesLowerCaseIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(14);
            }
            boolean bl = flag = this.implDatabaseMetaData.storesLowerCaseIdentifiers.booleanValue();
            return bl;
        }
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.storesLowerCaseQuotedIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(18);
            }
            boolean bl = flag = this.implDatabaseMetaData.storesLowerCaseQuotedIdentifiers.booleanValue();
            return bl;
        }
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.storesMixedCaseIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(15);
            }
            boolean bl = flag = this.implDatabaseMetaData.storesMixedCaseIdentifiers.booleanValue();
            return bl;
        }
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.storesMixedCaseQuotedIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(19);
            }
            boolean bl = flag = this.implDatabaseMetaData.storesMixedCaseQuotedIdentifiers.booleanValue();
            return bl;
        }
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.storesUpperCaseIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(13);
            }
            boolean bl = flag = this.implDatabaseMetaData.storesUpperCaseIdentifiers.booleanValue();
            return bl;
        }
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.storesUpperCaseQuotedIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(17);
            }
            boolean bl = flag = this.implDatabaseMetaData.storesUpperCaseQuotedIdentifiers.booleanValue();
            return bl;
        }
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsANSI92EntryLevelSQL == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(47);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsANSI92EntryLevelSQL.booleanValue();
            return bl;
        }
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsANSI92FullSQL == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(49);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsANSI92FullSQL.booleanValue();
            return bl;
        }
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsANSI92IntermediateSQL == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(48);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsANSI92IntermediateSQL.booleanValue();
            return bl;
        }
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsAlterTableWithAddColumn == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(28);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsAlterTableWithAddColumn.booleanValue();
            return bl;
        }
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsAlterTableWithDropColumn == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(29);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsAlterTableWithDropColumn.booleanValue();
            return bl;
        }
    }

    public boolean supportsBatchUpdates() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            boolean bl = flag = true;
            return bl;
        }
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsCatalogsInDataManipulation == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(64);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsCatalogsInDataManipulation.booleanValue();
            return bl;
        }
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsCatalogsInIndexDefinitions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(67);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsCatalogsInIndexDefinitions.booleanValue();
            return bl;
        }
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsCatalogsInPrivilegeDefinitions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(68);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsCatalogsInPrivilegeDefinitions.booleanValue();
            return bl;
        }
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsCatalogsInProcedureCalls == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(65);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsCatalogsInProcedureCalls.booleanValue();
            return bl;
        }
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsCatalogsInTableDefinitions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(66);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsCatalogsInTableDefinitions.booleanValue();
            return bl;
        }
    }

    public boolean supportsColumnAliasing() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsColumnAliasing == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(30);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsColumnAliasing.booleanValue();
            return bl;
        }
    }

    public boolean supportsConvert() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsConvert == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(32);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsConvert.booleanValue();
            return bl;
        }
    }

    public boolean supportsConvert(int i, int j) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            boolean bl = flag = this.implDatabaseMetaData.supportsConvert(i, j);
            return bl;
        }
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsCoreSQLGrammar == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(45);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsCoreSQLGrammar.booleanValue();
            return bl;
        }
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsCorrelatedSubqueries == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(77);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsCorrelatedSubqueries.booleanValue();
            return bl;
        }
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsDataDefinitionAndDataManipulationTransactions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(111);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsDataDefinitionAndDataManipulationTransactions.booleanValue();
            return bl;
        }
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsDataManipulationTransactionsOnly == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(112);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsDataManipulationTransactionsOnly.booleanValue();
            return bl;
        }
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsDifferentTableCorrelationNames == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(34);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsDifferentTableCorrelationNames.booleanValue();
            return bl;
        }
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsExpressionsInOrderBy == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(35);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsExpressionsInOrderBy.booleanValue();
            return bl;
        }
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsExtendedSQLGrammar == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(46);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsExtendedSQLGrammar.booleanValue();
            return bl;
        }
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsFullOuterJoins == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(52);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsFullOuterJoins.booleanValue();
            return bl;
        }
    }

    public boolean supportsGroupBy() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsGroupBy == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(37);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsGroupBy.booleanValue();
            return bl;
        }
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsGroupByBeyondSelect == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(39);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsGroupByBeyondSelect.booleanValue();
            return bl;
        }
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsGroupByUnrelated == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(38);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsGroupByUnrelated.booleanValue();
            return bl;
        }
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsIntegrityEnhancementFacility == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(50);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsIntegrityEnhancementFacility.booleanValue();
            return bl;
        }
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsLikeEscapeClause == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(40);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsLikeEscapeClause.booleanValue();
            return bl;
        }
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsLimitedOuterJoins == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(53);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsLimitedOuterJoins.booleanValue();
            return bl;
        }
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsMinimumSQLGrammar == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(44);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsMinimumSQLGrammar.booleanValue();
            return bl;
        }
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsMixedCaseIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(12);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsMixedCaseIdentifiers.booleanValue();
            return bl;
        }
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsMixedCaseQuotedIdentifiers == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(16);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsMixedCaseQuotedIdentifiers.booleanValue();
            return bl;
        }
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsMultipleResultSets == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(41);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsMultipleResultSets.booleanValue();
            return bl;
        }
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsMultipleTransactions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(42);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsMultipleTransactions.booleanValue();
            return bl;
        }
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsNonNullableColumns == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(43);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsNonNullableColumns.booleanValue();
            return bl;
        }
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsOpenCursorsAcrossCommit == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(80);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsOpenCursorsAcrossCommit.booleanValue();
            return bl;
        }
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsOpenCursorsAcrossRollback == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(81);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsOpenCursorsAcrossRollback.booleanValue();
            return bl;
        }
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsOpenStatementsAcrossCommit == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(82);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsOpenStatementsAcrossCommit.booleanValue();
            return bl;
        }
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsOpenStatementsAcrossRollback == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(83);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsOpenStatementsAcrossRollback.booleanValue();
            return bl;
        }
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsOrderByUnrelated == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(36);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsOrderByUnrelated.booleanValue();
            return bl;
        }
    }

    public boolean supportsOuterJoins() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsOuterJoins == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(51);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsOuterJoins.booleanValue();
            return bl;
        }
    }

    public boolean supportsPositionedDelete() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsPositionedDelete == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(69);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsPositionedDelete.booleanValue();
            return bl;
        }
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsPositionedUpdate == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(70);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsPositionedUpdate.booleanValue();
            return bl;
        }
    }

    public boolean supportsResultSetConcurrency(int i, int j) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            boolean flag1 = false;
            if (j == 1007) {
                flag1 = this.supportsResultSetType(i);
            }
            switch (i) {
                default: {
                    String[] as = new String[]{"supportsResultSetConcurrency"};
                    throw this.exceptions.getException(6003, as);
                }
                case 1003: 
                case 1004: 
                case 1005: 
            }
            switch (j) {
                default: {
                    String[] as1 = new String[]{"supportsResultSetConcurrency"};
                    throw this.exceptions.getException(6003, as1);
                }
                case 1007: 
                case 1008: 
            }
            boolean bl = flag = flag1;
            return bl;
        }
    }

    public boolean supportsResultSetType(int i) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            boolean flag1 = false;
            switch (i) {
                case 1003: {
                    flag1 = true;
                    break;
                }
                case 1004: {
                    flag1 = true;
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.supportsResultSetTypeScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(116);
                    }
                    flag1 = this.implDatabaseMetaData.supportsResultSetTypeScrollSensitive;
                    break;
                }
                default: {
                    String[] as = new String[]{"supportsResultSetType"};
                    throw this.exceptions.getException(6003, as);
                }
            }
            boolean bl = flag = flag1;
            return bl;
        }
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSchemasInDataManipulation == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(59);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsSchemasInDataManipulation.booleanValue();
            return bl;
        }
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSchemasInIndexDefinitions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(62);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsSchemasInIndexDefinitions.booleanValue();
            return bl;
        }
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSchemasInPrivilegeDefinitions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(63);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsSchemasInPrivilegeDefinitions.booleanValue();
            return bl;
        }
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSchemasInProcedureCalls == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(60);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsSchemasInProcedureCalls.booleanValue();
            return bl;
        }
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSchemasInTableDefinitions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(61);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsSchemasInTableDefinitions.booleanValue();
            return bl;
        }
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSelectForUpdate == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(71);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsSelectForUpdate.booleanValue();
            return bl;
        }
    }

    public boolean supportsStoredProcedures() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsStoredProcedures == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(72);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsStoredProcedures.booleanValue();
            return bl;
        }
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSubqueriesInComparisons == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(73);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsSubqueriesInComparisons.booleanValue();
            return bl;
        }
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSubqueriesInExists == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(74);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsSubqueriesInExists.booleanValue();
            return bl;
        }
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSubqueriesInIns == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(75);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsSubqueriesInIns.booleanValue();
            return bl;
        }
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsSubqueriesInQuantifieds == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(76);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsSubqueriesInQuantifieds.booleanValue();
            return bl;
        }
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsTableCorrelationNames == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(33);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsTableCorrelationNames.booleanValue();
            return bl;
        }
    }

    public boolean supportsTransactionIsolationLevel(int i) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag4;
            this.validateClosedState();
            switch (i) {
                case 2: {
                    boolean flag;
                    if (this.implDatabaseMetaData.supportsTransactionIsolationLevelReadCommited == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(107);
                    }
                    boolean bl = flag = this.implDatabaseMetaData.supportsTransactionIsolationLevelReadCommited.booleanValue();
                    return bl;
                }
                case 1: {
                    boolean flag1;
                    if (this.implDatabaseMetaData.supportsTransactionIsolationLevelReadUncommited == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(108);
                    }
                    boolean bl = flag1 = this.implDatabaseMetaData.supportsTransactionIsolationLevelReadUncommited.booleanValue();
                    return bl;
                }
                case 4: {
                    boolean flag2;
                    if (this.implDatabaseMetaData.supportsTransactionIsolationLevelRepeatableRead == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(109);
                    }
                    boolean bl = flag2 = this.implDatabaseMetaData.supportsTransactionIsolationLevelRepeatableRead.booleanValue();
                    return bl;
                }
                case 8: {
                    boolean flag3;
                    if (this.implDatabaseMetaData.supportsTransactionIsolationLevelSerializable == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(110);
                    }
                    boolean bl = flag3 = this.implDatabaseMetaData.supportsTransactionIsolationLevelSerializable.booleanValue();
                    return bl;
                }
            }
            boolean bl = flag4 = false;
            return bl;
        }
    }

    public boolean supportsTransactions() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsTransactions == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(106);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsTransactions.booleanValue();
            return bl;
        }
    }

    public boolean supportsUnion() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsUnion == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(78);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsUnion.booleanValue();
            return bl;
        }
    }

    public boolean supportsUnionAll() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.supportsUnionAll == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(79);
            }
            boolean bl = flag = this.implDatabaseMetaData.supportsUnionAll.booleanValue();
            return bl;
        }
    }

    public boolean updatesAreDetected(int i) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            boolean flag1 = false;
            switch (i) {
                case 1003: {
                    if (this.implDatabaseMetaData.updatesAreDetectedForwardOnly == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(135);
                    }
                    flag1 = this.implDatabaseMetaData.updatesAreDetectedForwardOnly;
                    break;
                }
                case 1004: {
                    if (this.implDatabaseMetaData.updatesAreDetectedScrollInsensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(136);
                    }
                    flag1 = this.implDatabaseMetaData.updatesAreDetectedScrollInsensitive;
                    break;
                }
                case 1005: {
                    if (this.implDatabaseMetaData.updatesAreDetectedScrollSensitive == null) {
                        this.implDatabaseMetaData.initializeNonResultSetMetaData(137);
                    }
                    flag1 = this.implDatabaseMetaData.updatesAreDetectedScrollSensitive;
                    break;
                }
                default: {
                    String[] as = new String[]{"updatesAreDetected"};
                    throw this.exceptions.getException(6003, as);
                }
            }
            boolean bl = flag = flag1;
            return bl;
        }
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.usesLocalFilePerTable == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(11);
            }
            boolean bl = flag = this.implDatabaseMetaData.usesLocalFilePerTable.booleanValue();
            return bl;
        }
    }

    public boolean usesLocalFiles() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean flag;
            this.validateClosedState();
            if (this.implDatabaseMetaData.usesLocalFiles == null) {
                this.implDatabaseMetaData.initializeNonResultSetMetaData(10);
            }
            boolean bl = flag = this.implDatabaseMetaData.usesLocalFiles.booleanValue();
            return bl;
        }
    }

    private void validateClosedState() throws SQLException {
        if (this.connection != null && this.connection.isClosed()) {
            this.connection = null;
            this.ownerConnection = null;
        }
        if (this.connection == null || this.ownerConnection == null) {
            throw this.exceptions.getException(6010);
        }
    }

    static {
        driverMajorVersion = 2;
        driverMinorVersion = 1;
    }
}

