/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ksql.shell;

import com.kingdee.bos.ksql.shell.PreparedStatement;
import com.kingdee.bos.ksql.shell.SQLParser;
import com.kingdee.bos.ksql.shell.SQLParserException;
import com.kingdee.bos.ksql.shell.Statement;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Map;

public class Connection
implements java.sql.Connection {
    private java.sql.Connection cn;
    private String originalSQL = "";
    private String dbType;
    private SQLParser parser = new SQLParser();

    protected Connection(java.sql.Connection cn, String dbType) {
        this.cn = cn;
        this.dbType = dbType;
    }

    protected String getDbType() {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            String string = this.dbType;
            return string;
        }
    }

    protected SQLParser getSQLParser() {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            SQLParser sQLParser = this.parser;
            return sQLParser;
        }
    }

    public void clearWarnings() throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            this.cn.clearWarnings();
        }
    }

    public void close() throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            this.parser = null;
            this.cn.close();
        }
    }

    public void commit() throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            this.cn.commit();
        }
    }

    public java.sql.Statement createStatement() throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            Statement statement = new Statement(this.cn.createStatement(), this);
            return statement;
        }
    }

    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            Statement statement = new Statement(this.cn.createStatement(resultSetType, resultSetConcurrency), this);
            return statement;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            boolean bl = this.cn.getAutoCommit();
            return bl;
        }
    }

    public String getCatalog() throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            String string = this.cn.getCatalog();
            return string;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            DatabaseMetaData databaseMetaData = this.cn.getMetaData();
            return databaseMetaData;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            int n = this.cn.getTransactionIsolation();
            return n;
        }
    }

    public Map getTypeMap() throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            Map<String, Class<?>> map = this.cn.getTypeMap();
            return map;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            SQLWarning sQLWarning = this.cn.getWarnings();
            return sQLWarning;
        }
    }

    public boolean isClosed() throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            boolean bl = this.cn.isClosed();
            return bl;
        }
    }

    public boolean isReadOnly() throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            boolean bl = this.cn.isReadOnly();
            return bl;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            try {
                sql = this.parser.parse(sql, this.dbType);
            }
            catch (Exception ex) {
                throw new SQLParserException("Unexpect token exception ", ex);
            }
            String string = this.cn.nativeSQL(sql);
            return string;
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            CallableStatement callableStatement = this.cn.prepareCall(sql);
            return callableStatement;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            CallableStatement callableStatement = this.cn.prepareCall(sql, resultSetType, resultSetConcurrency);
            return callableStatement;
        }
    }

    public java.sql.PreparedStatement prepareStatement(String sql) throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            try {
                sql = this.parser.parse(sql, this.dbType);
            }
            catch (Exception ex) {
                throw new SQLParserException("Unexpect token exception ", ex);
            }
            PreparedStatement preparedStatement = new PreparedStatement(this.cn.prepareStatement(sql), this);
            return preparedStatement;
        }
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            try {
                sql = this.parser.parse(sql, this.dbType);
            }
            catch (Exception ex) {
                throw new SQLParserException("Unexpect token exception ", ex);
            }
            PreparedStatement preparedStatement = new PreparedStatement(this.cn.prepareStatement(sql, resultSetType, resultSetConcurrency), this);
            return preparedStatement;
        }
    }

    public void rollback() throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            this.cn.rollback();
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            this.cn.setAutoCommit(autoCommit);
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            this.cn.setCatalog(catalog);
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            this.cn.setReadOnly(readOnly);
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            this.cn.setTransactionIsolation(level);
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        java.sql.Connection connection = this.cn;
        synchronized (connection) {
            this.cn.setTypeMap(map);
        }
    }
}

