/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ksql.translator;

import com.kingdee.bos.ksql.pub.KSQLException;

public class Automata {
    private int[][] table = new int[][]{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 2, 9, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 3, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 4, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 4, 5, 0, 0, 0}, {0, 0, 0, 0, 0, 5, 6, 0, 0, 0}, {0, 0, 0, 0, 7, 6, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 8, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 16, 10, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 11, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 11, 0, 12, 0, 0}, {0, 0, 0, 0, 0, 12, 0, 13, 0, 0}, {0, 0, 0, 0, 14, 13, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 15, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 17, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 18, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 18, 19, 0, 0, 0}, {0, 0, 0, 0, 0, 19, 20, 0, 0, 0}, {0, 0, 0, 0, 0, 20, 0, 0, 0, 21}, {0, 0, 0, 0, 0, 21, 0, 22, 0, 0}, {0, 0, 0, 0, 0, 22, 0, 23, 0, 0}, {0, 0, 0, 0, 24, 23, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 25, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    private String m_str;
    private int m_Index;
    private int m_AccStateDate;
    private int m_AccStateTime;
    private int m_AccStateTimeStamp;
    private int iType;
    private int DATE = 1;
    private int TIME = 2;
    private int TIMESTAMP = 3;

    public Automata(String s) {
        this.m_str = s;
        this.m_Index = 0;
        this.m_AccStateDate = 8;
        this.m_AccStateTime = 15;
        this.m_AccStateTimeStamp = 25;
    }

    public int getIType() {
        return this.iType;
    }

    public void setIType(int iType) {
        this.iType = iType;
    }

    public boolean accepts() throws KSQLException {
        boolean flag = false;
        int s = 0;
        char c = this.NextChar();
        int fyear = 0;
        int fmonth = 0;
        int fday = 0;
        int fhour = 0;
        int fminute = 0;
        int fsecond = 0;
        while (c != '#') {
            s = this.Move(s, c);
            switch (s) {
                case 4: {
                    ++fyear;
                    break;
                }
                case 5: {
                    ++fmonth;
                    break;
                }
                case 6: {
                    ++fday;
                    break;
                }
                case 11: {
                    ++fhour;
                    break;
                }
                case 12: {
                    ++fminute;
                    break;
                }
                case 13: {
                    ++fsecond;
                    break;
                }
                case 18: {
                    ++fyear;
                    break;
                }
                case 19: {
                    ++fmonth;
                    break;
                }
                case 20: {
                    ++fday;
                    break;
                }
                case 21: {
                    ++fhour;
                    break;
                }
                case 22: {
                    ++fminute;
                    break;
                }
                case 23: {
                    ++fsecond;
                }
            }
            c = this.NextChar();
        }
        if (s == this.m_AccStateDate) {
            this.iType = this.DATE;
            if (fyear != 4 || fmonth != 3 || fday != 3) {
                throw new KSQLException("Date format is not correct.");
            }
            flag = true;
        } else if (s == this.m_AccStateTime) {
            this.iType = this.TIME;
            if (fhour != 2 || fminute != 3 || fsecond != 3) {
                throw new KSQLException("Time format is not correct.");
            }
            flag = true;
        } else if (s == this.m_AccStateTimeStamp) {
            this.iType = this.TIMESTAMP;
            if (fyear != 4 || fmonth != 3 || fday != 3 || fhour != 3 || fminute != 3 || fsecond != 3) {
                throw new KSQLException("Timestamp format is not correct.");
            }
            flag = true;
        } else {
            this.iType = 0;
            flag = false;
            throw new KSQLException("Unexpected token ");
        }
        return flag;
    }

    private char NextChar() {
        char c;
        if (this.m_Index < this.m_str.length()) {
            c = this.m_str.charAt(this.m_Index);
            ++this.m_Index;
        } else {
            c = '#';
            --this.m_Index;
        }
        return c;
    }

    private int Move(int s, char c) throws KSQLException {
        int cIndex = this.GetIndexOfChar(c);
        if (cIndex != -1) {
            return this.table[s][cIndex];
        }
        throw new KSQLException("Incorrect date time format in ".concat(String.valueOf(String.valueOf(c))));
    }

    private int GetIndexOfChar(char c) {
        String str = "{dts' -:} #";
        if (Character.isDigit(c)) {
            return 5;
        }
        if (Character.isWhitespace(c)) {
            return 9;
        }
        return str.indexOf(c);
    }
}

