/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.lang.reflect.Array;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SimpleType;
import org.apache.axis.encoding.SimpleValueSerializer;
import org.apache.axis.encoding.ser.QNameSerializer;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Types;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SimpleListSerializer
implements SimpleValueSerializer {
    public QName xmlType;
    public Class javaType;
    private BeanPropertyDescriptor[] propertyDescriptor = null;
    private TypeDesc typeDesc = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SimpleListSerializer(Class javaType, QName xmlType) {
        this.xmlType = xmlType;
        this.javaType = javaType;
    }

    public SimpleListSerializer(Class javaType, QName xmlType, TypeDesc typeDesc) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.typeDesc = typeDesc;
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        if (value != null) {
            Class<?> clazz = value.getClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz2) {
                throw new IOException(Messages.getMessage("cantSerialize02"));
            }
        }
        if (value instanceof SimpleType) {
            attributes = this.getObjectAttributes(value, attributes, context);
        }
        String strValue = null;
        if (value != null) {
            strValue = this.getValueAsString(value, context);
        }
        context.startElement(name, attributes);
        if (strValue != null) {
            context.writeSafeString(strValue);
        }
        context.endElement();
    }

    public String getValueAsString(Object value, SerializationContext context) {
        int length = Array.getLength(value);
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < length) {
            Object object = Array.get(value, i);
            if (object instanceof Float || object instanceof Double) {
                double data = 0.0;
                data = object instanceof Float ? ((Float)object).doubleValue() : ((Double)object).doubleValue();
                if (Double.isNaN(data)) {
                    result.append("NaN");
                } else if (data == Double.POSITIVE_INFINITY) {
                    result.append("INF");
                } else if (data == Double.NEGATIVE_INFINITY) {
                    result.append("-INF");
                } else {
                    result.append(object.toString());
                }
            } else if (object instanceof QName) {
                result.append(QNameSerializer.qName2String((QName)object, context));
            } else {
                result.append(object.toString());
            }
            if (i < length - 1) {
                result.append(' ');
            }
            ++i;
        }
        return result.toString();
    }

    private Attributes getObjectAttributes(Object value, Attributes attributes, SerializationContext context) {
        if (this.typeDesc == null || !this.typeDesc.hasAttributes()) {
            return attributes;
        }
        AttributesImpl attrs = attributes == null ? new AttributesImpl() : (attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes));
        try {
            int i = 0;
            while (i < this.propertyDescriptor.length) {
                FieldDesc field;
                String propName = this.propertyDescriptor[i].getName();
                if (!propName.equals("class") && (field = this.typeDesc.getFieldByName(propName)) != null && !field.isElement()) {
                    Object propValue;
                    QName qname = field.getXmlName();
                    if (qname == null) {
                        qname = new QName("", propName);
                    }
                    if (this.propertyDescriptor[i].isReadable() && !this.propertyDescriptor[i].isIndexed() && (propValue = this.propertyDescriptor[i].get(value)) != null) {
                        String propString = this.getValueAsString(propValue, context);
                        String namespace = qname.getNamespaceURI();
                        String localName = qname.getLocalPart();
                        attrs.addAttribute(namespace, localName, context.qName2String(qname), "CDATA", propString);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            return attrs;
        }
        return attrs;
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class javaType, Types types) throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.apache.axis.encoding.SimpleType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(javaType)) {
            return null;
        }
        Element complexType = types.createElement("complexType");
        types.writeSchemaElementDecl(this.xmlType, complexType);
        complexType.setAttribute("name", this.xmlType.getLocalPart());
        Element simpleContent = types.createElement("simpleContent");
        complexType.appendChild(simpleContent);
        Element extension = types.createElement("extension");
        simpleContent.appendChild(extension);
        String base = "string";
        int i = 0;
        while (i < this.propertyDescriptor.length) {
            String propName = this.propertyDescriptor[i].getName();
            if (!propName.equals("value")) {
                FieldDesc field;
                if (this.typeDesc != null && (field = this.typeDesc.getFieldByName(propName)) != null) {
                    Class fieldType;
                    field.isElement();
                    QName qname = field.getXmlName();
                    if (qname == null) {
                        qname = new QName("", propName);
                    }
                    if (!types.isAcceptableAsAttribute(fieldType = this.propertyDescriptor[i].getType())) {
                        throw new AxisFault(Messages.getMessage("AttrNotSimpleType00", propName, fieldType.getName()));
                    }
                    Element elem = types.createAttributeElement(propName, fieldType, field.getXmlType(), false, extension.getOwnerDocument());
                    extension.appendChild(elem);
                }
            } else {
                BeanPropertyDescriptor bpd = this.propertyDescriptor[i];
                Class type = bpd.getType();
                if (!types.isAcceptableAsAttribute(type)) {
                    throw new AxisFault(Messages.getMessage("AttrNotSimpleType01", type.getName()));
                }
                base = types.writeType(type);
                extension.setAttribute("base", base);
            }
            ++i;
        }
        return complexType;
    }
}

