<Data version="20170616">
	<Sources>
		<BizMetaSource name="s1657675953191" bizMetaType="EASDBCenter" dbCenterId="SP1UPDBC860TEST" type="BizMeta">
			<UserSQLs>
				<UserSQL name="dm1657675986106" sqlType="KSQL"><![CDATA[select FID,Fnumber,FcompanyID,FCompanyName,FInvoiceDate,FInvoiceType,
FTaxAmtTotal,FAmountTaxTotal
from
(
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FTmInvoiceType
	  when N'1' then N'增值税电子普通发票'
	  when N'2' then N'增值税电子专用发票'
	  when N'3' then N'增值税普通发票'
	  when N'4' then N'增值税专用发票'
	  when N'5' then N'增值税普通发票（卷票）'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FTax,0) as FTaxAmtTotal,
	isnull(invoice.FAmountTax,0) as FAmountTaxTotal	
	from T_IM_IncomeInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid

	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'26' then N'全电普票'
	  when N'27' then N'全电专票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FTotalTaxAmount,0) as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_FullElectricInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FBizDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'15' then N'通行费电子发票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FTotalTaxAmount,0) as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_TollInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FBizDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'12' then N'机动车发票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FTotalTaxAmount,0) as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_VehicleInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'7' then N'通用机打发票'
	  when N'17' then N'过路过桥费'
	  when N'23' then N'通用机打电子发票'
	  else N''
	  end as FInvoiceType, 
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_MachineInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'8' then N'的士票'
	  else N''
	  end as FInvoiceType, 
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_TaxiInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'9' then N'火车票'
	  else N''
	  end as FInvoiceType, 
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_TrainInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'10' then N'飞机票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FTotalTaxAmount,0) as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_PlaneInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'11' then N'其他发票'
	  else N''
	  end as FInvoiceType, 
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_OtherInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'13' then N'二手车票'
	  else N''
	  end as FInvoiceType, 
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_SecondHandCarInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'14' then N'定额发票'
	  else N''
	  end as FInvoiceType, 
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_QuotaInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'16' then N'客运票'
	  when N'20' then N'轮船票'
	  else N''
	  end as FInvoiceType, 
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_ShipInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'19' then N'完税证明'
	  else N''
	  end as FInvoiceType, 
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_PurchaseInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'24' then N'火车票退票凭证'
	  else N''
	  end as FInvoiceType, 
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_TrainRefundVoucher as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'25' then N'财政电子票据'
	  else N''
	  end as FInvoiceType, 
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_FinancialInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
) as invoicePool 
where invoicePool.FCompanyID in (SELECT BaseUnit.FID
  FROM T_ORG_BaseUnit BaseUnit
 INNER JOIN T_ORG_Structure Structure
    ON Structure.FUnitId = BaseUnit.FID
 WHERE Structure.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD' and BaseUnit.FISLEAF =1 
   AND EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 10
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 10
           AND UserRoleOrg.Forgid = BaseUnit.fid)
   AND NOT EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 20
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 20
           AND UserRoleOrg.Forgid = BaseUnit.fid))]]></UserSQL>
				<UserSQL name="dm1657676013664" sqlType="KSQL"><![CDATA[select FID,Fnumber,FcompanyID,FCompanyName,FInvoiceDate,FInvoiceType
from
(
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FTmInvoiceType
	  when N'1' then N'增值税电子普通发票'
	  when N'2' then N'增值税电子专用发票'
	  when N'3' then N'增值税普通发票'
	  when N'4' then N'增值税专用发票'
	  when N'5' then N'增值税普通发票（卷票）'
	  else N''
	  end as FInvoiceType
	from T_IM_IncomeInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid

	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'26' then N'全电普票'
	  when N'27' then N'全电专票'
	  else N''
	  end as FInvoiceType
	from T_TM_FullElectricInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FBizDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'15' then N'通行费发票'
	  else N''
	  end as FInvoiceType
	from T_TM_TollInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FBizDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'12' then N'机动车销售统一发票'
	  else N''
	  end as FInvoiceType
	from T_TM_VehicleInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
		
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'13' then N'二手车销售统一发票'
	  else N''
	  end as FInvoiceType	
	from T_TM_SecondHandCarInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
) as invoicePool 
where invoicePool.FCompanyID in (SELECT BaseUnit.FID
  FROM T_ORG_BaseUnit BaseUnit
 INNER JOIN T_ORG_Structure Structure
    ON Structure.FUnitId = BaseUnit.FID
 WHERE Structure.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD' and BaseUnit.FISLEAF =1 
   AND EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 10
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 10
           AND UserRoleOrg.Forgid = BaseUnit.fid)
   AND NOT EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 20
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 20
           AND UserRoleOrg.Forgid = BaseUnit.fid))]]></UserSQL>
				<UserSQL name="dm1657676041492" sqlType="KSQL"><![CDATA[select FID,Fnumber,FcompanyID,FCompanyName,FInvoiceDate,FInvoiceType
from
(
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'9' then N'火车票'
	  else N''
	  end as FInvoiceType
	from T_TM_TrainInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'10' then N'飞机票'
	  else N''
	  end as FInvoiceType	
	from T_TM_PlaneInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'16' then N'客运票'
	  when N'20' then N'轮船票'
	  else N''
	  end as FInvoiceType
	from T_TM_ShipInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
) as invoicePool 
where invoicePool.FCompanyID in (SELECT BaseUnit.FID
  FROM T_ORG_BaseUnit BaseUnit
 INNER JOIN T_ORG_Structure Structure
    ON Structure.FUnitId = BaseUnit.FID
 WHERE Structure.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD' and BaseUnit.FISLEAF =1 
   AND EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 10
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 10
           AND UserRoleOrg.Forgid = BaseUnit.fid)
   AND NOT EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 20
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 20
           AND UserRoleOrg.Forgid = BaseUnit.fid))]]></UserSQL>
				<UserSQL name="dm1657676071293" sqlType="KSQL"><![CDATA[select FID,Fnumber,FcompanyID,FCompanyName,FInvoiceDate,FInvoiceType,
FAccepted,FUnAccept,FChecked,FUnCheck,FConfirmed,FUnConfirm
from
(
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FTmInvoiceType
	  when N'2' then N'增值税电子专用发票'
	  when N'4' then N'增值税专用发票'
	  else N''
	  end as FInvoiceType,
	case invoice.FIsAccept 
	  when 1 then 1 
      else 0
      end as FAccepted,
    case invoice.FIsAccept 
      when 0 then 1
      else 0
      end as FUnAccept,
	case checkabs.FCheckState 
	  when 1 then 1 
      else 0
      end as FChecked,
    case checkabs.FCheckState 
      when 0 then 1
      else 0
      end as FUnCheck,
	case checkabs.FConfirmState 
	  when 1 then 1 
      else 0
      end as FConfirmed,
    case checkabs.FConfirmState 
      when 0 then 1
      else 0
      end as FUnConfirm
	from T_IM_IncomeInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	left join T_TM_CheckAbs as checkabs ON invoice.FCheckAbsID = checkabs.FID
	where invoice.FTmInvoiceType = '4' or invoice.FTmInvoiceType = '2'

	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'27' then N'全电专票'
	  else N''
	  end as FInvoiceType,
	case invoice.FIsAccept 
	  when 1 then 1 
      else 0
      end as FAccepted,
    case invoice.FIsAccept 
      when 0 then 1
      else 0
      end as FUnAccept,
	case checkabs.FCheckState 
	  when 1 then 1 
      else 0
      end as FChecked,
    case checkabs.FCheckState 
      when 0 then 1
      else 0
      end as FUnCheck,
	case checkabs.FConfirmState 
	  when 1 then 1 
      else 0
      end as FConfirmed,
    case checkabs.FConfirmState 
      when 0 then 1
      else 0
      end as FUnConfirm
	from T_TM_FullElectricInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	left join T_TM_CheckAbs as checkabs ON invoice.FCheckAbsID = checkabs.FID
	where invoice.FInvoiceType = '27' 
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FBizDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'15' then N'通行费发票'
	  else N''
	  end as FInvoiceType,
	case invoice.FIsAccept 
	  when 1 then 1 
      else 0
      end as FAccepted,
    case invoice.FIsAccept 
      when 0 then 1
      else 0
      end as FUnAccept,
	case checkabs.FCheckState 
	  when 1 then 1 
      else 0
      end as FChecked,
    case checkabs.FCheckState 
      when 0 then 1
      else 0
      end as FUnCheck,
	case checkabs.FConfirmState 
	  when 1 then 1 
      else 0
      end as FConfirmed,
    case checkabs.FConfirmState 
      when 0 then 1
      else 0
      end as FUnConfirm
	from T_TM_TollInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	left join T_TM_CheckAbs as checkabs ON invoice.FCheckAbsID = checkabs.FID
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FBizDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'12' then N'机动车发票'
	  else N''
	  end as FInvoiceType,
	case invoice.FIsAccept 
	  when 1 then 1 
      else 0
      end as FAccepted,
    case invoice.FIsAccept 
      when 0 then 1
      else 0
      end as FUnAccept,
	case checkabs.FCheckState 
	  when 1 then 1 
      else 0
      end as FChecked,
    case checkabs.FCheckState 
      when 0 then 1
      else 0
      end as FUnCheck,
	case checkabs.FConfirmState 
	  when 1 then 1 
      else 0
      end as FConfirmed,
    case checkabs.FConfirmState 
      when 0 then 1
      else 0
      end as FUnConfirm
	from T_TM_VehicleInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	left join T_TM_CheckAbs as checkabs ON invoice.FCheckAbsID = checkabs.FID
) as invoicePool 
where invoicePool.FCompanyID in (SELECT BaseUnit.FID
  FROM T_ORG_BaseUnit BaseUnit
 INNER JOIN T_ORG_Structure Structure
    ON Structure.FUnitId = BaseUnit.FID
 WHERE Structure.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD' and BaseUnit.FISLEAF =1 
   AND EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 10
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 10
           AND UserRoleOrg.Forgid = BaseUnit.fid)
   AND NOT EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 20
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 20
           AND UserRoleOrg.Forgid = BaseUnit.fid))]]></UserSQL>
				<UserSQL name="dm1657676095455" sqlType="KSQL"><![CDATA[select FID,Fnumber,FcompanyID,FCompanyName,FInvoiceDate,FInvoiceType,
FReceiveed,FUnReceive
from
(
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FTmInvoiceType
	  when N'4' then N'增值税专用发票'
	  else N''
	  end as FInvoiceType,
	case invoice.FIsReceive 
	  when 1 then 1 
      else 0
      end as FReceiveed,
    case invoice.FIsReceive 
      when 0 then 1
      else 0
      end as FUnReceive
	from T_IM_IncomeInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	left join T_TM_CheckAbs as checkabs ON invoice.FCheckAbsID = checkabs.FID
	where invoice.FTmInvoiceType = '4' 
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FBizDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'12' then N'机动车发票'
	  else N''
	  end as FInvoiceType,
	case invoice.FIsReceive 
	  when 1 then 1 
      else 0
      end as FReceiveed,
    case invoice.FIsReceive 
      when 0 then 1
      else 0
      end as FUnReceive
	from T_TM_VehicleInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	left join T_TM_CheckAbs as checkabs ON invoice.FCheckAbsID = checkabs.FID
) as invoicePool 
where invoicePool.FCompanyID in (SELECT BaseUnit.FID
  FROM T_ORG_BaseUnit BaseUnit
 INNER JOIN T_ORG_Structure Structure
    ON Structure.FUnitId = BaseUnit.FID
 WHERE Structure.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD' and BaseUnit.FISLEAF =1 
   AND EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 10
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 10
           AND UserRoleOrg.Forgid = BaseUnit.fid)
   AND NOT EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 20
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 20
           AND UserRoleOrg.Forgid = BaseUnit.fid))]]></UserSQL>
				<UserSQL name="dm1657676122937" sqlType="KSQL"><![CDATA[select FID,Fnumber,FcompanyID,FCompanyName,FInvoiceDate,FInvoiceType,
FTaxTotal,FConfirmedTaxTotal,FUnConfirmTaxTotal
from
(
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FTmInvoiceType
	  when N'2' then N'增值税电子专用发票'
	  when N'4' then N'增值税专用发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FTax,0) as FTaxTotal,
	case checkabs.FConfirmState 
	  when 1 then isnull(invoice.FTax,0)  
      else 0
      end as FConfirmedTaxTotal,
    case checkabs.FConfirmState 
      when 0 then isnull(invoice.FTax,0) 
      else 0
      end as FUnConfirmTaxTotal
	from T_IM_IncomeInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	left join T_TM_CheckAbs as checkabs ON invoice.FCheckAbsID = checkabs.FID
	where invoice.FTmInvoiceType = '4' or invoice.FTmInvoiceType = '2'

	union all
		
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'27' then N'全电专票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FTotalTaxAmount,0) as FTaxTotal,
	case checkabs.FConfirmState 
	  when 1 then isnull(invoice.FTotalTaxAmount,0)  
      else 0
      end as FConfirmedTaxTotal,
    case checkabs.FConfirmState 
      when 0 then isnull(invoice.FTotalTaxAmount,0)  
      else 0
      end as FUnConfirmTaxTotal
	from T_TM_FullElectricInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	left join T_TM_CheckAbs as checkabs ON invoice.FCheckAbsID = checkabs.FID
	where invoice.FInvoiceType = '27' 
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FBizDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'15' then N'通行费发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FTotalTaxAmount,0) as FTaxTotal,
	case checkabs.FConfirmState 
	  when 1 then isnull(invoice.FTotalTaxAmount,0)  
      else 0
      end as FConfirmedTaxTotal,
    case checkabs.FConfirmState 
      when 0 then isnull(invoice.FTotalTaxAmount,0)  
      else 0
      end as FUnConfirmTaxTotal
	from T_TM_TollInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	left join T_TM_CheckAbs as checkabs ON invoice.FCheckAbsID = checkabs.FID
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FBizDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'12' then N'机动车发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FTotalTaxAmount,0) as FTaxTotal,
	case checkabs.FConfirmState 
	  when 1 then isnull(invoice.FTotalTaxAmount,0)  
      else 0
      end as FConfirmedTaxTotal,
    case checkabs.FConfirmState 
      when 0 then isnull(invoice.FTotalTaxAmount,0)  
      else 0
      end as FUnConfirmTaxTotal
	from T_TM_VehicleInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	left join T_TM_CheckAbs as checkabs ON invoice.FCheckAbsID = checkabs.FID
) as invoicePool 
where invoicePool.FCompanyID in (SELECT BaseUnit.FID
  FROM T_ORG_BaseUnit BaseUnit
 INNER JOIN T_ORG_Structure Structure
    ON Structure.FUnitId = BaseUnit.FID
 WHERE Structure.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD' and BaseUnit.FISLEAF =1 
   AND EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 10
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 10
           AND UserRoleOrg.Forgid = BaseUnit.fid)
   AND NOT EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 20
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 20
           AND UserRoleOrg.Forgid = BaseUnit.fid))]]></UserSQL>
				<UserSQL name="dm1657676147221" sqlType="KSQL"><![CDATA[select FID,Fnumber,FcompanyID,FCompanyName,FInvoiceDate,FInvoiceType,
FBizBill,FUnBizBill,FReBusinessed,FUnReBusiness,FPaymented,FUnPayment
from
(
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FTmInvoiceType
	  when N'1' then N'增值税电子普通发票'
	  when N'2' then N'增值税电子专用发票'
	  when N'3' then N'增值税普通发票'
	  when N'4' then N'增值税专用发票'
	  when N'5' then N'增值税普通发票（卷票）'
	  else N''
	  end as FInvoiceType, 
	case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 0 
      else 1 
      end as FBizBill,
    case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 1 
      else 0 
      end as FUnBizBill,
	case invoice.FReBusiness 
	  when 1 then 1 
      else 0
      end as FReBusinessed,
    case invoice.FReBusiness 
      when 0 then 1
      else 0
      end as FUnReBusiness,
	case invoice.FIsPayment 
	  when 1 then 1 
      else 0
      end as FPaymented,
    case invoice.FIsPayment 
      when 0 then 1
      else 0
      end as FUnPayment
	from T_IM_IncomeInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid

	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'26' then N'全电普票'
	  when N'27' then N'全电专票'
	  else N''
	  end as FInvoiceType, 
	case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 0 
      else 1 
      end as FBizBill,
    case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 1 
      else 0 
      end as FUnBizBill,
	case invoice.FIsBusiness 
	  when 1 then 1 
      else 0
      end as FReBusinessed,
    case invoice.FIsBusiness 
      when 0 then 1
      else 0
      end as FUnReBusiness,
	case invoice.FIsPayment 
	  when 1 then 1 
      else 0
      end as FPaymented,
    case invoice.FIsPayment 
      when 0 then 1
      else 0
      end as FUnPayment
	from T_TM_FullElectricInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FBizDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'15' then N'通行费电子发票'
	  else N''
	  end as FInvoiceType, 
	case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 0 
      else 1 
      end as FBizBill,
    case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 1 
      else 0 
      end as FUnBizBill,
	case invoice.FIsBusiness 
	  when 1 then 1 
      else 0
      end as FReBusinessed,
    case invoice.FIsBusiness 
      when 0 then 1
      else 0
      end as FUnReBusiness,
	case invoice.FIsPayment 
	  when 1 then 1 
      else 0
      end as FPaymented,
    case invoice.FIsPayment 
      when 0 then 1
      else 0
      end as FUnPayment	
	from T_TM_TollInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FBizDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'12' then N'机动车发票'
	  else N''
	  end as FInvoiceType, 
	case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 0 
      else 1 
      end as FBizBill,
    case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 1 
      else 0 
      end as FUnBizBill,
	case invoice.FIsBusiness 
	  when 1 then 1 
      else 0
      end as FReBusinessed,
    case invoice.FIsBusiness 
      when 0 then 1
      else 0
      end as FUnReBusiness,
	case invoice.FIsPayment 
	  when 1 then 1 
      else 0
      end as FPaymented,
    case invoice.FIsPayment 
      when 0 then 1
      else 0
      end as FUnPayment	
	from T_TM_VehicleInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'7' then N'通用机打发票'
	  when N'17' then N'过路过桥费'
	  when N'23' then N'通用机打电子发票'
	  else N''
	  end as FInvoiceType, 
	case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 0 
      else 1 
      end as FBizBill,
    case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 1 
      else 0 
      end as FUnBizBill,
	case invoice.FIsBusiness 
	  when 1 then 1 
      else 0
      end as FReBusinessed,
    case invoice.FIsBusiness 
      when 0 then 1
      else 0
      end as FUnReBusiness,
	case invoice.FIsPayment 
	  when 1 then 1 
      else 0
      end as FPaymented,
    case invoice.FIsPayment 
      when 0 then 1
      else 0
      end as FUnPayment	
	from T_TM_MachineInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'8' then N'的士票'
	  else N''
	  end as FInvoiceType, 
	case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 0 
      else 1 
      end as FBizBill,
    case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 1 
      else 0 
      end as FUnBizBill,
	case invoice.FIsBusiness 
	  when 1 then 1 
      else 0
      end as FReBusinessed,
    case invoice.FIsBusiness 
      when 0 then 1
      else 0
      end as FUnReBusiness,
	case invoice.FIsPayment 
	  when 1 then 1 
      else 0
      end as FPaymented,
    case invoice.FIsPayment 
      when 0 then 1
      else 0
      end as FUnPayment	
	from T_TM_TaxiInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'9' then N'火车票'
	  else N''
	  end as FInvoiceType, 
	case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 0 
      else 1 
      end as FBizBill,
    case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 1 
      else 0 
      end as FUnBizBill,
	case invoice.FIsBusiness 
	  when 1 then 1 
      else 0
      end as FReBusinessed,
    case invoice.FIsBusiness 
      when 0 then 1
      else 0
      end as FUnReBusiness,
	case invoice.FIsPayment 
	  when 1 then 1 
      else 0
      end as FPaymented,
    case invoice.FIsPayment 
      when 0 then 1
      else 0
      end as FUnPayment	
	from T_TM_TrainInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'10' then N'飞机票'
	  else N''
	  end as FInvoiceType, 
	case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 0 
      else 1 
      end as FBizBill,
    case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 1 
      else 0 
      end as FUnBizBill,
	case invoice.FIsBusiness 
	  when 1 then 1 
      else 0
      end as FReBusinessed,
    case invoice.FIsBusiness 
      when 0 then 1
      else 0
      end as FUnReBusiness,
	case invoice.FIsPayment 
	  when 1 then 1 
      else 0
      end as FPaymented,
    case invoice.FIsPayment 
      when 0 then 1
      else 0
      end as FUnPayment	
	from T_TM_PlaneInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'11' then N'其他发票'
	  else N''
	  end as FInvoiceType, 
	case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 0 
      else 1 
      end as FBizBill,
    case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 1 
      else 0 
      end as FUnBizBill,
	case invoice.FIsBusiness 
	  when 1 then 1 
      else 0
      end as FReBusinessed,
    case invoice.FIsBusiness 
      when 0 then 1
      else 0
      end as FUnReBusiness,
	case invoice.FIsPayment 
	  when 1 then 1 
      else 0
      end as FPaymented,
    case invoice.FIsPayment 
      when 0 then 1
      else 0
      end as FUnPayment	
	from T_TM_OtherInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'13' then N'二手车票'
	  else N''
	  end as FInvoiceType, 
	case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 0 
      else 1 
      end as FBizBill,
    case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 1 
      else 0 
      end as FUnBizBill,
	case invoice.FIsBusiness 
	  when 1 then 1 
      else 0
      end as FReBusinessed,
    case invoice.FIsBusiness 
      when 0 then 1
      else 0
      end as FUnReBusiness,
	case invoice.FIsPayment 
	  when 1 then 1 
      else 0
      end as FPaymented,
    case invoice.FIsPayment 
      when 0 then 1
      else 0
      end as FUnPayment	
	from T_TM_SecondHandCarInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'14' then N'定额发票'
	  else N''
	  end as FInvoiceType, 
	case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 0 
      else 1 
      end as FBizBill,
    case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 1 
      else 0 
      end as FUnBizBill,
	case invoice.FIsBusiness 
	  when 1 then 1 
      else 0
      end as FReBusinessed,
    case invoice.FIsBusiness 
      when 0 then 1
      else 0
      end as FUnReBusiness,
	case invoice.FIsPayment 
	  when 1 then 1 
      else 0
      end as FPaymented,
    case invoice.FIsPayment 
      when 0 then 1
      else 0
      end as FUnPayment	
	from T_TM_QuotaInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'16' then N'客运票'
	  when N'20' then N'轮船票'
	  else N''
	  end as FInvoiceType, 
	case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 0 
      else 1 
      end as FBizBill,
    case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 1 
      else 0 
      end as FUnBizBill,
	case invoice.FIsBusiness 
	  when 1 then 1 
      else 0
      end as FReBusinessed,
    case invoice.FIsBusiness 
      when 0 then 1
      else 0
      end as FUnReBusiness,
	case invoice.FIsPayment 
	  when 1 then 1 
      else 0
      end as FPaymented,
    case invoice.FIsPayment 
      when 0 then 1
      else 0
      end as FUnPayment	
	from T_TM_ShipInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'19' then N'完税证明'
	  else N''
	  end as FInvoiceType, 
	case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 0 
      else 1 
      end as FBizBill,
    case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 1 
      else 0 
      end as FUnBizBill,
	case invoice.FIsBusiness 
	  when 1 then 1 
      else 0
      end as FReBusinessed,
    case invoice.FIsBusiness 
      when 0 then 1
      else 0
      end as FUnReBusiness,
	case invoice.FIsPayment 
	  when 1 then 1 
      else 0
      end as FPaymented,
    case invoice.FIsPayment 
      when 0 then 1
      else 0
      end as FUnPayment	
	from T_TM_PurchaseInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'24' then N'火车票退票凭证'
	  else N''
	  end as FInvoiceType, 
	case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 0 
      else 1 
      end as FBizBill,
    case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 1 
      else 0 
      end as FUnBizBill,
	case invoice.FIsBusiness 
	  when 1 then 1 
      else 0
      end as FReBusinessed,
    case invoice.FIsBusiness 
      when 0 then 1
      else 0
      end as FUnReBusiness,
	case invoice.FIsPayment 
	  when 1 then 1 
      else 0
      end as FPaymented,
    case invoice.FIsPayment 
      when 0 then 1
      else 0
      end as FUnPayment	
	from T_TM_TrainRefundVoucher as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'25' then N'财政电子票据'
	  else N''
	  end as FInvoiceType, 
	case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 0 
      else 1 
      end as FBizBill,
    case isnull(invoice.FBIZBILLNUMBER,'_$$null&&_') 
	  when  '_$$null&&_' then 1 
      else 0 
      end as FUnBizBill,
	case invoice.FIsBusiness 
	  when 1 then 1 
      else 0
      end as FReBusinessed,
    case invoice.FIsBusiness 
      when 0 then 1
      else 0
      end as FUnReBusiness,
	case invoice.FIsPayment 
	  when 1 then 1 
      else 0
      end as FPaymented,
    case invoice.FIsPayment 
      when 0 then 1
      else 0
      end as FUnPayment
	from T_TM_FinancialInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
) as invoicePool 
where invoicePool.FCompanyID in (SELECT BaseUnit.FID
  FROM T_ORG_BaseUnit BaseUnit
 INNER JOIN T_ORG_Structure Structure
    ON Structure.FUnitId = BaseUnit.FID
 WHERE Structure.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD' and BaseUnit.FISLEAF =1 
   AND EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 10
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 10
           AND UserRoleOrg.Forgid = BaseUnit.fid)
   AND NOT EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 20
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 20
           AND UserRoleOrg.Forgid = BaseUnit.fid))]]></UserSQL>
				<UserSQL name="dm1657676174214" sqlType="KSQL"><![CDATA[select FID,Fnumber,FcompanyID,FCompanyName,FInvoiceDate,FInvoiceType,
FResourceType,FAmountTaxTotal
from
(
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FTmInvoiceType
	  when N'1' then N'增值税电子普通发票'
	  when N'2' then N'增值税电子专用发票'
	  when N'3' then N'增值税普通发票'
	  when N'4' then N'增值税专用发票'
	  when N'5' then N'增值税普通发票（卷票）'
	  else N''
	  end as FInvoiceType, 
	case invoice.FResourceType
	  when N'0' then N'手工新增'
	  when N'1' then N'Excel导入'
	  when N'2' then N'发票云下载'
	  when N'3' then N'WebService接入'
	  when N'4' then N'OCR采集'
	  else N''
	  end as FResourceType, 
	isnull(invoice.FAmountTax,0) as FAmountTaxTotal	
	from T_IM_IncomeInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid

	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'26' then N'全电普票'
	  when N'27' then N'全电专票'
	  else N''
	  end as FInvoiceType, 
	case invoice.FSourceType
	  when N'1' then N'发票云下载'
	  when N'2' then N'OCR采集'
	  when N'3' then N'手工新增'
	  when N'4' then N'Excel导入'
	  else N''
	  end as FResourceType,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_FullElectricInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FBizDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'15' then N'通行费电子发票'
	  else N''
	  end as FInvoiceType, 
	case invoice.FSourceType
	  when N'1' then N'发票云下载'
	  when N'2' then N'OCR采集'
	  when N'3' then N'手工新增'
	  when N'4' then N'Excel导入'
	  else N''
	  end as FResourceType,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_TollInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FBizDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'12' then N'机动车发票'
	  else N''
	  end as FInvoiceType, 
	case invoice.FSourceType
	  when N'1' then N'发票云下载'
	  when N'2' then N'OCR采集'
	  when N'3' then N'手工新增'
	  when N'4' then N'Excel导入'
	  else N''
	  end as FResourceType,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_VehicleInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'7' then N'通用机打发票'
	  when N'17' then N'过路过桥费'
	  when N'23' then N'通用机打电子发票'
	  else N''
	  end as FInvoiceType, 
	case invoice.FSourceType
	  when N'1' then N'发票云下载'
	  when N'2' then N'OCR采集'
	  when N'3' then N'手工新增'
	  when N'4' then N'Excel导入'
	  else N''
	  end as FResourceType,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_MachineInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'8' then N'的士票'
	  else N''
	  end as FInvoiceType, 
	case invoice.FSourceType
	  when N'1' then N'发票云下载'
	  when N'2' then N'OCR采集'
	  when N'3' then N'手工新增'
	  when N'4' then N'Excel导入'
	  else N''
	  end as FResourceType,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_TaxiInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'9' then N'火车票'
	  else N''
	  end as FInvoiceType, 
	case invoice.FSourceType
	  when N'1' then N'发票云下载'
	  when N'2' then N'OCR采集'
	  when N'3' then N'手工新增'
	  when N'4' then N'Excel导入'
	  else N''
	  end as FResourceType,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_TrainInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'10' then N'飞机票'
	  else N''
	  end as FInvoiceType, 
	case invoice.FSourceType
	  when N'1' then N'发票云下载'
	  when N'2' then N'OCR采集'
	  when N'3' then N'手工新增'
	  when N'4' then N'Excel导入'
	  else N''
	  end as FResourceType,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_PlaneInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'11' then N'其他发票'
	  else N''
	  end as FInvoiceType, 
	case invoice.FSourceType
	  when N'1' then N'发票云下载'
	  when N'2' then N'OCR采集'
	  when N'3' then N'手工新增'
	  when N'4' then N'Excel导入'
	  else N''
	  end as FResourceType,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_OtherInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'13' then N'二手车票'
	  else N''
	  end as FInvoiceType, 
	case invoice.FSourceType
	  when N'1' then N'发票云下载'
	  when N'2' then N'OCR采集'
	  when N'3' then N'手工新增'
	  when N'4' then N'Excel导入'
	  else N''
	  end as FResourceType,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_SecondHandCarInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'14' then N'定额发票'
	  else N''
	  end as FInvoiceType, 
	case invoice.FSourceType
	  when N'1' then N'发票云下载'
	  when N'2' then N'OCR采集'
	  when N'3' then N'手工新增'
	  when N'4' then N'Excel导入'
	  else N''
	  end as FResourceType,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_QuotaInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'16' then N'客运票'
	  when N'20' then N'轮船票'
	  else N''
	  end as FInvoiceType, 
	case invoice.FSourceType
	  when N'1' then N'发票云下载'
	  when N'2' then N'OCR采集'
	  when N'3' then N'手工新增'
	  when N'4' then N'Excel导入'
	  else N''
	  end as FResourceType,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_ShipInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'19' then N'完税证明'
	  else N''
	  end as FInvoiceType, 
	case invoice.FSourceType
	  when N'1' then N'发票云下载'
	  when N'2' then N'OCR采集'
	  when N'3' then N'手工新增'
	  when N'4' then N'Excel导入'
	  else N''
	  end as FResourceType,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_PurchaseInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'24' then N'火车票退票凭证'
	  else N''
	  end as FInvoiceType, 
	case invoice.FSourceType
	  when N'1' then N'发票云下载'
	  when N'2' then N'OCR采集'
	  when N'3' then N'手工新增'
	  when N'4' then N'Excel导入'
	  else N''
	  end as FResourceType,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_TrainRefundVoucher as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'25' then N'财政电子票据'
	  else N''
	  end as FInvoiceType, 
	case invoice.FSourceType
	  when N'1' then N'发票云下载'
	  when N'2' then N'OCR采集'
	  when N'3' then N'手工新增'
	  when N'4' then N'Excel导入'
	  else N''
	  end as FResourceType,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_FinancialInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
) as invoicePool 
where invoicePool.FCompanyID in (SELECT BaseUnit.FID
  FROM T_ORG_BaseUnit BaseUnit
 INNER JOIN T_ORG_Structure Structure
    ON Structure.FUnitId = BaseUnit.FID
 WHERE Structure.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD' and BaseUnit.FISLEAF =1 
   AND EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 10
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 10
           AND UserRoleOrg.Forgid = BaseUnit.fid)
   AND NOT EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 20
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 20
           AND UserRoleOrg.Forgid = BaseUnit.fid))]]></UserSQL>
				<UserSQL name="dm1657676207582" sqlType="KSQL"><![CDATA[select FID,Fnumber,FcompanyID,FCompanyName,FInvoiceDate,FConfirmTime,FInvoiceType,
FTaxTotal
from
(
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	checkabs.FConfirmTime as FConfirmTime,
	case invoice.FTmInvoiceType
	  when N'2' then N'增值税电子专用发票'
	  when N'4' then N'增值税专用发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FTax,0) as FTaxTotal	
	from T_IM_IncomeInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	left join T_TM_CheckAbs as checkabs ON invoice.FCheckAbsID = checkabs.FID
	where invoice.FTmInvoiceType = '4' or invoice.FTmInvoiceType = '2'

	union all
		
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	checkabs.FConfirmTime as FConfirmTime,
	case invoice.FInvoiceType
	  when N'27' then N'全电专票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FTotalTaxAmount,0) as FTaxTotal	
	from T_TM_FullElectricInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	left join T_TM_CheckAbs as checkabs ON invoice.FCheckAbsID = checkabs.FID
	where invoice.FInvoiceType = '27' 
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FBizDate as FInvoiceDate,
	checkabs.FConfirmTime as FConfirmTime,
	case invoice.FInvoiceType
	  when N'15' then N'通行费发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FTotalTaxAmount,0) as FTaxTotal	
	from T_TM_TollInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	left join T_TM_CheckAbs as checkabs ON invoice.FCheckAbsID = checkabs.FID
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FBizDate as FInvoiceDate,
	checkabs.FConfirmTime as FConfirmTime,
	case invoice.FInvoiceType
	  when N'12' then N'机动车发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FTotalTaxAmount,0) as FTaxTotal	
	from T_TM_VehicleInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	left join T_TM_CheckAbs as checkabs ON invoice.FCheckAbsID = checkabs.FID
) as invoicePool 
where invoicePool.FCompanyID in (SELECT BaseUnit.FID
  FROM T_ORG_BaseUnit BaseUnit
 INNER JOIN T_ORG_Structure Structure
    ON Structure.FUnitId = BaseUnit.FID
 WHERE Structure.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD' and BaseUnit.FISLEAF =1 
   AND EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 10
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 10
           AND UserRoleOrg.Forgid = BaseUnit.fid)
   AND NOT EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 20
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 20
           AND UserRoleOrg.Forgid = BaseUnit.fid))]]></UserSQL>
				<UserSQL name="dm1657676233087" sqlType="KSQL"><![CDATA[select FID,Fnumber,FcompanyID,FCompanyName,FInvoiceDate,FInvoiceType,
FAmountTotal,FTaxAmtTotal,FAmountTaxTotal
from
(
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FTmInvoiceType
	  when N'1' then N'增值税电子普通发票'
	  when N'2' then N'增值税电子专用发票'
	  when N'3' then N'增值税普通发票'
	  when N'4' then N'增值税专用发票'
	  when N'5' then N'增值税普通发票（卷票）'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FAmount,0) as FAmountTotal,
	isnull(invoice.FTax,0) as FTaxAmtTotal,
	isnull(invoice.FAmountTax,0) as FAmountTaxTotal	
	from T_IM_IncomeInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid

	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'26' then N'全电普票'
	  when N'27' then N'全电专票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FInvoiceAmount,0) as FAmountTotal,
	isnull(invoice.FTotalTaxAmount,0) as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_FullElectricInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FBizDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'15' then N'通行费电子发票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FInvoiceAmount,0) as FAmountTotal,
	isnull(invoice.FTotalTaxAmount,0) as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_TollInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FBizDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'12' then N'机动车发票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FInvoiceMoney,0) as FAmountTotal,
	isnull(invoice.FTotalTaxAmount,0) as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_VehicleInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'7' then N'通用机打发票'
	  when N'17' then N'过路过桥费'
	  when N'23' then N'通用机打电子发票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FTotalAmount,0) as FAmountTotal,
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_MachineInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'8' then N'的士票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FTotalAmount,0) as FAmountTotal,
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_TaxiInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'9' then N'火车票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FTotalAmount,0) as FAmountTotal,
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_TrainInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'10' then N'飞机票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FInvoiceAmount,0) as FAmountTotal,
	isnull(invoice.FTotalTaxAmount,0) as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_PlaneInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'11' then N'其他发票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FTotalAmount,0) as FAmountTotal,
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_OtherInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'13' then N'二手车票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FTotalAmount,0) as FAmountTotal,
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_SecondHandCarInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'14' then N'定额发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FTotalAmount,0) as FAmountTotal,
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_QuotaInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'16' then N'客运票'
	  when N'20' then N'轮船票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FTotalAmount,0) as FAmountTotal,
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_ShipInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'19' then N'完税证明'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FTotalAmount,0) as FAmountTotal,
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_PurchaseInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'24' then N'火车票退票凭证'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FTotalAmount,0) as FAmountTotal,
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_TrainRefundVoucher as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'25' then N'财政电子票据'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FTotalAmount,0) as FAmountTotal,
	0 as FTaxAmtTotal,
	isnull(invoice.FTotalAmount,0) as FAmountTaxTotal	
	from T_TM_FinancialInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
) as invoicePool 
where invoicePool.FCompanyID in (SELECT BaseUnit.FID
  FROM T_ORG_BaseUnit BaseUnit
 INNER JOIN T_ORG_Structure Structure
    ON Structure.FUnitId = BaseUnit.FID
 WHERE Structure.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD' and BaseUnit.FISLEAF =1 
   AND EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 10
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 10
           AND UserRoleOrg.Forgid = BaseUnit.fid)
   AND NOT EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 20
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 20
           AND UserRoleOrg.Forgid = BaseUnit.fid))]]></UserSQL>
				<UserSQL name="dm1657676256855" sqlType="KSQL"><![CDATA[select FID,Fnumber,FcompanyID,FCompanyName,FInvoiceDate,FInvoiceType,
FUnTransferTaxAmt,FTransferTaxAmt
from
(
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FTmInvoiceType
	  when N'2' then N'增值税电子专用发票'
	  when N'4' then N'增值税专用发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FUnTransferTaxAmt,0) as FUnTransferTaxAmt,
	isnull(invoice.FTransferTaxAmt,0) as FTransferTaxAmt
	from T_IM_IncomeInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	where invoice.FTmInvoiceType = '4' or invoice.FTmInvoiceType = '2'

	union all
		
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FCreateTime as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'27' then N'全电专票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FUnTransferTaxAmt,0) as FUnTransferTaxAmt,
	isnull(invoice.FTransferTaxAmt,0) as FTransferTaxAmt	
	from T_TM_FullElectricInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	where invoice.FInvoiceType = '27' 
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FBizDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'15' then N'通行费发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FUnTransferTaxAmt,0) as FUnTransferTaxAmt,
	isnull(invoice.FTransferTaxAmt,0) as FTransferTaxAmt
	from T_TM_TollInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	
	union all
	
	select invoice.FID as FID,
	CONVERT(NVARCHAR(80),invoice.Fnumber) as Fnumber,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FBizDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'12' then N'机动车发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FUnTransferTaxAmt,0) as FUnTransferTaxAmt,
	isnull(invoice.FTransferTaxAmt,0) as FTransferTaxAmt
	from T_TM_VehicleInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
) as invoicePool 
where invoicePool.FCompanyID in (SELECT BaseUnit.FID
  FROM T_ORG_BaseUnit BaseUnit
 INNER JOIN T_ORG_Structure Structure
    ON Structure.FUnitId = BaseUnit.FID
 WHERE Structure.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD' and BaseUnit.FISLEAF =1 
   AND EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 10
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 10
           AND UserRoleOrg.Forgid = BaseUnit.fid)
   AND NOT EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND UserOrgPerm.FPermType = 20
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '114d8d6e-d849-4901-83eb-ffec375de0e9PERMITEM'
           AND RolePerm.FPermType = 20
           AND UserRoleOrg.Forgid = BaseUnit.fid))]]></UserSQL>
			</UserSQLs>
		</BizMetaSource>
	</Sources>
	<ExtractSchedule dayAtMonthly="0" weekAtWeekly="1" time="75600" />
	<Entities>
		<Entity name="dm1657675986106" alias="进项发票数据汇总-全票种" associateName="dm1657675986106" directModel="false" source="s1657675953191">
			<Design x="10" y="10" width="200" height="90" />
			<Properties>
				<Property name="FID" associateName="FID" alias="FID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNUMBER" associateName="FNUMBER" alias="单据编码" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="公司ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYNAME" associateName="FCOMPANYNAME" alias="财务组织" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINVOICEDATE" associateName="FINVOICEDATE" alias="业务日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FINVOICETYPE" associateName="FINVOICETYPE" alias="发票类型" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FTAXAMTTOTAL" associateName="FTAXAMTTOTAL" alias="税额合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FAMOUNTTAXTOTAL" associateName="FAMOUNTTAXTOTAL" alias="价税合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1657676013664" alias="进行发票数据汇总-全电、增值、通行费、机动车、二手车" associateName="dm1657676013664" directModel="false" source="s1657675953191">
			<Design x="250" y="10" width="200" height="90" />
			<Properties>
				<Property name="FID" associateName="FID" alias="FID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNUMBER" associateName="FNUMBER" alias="单据编码" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="公司ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYNAME" associateName="FCOMPANYNAME" alias="财务组织" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINVOICEDATE" associateName="FINVOICEDATE" alias="业务日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FINVOICETYPE" associateName="FINVOICETYPE" alias="发票类型" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1657676041492" alias="进项发票数据汇总-火车、飞机、轮船、客运" associateName="dm1657676041492" directModel="false" source="s1657675953191">
			<Design x="490" y="10" width="200" height="90" />
			<Properties>
				<Property name="FID" associateName="FID" alias="FID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNUMBER" associateName="FNUMBER" alias="单据编码" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="公司ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYNAME" associateName="FCOMPANYNAME" alias="财务组织" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINVOICEDATE" associateName="FINVOICEDATE" alias="业务日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FINVOICETYPE" associateName="FINVOICETYPE" alias="发票类型" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1657676071293" alias="可勾选发票到票与认证情况-增值、全电、通行、机动" associateName="dm1657676071293" directModel="false" source="s1657675953191">
			<Design x="730" y="10" width="200" height="90" />
			<Properties>
				<Property name="FID" associateName="FID" alias="FID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNUMBER" associateName="FNUMBER" alias="单据编码" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="公司ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYNAME" associateName="FCOMPANYNAME" alias="财务组织" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINVOICEDATE" associateName="FINVOICEDATE" alias="业务日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FINVOICETYPE" associateName="FINVOICETYPE" alias="发票类型" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FACCEPTED" associateName="FACCEPTED" alias="已到票数量" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FUNACCEPT" associateName="FUNACCEPT" alias="未到票数量" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FCHECKED" associateName="FCHECKED" alias="已勾选数量" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FUNCHECK" associateName="FUNCHECK" alias="未勾选数量" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FCONFIRMED" associateName="FCONFIRMED" alias="已确认数量" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FUNCONFIRM" associateName="FUNCONFIRM" alias="未确认数量" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1657676095455" alias="可勾选发票到票与认证情况-增值、机动" associateName="dm1657676095455" directModel="false" source="s1657675953191">
			<Design x="970" y="10" width="200" height="90" />
			<Properties>
				<Property name="FID" associateName="FID" alias="FID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNUMBER" associateName="FNUMBER" alias="单据编码" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="公司ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYNAME" associateName="FCOMPANYNAME" alias="财务组织" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINVOICEDATE" associateName="FINVOICEDATE" alias="业务日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FINVOICETYPE" associateName="FINVOICETYPE" alias="发票类型" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FRECEIVEED" associateName="FRECEIVEED" alias="已签收数量" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FUNRECEIVE" associateName="FUNRECEIVE" alias="未签收数量" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1657676122937" alias="进项税额认证情况" associateName="dm1657676122937" directModel="false" source="s1657675953191">
			<Design x="1210" y="10" width="200" height="90" />
			<Properties>
				<Property name="FID" associateName="FID" alias="FID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNUMBER" associateName="FNUMBER" alias="单据编码" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="公司ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYNAME" associateName="FCOMPANYNAME" alias="财务组织" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINVOICEDATE" associateName="FINVOICEDATE" alias="业务日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FINVOICETYPE" associateName="FINVOICETYPE" alias="发票类型" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FTAXTOTAL" associateName="FTAXTOTAL" alias="税额合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FCONFIRMEDTAXTOTAL" associateName="FCONFIRMEDTAXTOTAL" alias="已确认发票税额合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FUNCONFIRMTAXTOTAL" associateName="FUNCONFIRMTAXTOTAL" alias="未确认发票税额合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1657676147221" alias="发票关联业务情况" associateName="dm1657676147221" directModel="false" source="s1657675953191">
			<Design x="1450" y="10" width="200" height="90" />
			<Properties>
				<Property name="FID" associateName="FID" alias="FID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNUMBER" associateName="FNUMBER" alias="单据编码" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="公司ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYNAME" associateName="FCOMPANYNAME" alias="财务组织" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINVOICEDATE" associateName="FINVOICEDATE" alias="业务日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FINVOICETYPE" associateName="FINVOICETYPE" alias="发票类型" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FBIZBILL" associateName="FBIZBILL" alias="已关联业务单据数量" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FUNBIZBILL" associateName="FUNBIZBILL" alias="未关联业务单据数量" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FREBUSINESSED" associateName="FREBUSINESSED" alias="已业务入账单据数量" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FUNREBUSINESS" associateName="FUNREBUSINESS" alias="未业务入账单据数量" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FPAYMENTED" associateName="FPAYMENTED" alias="已业务付款单据数量" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FUNPAYMENT" associateName="FUNPAYMENT" alias="未业务付款单据数量" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1657676174214" alias="进项数据分布-全票种" associateName="dm1657676174214" directModel="false" source="s1657675953191">
			<Design x="10" y="130" width="200" height="90" />
			<Properties>
				<Property name="FID" associateName="FID" alias="FID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNUMBER" associateName="FNUMBER" alias="FNUMBER" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="FCOMPANYID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYNAME" associateName="FCOMPANYNAME" alias="FCOMPANYNAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINVOICEDATE" associateName="FINVOICEDATE" alias="FINVOICEDATE" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FINVOICETYPE" associateName="FINVOICETYPE" alias="FINVOICETYPE" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FRESOURCETYPE" associateName="FRESOURCETYPE" alias="FRESOURCETYPE" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FAMOUNTTAXTOTAL" associateName="FAMOUNTTAXTOTAL" alias="FAMOUNTTAXTOTAL" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1657676207582" alias="进项数据分布-进项税额分布" associateName="dm1657676207582" directModel="false" source="s1657675953191">
			<Design x="250" y="130" width="200" height="90" />
			<Properties>
				<Property name="FID" associateName="FID" alias="FID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNUMBER" associateName="FNUMBER" alias="单据编码" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="公司ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYNAME" associateName="FCOMPANYNAME" alias="财务组织" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINVOICEDATE" associateName="FINVOICEDATE" alias="业务日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FCONFIRMTIME" associateName="FCONFIRMTIME" alias="确认日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FINVOICETYPE" associateName="FINVOICETYPE" alias="发票类型" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FTAXTOTAL" associateName="FTAXTOTAL" alias="税额合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1657676233087" alias="收票量排行" associateName="dm1657676233087" directModel="false" source="s1657675953191">
			<Design x="490" y="130" width="200" height="90" />
			<Properties>
				<Property name="FID" associateName="FID" alias="FID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNUMBER" associateName="FNUMBER" alias="单据编码" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="公司ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYNAME" associateName="FCOMPANYNAME" alias="财务组织" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINVOICEDATE" associateName="FINVOICEDATE" alias="业务日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FINVOICETYPE" associateName="FINVOICETYPE" alias="发票类型" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FAMOUNTTOTAL" associateName="FAMOUNTTOTAL" alias="金额合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FTAXAMTTOTAL" associateName="FTAXAMTTOTAL" alias="税额合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FAMOUNTTAXTOTAL" associateName="FAMOUNTTAXTOTAL" alias="价税合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1657676256855" alias="发票进项税额转出情况" associateName="dm1657676256855" directModel="false" source="s1657675953191">
			<Design x="730" y="130" width="200" height="90" />
			<Properties>
				<Property name="FID" associateName="FID" alias="FID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNUMBER" associateName="FNUMBER" alias="单据编码" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="公司ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYNAME" associateName="FCOMPANYNAME" alias="财务组织" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINVOICEDATE" associateName="FINVOICEDATE" alias="业务日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FINVOICETYPE" associateName="FINVOICETYPE" alias="发票类型" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FUNTRANSFERTAXAMT" associateName="FUNTRANSFERTAXAMT" alias="待转出税额合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FTRANSFERTAXAMT" associateName="FTRANSFERTAXAMT" alias="已转出税额合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
	</Entities>
	<Relations />
	<UnionEntityInnerRelations />
</Data>