/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.autoupdate;

import com.kingdee.bos.autoupdate.JNLPException;
import com.kingdee.bos.autoupdate.LaunchException;
import com.kingdee.bos.autoupdate.Logger;
import com.kingdee.bos.autoupdate.cache.CacheUpdater;
import com.kingdee.bos.autoupdate.config.ConfigInfo;
import com.kingdee.bos.autoupdate.config.ConfigManager;
import com.kingdee.bos.autoupdate.jnl.JARInfo;
import com.kingdee.bos.autoupdate.jnl.JREInfo;
import com.kingdee.bos.autoupdate.jnl.LaunchInfo;
import com.kingdee.bos.autoupdate.jnl.MacroInterpreter;
import com.kingdee.bos.autoupdate.jnl.PropertyInfo;
import com.kingdee.bos.autoupdate.jnl.ResourceInfo;
import com.kingdee.bos.autoupdate.util.StringUtil;
import com.kingdee.bos.autoupdate.util.URLUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;

public class Launch {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void launch(String jnlpUrl, String localPath) throws JNLPException {
        if (jnlpUrl == null || localPath == null) {
            throw new NullPointerException();
        }
        MacroInterpreter.addMarco("HOME", localPath);
        try {
            CacheUpdater updater = new CacheUpdater(jnlpUrl, localPath);
            LaunchInfo launchInfo = updater.update();
            if (!$assertionsDisabled && launchInfo == null) {
                throw new AssertionError();
            }
            String args = Launch.buildStartCmdArgs(localPath, launchInfo);
            String cmd = Launch.getJreCmd() + " " + args;
            String[] cmdarray = StringUtil.split(cmd, " ");
            Logger.getInstance().info("JVM CMD: " + cmd);
            OutputStream os = null;
            os = ConfigInfo.isDebug ? System.out : new FileOutputStream(ConfigManager.getConfigFile("app.log"));
            Process proc = Runtime.getRuntime().exec(cmdarray);
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT", os);
            errorGobbler.start();
            outputGobbler.start();
            os.flush();
            os.close();
        }
        catch (MalformedURLException urle) {
            throw new LaunchException("Invalidate URL[" + jnlpUrl + "]", urle);
        }
        catch (IOException ioe) {
            throw new LaunchException("Cannot start application!", ioe);
        }
    }

    private static String buildStartCmdArgs(String localPath, LaunchInfo launchInfo) {
        if (localPath.lastIndexOf(localPath.length()) != File.separatorChar) {
            localPath = localPath + File.separatorChar;
        }
        StringBuffer classPath = new StringBuffer();
        StringBuffer jvmProps = new StringBuffer();
        String jreArgs = "";
        boolean isJreInit = false;
        ResourceInfo[] resources = launchInfo.getResources().getResources();
        ResourceInfo resource = null;
        int len = resources.length;
        for (int i = 0; i < len; ++i) {
            resource = resources[i];
            if (resource instanceof JARInfo) {
                classPath.append(localPath + URLUtil.getRelativePath(launchInfo.getCodebase(), resource.getHref()) + File.pathSeparatorChar);
                continue;
            }
            if (resource instanceof PropertyInfo) {
                PropertyInfo prop = (PropertyInfo)resource;
                jvmProps.append("-D" + prop.getName() + "=" + MacroInterpreter.interpret(prop.getValue()) + " ");
                continue;
            }
            if (!(resource instanceof JREInfo) || isJreInit) continue;
            JREInfo jre = (JREInfo)resource;
            if (jre.getInitialHeap() != null && jre.getInitialHeap().length() > 0) {
                jreArgs = jreArgs + "-Xms" + jre.getInitialHeap() + " ";
            }
            if (jre.getMaxHeap() != null && jre.getInitialHeap().length() > 0) {
                jreArgs = jreArgs + "-Xmx" + jre.getMaxHeap() + " ";
            }
            isJreInit = true;
        }
        classPath.append(" ");
        return jreArgs + jvmProps.toString() + "-cp " + classPath.toString() + Launch.getAppCmd(launchInfo);
    }

    private static String getJreCmd() {
        String cmd = System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + "javaw.exe";
        return cmd;
    }

    private static String getAppCmd(LaunchInfo launchInfo) {
        StringBuffer appCmd = new StringBuffer();
        appCmd.append(launchInfo.getAppInfo().getMainClass() + " ");
        String[] args = launchInfo.getAppInfo().getArguments();
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            appCmd.append(args[i] + " ");
        }
        return appCmd.toString();
    }

    static {
        $assertionsDisabled = !Launch.class.desiredAssertionStatus();
    }

    static class StreamGobbler
    extends Thread {
        InputStream is;
        String type;
        OutputStream os;

        StreamGobbler(InputStream is, String type) {
            this(is, type, null);
        }

        StreamGobbler(InputStream is, String type, OutputStream redirect) {
            this.is = is;
            this.type = type;
            this.os = redirect;
        }

        public void run() {
            try {
                PrintWriter pw = null;
                if (this.os != null) {
                    pw = new PrintWriter(this.os);
                }
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (pw != null) {
                        pw.println(line);
                    }
                    System.out.println(this.type + ">" + line);
                }
                if (pw != null) {
                    pw.flush();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

