/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart;

import com.kingdee.bos.ctrl.swing.chart.ScatterDataset;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.DefaultPieDataset;
import org.jfree.data.PieDataset;
import org.jfree.data.XYDataset;

final class ChartDataUtil {
    ChartDataUtil() {
    }

    public static CategoryDataset createCategoryDataset(String[] categoryKeys, String[] seriesKeys, double[][] data) {
        return DatasetUtilities.createCategoryDataset((String[])seriesKeys, (String[])categoryKeys, (double[][])data);
    }

    public static CategoryDataset createStackedCategoryDataset(String[] categoryKeys, String[] seriesKeys, double[][] data) {
        int r = 0;
        int c = 0;
        if (data != null) {
            r = data.length;
            if (data[0] != null) {
                c = data[0].length;
            }
        }
        if (r == 0 || c == 0) {
            return null;
        }
        double[][] stacked = new double[r][c];
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                stacked[i][j] = i > 0 ? data[i][j] + stacked[i - 1][j] : data[i][j];
                ++j;
            }
            ++i;
        }
        return DatasetUtilities.createCategoryDataset((String[])seriesKeys, (String[])categoryKeys, (double[][])stacked);
    }

    public static PieDataset createPieDataset(String[] keys, double[] data) {
        DefaultPieDataset result = new DefaultPieDataset();
        int i = 0;
        while (i < keys.length) {
            result.setValue((Comparable)((Object)keys[i]), data[i]);
            ++i;
        }
        return result;
    }

    public static CategoryDataset createLineDataset(String[] categoryKeys, String[] seriesKeys, double[][] data) {
        return DatasetUtilities.createCategoryDataset((String[])seriesKeys, (String[])categoryKeys, (double[][])data);
    }

    public static XYDataset createScatterDataset(String[] seriesKeys, double[][] data) {
        return new ScatterDataset(seriesKeys, data);
    }
}

