/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.dial;

import com.kingdee.bos.ctrl.swing.dial.BasicDial;
import com.kingdee.bos.ctrl.swing.dial.DialLegend;
import com.kingdee.bos.ctrl.swing.dial.DialScale;
import com.kingdee.bos.ctrl.swing.dial.DialTitle;
import com.kingdee.bos.ctrl.swing.dial.KpiNeedle;
import com.kingdee.bos.ctrl.swing.dial.KpiPan;
import com.kingdee.bos.ctrl.swing.dial.KpiScale;
import com.kingdee.bos.ctrl.swing.dial.KpiTitle;
import com.kingdee.bos.ctrl.swing.dial.Legend;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.text.Format;

public class KpiDial
extends BasicDial {
    protected static final int PANRADIUS_NORMAL = 60;
    protected static final double RADIUS_HEIGHT = 0.8783783783783784;

    public Legend createKpiLegend(String normal, String warning, String critical, int orient) {
        Legend legend = null;
        DialScale scl = this.getScale(0);
        if (scl != null && scl instanceof KpiScale) {
            KpiScale kpiscl = (KpiScale)scl;
            legend = DialLegend.createInstance(kpiscl.getNormalPaint(), normal, kpiscl.getWarningPaint(), warning, kpiscl.getCriticalPaint(), critical, orient);
        }
        return legend;
    }

    protected void drawTitle(Graphics2D g2) {
        super.drawTitle(g2);
        KpiTitle ttl = this.getKpiTitle();
        Rectangle ttlR = ttl.getRect();
        g2.setPaint(ttl.getOutlinePaint());
        g2.drawLine(ttlR.x, ttlR.y + ttlR.height - 1, ttlR.x + ttlR.width - 1, ttlR.y + ttlR.height - 1);
        g2.drawLine(ttlR.x, ttlR.y + ttlR.height * 2 / 3, ttlR.x, ttlR.y + ttlR.height - 1);
        g2.drawLine(ttlR.x + ttlR.width - 1, ttlR.y + ttlR.height * 2 / 3, ttlR.x + ttlR.width - 1, ttlR.y + ttlR.height - 1);
    }

    protected String generateToolTip() {
        DialScale scl = this.getScale(0);
        Format ft = null;
        Object val = null;
        String tip = "";
        if (scl != null) {
            ft = scl.getTickLabelFormat();
        }
        if (ft != null) {
            val = this.getValue();
        }
        if (val != null) {
            tip = ft.format(val);
        }
        return tip;
    }

    protected void paintComponent(Graphics g) {
        int i;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.isOpaque()) {
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, width, height);
        }
        Insets ins = this.getInsets();
        Rectangle area = new Rectangle(ins.top, ins.left, width -= ins.left + ins.right, height -= ins.top + ins.bottom);
        Rectangle panR = new Rectangle();
        Rectangle ttlR = new Rectangle();
        this.calcElementRect(area, panR, ttlR);
        if (this.pan != null) {
            this.pan.draw(g, panR, this);
        }
        if (this.scales != null) {
            i = 0;
            while (i < this.scales.size()) {
                BasicDial.ScaleItem si = (BasicDial.ScaleItem)this.scales.get(i);
                si.scale.draw(g, panR, this);
                ++i;
            }
        }
        if (this.indicators != null) {
            i = 0;
            while (i < this.indicators.size()) {
                BasicDial.IndicatorItem ii = (BasicDial.IndicatorItem)this.indicators.get(i);
                ii.indicator.draw(g, area, this);
                ++i;
            }
        }
        if (this.needles != null) {
            i = 0;
            while (i < this.needles.size()) {
                BasicDial.NeedleItem ni = (BasicDial.NeedleItem)this.needles.get(i);
                ni.needle.draw(g, panR, this);
                ++i;
            }
        }
        DialTitle ttl = this.getTitle();
        ttl.setRect(ttlR);
        this.drawTitle(g2);
    }

    private void calcElementRect(Rectangle area, Rectangle panR, Rectangle ttlR) {
        int r = (area.width - 1) / 2;
        int rfromh = (int)((double)(area.height - 19) * 0.8783783783783784);
        if (r > rfromh) {
            r = rfromh;
        }
        panR.width = 2 * r + 1;
        panR.height = (int)((double)r / 0.8783783783783784);
        int h = 19 + panR.height;
        panR.x = area.x + (area.width - panR.width) / 2;
        panR.y = area.y + (area.height - h) / 2;
        ttlR.x = panR.x;
        ttlR.y = panR.y + panR.height;
        ttlR.height = 19;
        ttlR.width = panR.width;
    }

    public KpiScale getScale() {
        return (KpiScale)this.getScale(0);
    }

    public KpiNeedle getNeedle() {
        return (KpiNeedle)super.getNeedle(0);
    }

    public void clear() {
        this.setValue(null);
        this.getScale().setTotalRange(null);
        this.getScale().setNormalRange(null);
        this.getScale().setWarningRange(null);
        this.getScale().setCriticalRange(null);
        this.repaint();
    }

    public KpiTitle getKpiTitle() {
        return (KpiTitle)super.getTitle();
    }

    public KpiPan getKpiPan() {
        return (KpiPan)super.getPan();
    }
}

