/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.layout.render;

import com.kingdee.bos.web.anole.controls.KDComponent;
import com.kingdee.bos.web.anole.layout.GridLayout;
import com.kingdee.bos.web.anole.layout.render.ILayoutRender;
import com.kingdee.bos.web.anole.runtime.MobileCapabilities;

public abstract class GridLayoutRender
implements ILayoutRender {
    public static final String HTML_SPACE = "&nbsp";
    public static final int DEFAULT_PIXES_SIZE = 9;

    protected int getMaxCompLength(KDComponent pCom) {
        int max = 0;
        int icount = pCom.getComponentCount();
        KDComponent comp = null;
        int i = 0;
        while (i < icount) {
            comp = pCom.getComponent(i);
            if (comp.getLength() > max) {
                max = comp.getLength();
            }
            ++i;
        }
        return max;
    }

    protected int preScan(KDComponent pCom) {
        int i;
        KDComponent[] comps = pCom.getComponents();
        int icount = pCom.getComponentCount();
        int irow = ((GridLayout)pCom.getLayout()).getRows();
        int icol = ((GridLayout)pCom.getLayout()).getColumns();
        MobileCapabilities mobileCaps = (MobileCapabilities)pCom.getAppInstance().getBrowserCaps();
        int iDefaultSize = mobileCaps.getDefaultScreenCharactersWidth();
        int iDefaultWidth = mobileCaps.getDefaultScreenPixelsWidth();
        int cMaxWidth = 0;
        int j = 0;
        while (j < icol) {
            int cMax = 0;
            i = 0;
            while (i < irow) {
                int index = i * icol + j;
                if (index > icount - 1) break;
                KDComponent comp = comps[index];
                int length = comp.getPreferredSize().getWidth();
                if (length >= cMax) {
                    cMax = length;
                }
                ++i;
            }
            if (cMax > cMaxWidth) {
                cMaxWidth = cMax;
            }
            ++j;
        }
        int newCol = 1;
        if (cMaxWidth * icol > iDefaultWidth) {
            int i2 = icol - 1;
            while (i2 > 1) {
                if (cMaxWidth * i2 <= iDefaultWidth) {
                    newCol = i2;
                    break;
                }
                --i2;
            }
            int newRow = irow * icol / newCol;
            if (irow * icol % newCol != 0) {
                ++newRow;
            }
            ((GridLayout)pCom.getLayout()).setRows(newRow);
            ((GridLayout)pCom.getLayout()).setColumns(newCol);
        }
        int w = iDefaultWidth / newCol;
        i = 0;
        while (i < icount) {
            KDComponent comp = comps[i];
            if (comp.getWidth() > w) {
                float rato = (float)comp.getHeight() / (float)comp.getWidth();
                comp.setHeight((int)Math.ceil(rato * (float)w));
                comp.setWidth(w);
            }
            ++i;
        }
        return cMaxWidth;
    }
}

