/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.servlet;

import com.kingdee.bos.web.anole.config.Configurator;
import com.kingdee.bos.web.anole.runtime.Application;
import com.kingdee.bos.web.anole.runtime.ApplicationFactory;
import com.kingdee.bos.web.anole.runtime.DeviceCapsConfig;
import com.kingdee.bos.web.anole.runtime.FrameworkConfig;
import com.kingdee.bos.web.anole.runtime.RequestOptions;
import com.kingdee.bos.web.anole.runtime.SessionApplicationFactory;
import com.kingdee.bos.web.anole.utils.AnoleResourceBundle;
import com.kingdee.bos.web.anole.utils.Log4j;
import com.kingdee.bos.web.anole.xmlparser.ParserUtils;
import com.kingdee.bos.web.anole.xmlparser.TreeNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class JspxServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String METHOD_POST = "POST";
    private ServletContext servletContext = null;
    private FrameworkConfig frameworkConfig = null;
    private DeviceCapsConfig deviceCapsConfig = null;
    private ApplicationFactory appManager = null;
    private UIManager uiManager = null;
    private Logger logger = null;
    private ResourceBundle myResources = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.myResources = AnoleResourceBundle.getInstance();
        this.logger = Log4j.getInstance();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("ANOLE" + this.myResources.getString("starting")));
        }
        this.createTempPath();
        this.servletContext = config.getServletContext();
        this.genrateFrameworkConfig();
        this.genrateDeviceCapsConfig();
        this.appManager = new SessionApplicationFactory(this.servletContext, this.deviceCapsConfig, this.frameworkConfig);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("ANOLE" + this.myResources.getString("started")));
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestOptions requestOptions = new RequestOptions(request);
        this.logger.debug((Object)(String.valueOf(this.myResources.getString("recevicedip")) + request.getRemoteAddr()));
        if (request.getMethod().equals(METHOD_POST) && requestOptions.getEventCurrentWindow() == null) {
            return;
        }
        Application app = this.appManager.findApplication(request);
        if (app == null) {
            return;
        }
        app.setRequestOptions(requestOptions);
        app.update();
        app.fireEvent();
        this.appManager.saveApplication(request, app);
        app.render(response);
        this.logger.debug((Object)(String.valueOf(this.myResources.getString("renderfinished")) + request.getRemoteAddr()));
    }

    public void destroy() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.myResources.getString("destory"));
        }
    }

    private void createTempPath() {
        String tmpPath = Configurator.getTempPath();
        this.createDirectory(tmpPath);
    }

    private void createDirectory(String strPath) {
        File dir = new File(strPath);
        if (dir != null) {
            if (dir.exists()) {
                dir.delete();
            } else if (dir.mkdir()) {
                this.logger.info((Object)(String.valueOf(strPath) + " " + this.myResources.getString("createsucessfully")));
            } else {
                this.logger.info((Object)(String.valueOf(strPath) + " " + this.myResources.getString("createfailure")));
            }
        } else {
            this.logger.info((Object)(String.valueOf(strPath) + " " + this.myResources.getString("nopermission")));
        }
    }

    private void genrateFrameworkConfig() {
        URL urlSystemConfigFile = Configurator.getSystemConfigURL();
        try {
            InputStream fis = urlSystemConfigFile.openStream();
            TreeNode root = ParserUtils.parseXMLDocument(fis);
            this.frameworkConfig = new FrameworkConfig(root);
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)("config.xml " + this.myResources.getString("notfound")));
        }
        catch (IOException e) {
            this.logger.error((Object)("config.xml " + this.myResources.getString("notfound")));
        }
        this.logger.info((Object)("config.xml " + this.myResources.getString("loadsuccessfully")));
    }

    private void genrateDeviceCapsConfig() {
        URL urlBrowserCapsConfig = Configurator.getDeviceCapabilityConfigURL();
        try {
            InputStream fis = urlBrowserCapsConfig.openStream();
            TreeNode root = ParserUtils.parseXMLDocument(fis);
            this.deviceCapsConfig = new DeviceCapsConfig(root);
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)("deviceCaps.xml " + this.myResources.getString("notfound")));
        }
        catch (IOException e) {
            this.logger.error((Object)("deviceCaps.xml " + this.myResources.getString("notfound")));
        }
        this.logger.info((Object)("deviceCaps.xml " + this.myResources.getString("loadsuccessfully")));
    }
}

