/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ksql.shell;

import com.kingdee.bos.ksql.shell.Connection;
import com.kingdee.bos.ksql.shell.ResultSet;
import com.kingdee.bos.ksql.shell.SQLParser;
import com.kingdee.bos.ksql.shell.SQLParserException;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class Statement
implements java.sql.Statement {
    protected java.sql.Statement stmt;
    protected SQLParser parser;
    protected Connection cn;
    protected String dbType;

    protected Statement(java.sql.Statement stmt, Connection cn) {
        this.stmt = stmt;
        this.cn = cn;
        this.parser = cn.getSQLParser();
        this.dbType = cn.getDbType();
    }

    public void addBatch(String sql) throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            try {
                sql = this.parser.parse(sql, this.dbType);
            }
            catch (Exception ex) {
                throw new SQLParserException("Unexpect token exception ", ex);
            }
            this.stmt.addBatch(sql);
        }
    }

    public void cancel() throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            this.stmt.cancel();
        }
    }

    public void clearBatch() throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            this.stmt.clearBatch();
        }
    }

    public void clearWarnings() throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            this.stmt.clearWarnings();
        }
    }

    public void close() throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            this.stmt.close();
        }
    }

    public boolean execute(String sql) throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            try {
                sql = this.parser.parse(sql, this.dbType);
            }
            catch (Exception ex) {
                throw new SQLParserException("Unexpect token exception ", ex);
            }
            boolean bl = this.stmt.execute(sql);
            return bl;
        }
    }

    public int[] executeBatch() throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            int[] nArray = this.stmt.executeBatch();
            return nArray;
        }
    }

    public java.sql.ResultSet executeQuery(String sql) throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            try {
                sql = this.parser.parse(sql, this.dbType);
            }
            catch (Exception ex) {
                throw new SQLParserException("Unexpect token exception ", ex);
            }
            java.sql.ResultSet rs = this.stmt.executeQuery(sql);
            if (rs != null) {
                ResultSet resultSet = new ResultSet(rs, this);
                return resultSet;
            }
            java.sql.ResultSet resultSet = rs;
            return resultSet;
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            try {
                sql = this.parser.parse(sql, this.dbType);
            }
            catch (Exception ex) {
                throw new SQLParserException("Unexpect token exception ", ex);
            }
            int n = this.stmt.executeUpdate(sql);
            return n;
        }
    }

    public java.sql.Connection getConnection() throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            Connection connection2 = this.cn;
            return connection2;
        }
    }

    public int getFetchDirection() throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            int n = this.stmt.getFetchDirection();
            return n;
        }
    }

    public int getFetchSize() throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            int n = this.stmt.getFetchSize();
            return n;
        }
    }

    public int getMaxFieldSize() throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            int n = this.stmt.getMaxFieldSize();
            return n;
        }
    }

    public int getMaxRows() throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            int n = this.stmt.getMaxRows();
            return n;
        }
    }

    public boolean getMoreResults() throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            boolean bl = this.stmt.getMoreResults();
            return bl;
        }
    }

    public int getQueryTimeout() throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            int n = this.stmt.getQueryTimeout();
            return n;
        }
    }

    public java.sql.ResultSet getResultSet() throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            java.sql.ResultSet rs = this.stmt.getResultSet();
            if (rs == null) {
                java.sql.ResultSet resultSet = null;
                return resultSet;
            }
            ResultSet resultSet = new ResultSet(rs, this);
            return resultSet;
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            int n = this.stmt.getResultSetConcurrency();
            return n;
        }
    }

    public int getResultSetType() throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            int n = this.stmt.getResultSetType();
            return n;
        }
    }

    public int getUpdateCount() throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            int n = this.stmt.getUpdateCount();
            return n;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            SQLWarning sQLWarning = this.stmt.getWarnings();
            return sQLWarning;
        }
    }

    public void setCursorName(String name) throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            this.stmt.setCursorName(name);
        }
    }

    public void setEscapeProcessing(boolean p) throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            this.stmt.setEscapeProcessing(p);
        }
    }

    public void setFetchDirection(int p) throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            this.stmt.setFetchDirection(p);
        }
    }

    public void setFetchSize(int p) throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            this.stmt.setFetchSize(p);
        }
    }

    public void setMaxFieldSize(int p) throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            this.stmt.setMaxFieldSize(p);
        }
    }

    public void setMaxRows(int p1) throws SQLException {
        Connection connection = this.cn;
        synchronized (connection) {
            this.stmt.setMaxRows(p1);
        }
    }

    public void setQueryTimeout(int p1) throws SQLException {
        this.stmt.setQueryTimeout(p1);
    }
}

