/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.attachments;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.axis.AxisFault;
import org.apache.axis.Part;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.attachments.DimeDelimitedInputStream;
import org.apache.axis.attachments.DimeTypeNameFormat;
import org.apache.axis.attachments.ManagedMemoryDataSource;
import org.apache.axis.attachments.MultiPartInputStream;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class MultiPartDimeInputStream
extends MultiPartInputStream {
    protected static Log log;
    protected HashMap parts = new HashMap();
    protected LinkedList orderedParts = new LinkedList();
    protected int rootPartLength = 0;
    protected boolean closed = false;
    protected boolean eos = false;
    protected DimeDelimitedInputStream dimeDelimitedStream = null;
    protected InputStream soapStream = null;
    protected byte[] boundary = null;
    protected ByteArrayInputStream cachedSOAPEnvelope = null;
    protected String contentId = null;
    protected static final String[] READ_ALL;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.attachments.MultiPartDimeInputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog(clazz.getName());
        READ_ALL = new String[]{" * \u0000 ".intern()};
    }

    public MultiPartDimeInputStream(InputStream is) throws IOException {
        super(null);
        this.dimeDelimitedStream = new DimeDelimitedInputStream(is);
        this.soapStream = this.dimeDelimitedStream;
        this.contentId = this.dimeDelimitedStream.getContentId();
    }

    public Part getAttachmentByReference(String[] id) throws AxisFault {
        Part ret = null;
        try {
            int i = id.length - 1;
            while (ret == null && i > -1) {
                ret = (AttachmentPart)this.parts.get(id[i]);
                --i;
            }
            if (ret == null) {
                ret = this.readTillFound(id);
            }
            log.debug((Object)Messages.getMessage("return02", "getAttachmentByReference(\"" + id + "\"", ret == null ? "null" : ret.toString()));
        }
        catch (IOException e) {
            throw new AxisFault(String.valueOf(e.getClass().getName()) + e.getMessage());
        }
        return ret;
    }

    protected void addPart(String contentId, String locationId, AttachmentPart ap) {
        if (contentId != null && contentId.trim().length() != 0) {
            this.parts.put(contentId, ap);
        }
        this.orderedParts.add(ap);
    }

    protected void readAll() throws AxisFault {
        try {
            this.readTillFound(READ_ALL);
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
    }

    public Collection getAttachments() throws AxisFault {
        this.readAll();
        return new LinkedList(this.orderedParts);
    }

    protected Part readTillFound(String[] id) throws IOException {
        if (this.dimeDelimitedStream == null) {
            return null;
        }
        AttachmentPart ret = null;
        try {
            if (this.soapStream != null) {
                if (!this.eos) {
                    ByteArrayOutputStream soapdata = new ByteArrayOutputStream(8192);
                    byte[] buf = new byte[16384];
                    int byteread = 0;
                    do {
                        if ((byteread = this.soapStream.read(buf)) <= 0) continue;
                        soapdata.write(buf, 0, byteread);
                    } while (byteread > -1);
                    soapdata.close();
                    this.soapStream.close();
                    this.soapStream = new ByteArrayInputStream(soapdata.toByteArray());
                }
                this.dimeDelimitedStream = this.dimeDelimitedStream.getNextStream();
            }
            if (this.dimeDelimitedStream != null) {
                do {
                    String contentId = this.dimeDelimitedStream.getContentId();
                    String type = this.dimeDelimitedStream.getType();
                    if (type != null && !this.dimeDelimitedStream.getDimeTypeNameFormat().equals(DimeTypeNameFormat.MIME)) {
                        type = "application/uri; uri=\"" + type + "\"";
                    }
                    ManagedMemoryDataSource source = new ManagedMemoryDataSource(this.dimeDelimitedStream, 16384, type, true);
                    DataHandler dh = new DataHandler((DataSource)source);
                    AttachmentPart ap = new AttachmentPart(dh);
                    if (contentId != null) {
                        ap.setMimeHeader("Content-Id", contentId);
                    }
                    this.addPart(contentId, "", ap);
                    int i = id.length - 1;
                    while (ret == null && i > -1) {
                        if (contentId != null && id[i].equals(contentId)) {
                            ret = ap;
                        }
                        --i;
                    }
                    this.dimeDelimitedStream = this.dimeDelimitedStream.getNextStream();
                } while (ret == null && this.dimeDelimitedStream != null);
            }
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
        return ret;
    }

    public String getContentLocation() {
        return null;
    }

    public String getContentId() {
        return this.contentId;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(Messages.getMessage("streamClosed"));
        }
        if (this.eos) {
            return -1;
        }
        int read = this.soapStream.read(b, off, len);
        if (read < 0) {
            this.eos = true;
        }
        return read;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(Messages.getMessage("streamClosed"));
        }
        if (this.eos) {
            return -1;
        }
        int ret = this.soapStream.read();
        if (ret < 0) {
            this.eos = true;
        }
        return ret;
    }

    public void close() throws IOException {
        this.closed = true;
        this.soapStream.close();
    }
}

