/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Use;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.ser.ArraySerializerFactory;
import org.apache.axis.schema.SchemaVersion;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class ArraySerializer
implements Serializer {
    QName xmlType = null;
    Class javaType = null;
    QName componentType = null;
    QName componentQName = null;
    protected static Log log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.encoding.ser.ArraySerializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog(clazz.getName());
    }

    public ArraySerializer(Class javaType, QName xmlType) {
        this.javaType = javaType;
        this.xmlType = xmlType;
    }

    public ArraySerializer(Class javaType, QName xmlType, QName componentType) {
        this(javaType, xmlType);
        this.componentType = componentType;
    }

    public ArraySerializer(Class javaType, QName xmlType, QName componentType, QName componentQName) {
        this(javaType, xmlType, componentType);
        this.componentQName = componentQName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        boolean maxOccursUsage;
        int dim2Len;
        String arrayType;
        int len;
        QName componentTypeQName;
        Collection list;
        boolean encoded;
        SOAPConstants soap;
        SchemaVersion schema;
        block56: {
            Class<?> componentClass;
            if (value == null) {
                throw new IOException(Messages.getMessage("cantDoNullArray00"));
            }
            MessageContext msgContext = context.getMessageContext();
            schema = SchemaVersion.SCHEMA_2001;
            soap = SOAPConstants.SOAP11_CONSTANTS;
            encoded = context.isEncoded();
            if (msgContext != null) {
                schema = msgContext.getSchemaVersion();
                soap = msgContext.getSOAPConstants();
            }
            Class<?> cls = value.getClass();
            list = null;
            if (!cls.isArray()) {
                if (!(value instanceof Collection)) {
                    throw new IOException(Messages.getMessage("cantSerialize00", cls.getName()));
                }
                list = (Collection)value;
            }
            if (list == null) {
                componentClass = cls.getComponentType();
            } else {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$1 = clazz2;
                }
                componentClass = clazz;
            }
            componentTypeQName = this.componentType;
            String dims = "";
            if (componentTypeQName != null) {
                TypeMapping tm = context.getTypeMapping();
                SerializerFactory factory = (SerializerFactory)tm.getSerializer(componentClass, componentTypeQName);
                while (componentClass.isArray() && factory instanceof ArraySerializerFactory) {
                    ArraySerializerFactory asf = (ArraySerializerFactory)factory;
                    componentClass = componentClass.getComponentType();
                    QName componentType = null;
                    if (asf.getComponentType() != null) {
                        componentType = asf.getComponentType();
                        if (encoded) {
                            componentTypeQName = componentType;
                        }
                    }
                    factory = (SerializerFactory)tm.getSerializer(componentClass, componentType);
                    if (soap == SOAPConstants.SOAP12_CONSTANTS) {
                        dims = String.valueOf(dims) + "* ";
                        continue;
                    }
                    dims = String.valueOf(dims) + "[]";
                }
            } else {
                while (componentClass.isArray()) {
                    componentClass = componentClass.getComponentType();
                    if (soap == SOAPConstants.SOAP12_CONSTANTS) {
                        dims = String.valueOf(dims) + "* ";
                        continue;
                    }
                    dims = String.valueOf(dims) + "[]";
                }
            }
            if (componentTypeQName == null && (componentTypeQName = context.getCurrentXMLType()) != null && (componentTypeQName.equals(this.xmlType) || componentTypeQName.equals(Constants.XSD_ANYTYPE) || componentTypeQName.equals(soap.getArrayType()))) {
                componentTypeQName = null;
            }
            if (componentTypeQName == null) {
                componentTypeQName = context.getItemType();
            }
            if (componentTypeQName == null) {
                componentTypeQName = context.getQNameForClass(componentClass);
            }
            if (componentTypeQName == null) {
                Class<?> searchCls = componentClass;
                while (true) {
                    if (searchCls == null || componentTypeQName != null) {
                        if (componentTypeQName == null) break;
                        componentClass = searchCls;
                        break;
                    }
                    searchCls = searchCls.getSuperclass();
                    componentTypeQName = context.getQNameForClass(searchCls);
                }
            }
            if (componentTypeQName == null) {
                throw new IOException(Messages.getMessage("noType00", componentClass.getName()));
            }
            len = list == null ? Array.getLength(value) : list.size();
            arrayType = "";
            dim2Len = -1;
            if (encoded) {
                arrayType = soap == SOAPConstants.SOAP12_CONSTANTS ? String.valueOf(dims) + len : String.valueOf(dims) + "[" + len + "]";
                boolean enable2Dim = false;
                if (msgContext != null) {
                    enable2Dim = JavaUtils.isTrueExplicitly(msgContext.getProperty("enable2DArrayEncoding"));
                }
                if (enable2Dim && !dims.equals("") && cls.isArray() && len > 0) {
                    block55: {
                        boolean okay = true;
                        int i = 0;
                        while (true) {
                            if (i >= len || !okay) {
                                if (!okay) break block55;
                                dims = dims.substring(0, dims.length() - 2);
                                if (soap != SOAPConstants.SOAP12_CONSTANTS) break;
                                arrayType = String.valueOf(dims) + len + " " + dim2Len;
                                break block56;
                            }
                            Object elementValue = Array.get(value, i);
                            if (elementValue == null) {
                                okay = false;
                            } else if (dim2Len < 0) {
                                dim2Len = Array.getLength(elementValue);
                                if (dim2Len <= 0) {
                                    okay = false;
                                }
                            } else if (dim2Len != Array.getLength(elementValue)) {
                                okay = false;
                            }
                            ++i;
                        }
                        arrayType = String.valueOf(dims) + "[" + len + "," + dim2Len + "]";
                        break block56;
                    }
                    dim2Len = -1;
                }
            }
        }
        QName itemQName = context.getItemQName();
        boolean bl = maxOccursUsage = !encoded && itemQName == null && componentTypeQName.equals(context.getCurrentXMLType());
        if (encoded) {
            AttributesImpl attrs = attributes == null ? new AttributesImpl() : (attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes));
            String compType = context.attributeQName2String(componentTypeQName);
            if (attrs.getIndex(soap.getEncodingURI(), soap.getAttrItemType()) == -1) {
                String encprefix = context.getPrefixForURI(soap.getEncodingURI());
                if (soap != SOAPConstants.SOAP12_CONSTANTS) {
                    compType = String.valueOf(compType) + arrayType;
                    attrs.addAttribute(soap.getEncodingURI(), soap.getAttrItemType(), String.valueOf(encprefix) + ":arrayType", "CDATA", compType);
                } else {
                    attrs.addAttribute(soap.getEncodingURI(), soap.getAttrItemType(), String.valueOf(encprefix) + ":itemType", "CDATA", compType);
                    attrs.addAttribute(soap.getEncodingURI(), "arraySize", String.valueOf(encprefix) + ":arraySize", "CDATA", arrayType);
                }
            }
            String qname = String.valueOf(context.getPrefixForURI(schema.getXsiURI(), "xsi")) + ":type";
            QName soapArray = soap == SOAPConstants.SOAP12_CONSTANTS ? Constants.SOAP_ARRAY12 : Constants.SOAP_ARRAY;
            int typeI = attrs.getIndex(schema.getXsiURI(), "type");
            if (typeI != -1) {
                attrs.setAttribute(typeI, schema.getXsiURI(), "type", qname, "CDATA", context.qName2String(soapArray));
            } else {
                attrs.addAttribute(schema.getXsiURI(), "type", qname, "CDATA", context.qName2String(soapArray));
            }
            attributes = attrs;
        }
        QName elementName = name;
        Attributes serializeAttr = attributes;
        if (!maxOccursUsage) {
            serializeAttr = null;
            context.startElement(name, attributes);
            if (itemQName != null) {
                elementName = itemQName;
            } else if (this.componentQName != null) {
                elementName = this.componentQName;
            }
        }
        if (dim2Len < 0) {
            Object aValue;
            if (list == null) {
                int index = 0;
                while (index < len) {
                    aValue = Array.get(value, index);
                    context.serialize(elementName, serializeAttr == null ? serializeAttr : new AttributesImpl(serializeAttr), aValue, componentTypeQName);
                    ++index;
                }
            } else {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    aValue = iterator.next();
                    context.serialize(elementName, serializeAttr == null ? serializeAttr : new AttributesImpl(serializeAttr), aValue, componentTypeQName);
                }
            }
        } else {
            int index = 0;
            block8: while (index < len) {
                int index2 = 0;
                while (true) {
                    if (index2 >= dim2Len) {
                        ++index;
                        continue block8;
                    }
                    Object aValue = Array.get(Array.get(value, index), index2);
                    context.serialize(elementName, null, aValue, componentTypeQName);
                    ++index2;
                }
            }
        }
        if (!maxOccursUsage) {
            context.endElement();
        }
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    private static boolean isArray(Class clazz) {
        if (!clazz.isArray()) {
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("java.util.Collection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz2.isAssignableFrom(clazz)) {
                return false;
            }
        }
        return true;
    }

    private static Class getComponentType(Class clazz) {
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.util.Collection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.isAssignableFrom(clazz)) {
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz3;
        }
        return null;
    }

    public Element writeSchema(Class javaType, Types types) throws Exception {
        boolean encoded = true;
        MessageContext mc = MessageContext.getCurrentContext();
        if (mc != null) {
            encoded = mc.isEncoded();
        } else {
            boolean bl = encoded = types.getServiceDesc().getUse() == Use.ENCODED;
        }
        if (!encoded) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> cType = clazz;
            if (javaType.isArray()) {
                cType = javaType.getComponentType();
            }
            String typeName = types.writeType(cType);
            return types.createLiteralArrayElement(typeName, null);
        }
        String componentTypeName = null;
        Class componentType = null;
        if (ArraySerializer.isArray(javaType)) {
            String dimString = "[]";
            componentType = ArraySerializer.getComponentType(javaType);
            while (ArraySerializer.isArray(componentType)) {
                dimString = String.valueOf(dimString) + "[]";
                componentType = ArraySerializer.getComponentType(componentType);
            }
            types.writeType(componentType, null);
            componentTypeName = String.valueOf(types.getQNameString(types.getTypeQName(componentType))) + dimString;
        }
        return types.createArrayElement(componentTypeName);
    }
}

