/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.ElementDesc;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.ser.SimpleDeserializer;
import org.apache.axis.message.MessageElement;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.BeanUtils;
import org.apache.axis.utils.FieldPropertyDescriptor;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class BeanSerializer
implements Serializer,
Serializable {
    protected static Log log;
    private static final QName MUST_UNDERSTAND_QNAME;
    private static final Object[] ZERO_ARGS;
    QName xmlType;
    Class javaType;
    protected BeanPropertyDescriptor[] propertyDescriptor = null;
    protected TypeDesc typeDesc = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.encoding.ser.BeanSerializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog(clazz.getName());
        MUST_UNDERSTAND_QNAME = new QName("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand");
        ZERO_ARGS = new Object[]{"0"};
    }

    public BeanSerializer(Class javaType, QName xmlType) {
        this(javaType, xmlType, TypeDesc.getTypeDescForClass(javaType));
    }

    public BeanSerializer(Class javaType, QName xmlType, TypeDesc typeDesc) {
        this(javaType, xmlType, typeDesc, null);
        this.propertyDescriptor = typeDesc != null ? typeDesc.getPropertyDescriptors() : BeanUtils.getPd(javaType, null);
    }

    public BeanSerializer(Class javaType, QName xmlType, TypeDesc typeDesc, BeanPropertyDescriptor[] propertyDescriptor) {
        this.xmlType = xmlType;
        this.javaType = javaType;
        this.typeDesc = typeDesc;
        this.propertyDescriptor = propertyDescriptor;
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        Object newVal;
        boolean suppressElement;
        Attributes beanAttrs = this.getObjectAttributes(value, attributes, context);
        boolean isEncoded = context.isEncoded();
        boolean bl = suppressElement = !isEncoded && name.getNamespaceURI().equals("") && name.getLocalPart().equals("any");
        if (!suppressElement) {
            context.startElement(name, beanAttrs);
        }
        if (value.getClass().isArray() && (newVal = JavaUtils.convert(value, this.javaType)) != null && this.javaType.isAssignableFrom(newVal.getClass())) {
            value = newVal;
        }
        try {
            Object anyVal;
            BeanPropertyDescriptor anyDesc;
            int i = 0;
            while (i < this.propertyDescriptor.length) {
                block22: {
                    QName xmlType;
                    QName qname;
                    block24: {
                        Object propValue;
                        block25: {
                            QName itemQName;
                            boolean isArray;
                            boolean isNillable;
                            boolean isOmittable;
                            Class javaType;
                            String propName;
                            block23: {
                                FieldDesc field;
                                propName = this.propertyDescriptor[i].getName();
                                if (propName.equals("class")) break block22;
                                qname = null;
                                xmlType = null;
                                javaType = this.propertyDescriptor[i].getType();
                                isOmittable = false;
                                isNillable = Types.isNullable(javaType);
                                isArray = false;
                                itemQName = null;
                                if (this.typeDesc == null || (field = this.typeDesc.getFieldByName(propName)) == null) break block23;
                                if (!field.isElement()) break block22;
                                ElementDesc element = (ElementDesc)field;
                                qname = isEncoded ? new QName(element.getXmlName().getLocalPart()) : element.getXmlName();
                                isOmittable = element.isMinOccursZero();
                                isNillable = element.isNillable();
                                isArray = element.isMaxOccursUnbounded();
                                xmlType = element.getXmlType();
                                itemQName = element.getItemQName();
                                context.setItemQName(itemQName);
                            }
                            if (qname == null) {
                                qname = new QName(isEncoded ? "" : name.getNamespaceURI(), propName);
                            }
                            if (xmlType == null) {
                                xmlType = context.getQNameForClass(javaType);
                            }
                            if (!this.propertyDescriptor[i].isReadable()) break block22;
                            if (itemQName == null && (this.propertyDescriptor[i].isIndexed() || isArray)) break block24;
                            propValue = this.propertyDescriptor[i].get(value);
                            if (propValue != null) break block25;
                            if (!isNillable && !isOmittable) {
                                Class<?> clazz = class$1;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("java.lang.Number");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (clazz.isAssignableFrom(javaType)) {
                                    try {
                                        Constructor constructor = javaType.getConstructor(SimpleDeserializer.STRING_CLASS);
                                        propValue = constructor.newInstance(ZERO_ARGS);
                                    }
                                    catch (Exception constructor) {
                                        // empty catch block
                                    }
                                }
                                if (propValue == null) {
                                    throw new IOException(Messages.getMessage("nullNonNillableElement", propName));
                                }
                            }
                            if (isOmittable && !isEncoded) break block22;
                        }
                        context.serialize(qname, null, propValue, xmlType);
                        break block22;
                    }
                    int j = 0;
                    while (j >= 0) {
                        Object propValue = null;
                        try {
                            propValue = this.propertyDescriptor[i].get(value, j);
                            ++j;
                        }
                        catch (Exception e) {
                            j = -1;
                        }
                        if (j < 0) continue;
                        context.serialize(qname, null, propValue, xmlType);
                    }
                }
                ++i;
            }
            BeanPropertyDescriptor beanPropertyDescriptor = anyDesc = this.typeDesc == null ? null : this.typeDesc.getAnyDesc();
            if (anyDesc != null && (anyVal = anyDesc.get(value)) != null && anyVal instanceof MessageElement[]) {
                MessageElement[] anyContent = (MessageElement[])anyVal;
                int i2 = 0;
                while (i2 < anyContent.length) {
                    MessageElement element = anyContent[i2];
                    element.output(context);
                    ++i2;
                }
            }
        }
        catch (InvocationTargetException ite) {
            Throwable target = ite.getTargetException();
            log.error((Object)Messages.getMessage("exception00"), target);
            throw new IOException(target.toString());
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            throw new IOException(e.toString());
        }
        if (!suppressElement) {
            context.endElement();
        }
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    /*
     * Unable to fully structure code
     */
    public Element writeSchema(Class javaType, Types types) throws Exception {
        complexType = types.createElement("complexType");
        e = null;
        superClass = javaType.getSuperclass();
        superPd = null;
        stopClasses = types.getStopClasses();
        if (superClass == null) ** GOTO lbl-1000
        v0 = BeanSerializer.class$2;
        if (v0 == null) {
            try {
                v0 = BeanSerializer.class$2 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException v1) {
                throw new NoClassDefFoundError(v1.getMessage());
            }
        }
        if (superClass == v0) ** GOTO lbl-1000
        v2 = BeanSerializer.class$3;
        if (v2 == null) {
            try {
                v2 = BeanSerializer.class$3 = Class.forName("java.lang.Exception");
            }
            catch (ClassNotFoundException v3) {
                throw new NoClassDefFoundError(v3.getMessage());
            }
        }
        if (superClass == v2) ** GOTO lbl-1000
        v4 = BeanSerializer.class$4;
        if (v4 == null) {
            try {
                v4 = BeanSerializer.class$4 = Class.forName("java.lang.Throwable");
            }
            catch (ClassNotFoundException v5) {
                throw new NoClassDefFoundError(v5.getMessage());
            }
        }
        if (superClass == v4) ** GOTO lbl-1000
        v6 = BeanSerializer.class$5;
        if (v6 == null) {
            try {
                v6 = BeanSerializer.class$5 = Class.forName("java.lang.RuntimeException");
            }
            catch (ClassNotFoundException v7) {
                throw new NoClassDefFoundError(v7.getMessage());
            }
        }
        if (superClass == v6) ** GOTO lbl-1000
        v8 = BeanSerializer.class$6;
        if (v8 == null) {
            try {
                v8 = BeanSerializer.class$6 = Class.forName("java.rmi.RemoteException");
            }
            catch (ClassNotFoundException v9) {
                throw new NoClassDefFoundError(v9.getMessage());
            }
        }
        if (superClass == v8) ** GOTO lbl-1000
        v10 = BeanSerializer.class$7;
        if (v10 == null) {
            try {
                v10 = BeanSerializer.class$7 = Class.forName("org.apache.axis.AxisFault");
            }
            catch (ClassNotFoundException v11) {
                throw new NoClassDefFoundError(v11.getMessage());
            }
        }
        if (!(superClass == v10 || stopClasses != null && stopClasses.contains(superClass.getName()))) {
            base = types.writeType(superClass);
            complexContent = types.createElement("complexContent");
            complexType.appendChild(complexContent);
            extension = types.createElement("extension");
            complexContent.appendChild(extension);
            extension.setAttribute("base", base);
            e = extension;
            superTypeDesc = TypeDesc.getTypeDescForClass(superClass);
            superPd = superTypeDesc != null ? superTypeDesc.getPropertyDescriptors() : BeanUtils.getPd(superClass, null);
        } else lbl-1000:
        // 7 sources

        {
            e = complexType;
        }
        all = types.createElement("sequence");
        e.appendChild(all);
        if (Modifier.isAbstract(javaType.getModifiers())) {
            complexType.setAttribute("abstract", "true");
        }
        i = 0;
        while (i < this.propertyDescriptor.length) {
            propName = this.propertyDescriptor[i].getName();
            writeProperty = true;
            if (propName.equals("class")) {
                writeProperty = false;
            }
            if (superPd != null && writeProperty) {
                j = 0;
                while (j < superPd.length && writeProperty) {
                    if (propName.equals(superPd[j].getName())) {
                        writeProperty = false;
                    }
                    ++j;
                }
            }
            if (writeProperty) {
                if (this.typeDesc != null) {
                    fieldType = this.propertyDescriptor[i].getType();
                    field = this.typeDesc.getFieldByName(propName);
                    if (field != null) {
                        qname = field.getXmlName();
                        fieldXmlType = field.getXmlType();
                        v12 = isAnonymous = fieldXmlType != null && fieldXmlType.getLocalPart().startsWith(">") != false;
                        if (qname != null) {
                            propName = qname.getLocalPart();
                        }
                        if (!field.isElement()) {
                            this.writeAttribute(types, propName, fieldType, fieldXmlType, complexType);
                        } else {
                            this.writeField(types, propName, fieldXmlType, fieldType, this.propertyDescriptor[i].isIndexed(), field.isMinOccursZero(), all, isAnonymous, ((ElementDesc)field).getItemQName());
                        }
                    } else {
                        this.writeField(types, propName, null, fieldType, this.propertyDescriptor[i].isIndexed(), false, all, false, null);
                    }
                } else {
                    done = false;
                    if (this.propertyDescriptor[i] instanceof FieldPropertyDescriptor && types.getTypeQName(clazz = (fpd = (FieldPropertyDescriptor)this.propertyDescriptor[i]).getField().getType()) != null) {
                        this.writeField(types, propName, null, clazz, false, false, all, false, null);
                        done = true;
                    }
                    if (!done) {
                        this.writeField(types, propName, null, this.propertyDescriptor[i].getType(), this.propertyDescriptor[i].isIndexed(), false, all, false, null);
                    }
                }
            }
            ++i;
        }
        return complexType;
    }

    protected void writeField(Types types, String fieldName, QName xmlType, Class fieldType, boolean isUnbounded, boolean isOmittable, Element where, boolean isAnonymous, QName itemQName) throws Exception {
        Element elem;
        String elementType = null;
        if (isAnonymous) {
            elem = types.createElementWithAnonymousType(fieldName, fieldType, isOmittable, where.getOwnerDocument());
        } else {
            FieldDesc field;
            QName typeQName;
            if (!SchemaUtils.isSimpleSchemaType(xmlType) && Types.isArray(fieldType)) {
                xmlType = null;
            }
            if (itemQName != null && SchemaUtils.isSimpleSchemaType(xmlType) && Types.isArray(fieldType)) {
                xmlType = null;
            }
            if ((elementType = types.getQNameString(typeQName = types.writeTypeAndSubTypeForPart(fieldType, xmlType))) == null) {
                QName anyQN = Constants.XSD_ANYTYPE;
                String prefix = types.getNamespaces().getCreatePrefix(anyQN.getNamespaceURI());
                elementType = String.valueOf(prefix) + ":" + anyQN.getLocalPart();
            }
            boolean isNillable = Types.isNullable(fieldType);
            if (this.typeDesc != null && (field = this.typeDesc.getFieldByName(fieldName)) != null && field.isElement()) {
                isNillable = ((ElementDesc)field).isNillable();
            }
            elem = types.createElement(fieldName, elementType, isNillable, isOmittable, where.getOwnerDocument());
        }
        if (isUnbounded) {
            elem.setAttribute("maxOccurs", "unbounded");
        }
        where.appendChild(elem);
    }

    protected void writeAttribute(Types types, String fieldName, Class fieldType, QName fieldXmlType, Element where) throws Exception {
        if (!types.isAcceptableAsAttribute(fieldType)) {
            throw new AxisFault(Messages.getMessage("AttrNotSimpleType00", fieldName, fieldType.getName()));
        }
        Element elem = types.createAttributeElement(fieldName, fieldType, fieldXmlType, false, where.getOwnerDocument());
        where.appendChild(elem);
    }

    protected Attributes getObjectAttributes(Object value, Attributes attributes, SerializationContext context) {
        if (this.typeDesc == null || !this.typeDesc.hasAttributes()) {
            return attributes;
        }
        AttributesImpl attrs = attributes == null ? new AttributesImpl() : (attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes));
        try {
            int i = 0;
            while (i < this.propertyDescriptor.length) {
                FieldDesc field;
                String propName = this.propertyDescriptor[i].getName();
                if (!propName.equals("class") && (field = this.typeDesc.getFieldByName(propName)) != null && !field.isElement()) {
                    QName qname = field.getXmlName();
                    if (qname == null) {
                        qname = new QName("", propName);
                    }
                    if (this.propertyDescriptor[i].isReadable() && !this.propertyDescriptor[i].isIndexed()) {
                        Object propValue = this.propertyDescriptor[i].get(value);
                        if (qname.equals(MUST_UNDERSTAND_QNAME)) {
                            if (propValue.equals(Boolean.TRUE)) {
                                propValue = "1";
                            } else if (propValue.equals(Boolean.FALSE)) {
                                propValue = "0";
                            }
                        }
                        if (propValue != null) {
                            this.setAttributeProperty(propValue, qname, field.getXmlType(), attrs, context);
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            return attrs;
        }
        return attrs;
    }

    private void setAttributeProperty(Object propValue, QName qname, QName xmlType, AttributesImpl attrs, SerializationContext context) throws Exception {
        String localName;
        String namespace = qname.getNamespaceURI();
        if (attrs.getIndex(namespace, localName = qname.getLocalPart()) != -1) {
            return;
        }
        String propString = context.getValueAsString(propValue, xmlType);
        attrs.addAttribute(namespace, localName, context.attributeQName2String(qname), "CDATA", propString);
    }
}

