/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.cdo.CommonDataObject;
import com.kingdee.bos.cdo.ICommonDataObject;
import com.kingdee.bos.cdo.utils.CDOUtils;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AccountStandardAssignOrgCollection;
import com.kingdee.eas.cp.bc.AccountStandardAssignOrgFactory;
import com.kingdee.eas.cp.bc.AccountStandardAssignOrgInfo;
import com.kingdee.eas.cp.bc.AccountStandardAssignPersonCollection;
import com.kingdee.eas.cp.bc.AccountStandardAssignPersonFactory;
import com.kingdee.eas.cp.bc.AccountStandardAssignPersonInfo;
import com.kingdee.eas.cp.bc.AccountStandardCollection;
import com.kingdee.eas.cp.bc.AccountStandardFactory;
import com.kingdee.eas.cp.bc.AccountStandardInfo;
import com.kingdee.eas.cp.bc.ControlMethod;
import com.kingdee.eas.cp.bc.EnableStateEnum;
import com.kingdee.eas.cp.bc.ExpenseTypeEntryCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeEntryFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeEntryInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.IAccountStandard;
import com.kingdee.eas.cp.bc.IAccountStandardAssignPerson;
import com.kingdee.eas.cp.bc.StaffLevelAttriEnum;
import com.kingdee.eas.cp.bc.StandardException;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.app.control.AccountControl;
import com.kingdee.eas.cp.bc.app.control.ControlFactory;
import com.kingdee.eas.cp.bc.app.control.util.ControlUtil;
import com.kingdee.eas.cp.bc.services.IAccountStandardService;
import com.kingdee.eas.cp.bc.services.util.CommonDataUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.cp.bc.services.IAccountStandardService"})
@Description(value="")
public class AccountStandardService
extends BusinessServices
implements IAccountStandardService {
    Map standardMap = null;
    String standardId = null;
    String standardName = null;
    String standardExpenseType = null;
    String standardCurrency = null;
    String standardReimburseLevel = null;
    List errorList = null;
    Map infoMap = null;
    List orgList = null;
    String deleteAccountIds = null;
    boolean hasAdd = false;

    public AccountStandardService(Context context) {
        super(context);
    }

    @Override
    public boolean save(String model, List personIds) throws BOSException, EASBizException {
        if (model == null) {
            return false;
        }
        AccountStandardInfo info = (AccountStandardInfo)JSONUtils.convertJsonToObject((Context)this.getContext(), (String)model, AccountStandardInfo.class);
        if (info.getExpenseType() == null || info.getReimburseLV() == null || info.getCurrencyType() == null || info.getCompany() == null) {
            return false;
        }
        this.checkInfo(info, personIds);
        AccountStandardFactory.getLocalInstance((Context)this.getContext()).save((CoreBaseInfo)info);
        AccountStandardAssignPersonFactory.getLocalInstance((Context)this.getContext()).delete("where accountStandard.id = '" + info.getId().toString() + "'");
        if (personIds != null && personIds.size() > 0) {
            CoreBaseCollection con = new CoreBaseCollection();
            Iterator it = personIds.iterator();
            while (it.hasNext()) {
                String personId = it.next().toString();
                PersonInfo person = new PersonInfo();
                person.setId(BOSUuid.read((String)personId));
                AccountStandardAssignPersonInfo assignInfo = new AccountStandardAssignPersonInfo();
                assignInfo.setPerson(person);
                assignInfo.setAccountStandard(info);
                con.add((CoreBaseInfo)assignInfo);
            }
            AccountStandardAssignPersonFactory.getLocalInstance((Context)this.getContext()).saveBatchData(con);
        }
        return true;
    }

    private void checkInfo(AccountStandardInfo info, List personIds) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getContext().get((Object)"CompanyInfo");
        String expenseTypeId = info.getExpenseType().getId().toString();
        String currencyId = info.getCurrencyType().getId().toString();
        String lvId = info.getReimburseLV().getId().toString();
        String infoId = info.getId().toString();
        AccountStandardCollection con = AccountStandardFactory.getLocalInstance((Context)this.getContext()).getAccountStandardCollection("select id where expenseType.id = '" + expenseTypeId + "' and currencyType.id = '" + currencyId + "' and reimburseLV = '" + lvId + "' and company.id = '" + company.getId().toString() + "' and state = 1 and id <> '" + infoId + "'");
        if (con.size() > 0) {
            throw new StandardException(StandardException.ACCOUNTSTANDARD_REPEAT);
        }
        if (personIds != null && personIds.size() > 0) {
            StringBuffer string = new StringBuffer();
            StringBuffer oql = new StringBuffer();
            Iterator it = personIds.iterator();
            while (it.hasNext()) {
                String id = it.next().toString();
                string.append("'").append(id).append("',");
            }
            string.deleteCharAt(string.length() - 1);
            oql.append("select id,person.number,person.name,accountStandard.number where ").append("person.id in (").append(string.toString()).append(") and ").append("accountStandard.expenseType.id = '").append(expenseTypeId).append("' and ").append("accountStandard.currencyType.id = '").append(currencyId).append("' and ").append("accountStandard.state = 1 and accountStandard.id <> '").append(infoId).append("'");
            AccountStandardAssignPersonCollection result = AccountStandardAssignPersonFactory.getLocalInstance((Context)this.getContext()).getAccountStandardAssignPersonCollection(oql.toString());
            if (result.size() > 0) {
                AccountStandardAssignPersonInfo assignInfo = result.get(0);
                String personNumber = assignInfo.getPerson().getNumber();
                String personName = assignInfo.getPerson().getName();
                String person = personName + "(" + personNumber + ")";
                throw new StandardException(StandardException.ACCOUNTSTANDARD_PERSON_REPEAT, new Object[]{person, assignInfo.getAccountStandard().getNumber()});
            }
        }
    }

    @Override
    public List<Map<String, Object>> enable(List<Map<String, Object>> accountStandards, boolean enable) throws BOSException, EASBizException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        if (accountStandards == null || accountStandards.size() == 0) {
            return resultList;
        }
        StringBuffer queryExistSb = new StringBuffer();
        String querySql = "SELECT FID WHERE ";
        String whereSql = "EXPENSETYPE.ID = '%s' AND CURRENCYTYPE.ID = '%s' AND REIMBURSELV.ID = '%s' AND STATE = 1 AND ID != '%s'";
        IAccountStandard accountStInstance = AccountStandardFactory.getLocalInstance((Context)this.getContext());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("state"));
        for (Map<String, Object> accountStandard : accountStandards) {
            String accountStId = accountStandard.get("id").toString();
            AccountStandardInfo accountStInfo = new AccountStandardInfo();
            accountStInfo.setId(BOSUuid.read((String)accountStId));
            if (!enable) {
                accountStInfo.setState(EnableStateEnum.DISABLE);
                accountStInstance.updatePartial(accountStInfo, selector);
                continue;
            }
            queryExistSb = new StringBuffer();
            queryExistSb.append(querySql);
            queryExistSb.append(String.format(whereSql, accountStandard.get("expenseType.id"), accountStandard.get("currencyType.id"), accountStandard.get("reimburseLV.id"), accountStId));
            CoreBaseCollection existCollection = accountStInstance.getCollection(queryExistSb.toString());
            if (existCollection.size() != 0) {
                HashMap<String, String> failAccountSt = new HashMap<String, String>();
                failAccountSt.put("id", accountStId);
                failAccountSt.put("name", accountStandard.get("name").toString());
                resultList.add(failAccountSt);
                continue;
            }
            accountStInfo.setState(EnableStateEnum.ENABLE);
            accountStInstance.updatePartial(accountStInfo, selector);
        }
        return resultList;
    }

    @Override
    public List getAssignPersons(String id) throws BOSException, EASBizException {
        ArrayList<CommonDataObject> result = new ArrayList<CommonDataObject>();
        if (id == null || id.length() < 0) {
            return result;
        }
        AccountStandardAssignPersonCollection con = AccountStandardAssignPersonFactory.getLocalInstance((Context)this.getContext()).getAccountStandardAssignPersonCollection("select person.id,person.number,person.name where accountStandard.id = '" + id + "'");
        Iterator it = con.iterator();
        while (it.hasNext()) {
            AdminOrgUnitInfo adminOrg;
            CommonDataObject person = new CommonDataObject();
            AccountStandardAssignPersonInfo info = (AccountStandardAssignPersonInfo)it.next();
            person.setBosType(new PersonInfo().getBOSType().toString());
            person.put((Object)"id", (Object)info.getPerson().getId());
            person.put((Object)"number", (Object)info.getPerson().getNumber());
            person.put((Object)"name", (Object)info.getPerson().getName());
            PositionInfo position = PersonFactory.getLocalInstance((Context)this.getContext()).getPrimaryPosition(info.getPerson().getId());
            if (position != null && position.getName() != null) {
                person.put((Object)"Position.name", (Object)position.getName());
            }
            if ((adminOrg = PersonFactory.getLocalInstance((Context)this.getContext()).getPrimaryAdminOrgUnit(info.getPerson().getId())) != null && adminOrg.getName() != null) {
                person.put((Object)"AdminOrgUnit.name", (Object)adminOrg.getName());
            }
            result.add(person);
        }
        return result;
    }

    @Override
    public Map<String, Object> initAccountStandardView(String accountStandardId) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)accountStandardId)) {
            return resultMap;
        }
        FilterInfo queryFilter = new FilterInfo();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        queryFilter.getFilterItems().add(new FilterItemInfo("accountStandard.id", (Object)accountStandardId));
        entityViewInfo.setFilter(queryFilter);
        HashSet<String> assignPersonIds = new HashSet<String>();
        AccountStandardAssignPersonCollection assignPersonCollection = AccountStandardAssignPersonFactory.getLocalInstance((Context)this.getContext()).getAccountStandardAssignPersonCollection(entityViewInfo);
        int is = assignPersonCollection.size();
        for (int i = 0; i < is; ++i) {
            assignPersonIds.add(assignPersonCollection.get(i).getPerson().getId().toString());
        }
        resultMap.put("assignPersonIds", assignPersonIds);
        HashSet<String> assignOrgIds = new HashSet<String>();
        AccountStandardAssignOrgCollection assignOrgCon = AccountStandardAssignOrgFactory.getLocalInstance((Context)this.getContext()).getAccountStandardAssignOrgCollection(entityViewInfo);
        int is2 = assignOrgCon.size();
        for (int i = 0; i < is2; ++i) {
            assignOrgIds.add(assignOrgCon.get(i).getCompany().getId().toString());
        }
        resultMap.put("assignOrgIds", assignOrgIds);
        resultMap.put("orgFilterIds", CommonDataUtils.getEqAndChildCompanyOrg(this.getContext()));
        resultMap.put("personFilterIds", CommonDataUtils.getEqAndChildPerson(this.getContext()));
        return resultMap;
    }

    @Override
    public List assignOrg(List<Map> accountStandard, List<Map> org) throws BOSException, EASBizException {
        return this.assignCommonUtil(accountStandard, org, CommonDataUtils.companyType, (IDataBase)AccountStandardAssignOrgFactory.getLocalInstance((Context)this.getContext()));
    }

    @Override
    public List assignPerson(Map accountStandard, List<Map> person) throws BOSException, EASBizException {
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(accountStandard);
        return this.assignCommonUtil(list, person, CommonDataUtils.peronType, (IDataBase)AccountStandardAssignPersonFactory.getLocalInstance((Context)this.getContext()));
    }

    public List assignCommonUtil(List<Map> accountStandard, List<Map> linkInfos, String linkType, IDataBase iservice) throws BOSException, EASBizException {
        CoreBaseCollection assignOrgCon = new CoreBaseCollection();
        Object info = null;
        AccountStandardInfo accountInfo = null;
        this.errorList = new ArrayList();
        this.deleteAccountIds = "";
        int is = accountStandard.size();
        for (int i = 0; i < is; ++i) {
            this.hasAdd = false;
            this.standardMap = accountStandard.get(i);
            this.standardId = this.standardMap.get("standardId").toString();
            this.standardName = this.standardMap.get("standardName").toString();
            this.standardExpenseType = this.standardMap.get("standardExpenseType").toString();
            this.standardCurrency = this.standardMap.get("standardCurrency").toString();
            this.standardReimburseLevel = this.standardMap.get("standardReimburseLevel").toString();
            FilterInfo queryFilter = new FilterInfo();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            queryFilter.getFilterItems().add(new FilterItemInfo("" + linkType + ".id", (Object)CommonDataUtils.getIds(linkInfos), CompareType.INCLUDE));
            queryFilter.getFilterItems().add(new FilterItemInfo("accountStandard.currencyType.id", (Object)this.standardCurrency, CompareType.EQUALS));
            queryFilter.getFilterItems().add(new FilterItemInfo("accountStandard.expenseType.id", (Object)this.standardExpenseType, CompareType.EQUALS));
            queryFilter.getFilterItems().add(new FilterItemInfo("accountStandard.reimburseLV.id", (Object)this.standardReimburseLevel, CompareType.EQUALS));
            queryFilter.getFilterItems().add(new FilterItemInfo("accountStandard.id", (Object)this.standardId, CompareType.NOTEQUALS));
            entityViewInfo.setSelector(CommonDataUtils.getAccountSelector(linkType));
            entityViewInfo.setFilter(queryFilter);
            CoreBaseCollection orgcon = iservice.getCollection(entityViewInfo);
            Set set = CommonDataUtils.convertSet((AbstractObjectCollection)orgcon);
            int js = linkInfos.size();
            for (int j = 0; j < js; ++j) {
                this.infoMap = new HashMap();
                this.infoMap.put("standardName", this.standardName);
                this.orgList = new ArrayList();
                if (set.contains(linkInfos.get(j).get("id").toString())) {
                    this.infoMap.put("standardName", this.standardName);
                    this.orgList.add(linkInfos.get(j).get("name"));
                } else {
                    this.hasAdd = true;
                    accountInfo = new AccountStandardInfo();
                    accountInfo.setId(BOSUuid.read((String)this.standardId));
                    assignOrgCon.add((CoreBaseInfo)this.initAssignInfo(accountInfo, linkInfos.get(j).get("id").toString(), linkType));
                }
                if (this.orgList.size() == 0) continue;
                this.infoMap.put("orgList", this.orgList);
                this.errorList.add(this.infoMap);
            }
            if (!this.hasAdd && linkInfos != null && linkInfos.size() != 0) continue;
            this.deleteAccountIds = this.deleteAccountIds + "'" + this.standardId + "',";
        }
        if (this.deleteAccountIds.length() > 0) {
            iservice.delete("where accountStandard.id in(" + this.deleteAccountIds.substring(0, this.deleteAccountIds.length() - 1) + ")");
        }
        if (assignOrgCon.size() != 0) {
            iservice.addnewBatchData(assignOrgCon);
        }
        return this.errorList;
    }

    public DataBaseInfo initAssignInfo(AccountStandardInfo standardInfo, String linkInfoId, String linkType) {
        if (linkType.equals("company")) {
            AccountStandardAssignOrgInfo info = new AccountStandardAssignOrgInfo();
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)linkInfoId));
            info.setAccountStandard(standardInfo);
            info.setCompany(company);
            return info;
        }
        AccountStandardAssignPersonInfo info = new AccountStandardAssignPersonInfo();
        PersonInfo personinfo = new PersonInfo();
        personinfo.setId(BOSUuid.read((String)linkInfoId));
        info.setAccountStandard(standardInfo);
        info.setPerson(personinfo);
        return info;
    }

    @Override
    public void cancelAccountStandardAssign(String type, String accountStandardId, String assignId) throws BOSException, EASBizException {
        IAccountStandardAssignPerson iservice = null;
        String linkType = null;
        if (type.equals("person")) {
            linkType = "person";
            iservice = AccountStandardAssignPersonFactory.getLocalInstance((Context)this.getContext());
        } else {
            linkType = "company";
            iservice = AccountStandardAssignOrgFactory.getLocalInstance((Context)this.getContext());
        }
        iservice.delete("where " + linkType + ".id='" + assignId + "' and accountStandard.id='" + accountStandardId + "'");
    }

    @Override
    public Map<String, Object> initAccountStandardAssign(List<String> accountStandardIds) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("orgFilterIds", CommonDataUtils.getEqAndChildCompanyOrg(this.getContext()));
        StringBuffer oqlBuffer = new StringBuffer();
        for (String id : accountStandardIds) {
            oqlBuffer.append("'").append(id).append("',");
        }
        oqlBuffer.deleteCharAt(oqlBuffer.lastIndexOf(","));
        String oql = "select company.id, company.name where accountStandard.id in (" + oqlBuffer.toString() + ")";
        AccountStandardAssignOrgCollection accountStandardAssignOrgCollection = AccountStandardAssignOrgFactory.getLocalInstance((Context)this.getContext()).getAccountStandardAssignOrgCollection(oql);
        ArrayList assignOrgs = new ArrayList();
        int is = accountStandardAssignOrgCollection.size();
        for (int i = 0; i < is; ++i) {
            HashMap<String, String> org = new HashMap<String, String>();
            AccountStandardAssignOrgInfo accountStandardAssignOrgInfo = accountStandardAssignOrgCollection.get(i);
            org.put("id", accountStandardAssignOrgInfo.getCompany().getId().toString());
            org.put("name", accountStandardAssignOrgInfo.getCompany().getName());
            assignOrgs.add(org);
        }
        resultMap.put("assignOrgs", assignOrgs);
        return resultMap;
    }

    @Override
    public List<Map> fetchAccountStandard(CommonDataObject commonDataObject) throws BOSException, EASBizException {
        IObjectValue billInfo = CDOUtils.convertCDOToObjectInfo((Context)this.getContext(), (ICommonDataObject)commonDataObject);
        HashMap<String, IObjectValue> paramMap = new HashMap<String, IObjectValue>();
        paramMap.put("billinfo", billInfo);
        AccountControl accountControl = (AccountControl)ControlFactory.createAccountControl();
        List checkMap = accountControl.check(this.getContext(), StaffLevelAttriEnum.USERDEFINED, paramMap);
        return checkMap;
    }

    @Override
    public Map<String, Object> initAccountLimitQueryData(String userID) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Date date = new Date();
        String adminIds = CommonDataUtils.getSpecialData(this.getContext(), userID);
        if (adminIds != null && adminIds.length() > 0) {
            result.put("adminIds", adminIds);
        }
        List listData = this.getAccountLimitQueryDataByUserId(userID, new SimpleDateFormat("yyyy-MM-dd").format(date));
        result.put("listData", listData);
        return result;
    }

    @Override
    public List getAccountLimitQueryDataByAdminIds(String adminIds, String date) throws BOSException, EASBizException {
        ArrayList<Map> result = new ArrayList<Map>();
        try {
            Map persons = CommonDataUtils.getPersonIdsByAdminIds(this.getContext(), adminIds);
            ArrayList<String> personIds = new ArrayList<String>();
            Set keySet = persons.keySet();
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                personIds.add(it.next().toString());
            }
            Map adminMap = ControlUtil.getAdminOrgUnitsByPersons((Context)this.getContext(), personIds);
            Map stdMap = ControlUtil.getAccountStandards((Context)this.getContext(), personIds, (Date)this.getDateByString(date));
            if (stdMap != null && adminMap != null) {
                Set entrySet = stdMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    Map data = this.bulidQueryListData((Map)entry.getValue(), adminMap, this.getDateByString(date));
                    result.add(data);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private Map bulidQueryListData(Map map, Map adminMap, Date date) throws EASBizException, BOSException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String personId = (String)map.get("personId");
        data.put("personID", personId);
        data.put("personName", (String)map.get("personName"));
        data.put("reimburseLevelID", (String)map.get("levelId"));
        data.put("reimburseLevelName", (String)map.get("levelName"));
        data.put("expenseTypeID", (String)map.get("expenseTypeId"));
        data.put("expenseType", (String)map.get("expenseTypeName"));
        data.put("currencyID", (String)map.get("currencyId"));
        data.put("currencyName", (String)map.get("currencyName"));
        BigDecimal monthLimit = (BigDecimal)map.get("monthLimit");
        data.put("monthLimit", monthLimit);
        Date effectiveDate = (Date)map.get("effectiveDate");
        data.put("effectiveDate", effectiveDate);
        int controMethodVal = (Integer)map.get("controlMethod");
        data.put("controlMethod", ControlMethod.getEnum((int)controMethodVal).toString());
        data.put("controlVal", controMethodVal);
        Map monthData = ControlUtil.getEffectiveMonth((Context)this.getContext(), (Date)effectiveDate, (Date)date, (ControlMethod)ControlMethod.getEnum((int)controMethodVal));
        BigDecimal limit = monthLimit.multiply(new BigDecimal(monthData.get("month").toString()));
        if (ControlMethod.getEnum((int)controMethodVal).equals((Object)ControlMethod.quarter)) {
            data.put("quarterLimit", limit);
        }
        if (ControlMethod.getEnum((int)controMethodVal).equals((Object)ControlMethod.total)) {
            data.put("yearLimit", limit);
        }
        BigDecimal totalUsedAmount = ControlUtil.countAccountEntryUsedAmount((Context)this.getContext(), (String)personId, (Date)((Date)monthData.get("beginDate")), (Date)((Date)monthData.get("endDate")), (String)((String)map.get("expenseTypeId")), (String)((String)map.get("currencyId")));
        BigDecimal totalUsingAmount = ControlUtil.countAccountEntryUsingAmount((Context)this.getContext(), (String)personId, (Date)((Date)monthData.get("beginDate")), (Date)((Date)monthData.get("endDate")), (String)((String)map.get("expenseTypeId")), (String)((String)map.get("currencyId")));
        BigDecimal totalAmount = totalUsedAmount.add(totalUsingAmount);
        data.put("amountUsed", totalUsedAmount);
        data.put("amountUsing", totalUsingAmount);
        data.put("amountUsable", limit.compareTo(totalAmount) > 0 ? limit.subtract(totalAmount) : new BigDecimal("0.00"));
        data.put("adminOrgUnitName", ((AdminOrgUnitInfo)adminMap.get(personId)).getName());
        return data;
    }

    @Override
    public List getAccountLimitQueryDataByUserId(String userID, String date) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("person.id"));
        selector.add(new SelectorItemInfo("person.name"));
        UserInfo userInfo = UserFactory.getLocalInstance((Context)this.getContext()).getUserInfo((IObjectPK)new ObjectUuidPK(userID), selector);
        String personId = userInfo.getPerson().getId().toString();
        String personName = userInfo.getPerson().getName();
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<Map> listData = new ArrayList<Map>();
        ids.add(personId);
        Map adminMap = ControlUtil.getAdminOrgUnitsByPersons((Context)this.getContext(), ids);
        Map stdMap = ControlUtil.getAccountStandards((Context)this.getContext(), ids, (Date)this.getDateByString(date));
        if (stdMap != null && adminMap != null) {
            Set entrySet = stdMap.entrySet();
            for (Map.Entry entry : entrySet) {
                Map data = this.bulidQueryListData((Map)entry.getValue(), adminMap, this.getDateByString(date));
                listData.add(data);
            }
        }
        return listData;
    }

    private Date getDateByString(String date) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return sdf.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    @Override
    public Map<String, Object> initAccountLimitBillQueryData(Map<String, Object> parameterMap) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String personID = parameterMap.get("personID").toString();
        String expenseTypeID = parameterMap.get("expenseTypeID").toString();
        String currencyID = parameterMap.get("currencyID").toString();
        String dateStr = parameterMap.get("date").toString();
        String effiDateStr = parameterMap.get("effectiveDate").toString();
        String methodVal = parameterMap.get("methodVal").toString();
        Date date = this.getDateByString(dateStr);
        Date effectiveDate = this.getDateByString(effiDateStr);
        ControlMethod method = ControlMethod.getEnum((int)Integer.valueOf(methodVal));
        Map dateMap = ControlUtil.getEffectiveMonth((Context)this.getContext(), (Date)effectiveDate, (Date)date, (ControlMethod)method);
        Date beginDate = (Date)dateMap.get("beginDate");
        Date endDate = (Date)dateMap.get("endDate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList list = new ArrayList();
        StringBuffer sql = new StringBuffer();
        sql.append(" select AA.id id, AA.applierid applierid, AA.bizreqdate bizreqdate, AA.number number, AA.cause cause,       ");
        sql.append(" AA.amount amount, AA.amountapproved amountapproved, AA.amountencashed amountencashed,                      ");
        sql.append(" AA.state state, AA.expensetypeid expensetypeid, AA.currencyid currencyid, AA.checkamount checkamount,      ");
        sql.append(" BB.FACTDEFNAME actdefname, BB.FPERSONEMPNAME personempname                                                 ");
        sql.append(" from                                                                                                       ");
        sql.append(" (select                                         \t\t\t\t\t\t\t\t\t\t\t\t\t\t    ");
        sql.append(" A.fid id, A.fapplierid applierid, A.fbizreqdate bizreqdate, A.fnumber number, A.fcause cause,              ");
        sql.append(" A.famount amount, A.famountapproved amountapproved, A.famountencashed amountencashed,                      ");
        sql.append(" A.fstate state, B.fexpensetypeid expensetypeid, B.fcurrencyid currencyid, sum(C.fcheckamount) checkamount  ");
        sql.append(" from                                                                                                       ");
        sql.append(" t_bc_bizaccountbill as A                                                                                   ");
        sql.append(" left join T_BC_BizAccountBillEntry B on A.fid = B.fbillid                                                  ");
        sql.append(" left join T_BC_BizABRCE as C on A.fid = C.fparentid                                                        ");
        sql.append(" where A.fapplierid = ? and B.fexpensetypeid = ? and B.fcurrencyid = ?                                      ");
        sql.append(" and B.fhappentime between '" + sdf.format(beginDate) + "' and '" + sdf.format(endDate) + "'                  ");
        sql.append(" and A.FState not in (20,27,40)                   \t\t\t\t\t\t\t\t\t\t\t\t\t\t    ");
        sql.append(" group by A.fid, A.fapplierid, A.fbizreqdate, A.fnumber, A.fcause, A.famount,                               ");
        sql.append(" A.famountapproved, A.famountencashed, A.fstate, B.fexpensetypeid, B.fcurrencyid) as AA                     ");
        sql.append(" left join                                                                                                  ");
        sql.append(" (SELECT distinct                                                                                           ");
        sql.append(" ASSIGN.FACTDEFNAME_L2 FACTDEFNAME, ASSIGN.FPERSONEMPNAME_L2 FPERSONEMPNAME, ASSIGN.FBIZOBJID FBIZOBJID     ");
        sql.append(" FROM T_WFR_ProcInst AS PROCINST                                                                            ");
        sql.append(" INNER JOIN T_WFR_Assign AS ASSIGN ON ASSIGN.FPROCINSTID=PROCINST.FPROCINSTID                               ");
        sql.append(" WHERE (PROCINST.FPROCDEFTYPE = 'NORMAL' OR PROCINST.FPROCDEFTYPE = 'MICRO')                                ");
        sql.append(" AND PROCINST.FSTATE LIKE 'open%'                                                                           ");
        sql.append(" AND ASSIGN.FBIZPACKAGE='com.kingdee.eas.base.multiapprove.client' ) BB                                     ");
        sql.append(" on AA.id = BB.FBIZOBJID                                                                                    ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString(), (Object[])new Object[]{personID, expenseTypeID, currencyID});
            while (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String[] str = new String[]{"id", "applierid", "bizreqdate", "number", "cause", "amount", "amountapproved", "amountencashed", "state", "expensetypeid", "currencyid", "checkamount", "actdefname", "personempname"};
                int n = str.length;
                for (int i = 0; i < n - 2; ++i) {
                    map.put(str[i], rowSet.getObject(str[i]));
                    if (!str[i].equals("state")) continue;
                    int state = (Integer)rowSet.getObject("state");
                    map.put("statename", StateEnum.getEnum((int)state).getAlias(JComponent.getDefaultLocale()));
                }
                String actdefname = (String)rowSet.getObject("actdefname");
                String personempname = (String)rowSet.getObject("personempname");
                map.put("note", (actdefname == null ? "" : actdefname + " : ") + personempname == null ? "" : personempname);
                list.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        result.put("listData", list);
        return result;
    }

    @Override
    public Map<String, String> getFilterInfoData() throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getContext().get((Object)"CompanyInfo");
        String ln = company.getLongNumber();
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        String[] lnSecs = ln.split("!");
        int size = lnSecs.length;
        HashSet<String> lnUps = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            lnUps.add(lnSecs[i]);
        }
        if (lnUps.size() != 0) {
            fic.add(new FilterItemInfo("company.number", lnUps, CompareType.INCLUDE));
            fi.setMaskString("#0 or #1");
        }
        FilterInfo tempFilter = new FilterInfo();
        tempFilter.getFilterItems().add(new FilterItemInfo("operationType.isEnable", null, CompareType.IS));
        tempFilter.getFilterItems().add(new FilterItemInfo("operationType.isEnable", (Object)Boolean.TRUE, CompareType.EQUALS));
        tempFilter.setMaskString("#0 or #1");
        fi.mergeFilter(tempFilter, "and");
        FilterInfo tempFilter1 = new FilterInfo();
        tempFilter1.getFilterItems().add(new FilterItemInfo("controlType", (Object)0, CompareType.NOTEQUALS));
        fi.mergeFilter(tempFilter1, "and");
        result.put("expenseTypeFilter", fi.toString());
        List<String> personIds = CommonDataUtils.getEqAndChildPerson(this.getContext());
        fi = new FilterInfo();
        HashSet<String> set = new HashSet<String>();
        set.addAll(personIds);
        fi.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", set, CompareType.INCLUDE));
        result.put("personFilter", fi.toString());
        return result;
    }

    @Override
    public List<Map<String, Object>> getGroupFilter() throws EASBizException, BOSException, SQLException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getContext().get((Object)"CompanyInfo");
        HashMap<String, Object> expenseTypeGroup = new HashMap<String, Object>();
        expenseTypeGroup.put("field", "expenseType");
        expenseTypeGroup.put("dataType", "ObjectValue");
        expenseTypeGroup.put("title", "\u8d39\u7528\u7c7b\u578b");
        expenseTypeGroup.put("mitiSelect", "false");
        expenseTypeGroup.put("displayCount", 8);
        expenseTypeGroup.put("unlimited", true);
        String longNumber = company.getLongNumber();
        String[] numbers = longNumber.split("!");
        HashSet<String> companyNumbers = new HashSet<String>();
        int is = numbers.length;
        for (int i = 0; i < is; ++i) {
            companyNumbers.add(numbers[i]);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("expenseType.operationType.isEnable", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isFilterControl", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("expenseType.company.number", companyNumbers, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("expenseType.controlType", (Object)0, CompareType.NOTEQUALS));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("expenseType.id"));
        selector.add(new SelectorItemInfo("expenseType.name"));
        entityViewInfo.setSelector(selector);
        ExpenseTypeEntryCollection expenseTypeEntryCollection = ExpenseTypeEntryFactory.getLocalInstance((Context)this.getContext()).getExpenseTypeEntryCollection(entityViewInfo);
        ArrayList<String> expenseTypeIds = new ArrayList<String>();
        ArrayList filterItems = new ArrayList();
        int js = expenseTypeEntryCollection.size();
        for (int j = 0; j < js; ++j) {
            ExpenseTypeEntryInfo expenseTypeEntryInfo = expenseTypeEntryCollection.get(j);
            ExpenseTypeInfo expenseTypeInfo = expenseTypeEntryInfo.getExpenseType();
            String expenseTypeId = expenseTypeInfo.getId().toString();
            if (expenseTypeIds.contains(expenseTypeId)) continue;
            expenseTypeIds.add(expenseTypeId);
            HashMap<String, Object> filterMap = new HashMap<String, Object>();
            filterMap.put("alias", expenseTypeInfo.getName());
            filterMap.put("value", expenseTypeId);
            filterMap.put("isDefault", false);
            filterItems.add(filterMap);
        }
        expenseTypeGroup.put("filterItems", filterItems);
        resultList.add(expenseTypeGroup);
        return resultList;
    }

    @Override
    public boolean delete(List ids) throws BOSException, EASBizException {
        if (ids != null && ids.size() > 0) {
            ObjectUuidPK[] pks = new ObjectUuidPK[ids.size()];
            StringBuffer s = new StringBuffer();
            for (int i = 0; i < pks.length; ++i) {
                pks[i] = new ObjectUuidPK(ids.get(i).toString());
                s.append("'").append(ids.get(i).toString()).append("',");
            }
            s.deleteCharAt(s.length() - 1);
            AccountStandardFactory.getLocalInstance((Context)this.getContext()).deleteBatchData((IObjectPK[])pks);
        }
        return true;
    }
}

