/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.Domain;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.cdo.CommonDataObject;
import com.kingdee.bos.cdo.utils.CDOUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AmountControlTypeEnum;
import com.kingdee.eas.cp.bc.BgCtrlBizCollHandler;
import com.kingdee.eas.cp.bc.BizAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountBillFactory;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.CreditControlSTDInfo;
import com.kingdee.eas.cp.bc.CreditControlType;
import com.kingdee.eas.cp.bc.DailyLoanBillEntryInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.EntryStateEnum;
import com.kingdee.eas.cp.bc.EvectionLoanBillFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionReqBillEntryInfo;
import com.kingdee.eas.cp.bc.EvectionReqBillFactory;
import com.kingdee.eas.cp.bc.EvectionReqBillInfo;
import com.kingdee.eas.cp.bc.ExpenseAccountFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.IExpenseAccountFacade;
import com.kingdee.eas.cp.bc.LoanBillInfo;
import com.kingdee.eas.cp.bc.OtherExpenseBillEntryInfo;
import com.kingdee.eas.cp.bc.OtherExpenseBillFactory;
import com.kingdee.eas.cp.bc.OtherExpenseBillInfo;
import com.kingdee.eas.cp.bc.PriorEnum;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TravelAccountBillFactory;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.cp.bc.app.creditcontrol.util.CreditControlUtil;
import com.kingdee.eas.cp.bc.services.IBizCollBillService;
import com.kingdee.eas.cp.bc.services.util.CommonDataUtils;
import com.kingdee.eas.cp.bc.services.util.ModelUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BudgetCtrlCaller;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Component(value={"com.kingdee.eas.cp.bc.services.IBizCollBillService"})
@Description(value="")
public class BizCollBillService
extends BusinessServices
implements IBizCollBillService {
    public BizCollBillService(Context context) {
        super(context);
    }

    public IObjectValue buildModel(IObjectValue object) throws BOSException, EASBizException {
        OtherExpenseBillEntryInfo entry;
        UserInfo user = (UserInfo)this.getContext().get((Object)"UserInfo");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getContext().get((Object)"CompanyInfo");
        BizCollBillBaseInfo baseInfo = CommonUtilFacadeFactory.getLocalInstance((Context)this.getContext()).forLoanBillCreateNewData();
        BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)object;
        Date date = DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis()));
        billInfo.setApplier(baseInfo.getApplier());
        billInfo.setBiller(user);
        billInfo.setOrgUnit(baseInfo.getOrgUnit());
        billInfo.setApplierCompany(baseInfo.getApplierCompany());
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)ModelUtils.simpleClone((CoreBaseInfo)baseInfo.getCompany());
        billInfo.setCompany(companyInfo);
        CostCenterOrgUnitInfo costInfo = (CostCenterOrgUnitInfo)ModelUtils.simpleClone((CoreBaseInfo)baseInfo.getCostedDept());
        billInfo.setCostedDept(costInfo);
        CurrencyInfo currency = (CurrencyInfo)ModelUtils.simpleClone((CoreBaseInfo)baseInfo.getCurrencyType());
        billInfo.setCurrencyType(currency);
        billInfo.setName("CPBCBILL");
        billInfo.setPosition(baseInfo.getPosition());
        billInfo.setBizReqDate(date);
        billInfo.setBillDate(date);
        billInfo.setAmount(new BigDecimal("0.00"));
        billInfo.setAmountApproved(new BigDecimal("0.00"));
        billInfo.setState(StateEnum.NEW);
        billInfo.setPrior(PriorEnum.LOW);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP001");
        paramList.add("CP002");
        paramList.add("CP010");
        paramList.add("CP011");
        paramList.add("CP019");
        paramList.add("CP025");
        paramList.add("CP017");
        paramList.add("CP027");
        paramList.add("CP028");
        Map paramObj = ExpenseCommenFacadeFactory.getLocalInstance((Context)this.getContext()).getParams(paramList);
        if (billInfo instanceof OtherExpenseBillInfo) {
            Object value = paramObj.get("CP017");
            if (Boolean.valueOf(value.toString()).booleanValue()) {
                billInfo.setAmountControlType(AmountControlTypeEnum.oneTOmore);
            } else {
                billInfo.setAmountControlType(AmountControlTypeEnum.oneTOone);
            }
        } else {
            billInfo.setAmountControlType(AmountControlTypeEnum.oneTOmore);
        }
        HashMap<String, Object> initData = new HashMap<String, Object>();
        initData.putAll(paramObj);
        Set idSet = CommonDataUtils.getApplierAdminOrgUnitIds(this.getContext());
        initData.put("adminOrgUnitIds", idSet);
        if (billInfo.get("applier") != null) {
            Map stringMap = CommonDataUtils.getApplierRelatedInfo(this.getContext(), billInfo.getApplier().getId().toString());
            initData.putAll(stringMap);
        }
        if (billInfo instanceof LoanBillInfo && Boolean.valueOf((String)paramObj.get("CP025")).booleanValue()) {
            String personId = billInfo.getApplier().getId().toString();
            CreditControlSTDInfo creditControlSTD = CreditControlUtil.getCreditControlSTDByPerson((Context)this.getContext(), (String)personId);
            if (creditControlSTD != null) {
                CreditControlType termCtrl = creditControlSTD.getTermCtrl();
                initData.put("creditControlSTDId", creditControlSTD.getId().toString());
                initData.put("termCtrlType", creditControlSTD.getTermCtrl());
                if (!termCtrl.equals((Object)CreditControlType.NOTPROMPT)) {
                    BigDecimal termCtrlVal = creditControlSTD.getTermCtrlVal();
                    int foreseeDays = termCtrlVal.intValue();
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(5, foreseeDays);
                    ((LoanBillInfo)billInfo).setForeseeDate(calendar.getTime());
                }
            }
        }
        billInfo.put("initData", initData);
        billInfo.put("autoSetApprovedAmount", (Object)true);
        billInfo.put("getBudgetByOperationType", (Object)true);
        if (billInfo instanceof OtherExpenseBillInfo) {
            ((OtherExpenseBillInfo)billInfo).setName("\u8d39\u7528\u7533\u8bf7\u5355");
            ((OtherExpenseBillInfo)billInfo).setPayMode(this.getDefaultPayMode());
            entry = new OtherExpenseBillEntryInfo();
            entry.setHappenTime(date);
            entry.setPurpose("");
            entry.setAmount(new BigDecimal("0.00"));
            entry.setAmountApproved(new BigDecimal("0.00"));
            entry.setAmountOri(new BigDecimal("0.00"));
            entry.setAmountApprovedOri(new BigDecimal("0.00"));
            entry.setCurrencyType(currency);
            entry.setExchangeRate(new BigDecimal("1.0000"));
            entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
            entry.setExchangeRatePrecision(4);
            entry.setBudgetDo(new BigDecimal("0.00"));
            ((OtherExpenseBillInfo)billInfo).getEntries().add(entry);
        } else if (billInfo instanceof DailyLoanBillInfo) {
            ((DailyLoanBillInfo)billInfo).setName("\u501f\u6b3e\u5355");
            ((DailyLoanBillInfo)billInfo).setPayMode(this.getDefaultPayMode());
            entry = new DailyLoanBillEntryInfo();
            entry.setHappenTime(date);
            entry.setPurpose("");
            entry.setAmount(new BigDecimal("0.00"));
            entry.setAmountApproved(new BigDecimal("0.00"));
            entry.setAmountOri(new BigDecimal("0.00"));
            entry.setAmountApprovedOri(new BigDecimal("0.00"));
            entry.setCurrencyType(currency);
            entry.setExchangeRate(new BigDecimal("1.0000"));
            entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
            entry.setExchangeRatePrecision(4);
            entry.setBudgetDo(new BigDecimal("0.00"));
            ((DailyLoanBillInfo)billInfo).getEntries().add((DailyLoanBillEntryInfo)entry);
        } else if (billInfo instanceof BizAccountBillInfo) {
            ((BizAccountBillInfo)billInfo).setName("\u8d39\u7528\u62a5\u9500\u5355");
            ((BizAccountBillInfo)billInfo).setPayMode(this.getDefaultPayMode());
            entry = new BizAccountBillEntryInfo();
            entry.setHappenTime(date);
            entry.setPurpose("");
            entry.setAmount(new BigDecimal("0.00"));
            entry.setAmountApproved(new BigDecimal("0.00"));
            entry.setAmountOri(new BigDecimal("0.00"));
            entry.setAmountApprovedOri(new BigDecimal("0.00"));
            entry.setCurrencyType(currency);
            entry.setExchangeRate(new BigDecimal("1.0000"));
            entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
            entry.setExchangeRatePrecision(4);
            entry.setCompany(companyInfo);
            entry.setCostCenter(costInfo);
            entry.setPayState(EntryStateEnum.UNDONE);
            entry.setReceiveState(EntryStateEnum.UNDONE);
            entry.setBudgetDo(new BigDecimal("0.00"));
            ((BizAccountBillInfo)billInfo).getEntries().add((BizAccountBillEntryInfo)entry);
        } else if (billInfo instanceof EvectionReqBillInfo) {
            ((EvectionReqBillInfo)billInfo).setName("\u51fa\u5dee\u7533\u8bf7\u5355");
            entry = new EvectionReqBillEntryInfo();
            entry.setAmount(new BigDecimal("0.00"));
            entry.setAmountApproved(new BigDecimal("0.00"));
            entry.setAmountOri(new BigDecimal("0.00"));
            entry.setAmountApprovedOri(new BigDecimal("0.00"));
            entry.setCurrencyType(currency);
            entry.setExchangeRate(new BigDecimal("1.0000"));
            entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
            entry.setExchangeRatePrecision(4);
            entry.setBudgetDo(new BigDecimal("0.00"));
            entry.setHotelExpense(new BigDecimal("0.00"));
            entry.setBussesExpense(new BigDecimal("0.00"));
            entry.setOtherExpense(new BigDecimal("0.00"));
            entry.setTaxiExpense(new BigDecimal("0.00"));
            entry.setEventionSubsidy(new BigDecimal("0.00"));
            ((EvectionReqBillInfo)billInfo).getEntries().add((EvectionReqBillEntryInfo)entry);
        } else if (billInfo instanceof EvectionLoanBillInfo) {
            ((EvectionLoanBillInfo)billInfo).setName("\u51fa\u5dee\u501f\u6b3e\u5355");
            ((EvectionLoanBillInfo)billInfo).setPayMode(this.getDefaultPayMode());
        } else if (billInfo instanceof TravelAccountBillInfo) {
            ((TravelAccountBillInfo)billInfo).setName("\u5dee\u65c5\u8d39\u62a5\u9500\u5355");
            ((TravelAccountBillInfo)billInfo).setPayMode(this.getDefaultPayMode());
        }
        ModelUtils.reduceModel2((CoreBaseInfo)billInfo, "applier", "biller", "orgUnit", "applierCompany");
        if (!(billInfo instanceof OtherExpenseBillInfo) && !(billInfo instanceof EvectionReqBillInfo)) {
            CommonDataUtils.initDefaultPersonalBank(this.getContext(), billInfo);
        }
        return billInfo;
    }

    public CommonDataObject getDefaultPayModeCDO() {
        SettlementTypeInfo settle = null;
        CommonDataObject cdo = new CommonDataObject();
        try {
            ISettlementType iSettle = SettlementTypeFactory.getLocalInstance((Context)this.getContext());
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)true));
            viewInfo.setFilter(filter);
            SettlementTypeCollection collPay = iSettle.getSettlementTypeCollection(viewInfo);
            if (collPay != null && collPay.size() > 0) {
                settle = collPay.get(0);
                cdo = (CommonDataObject)CDOUtils.convertObjectInfoToCDO((Context)this.getContext(), (IObjectValue)settle);
            }
        }
        catch (BOSException e) {
            settle = null;
        }
        catch (EASBizException e) {
            settle = null;
            e.printStackTrace();
        }
        return cdo;
    }

    public SettlementTypeInfo getDefaultPayMode() {
        SettlementTypeInfo settle = null;
        try {
            ISettlementType iSettle = SettlementTypeFactory.getLocalInstance((Context)this.getContext());
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)true));
            viewInfo.setFilter(filter);
            SettlementTypeCollection collPay = iSettle.getSettlementTypeCollection(viewInfo);
            if (collPay != null && collPay.size() > 0) {
                settle = collPay.get(0);
            }
        }
        catch (BOSException e) {
            settle = null;
        }
        catch (EASBizException e) {
            settle = null;
            e.printStackTrace();
        }
        return settle;
    }

    public void abandon(List ids) throws BOSException, EASBizException {
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            BOSUuid uid = BOSUuid.read((String)it.next().toString());
            if (uid.getType().toString().equalsIgnoreCase("E76173AD")) {
                OtherExpenseBillFactory.getLocalInstance((Context)this.getContext()).abandon(uid);
                continue;
            }
            if (uid.getType().toString().equalsIgnoreCase("8110AAB2")) {
                DailyLoanBillFactory.getLocalInstance((Context)this.getContext()).abandon(uid);
                continue;
            }
            if (uid.getType().toString().equalsIgnoreCase("4A44F49F")) {
                BizAccountBillFactory.getLocalInstance((Context)this.getContext()).abandon(uid);
                continue;
            }
            if (uid.getType().toString().equalsIgnoreCase("DE853384")) {
                EvectionReqBillFactory.getLocalInstance((Context)this.getContext()).abandon(uid);
                continue;
            }
            if (uid.getType().toString().equalsIgnoreCase("7AE53B38")) {
                EvectionLoanBillFactory.getLocalInstance((Context)this.getContext()).abandon(uid);
                continue;
            }
            if (!uid.getType().toString().equalsIgnoreCase("C57003BC")) continue;
            TravelAccountBillFactory.getLocalInstance((Context)this.getContext()).abandon(uid);
        }
    }

    public List getCollection(String bosType, String view) throws BOSException, EASBizException, ParserException {
        ArrayList<CommonDataObject> result = new ArrayList<CommonDataObject>();
        IObjectCollection collection = DynamicObjectFactory.getLocalInstance((Context)this.getContext()).getCollection(new BOSObjectType(bosType), new EntityViewInfo(view));
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            CommonDataObject cdo = (CommonDataObject)CDOUtils.convertObjectInfoToCDO((Context)this.getContext(), (IObjectValue)((IObjectValue)it.next()));
            result.add(cdo);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close(String id) throws Exception {
        BOSUuid uid = BOSUuid.read((String)id);
        Domain cpbcDomain = Domain.getInstance((String)"cp_bc", null);
        if (uid.getType().toString().equalsIgnoreCase("E76173AD")) {
            OtherExpenseBillInfo billInfo = OtherExpenseBillFactory.getLocalInstance((Context)this.getContext()).getOtherExpenseBillInfo((IObjectPK)new ObjectUuidPK(uid));
            Boolean isPass = (Boolean)cpbcDomain.invokeService(this.getContext(), "ExpenseCommenFacadeService", "checkForBillClose", new Object[]{billInfo.getId().toString()});
            if (!StateEnum.CHECKED.equals((Object)billInfo.getState()) || !isPass.booleanValue()) throw new BOSException("The Bill Can Not Close");
            BgCtrlBizCollHandler.setBugdutDoForClose((Context)this.getContext(), (BizCollBillBaseInfo)billInfo);
            BudgetCtrlCaller.requestBudget((Context)this.getContext(), (BOSUuid)billInfo.getId());
            IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance((Context)this.getContext());
            facade.setState(uid, StateEnum.CLOSED);
            billInfo.setAmountBalance(new BigDecimal("0.00"));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("amountBalance"));
            OtherExpenseBillFactory.getLocalInstance((Context)this.getContext()).updatePartial((CoreBaseInfo)billInfo, sic);
            return;
        } else if (uid.getType().toString().equalsIgnoreCase("8110AAB2") || uid.getType().toString().equalsIgnoreCase("7AE53B38")) {
            DailyLoanBillInfo billInfo = null;
            if (uid.getType().toString().equalsIgnoreCase("8110AAB2")) {
                billInfo = DailyLoanBillFactory.getLocalInstance((Context)this.getContext()).getDailyLoanBillInfo((IObjectPK)new ObjectUuidPK(uid));
            } else if (uid.getType().toString().equalsIgnoreCase("7AE53B38")) {
                billInfo = EvectionLoanBillFactory.getLocalInstance((Context)this.getContext()).getEvectionLoanBillInfo((IObjectPK)new ObjectUuidPK(uid));
            }
            Boolean isPass = (Boolean)cpbcDomain.invokeService(this.getContext(), "ExpenseCommenFacadeService", "checkForBillClose", new Object[]{billInfo.getId().toString()});
            if (!isPass.booleanValue()) throw new BOSException("The Bill Can Not Close");
            if (billInfo.getLoanState().equals("Y") || billInfo.getState().equals((Object)StateEnum.ALREADYPAYMENT) && billInfo.getAmountBalance().doubleValue() <= 0.0) {
                DailyLoanBillInfo info = billInfo;
                BgCtrlBizCollHandler.setBugdutDoForClose((Context)this.getContext(), (BizCollBillBaseInfo)info);
                BudgetCtrlCaller.requestBudget((Context)this.getContext(), (BOSUuid)billInfo.getId());
                IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance((Context)this.getContext());
                facade.setState(uid, StateEnum.CLOSED);
                billInfo.setAmountBalance(new BigDecimal("0.00"));
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("amountBalance"));
                DailyLoanBillFactory.getLocalInstance((Context)this.getContext()).updatePartial((CoreBaseInfo)billInfo, sic);
                return;
            } else {
                if (!this.isNotRelaFiAndVoucher() || !billInfo.getState().equals((Object)StateEnum.CHECKED)) throw new BOSException("The Bill Can Not Close");
                DailyLoanBillInfo info = billInfo;
                BgCtrlBizCollHandler.setBugdutDoForClose((Context)this.getContext(), (BizCollBillBaseInfo)info);
                BudgetCtrlCaller.requestBudget((Context)this.getContext(), (BOSUuid)billInfo.getId());
                IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance((Context)this.getContext());
                facade.setState(uid, StateEnum.CLOSED);
                if (billInfo.getAmountBalance() != null && billInfo.getAmountBalance().compareTo(BizCollUtil.ZERO) > 0) {
                    billInfo.setReturnAmount(billInfo.getAmountBalance());
                } else {
                    billInfo.setReturnAmount(new BigDecimal("0.00"));
                }
                billInfo.setReturnDate(new Date());
                billInfo.setLoanState("Y");
                billInfo.setAmountBalance(new BigDecimal("0.00"));
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("loanState"));
                sic.add(new SelectorItemInfo("returnDate"));
                sic.add(new SelectorItemInfo("returnAmount"));
                sic.add(new SelectorItemInfo("amountBalance"));
                DailyLoanBillFactory.getLocalInstance((Context)this.getContext()).updatePartial((CoreBaseInfo)billInfo, sic);
            }
            return;
        } else if (uid.getType().toString().equalsIgnoreCase("DE853384")) {
            EvectionReqBillInfo billInfo = EvectionReqBillFactory.getLocalInstance((Context)this.getContext()).getEvectionReqBillInfo((IObjectPK)new ObjectUuidPK(uid));
            Boolean isPass = (Boolean)cpbcDomain.invokeService(this.getContext(), "ExpenseCommenFacadeService", "checkForBillClose", new Object[]{billInfo.getId().toString()});
            if (!isPass.booleanValue()) return;
            IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance((Context)this.getContext());
            facade.setState(uid, StateEnum.CLOSED);
            return;
        } else {
            if (!uid.getType().toString().equalsIgnoreCase("4A44F49F") && !uid.getType().toString().equalsIgnoreCase("C57003BC")) return;
            IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance((Context)this.getContext());
            facade.setState(uid, StateEnum.CLOSED);
        }
    }

    private boolean isNotRelaFiAndVoucher() throws EASBizException, BOSException {
        boolean isRelaFi = true;
        boolean isRelaCn = false;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP002");
        paramList.add("CP008");
        Map paramMap = ExpenseCommenFacadeFactory.getLocalInstance((Context)this.getContext()).getParams(paramList);
        isRelaFi = new Boolean(paramMap.get("CP002").toString());
        isRelaCn = paramMap.get("CP008") == null ? false : new Boolean(paramMap.get("CP008").toString());
        return !isRelaFi && !isRelaCn;
    }

    public Map initModelDataForViewLoad(CommonDataObject model) throws BOSException, EASBizException, SQLException {
        Boolean isPass;
        HashMap<String, Boolean> initData = new HashMap<String, Boolean>();
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP001");
        paramList.add("CP002");
        paramList.add("CP008");
        if (model.getBosType().equalsIgnoreCase("C57003BC") || model.getBosType().equalsIgnoreCase("4A44F49F")) {
            paramList.add("IsSSC");
            paramList.add("IsPaperParkIntegration");
        }
        Map paramMap = ExpenseCommenFacadeFactory.getLocalInstance((Context)this.getContext()).getParams(paramList);
        initData.putAll(paramMap);
        if (model.getBosType().equalsIgnoreCase("8110AAB2") || model.getBosType().equalsIgnoreCase("7AE53B38")) {
            isPass = CommonDataUtils.checkBillHasRePaybill(this.getContext(), model);
            initData.put("ispass", isPass);
        }
        if (model.getBosType().equalsIgnoreCase("DE853384")) {
            isPass = CommonDataUtils.checkBillHasNextBill(this.getContext(), model);
            initData.put("ispass", isPass);
        }
        if (model.getBosType().equalsIgnoreCase("8110AAB2") || model.getBosType().equalsIgnoreCase("7AE53B38") || model.getBosType().equalsIgnoreCase("E76173AD")) {
            Boolean isclose = CommonDataUtils.checkForBillClose(this.getContext(), model.get((Object)"id").toString());
            initData.put("isclose", isclose);
        }
        return initData;
    }

    public Map initModelDataForEditLoad(CommonDataObject model) throws BOSException, EASBizException {
        HashMap<String, Object> initData = new HashMap<String, Object>();
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP001");
        paramList.add("CP002");
        paramList.add("CP010");
        paramList.add("CP011");
        paramList.add("CP019");
        paramList.add("CP027");
        paramList.add("CP028");
        paramList.add("IsSSC");
        paramList.add("IsPaperParkIntegration");
        Map paramMap = ExpenseCommenFacadeFactory.getLocalInstance((Context)this.getContext()).getParams(paramList);
        initData.putAll(paramMap);
        initData.put("adminOrgUnitIds", CommonDataUtils.getApplierAdminOrgUnitIds(this.getContext()));
        if (model.get((Object)"applier") != null) {
            Map relatedInfoMap = CommonDataUtils.getApplierRelatedInfo(this.getContext(), ((CommonDataObject)model.get((Object)"applier")).get((Object)"id").toString());
            initData.putAll(relatedInfoMap);
        }
        if (model.get((Object)"company") != null) {
            initData.put("costDeptFilter", CommonDataUtils.getCostDeptFilter(this.getContext(), ((CommonDataObject)model.get((Object)"company")).get((Object)"id").toString()));
        }
        UserInfo user = (UserInfo)this.getContext().get((Object)"UserInfo");
        Set orgRangeSet = CommonDataUtils.getOrgIdsByUserAndType(this.getContext(), user.getId().toString(), String.valueOf(10), null);
        initData.put("orgRangeSet", orgRangeSet);
        return initData;
    }
}

