/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.ITransportOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitCollection;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.IBaseService;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.arap.IBaseService"})
public class BaseService
extends BusinessServices
implements IBaseService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.impl.PermissionService");

    public BaseService(Context context) {
        super(context);
    }

    @Override
    public OrgUnitInfo[] getAuthorizedBizOrgUnits(int orgType, String permissionItem) throws EASBizException, BOSException {
        OrgUnitCollection collection = this.getAuthOrgByPermItem(OrgType.getEnum((int)orgType), permissionItem);
        if (collection == null || collection.size() == 0) {
            return new OrgUnitInfo[0];
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < collection.size(); ++i) {
            keys.add(collection.get(i).getId().toString());
        }
        OrgUnitInfo[] results = this.getOrgUnitInfosByType(keys, orgType);
        return results;
    }

    protected OrgUnitCollection getAuthOrgByPermItem(OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission permission = PermissionFactory.getLocalInstance((Context)this.getContext());
        if (orgType == null) {
            return null;
        }
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        FullOrgUnitCollection result = permission.getAuthorizedOrg(this.getContext().getCaller(), orgType, (IObjectPK)treePK, permItem);
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    @Override
    public OrgUnitInfo[] getOrgUnitInfosByType(Set<String> keys, int orgTypeValue) throws BOSException, EASBizException {
        OrgType orgType = OrgType.getEnum((int)orgTypeValue);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        if (!orgType.equals((Object)OrgType.Admin)) {
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
        }
        SorterItemCollection sortCol = new SorterItemCollection();
        sortCol.add(new SorterItemInfo("number"));
        view.setSorter(sortCol);
        view.setFilter(filter);
        view.setSelector(this.getOrgInfoSelector(orgType));
        Context ctx = this.getContext();
        OrgUnitInfo[] results = null;
        try {
            switch (orgType.getValue()) {
                case 0: {
                    IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                    AdminOrgUnitCollection collection = iAdmin.getAdminOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
                case 1: {
                    ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                    view.getSelector().add(new SelectorItemInfo("baseCurrency.precision"));
                    CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
                case 2: {
                    ISaleOrgUnit iSale = SaleOrgUnitFactory.getLocalInstance((Context)ctx);
                    SaleOrgUnitCollection collection = iSale.getSaleOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
                case 3: {
                    IPurchaseOrgUnit iPurchase = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
                    PurchaseOrgUnitCollection collection = iPurchase.getPurchaseOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
                case 4: {
                    IStorageOrgUnit iStorage = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
                    StorageOrgUnitCollection collection = iStorage.getStorageOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
                case 24: {
                    ITransportOrgUnit iTransport = TransportOrgUnitFactory.getLocalInstance((Context)ctx);
                    TransportOrgUnitCollection collection = iTransport.getTransportOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return results;
    }

    public SelectorItemCollection getOrgInfoSelector(OrgType orgType) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("isCU"));
        selector.add(new SelectorItemInfo("isBizUnit"));
        selector.add(new SelectorItemInfo("isSaleOrgUnit"));
        selector.add(new SelectorItemInfo("isAdminOrgUnit"));
        selector.add(new SelectorItemInfo("isPurchaseOrgUnit"));
        selector.add(new SelectorItemInfo("isStorageOrgUnit"));
        selector.add(new SelectorItemInfo("isCompanyOrgUnit"));
        selector.add(new SelectorItemInfo("isTransportOrgUnit"));
        selector.add(new SelectorItemInfo("isFreeze"));
        selector.add(new SelectorItemInfo("isGrouping"));
        selector.add(new SelectorItemInfo("isCostOrgUnit"));
        selector.add(new SelectorItemInfo("isStart"));
        selector.add(new SelectorItemInfo("code"));
        selector.add(new SelectorItemInfo("orgTypeStr"));
        if (orgType.getValue() == 1) {
            selector.add(new SelectorItemInfo("baseCurrency.id"));
            selector.add(new SelectorItemInfo("baseCurrency.name"));
            selector.add(new SelectorItemInfo("baseCurrency.number"));
            selector.add(new SelectorItemInfo("accountTable.id"));
            selector.add(new SelectorItemInfo("accountTable.name"));
            selector.add(new SelectorItemInfo("accountTable.number"));
            selector.add(new SelectorItemInfo("accountPeriodType.id"));
            selector.add(new SelectorItemInfo("accountPeriodType.name"));
            selector.add(new SelectorItemInfo("accountPeriodType.number"));
        }
        return selector;
    }

    @Override
    public Map<String, Object> getContrastAccountF7(String companyid, int system, String currencyID, String currentAccountTableID, String baseCurrencyid, String accountTableID) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        int contrastAccountViewSystem = 1;
        if (system == 13) {
            contrastAccountViewSystem = 2;
        }
        items.add(new FilterItemInfo("ContrastAccountView.system", (Object)contrastAccountViewSystem));
        items.add(new FilterItemInfo("company.id", (Object)companyid, CompareType.EQUALS));
        PeriodInfo period = this.getCurrentPeriod(system, companyid);
        if (period != null) {
            items.add(new FilterItemInfo("ContrastAccountView.periodYear", (Object)period.getPeriodYear(), CompareType.EQUALS));
            items.add(new FilterItemInfo("ContrastAccountView.periodNumber", (Object)period.getPeriodNumber(), CompareType.EQUALS));
        } else {
            items.add(new FilterItemInfo("ContrastAccountView.periodYear", (Object)0, CompareType.EQUALS));
            items.add(new FilterItemInfo("ContrastAccountView.periodNumber", (Object)0, CompareType.EQUALS));
        }
        StringBuffer mask = new StringBuffer("#0 AND #1 AND #2 AND #3");
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        if ((accountTableID == null || accountTableID.length() < 2) && companyInfo.getAccountTable() != null) {
            accountTableID = companyInfo.getAccountTable().getId().toString();
        }
        if (baseCurrencyid == null && companyInfo.getBaseCurrency() != null) {
            baseCurrencyid = companyInfo.getBaseCurrency().getId().toString();
        }
        if (currentAccountTableID == null || currentAccountTableID.length() < 2) {
            currentAccountTableID = this.getCurrentAccountTableID(system, period, companyid, accountTableID);
        }
        if (currentAccountTableID != null && currentAccountTableID.length() > 0) {
            items.add(new FilterItemInfo("accountTableID.id", (Object)currentAccountTableID, CompareType.EQUALS));
            mask.append(" AND #4");
            if (currencyID != null && !"".equals(currencyID)) {
                items.add(new FilterItemInfo("accountingcurrency", (Object)new Integer(2), CompareType.EQUALS));
                mask.append(" AND (#5 ");
                items.add(new FilterItemInfo("accountingcurrency", (Object)new Integer(1), CompareType.EQUALS));
                items.add(new FilterItemInfo("currency.id", (Object)currencyID, CompareType.EQUALS));
                mask.append(" OR (#6 AND #7) ");
                if (baseCurrencyid != null && currencyID.equalsIgnoreCase(baseCurrencyid)) {
                    items.add(new FilterItemInfo("accountingcurrency", (Object)new Integer(0), CompareType.EQUALS));
                    mask.append(" OR #8 ");
                }
                mask.append(" )");
            }
        } else if (currencyID != null && !"".equals(currencyID)) {
            items.add(new FilterItemInfo("accountingcurrency", (Object)new Integer(2), CompareType.EQUALS));
            mask.append(" AND (#4 ");
            items.add(new FilterItemInfo("accountingcurrency", (Object)new Integer(1), CompareType.EQUALS));
            items.add(new FilterItemInfo("currency.id", (Object)currencyID, CompareType.EQUALS));
            mask.append(" OR (#5 AND #6) ");
            if (baseCurrencyid != null && currencyID.equalsIgnoreCase(baseCurrencyid)) {
                items.add(new FilterItemInfo("accountingcurrency", (Object)new Integer(0), CompareType.EQUALS));
                mask.append(" OR #7 ");
            }
            mask.append(" )");
        }
        filter.setMaskString(mask.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        filter.toString();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filter", filter.toString());
        return map;
    }

    public PeriodInfo getCurrentPeriod(int system, String companyid) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = null;
        ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)this.getContext());
        PeriodInfo info = ictrol.getCacheCurrentPeriod(system, companyid);
        if (info == null) {
            info = this.getStartPeriod(system, companyid);
        }
        return info;
    }

    public PeriodInfo getStartPeriod(int system, String companyid) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = null;
        ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)this.getContext());
        return ictrol.getStartPeriod(system, companyid);
    }

    public String getCurrentAccountTableID(int system, PeriodInfo period, String companyid, String accountTableID) throws EASBizException, BOSException {
        if (period == null) {
            period = this.getCurrentPeriod(system, companyid);
        }
        if (period == null) {
            period = this.getStartPeriod(system, companyid);
        }
        String currentAccountTableID = null;
        if (period != null && accountTableID != null) {
            AccountRefContrastInfo info = AccountRefContrastFactory.getLocalInstance((Context)this.getContext()).getLastAcctInfo(companyid, accountTableID, period.getPeriodYear(), period.getPeriodNumber());
            currentAccountTableID = info == null ? null : info.getEnabledAcctTable().getId().toString();
        } else if (period != null && accountTableID != null) {
            return accountTableID;
        }
        return currentAccountTableID;
    }

    @Override
    public Map<String, Object> getCostCenterUnit(String adminOrgUnitId, String companyOrgUnitId) throws EASBizException, BOSException {
        OrgUnitCollection costCenterCollectionByOrg;
        IOrgUnitRelation iUtilRel = OrgUnitRelationFactory.getLocalInstance((Context)this.getContext());
        OrgUnitCollection costCenterCollection = iUtilRel.getToUnit(adminOrgUnitId, 0, 5);
        if (costCenterCollection.size() > 0 && (costCenterCollectionByOrg = iUtilRel.getFromUnit(companyOrgUnitId, 1, 5)).contains(costCenterCollection.get(0))) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("costCenterUnit", costCenterCollection.get(0));
            return result;
        }
        return null;
    }

    @Override
    public Map<String, Object> getMultiUnitData(List<List> ids) throws BOSException, EASBizException {
        MaterialInfo[] materialInfos = new MaterialInfo[ids.size()];
        MeasureUnitInfo[] measureUnitInfos = new MeasureUnitInfo[ids.size()];
        MeasureUnitInfo[] measureBaseUnitInfos = new MeasureUnitInfo[ids.size()];
        MeasureUnitInfo[] measureAssistUnitInfos = new MeasureUnitInfo[ids.size()];
        MaterialInfo materialInfo = null;
        MeasureUnitInfo measureUnitInfo = null;
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            materialInfo = new MaterialInfo();
            materialInfo.setId(BOSUuid.read((String)ids.get(i).get(0).toString()));
            materialInfos[i] = materialInfo;
            measureUnitInfo = new MeasureUnitInfo();
            measureUnitInfo.setId(BOSUuid.read((String)ids.get(i).get(1).toString()));
            measureUnitInfos[i] = measureUnitInfo;
            if (ids.get(i).get(2) != null) {
                measureUnitInfo = new MeasureUnitInfo();
                measureUnitInfo.setId(BOSUuid.read((String)ids.get(i).get(2).toString()));
                measureBaseUnitInfos[i] = measureUnitInfo;
            }
            if (ids.get(i).get(3) == null) continue;
            measureUnitInfo = new MeasureUnitInfo();
            measureUnitInfo.setId(BOSUuid.read((String)ids.get(i).get(3).toString()));
            measureAssistUnitInfos[i] = measureUnitInfo;
        }
        SCMEntryDataVO inputVO = new SCMEntryDataVO();
        inputVO.setIsLoadingMmuPrecision(true);
        inputVO.setMaterialInfos(materialInfos);
        inputVO.setMeasureUnitInfos(measureUnitInfos);
        inputVO.setBaseMeasureUnitInfos(measureBaseUnitInfos);
        inputVO.setAssistMeasureUnitInfos(measureAssistUnitInfos);
        SCMEntryDataVO resultVO = SCMGroupFacadeFactory.getLocalInstance((Context)this.getContext()).loadComplexData(inputVO);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("MmuConvsRate", resultVO.getMmuConvsRate());
        result.put("MmuPrecisions", resultVO.getMmuPrecisions());
        return result;
    }

    public static SelectorItemCollection getBillSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.cu.id"));
        sic.add(new SelectorItemInfo("billType"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("bizType.number"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("paymentType.id"));
        sic.add(new SelectorItemInfo("paymentType.number"));
        sic.add(new SelectorItemInfo("paymentType.name"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("sourceBillType"));
        sic.add(new SelectorItemInfo("bizdate"));
        sic.add(new SelectorItemInfo("isInTax"));
        sic.add(new SelectorItemInfo("isPriceWithoutTax"));
        sic.add(new SelectorItemInfo("isBizBill"));
        sic.add(new SelectorItemInfo("cashDiscount.description"));
        sic.add(new SelectorItemInfo("cashDiscount.number"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("settleType.name"));
        sic.add(new SelectorItemInfo("settleType.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.rowType.id"));
        sic.add(new SelectorItemInfo("entry.rowType.number"));
        sic.add(new SelectorItemInfo("entry.rowType.name"));
        sic.add(new SelectorItemInfo("entry.rowType.precision"));
        sic.add(new SelectorItemInfo("entry.rowType.isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("entry.rowType.projectType"));
        sic.add(new SelectorItemInfo("entry.rowType.destinationType"));
        sic.add(new SelectorItemInfo("entry.rowType.requestOrgType"));
        sic.add(new SelectorItemInfo("entry.material.id"));
        sic.add(new SelectorItemInfo("entry.material.number"));
        sic.add(new SelectorItemInfo("entry.material.name"));
        sic.add(new SelectorItemInfo("entry.material.model"));
        sic.add(new SelectorItemInfo("entry.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entry.material.baseUnit.id"));
        sic.add(new SelectorItemInfo("entry.material.assistUnit.id"));
        sic.add(new SelectorItemInfo("entry.material.assistAttr.id"));
        sic.add(new SelectorItemInfo("entry.expenseItem.name"));
        sic.add(new SelectorItemInfo("entry.expenseItem.number"));
        sic.add(new SelectorItemInfo("entry.measureUnit.id"));
        sic.add(new SelectorItemInfo("entry.measureUnit.number"));
        sic.add(new SelectorItemInfo("entry.measureUnit.name"));
        sic.add(new SelectorItemInfo("entry.baseUnit.id"));
        sic.add(new SelectorItemInfo("entry.baseUnit.number"));
        sic.add(new SelectorItemInfo("entry.baseUnit.name"));
        sic.add(new SelectorItemInfo("entry.baseUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("entry.assistUnit.id"));
        sic.add(new SelectorItemInfo("entry.assistUnit.number"));
        sic.add(new SelectorItemInfo("entry.assistUnit.name"));
        sic.add(new SelectorItemInfo("entry.assistUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("entry.assistProperty.id"));
        sic.add(new SelectorItemInfo("entry.assistProperty.number"));
        sic.add(new SelectorItemInfo("entry.assistProperty.name"));
        sic.add(new SelectorItemInfo("entry.account.id"));
        sic.add(new SelectorItemInfo("entry.account.number"));
        sic.add(new SelectorItemInfo("entry.account.name"));
        sic.add(new SelectorItemInfo("entry.oppAccount.id"));
        sic.add(new SelectorItemInfo("entry.oppAccount.number"));
        sic.add(new SelectorItemInfo("entry.oppAccount.name"));
        sic.add(new SelectorItemInfo("entry.coreBillType.id"));
        sic.add(new SelectorItemInfo("entry.coreBillType.number"));
        sic.add(new SelectorItemInfo("entry.coreBillType.name"));
        sic.add(new SelectorItemInfo("entry.orderCustomer.id"));
        sic.add(new SelectorItemInfo("entry.orderCustomer.number"));
        sic.add(new SelectorItemInfo("entry.orderCustomer.name"));
        sic.add(new SelectorItemInfo("entry.serviceCustomer.id"));
        sic.add(new SelectorItemInfo("entry.serviceCustomer.number"));
        sic.add(new SelectorItemInfo("entry.serviceCustomer.name"));
        sic.add(new SelectorItemInfo("entry.recAsstActNumber"));
        sic.add(new SelectorItemInfo("entry.recAsstActName"));
        sic.add(new SelectorItemInfo("entry.ordCustNumber"));
        sic.add(new SelectorItemInfo("entry.ordCustName"));
        sic.add(new SelectorItemInfo("entry.serCustNumber"));
        sic.add(new SelectorItemInfo("entry.serCustName"));
        sic.add(new SelectorItemInfo("entry.materialName"));
        sic.add(new SelectorItemInfo("entry.sourceBillId"));
        sic.add(new SelectorItemInfo("entry.sourceBillEntryId"));
        return sic;
    }
}

