/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.cdo.CommonDataObject;
import com.kingdee.bos.cdo.ICommonDataObject;
import com.kingdee.bos.cdo.utils.CDOUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationRuleEnum;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillFactory;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDepCalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.IFaClearBill;
import com.kingdee.eas.fi.fa.manage.services.IFaClearBillService;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.fa.manage.services.IFaClearBillService"})
public class FaClearBillServiceImpl
extends BusinessServices
implements IFaClearBillService {
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static String className = "com.kingdee.eas.fi.fa.manage.FaCardResource";

    public FaClearBillServiceImpl(Context context) {
        super(context);
    }

    protected ICoreBase getBizInterface() throws BOSException, EASBizException {
        return FaClearBillFactory.getLocalInstance((Context)this.getContext());
    }

    public CompanyOrgUnitInfo getCurrentCompanyOrgUnitInfo(ICoreBase bizInterface, String[] ids) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(ids[0].toString());
        CoreBaseInfo billInfo = bizInterface.getValue("select company.* where id = '" + pk + "'");
        return (CompanyOrgUnitInfo)billInfo.get("company");
    }

    @Override
    public void checkBeforeVoucher(String[] ids) throws EASBizException, BOSException {
    }

    @Override
    public void checkBeforeDelVoucher(String[] ids) throws EASBizException, BOSException {
    }

    @Override
    public Map<String, Object> getPreDecTTerm(String faCurCardId) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FaCurCardInfo cardInfo = FaCurCardFactory.getLocalInstance((Context)this.getContext()).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(faCurCardId), this.getCurCardSelectors());
        BigDecimal preDecTTerm = this.getPreDectTerm(cardInfo);
        result.put("preDecTTerm", preDecTTerm);
        return result;
    }

    @Override
    public Map<String, Object> getPreDecTTerm(CommonDataObject faCurCardInfo) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FaCurCardInfo cardInfo = (FaCurCardInfo)CDOUtils.convertCDOToObjectInfo((Context)this.getContext(), (ICommonDataObject)faCurCardInfo);
        BigDecimal preDecTTerm = this.getPreDectTerm(cardInfo);
        result.put("preDecTTerm", preDecTTerm);
        return result;
    }

    @Override
    public Map<String, Object> getCurcardInfoCollection(String existId, String curcardIds) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<String> existIds = Arrays.asList(existId.split(","));
        List<String> curcardId = Arrays.asList(curcardIds.split(","));
        HashSet<String> idset = new HashSet<String>();
        for (int i = 0; i < curcardId.size(); ++i) {
            if (existIds.contains(curcardId.get(i))) continue;
            idset.add(curcardId.get(i));
        }
        SelectorItemCollection sic = this.getCurCardSelectors();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
        view.setFilter(f);
        view.setSelector(sic);
        FaCurCardCollection curcardColection = FaCurCardFactory.getLocalInstance((Context)this.getContext()).getFaCurCardCollection(view);
        if (curcardColection != null) {
            for (int i = 0; i < curcardColection.size(); ++i) {
                FaCurCardInfo entryInfo = curcardColection.get(i);
                String lastUpdateTime = entryInfo.getLastUpdateTime().toString();
                entryInfo.put("lastUpdateTime", (Object)lastUpdateTime);
            }
        }
        result.put("curcardCollection", curcardColection);
        return result;
    }

    @Override
    public String saveClearBill(CommonDataObject faClearBillInfo) throws EASBizException, BOSException {
        IFaClearBill iFactory = (IFaClearBill)this.getBizInterface();
        FaClearBillInfo clearBillInfo = (FaClearBillInfo)CDOUtils.convertCDOToObjectInfo((Context)this.getContext(), (ICommonDataObject)faClearBillInfo);
        FaClearBillEntryCollection entry = clearBillInfo != null ? clearBillInfo.getClearBillEntry() : null;
        this.setExtraPropertyValue(entry);
        IObjectPK pk = iFactory.save((CoreBaseInfo)clearBillInfo);
        return pk == null ? "" : pk.toString();
    }

    @Override
    public String submitClearBill(CommonDataObject faClearBillInfo) throws EASBizException, BOSException {
        IFaClearBill iFactory = (IFaClearBill)this.getBizInterface();
        FaClearBillInfo clearBillInfo = (FaClearBillInfo)CDOUtils.convertCDOToObjectInfo((Context)this.getContext(), (ICommonDataObject)faClearBillInfo);
        FaClearBillEntryCollection entry = clearBillInfo != null ? clearBillInfo.getClearBillEntry() : null;
        this.setExtraPropertyValue(entry);
        this.checkBeforeSubmit(clearBillInfo);
        IObjectPK pk = iFactory.submit((CoreBaseInfo)clearBillInfo);
        return pk == null ? "" : pk.toString();
    }

    @Override
    public boolean checkStatusValid(String billId) throws EASBizException, BOSException {
        boolean result = false;
        IFaClearBill iFactory = (IFaClearBill)this.getBizInterface();
        FaClearBillInfo clearBillInfo = iFactory.getFaClearBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getClearBillSelectors());
        result = iFactory.checkStatusValid((CoreBaseInfo)clearBillInfo);
        return result;
    }

    private void checkBeforeSubmit(FaClearBillInfo clearBillInfo) throws EASBizException, BOSException {
        FaClearBillEntryCollection entry;
        StringBuffer errorMessage = new StringBuffer(100);
        Date clearDate = clearBillInfo.getClearDate();
        if (clearDate == null) {
            errorMessage.append(EASResource.getString((String)className, (String)"FaClearBillEditUI_ClearDateIsNull"));
        } else {
            CompanyOrgUnitInfo companyInfo = clearBillInfo.getCompany();
            PeriodInfo currentPeriod = this.getCurrentPeriod(companyInfo);
            if (currentPeriod != null && (DateTimeUtils.dayBefore((Date)clearDate, (Date)currentPeriod.getBeginDate()) || DateTimeUtils.dayAfter((Date)clearDate, (Date)currentPeriod.getEndDate()))) {
                errorMessage.append("\n" + EASResource.getString((String)className, (String)"FaClearBillEditUI_ClearDateError"));
            }
        }
        if (clearBillInfo.getClearMode() == null) {
            errorMessage.append("\n" + EASResource.getString((String)className, (String)"FaClearBillEditUI_EntryIsNull"));
        }
        if ((entry = clearBillInfo.getClearBillEntry()) == null || entry.size() < 1) {
            errorMessage.append("\n" + EASResource.getString((String)className, (String)"FaClearBillEditUI_EntryIsNull"));
        }
        if (entry != null) {
            for (int i = 0; i < entry.size(); ++i) {
                FaCurCardInfo curCard;
                FaClearBillEntryInfo entryInfo = entry.get(i);
                String curcardId = entryInfo.getCurCard().getId().toString();
                BigDecimal clrQty = entryInfo.getClrQty();
                BigDecimal clrOriginal = entryInfo.getClrOriginal();
                BigDecimal clrAddupDep = entryInfo.getClrAddupDep();
                BigDecimal clrDec = entryInfo.getClrDecPrep();
                Date accountDate = (Date)entryInfo.get("curCardAccountDate");
                boolean canDoClear = (Boolean)entryInfo.get("canDoClear");
                BigDecimal assetAmount = (BigDecimal)entryInfo.get("assetAmount");
                if (accountDate != null && DateTimeUtils.dayBefore((Date)clearDate, (Date)accountDate)) {
                    errorMessage.append("\n" + EASResource.getString((String)className, (String)"FaClearBillEditUI_ClearDateBeforeAccountDate") + "[" + DateTimeUtils.format((Date)accountDate, (String)"yyyy-MM-dd") + "]");
                }
                if (clrQty == null || clrQty.compareTo(ZERO) <= 0 || clrOriginal == null || clrAddupDep == null || clrDec == null) {
                    errorMessage.append("\n" + EASResource.getString((String)className, (String)"FaClearBillEditUI_ClearQuantityError"));
                }
                if (clrQty != null && clrQty.compareTo(assetAmount) > 1) {
                    errorMessage.append("\n" + EASResource.getString((String)className, (String)"FaClearBillEditUI_ClearQuantityTooBig"));
                }
                if (!canDoClear && clrQty != null && clrQty.compareTo(assetAmount) == -1) {
                    errorMessage.append("\n" + EASResource.getString((String)className, (String)"FaClearBillEditUI_CanNotPartClear"));
                }
                boolean isAlreadyDep = (curCard = FaCurCardFactory.getLocalInstance((Context)this.getContext()).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curcardId), this.getCurCardSelectors())).getDeprTTerm() != null && curCard.getDeprTTerm().compareTo(ZERO) != 0;
                boolean isHasNew = curCard.isHasNew();
                if (curCard == null || curCard.getDeprMethod() == null || isHasNew || !isAlreadyDep || this.isNeedReDepr(curCard) || !this.checkDepreVoucher()) continue;
                errorMessage.append("\n" + EASResource.getString((String)className, (String)"FaClearBillEditUI_isDepVoucher"));
            }
        }
        if (StringUtils.isNotBlank((String)errorMessage.toString())) {
            throw new BOSException(errorMessage.toString());
        }
    }

    private void setExtraPropertyValue(FaClearBillEntryCollection entry) throws EASBizException, BOSException {
        if (entry != null) {
            for (int i = 0; i < entry.size(); ++i) {
                FaClearBillEntryInfo entryInfo = entry.get(i);
                String cardUpdateTime = (String)entryInfo.get("cardUpdateTime");
                try {
                    Timestamp lastUpdateTime = Timestamp.valueOf(cardUpdateTime);
                    entryInfo.put("cardUpdateTime", (Object)lastUpdateTime);
                    String curCardAccountDate = (String)entryInfo.get("curCardAccountDate");
                    Date accountDate = DateTimeUtils.parseDate((String)curCardAccountDate);
                    entryInfo.put("curCardAccountDate", (Object)accountDate);
                    Boolean canDoClear = (Boolean)entryInfo.get("canDoClear");
                    entryInfo.put("canDoClear", (Object)canDoClear);
                    BigDecimal assetAmount = (BigDecimal)entryInfo.get("assetAmount");
                    entryInfo.put("assetAmount", (Object)assetAmount);
                    continue;
                }
                catch (Exception ex) {
                    throw new BOSException("\ufffd\ufffd\u00bc\ufffd\u0136\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0534\ufffd\ufffd\ufffd\ufffd\ufffd", (Throwable)ex);
                }
            }
        }
    }

    private PeriodInfo getCurrentPeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)this.getContext(), (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)companyInfo);
    }

    private boolean isNeedReDepr(FaCurCardInfo curCardInfo) {
        return curCardInfo.getAssetCat().getDepreciationPolicy().getStartDeprTime().getValue() != 0;
    }

    private boolean checkDepreVoucher() throws BOSException, EASBizException {
        return ((IFaClearBill)this.getBizInterface()).isAlreadyDepVoucher();
    }

    private BigDecimal getPreDectTerm(FaCurCardInfo cardInfo) throws EASBizException, BOSException {
        BigDecimal preDecTTerm = ZERO;
        FaCurCardCollection cards = new FaCurCardCollection();
        cards.add(cardInfo);
        if (!FaDepCalFacadeFactory.getLocalInstance((Context)this.getContext()).isNeedDep(cards)) {
            return preDecTTerm;
        }
        if (!(cardInfo.getAssetCat().getDepreciationPolicy().getDeprRule() == FaDepreciationRuleEnum.YES_REGARDLESS_USESTATUS || cardInfo.getAssetCat().getDepreciationPolicy().getDeprRule() == FaDepreciationRuleEnum.DECIDE_BY_USESTATUS && cardInfo.getUseStatus().isIsDepreciation())) {
            return preDecTTerm;
        }
        HashMap map = FaDepCalFacadeFactory.getLocalInstance((Context)this.getContext()).calOneCardDep(cardInfo.getId().toString());
        if (map != null && (BigDecimal)map.get(new Integer(1)) != null) {
            preDecTTerm = (BigDecimal)map.get(new Integer(1));
        }
        return preDecTTerm;
    }

    private SelectorItemCollection getCurCardSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("measureUnit.name"));
        sic.add(new SelectorItemInfo("assetCat.name"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.OldChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.TotalDeprChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DevalueChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.LeaveValueChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.ChargeAccoutChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.UsedLifeChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DeprMethodChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.EvaluateChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.CostCenterChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.UseStatusChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.TailDispose"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.StartDeprTime"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DeprRule"));
        sic.add(new SelectorItemInfo("deprMethod.period"));
        sic.add(new SelectorItemInfo("deprMethod.isCustom"));
        sic.add(new SelectorItemInfo("deprMethod.depValuePolicy"));
        sic.add(new SelectorItemInfo("deprMethod.isWorkload"));
        sic.add(new SelectorItemInfo("deprMethod.id"));
        sic.add(new SelectorItemInfo("deprMethod.name"));
        sic.add(new SelectorItemInfo("deprMethod.number"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.StartDeprTime"));
        sic.add(new SelectorItemInfo("useStatus.isDepreciation"));
        sic.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
        sic.add(new SelectorItemInfo("evalDeprMode.period"));
        sic.add(new SelectorItemInfo("evalDeprMode.number"));
        sic.add(new SelectorItemInfo("evalDeprMode.name"));
        sic.add(new SelectorItemInfo("evalDeprMode.depValuePolicy"));
        sic.add(new SelectorItemInfo("evalDeprMode.isWorkload"));
        sic.add(new SelectorItemInfo("evalDeprMode.isCustom"));
        sic.add(new SelectorItemInfo("evalDeprMode.id"));
        return sic;
    }

    private SelectorItemCollection getClearBillSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("clearMode.id"));
        sic.add(new SelectorItemInfo("clearMode.name"));
        sic.add(new SelectorItemInfo("clearMode.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("handler.id"));
        sic.add(new SelectorItemInfo("handler.name"));
        sic.add(new SelectorItemInfo("handler.number"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("clearBillEntry.*"));
        return sic;
    }
}

