/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.services.model;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.fa.manage.services.model.IModelCreate;
import java.util.HashMap;
import java.util.Map;

public class ModelCreateContext {
    private static Map<String, String> modelCreators = new HashMap<String, String>();
    private static Map<String, String> modelPermissions = new HashMap<String, String>();

    public static IModelCreate getModelCreator(String bosType) throws BOSException {
        String creatorName = modelCreators.get(bosType);
        IModelCreate creator = null;
        try {
            creator = (IModelCreate)Class.forName(creatorName).newInstance();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return creator;
    }

    public static String getModelPermission(String bosType) {
        return modelPermissions.get(bosType);
    }

    static {
        modelCreators.put("42AC39EC", "com.kingdee.eas.fi.fa.manage.services.impl.FaCardModelCreator");
        modelCreators.put("25F51970", "com.kingdee.eas.fi.fa.manage.services.impl.FaClearBillModelCreator");
        modelPermissions.put("42AC39EC", "fa_card_addNew");
        modelPermissions.put("25F51970", "fa_cardclean_addnew");
    }
}

