/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.services.BDService;
import com.kingdee.eas.fi.gl.services.impl.ServiceWebUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.gl.services.BDService"})
@Description(value="\u57fa\u7840\u670d\u52a1")
public class BDServiceImpl
implements BDService {
    private final Context ctx;

    public BDServiceImpl(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public List<Map> getPeriodListByDate(String companyId, Date date) throws EASBizException, BOSException {
        PeriodCollection periodColl = PeriodUtils.getPeriodCollection((Context)this.ctx, (Date)date, (Date)date, (IObjectPK)new ObjectUuidPK(companyId));
        ArrayList<Map> periodList = new ArrayList<Map>();
        if (periodColl != null) {
            for (int i = 0; i < periodColl.size(); ++i) {
                PeriodInfo period = periodColl.get(i);
                HashMap<String, String> item = new HashMap<String, String>();
                item.put("alias", period.toString());
                item.put("value", ServiceWebUtils.toPeriodString(period));
                periodList.add(item);
            }
        }
        return periodList;
    }

    @Override
    public Map getPeriodByNumber(String companyId, int period) throws EASBizException, BOSException {
        int month;
        String str = String.valueOf(period);
        if (str.length() != 6) {
            return null;
        }
        int year = Integer.parseInt(str.substring(0, 4));
        PeriodInfo info = PeriodUtils.getPeriodInfo((Context)this.ctx, (int)year, (int)(month = Integer.parseInt(str.substring(4))), (IObjectPK)new ObjectUuidPK(companyId));
        if (info != null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("id", info.getId().toString());
            result.put("number", info.getNumber());
            result.put("beginDate", info.getBeginDate());
            result.put("endDate", info.getEndDate());
            return result;
        }
        return null;
    }

    @Override
    public Map getSysParam(String companyId, String[] paramNumbers) throws EASBizException, BOSException {
        return GlParam.getGlParams((Context)this.ctx, (String[])paramNumbers, (String)companyId).getParamMap();
    }

    @Override
    public CurrencyCollection getCurrencyCollection(String selector) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        if (StringUtils.isEmpty((String)selector)) {
            view.getSelector().add(new SelectorItemInfo("*"));
        } else {
            String[] selectors = selector.split(",");
            for (int i = 0; i < selectors.length; ++i) {
                view.getSelector().add(new SelectorItemInfo(selectors[i]));
            }
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1));
        view.setFilter(filter);
        return CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyCollection(view, true);
    }

    @Override
    public ExchangeRateInfo getExchangeRateInfo(String exchangeTableId, String srcCurrencyId, String targetCurrencyId, Date date) throws EASBizException, BOSException {
        return ExchangeRateFactory.getLocalInstance((Context)this.ctx).getExchangeRateConvertInfo((IObjectPK)new ObjectUuidPK(exchangeTableId), (IObjectPK)new ObjectUuidPK(srcCurrencyId), (IObjectPK)new ObjectUuidPK(targetCurrencyId), date);
    }

    @Override
    public AsstActTypeCollection getAsstActTypeCollection(String[] companyIds) throws EASBizException, BOSException {
        HashSet<String> companyIdSet = new HashSet<String>();
        for (int i = 0; i < companyIds.length; ++i) {
            companyIdSet.add(companyIds[i]);
        }
        return GlUtils.getAsstActTypeCollection((Context)this.ctx, companyIdSet);
    }
}

