/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.Account_ControlCollection;
import com.kingdee.eas.basedata.master.account.Account_ControlFactory;
import com.kingdee.eas.basedata.master.account.Account_ControlInfo;
import com.kingdee.eas.basedata.master.account.IAccountTable;
import com.kingdee.eas.basedata.master.account.IAccount_Control;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AccountBalanceInitData;
import com.kingdee.eas.fi.gl.GLInitFacadeFactory;
import com.kingdee.eas.fi.gl.InitAccountBalanceInfo;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.services.GLInitService;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;

@Component(value={"com.kingdee.eas.fi.gl.services.GLInitService"})
@Description(value="\u603b\u8d26\u521d\u59cb\u5316\u670d\u52a1")
public class GLInitServiceImpl
implements GLInitService {
    private final Context ctx;
    private final String DC_DEBIT = InitClientHelp.Title_Debit;
    private final String DC_CREDIT = InitClientHelp.Title_Credit;
    private final BigDecimal zero = new BigDecimal("0");

    public GLInitServiceImpl(Context ctx) {
        this.ctx = ctx;
    }

    public Object[] getInitAccountBalance(String currencyID, String companyID, String accountTableID, int type) throws EASBizException, BOSException {
        HashMap<String, Object> otherCtx = new HashMap<String, Object>();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
        otherCtx.put("COMPANY", company);
        otherCtx.put("ACCOUNTTABLEID", accountTableID);
        InitAccountBalanceInfo[] infoArray = null;
        if (type == 0) {
            AccountBalanceInitData[] initData = (AccountBalanceInitData[])GLInitFacadeFactory.getLocalInstance((Context)this.ctx).getAccountBalanceData(currencyID, otherCtx);
            infoArray = new InitAccountBalanceInfo[initData.length];
            for (AccountBalanceInitData initInfo : initData) {
                InitAccountBalanceInfo info = new InitAccountBalanceInfo();
                AccountViewInfo account = initInfo.getAccount();
                if (account == null) {
                    account = new AccountViewInfo();
                }
                account.setName(initInfo.getAccountName());
                account.setNumber(initInfo.getAccountNumber());
                account.setLongNumber(initInfo.getAccountLongNumber());
                info.setAccount(account);
                if (initInfo.getBeginBalanceFor() != null && this.zero.compareTo(initInfo.getBeginBalanceFor()) != 0) {
                    info.setBeginBalanceFor(initInfo.getBeginBalanceFor());
                }
                if (initInfo.getBeginBalanceLocal() != null && this.zero.compareTo(initInfo.getBeginBalanceLocal()) != 0) {
                    info.setBeginBalanceLocal(initInfo.getBeginBalanceLocal());
                }
                if (initInfo.getBeginBalanceReport() != null && this.zero.compareTo(initInfo.getBeginBalanceReport()) != 0) {
                    info.setBeginBalanceRpt(initInfo.getBeginBalanceReport());
                }
                if (initInfo.getYearDebitFor() != null && this.zero.compareTo(initInfo.getYearDebitFor()) != 0) {
                    info.setYearDebitFor(initInfo.getYearDebitFor());
                }
                if (initInfo.getYearDebitLocal() != null && this.zero.compareTo(initInfo.getYearDebitLocal()) != 0) {
                    info.setYearDebitLocal(initInfo.getYearDebitLocal());
                }
                if (initInfo.getYearDebitQty() != null && this.zero.compareTo(initInfo.getYearDebitQty()) != 0) {
                    info.setYearDebitQty(initInfo.getYearDebitQty());
                }
                if (initInfo.getYearDebitReport() != null && this.zero.compareTo(initInfo.getYearDebitReport()) != 0) {
                    info.setYearDebitRpt(initInfo.getYearDebitReport());
                }
                if (initInfo.getYearCreditFor() != null && this.zero.compareTo(initInfo.getYearCreditFor()) != 0) {
                    info.setYearCreditFor(initInfo.getYearCreditFor());
                }
                if (initInfo.getYearCreditLocal() != null && this.zero.compareTo(initInfo.getYearCreditLocal()) != 0) {
                    info.setYearCreditLocal(initInfo.getYearCreditLocal());
                }
                if (initInfo.getYearCreditQty() != null && this.zero.compareTo(initInfo.getYearCreditQty()) != 0) {
                    info.setYearCreditQty(initInfo.getYearCreditQty());
                }
                if (initInfo.getYearCreditReport() != null && this.zero.compareTo(initInfo.getYearCreditReport()) != 0) {
                    info.setYearCreditRpt(initInfo.getYearCreditReport());
                }
                if (initInfo.getYearPnLFor() != null && this.zero.compareTo(initInfo.getYearPnLFor()) != 0) {
                    info.setYearPnLFor(initInfo.getYearPnLFor());
                }
                if (initInfo.getYearPnLLocal() != null && this.zero.compareTo(initInfo.getYearPnLLocal()) != 0) {
                    info.setYearPnLLocal(initInfo.getYearPnLLocal());
                }
                if (initInfo.getYearPnLReport() != null && this.zero.compareTo(initInfo.getYearPnLReport()) != 0) {
                    info.setYearPnLRpt(initInfo.getYearPnLReport());
                }
                info.put("mu", (Object)initInfo.getAccountMeasureUnitName());
                info.put("dc", (Object)(initInfo.getAccountDC() == 1 ? this.DC_DEBIT : this.DC_CREDIT));
                infoArray[i] = info;
            }
        }
        return infoArray;
    }

    public AccountTableCollection getAccountTableCollection(String companyID) throws EASBizException, BOSException {
        if (companyID == null) {
            companyID = ContextUtil.getCurrentFIUnit((Context)this.ctx).getId().toString();
        }
        ArrayList<String> tableIdList = new ArrayList<String>();
        IAccount_Control acctCtrl = Account_ControlFactory.getLocalInstance((Context)this.ctx);
        EntityViewInfo eviForCtrl = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)companyID));
        eviForCtrl.setFilter(filter);
        eviForCtrl.getSelector().add("accountTableID.*");
        Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(eviForCtrl);
        if (acctCtrlCols != null) {
            int count = acctCtrlCols.size();
            for (int i = 0; i < count; ++i) {
                Account_ControlInfo acctCtrlInfo = acctCtrlCols.get(i);
                tableIdList.add(acctCtrlInfo.getAccountTableID().getId().toString());
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        IAccountTable iAccountTable = AccountTableFactory.getLocalInstance((Context)this.ctx);
        AccountTableCollection tableInfos = iAccountTable.getAccountTableCollection(evi);
        AccountTableCollection tableInfosNew = new AccountTableCollection();
        for (AccountTableInfo tableInfo : tableInfos) {
            if (!tableIdList.contains(tableInfo.getId().toString())) continue;
            tableInfosNew.add(tableInfo);
        }
        return tableInfosNew;
    }

    public CurrencyCollection getCurrencyCollection() throws EASBizException, BOSException {
        ICurrency curCtrl = CurrencyFactory.getLocalInstance((Context)this.ctx);
        CurrencyCollection curCol = curCtrl.getCurrencyCollection(false);
        return curCol;
    }
}

