/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CollectEnum;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.services.IGLRptAsstactBaseService;
import com.kingdee.eas.fi.gl.services.impl.GLRptBaseServiceImpl;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class GLRptAsstactBaseServiceImpl
extends GLRptBaseServiceImpl
implements IGLRptAsstactBaseService {
    public GLRptAsstactBaseServiceImpl(Context ctx) {
        super(ctx);
    }

    public List getAsstactTypeEntityList(Set companyIDs, String asstAccountId) throws BOSException, EASBizException {
        if (asstAccountId == null) {
            return GlUtils.queryAsstAct((Context)this.ctx, (Set)companyIDs);
        }
        return this.getAsstactTypeEntityList(asstAccountId);
    }

    private List getAsstactTypeEntityList(String asstAccountId) throws BOSException, EASBizException {
        ArrayList<AsstactTypeEntity> list = new ArrayList<AsstactTypeEntity>();
        if (StringUtils.isEmpty((String)asstAccountId)) {
            return list;
        }
        Iterator it = this.getAsstActGroupDetailCollection(asstAccountId).iterator();
        while (it.hasNext()) {
            AsstActTypeInfo info = ((AsstActGroupDetailInfo)it.next()).getAsstActType();
            list.add(this.createAsstactTypeEntity(info));
        }
        return list;
    }

    private AsstActGroupDetailCollection getAsstActGroupDetailCollection(String asstAccountId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("asstActType.id"));
        view.getSelector().add(new SelectorItemInfo("asstActType.number"));
        view.getSelector().add(new SelectorItemInfo("asstActType.name"));
        view.getSelector().add(new SelectorItemInfo("asstActType.defaultQueryName"));
        view.getSelector().add(new SelectorItemInfo("asstActType.realtionDataObject"));
        view.getSelector().add(new SelectorItemInfo("asstActType.isForCompany"));
        view.getSelector().add(new SelectorItemInfo("asstActType.glAsstActTypeGrp.id"));
        view.getSelector().add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        view.getSelector().add(new SelectorItemInfo("asstActType.mappingFieldName"));
        view.getSelector().add(new SelectorItemInfo("asstActType.groupTableName"));
        view.getSelector().add(new SelectorItemInfo("asstActType.groupMappingFieldName"));
        view.getSelector().add(new SelectorItemInfo("asstActType.isMultilevel"));
        view.getSelector().add(new SelectorItemInfo("asstActType.permissionItem"));
        view.getSelector().add(new SelectorItemInfo("asstActType.useLongNumber"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("asstAccount.id", (Object)asstAccountId));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("seq"));
        AsstActGroupDetailCollection coll = AsstActGroupDetailFactory.getLocalInstance((Context)this.ctx).getAsstActGroupDetailCollection(view);
        return coll;
    }

    private AsstactTypeEntity createAsstactTypeEntity(AsstActTypeInfo info) {
        AsstactTypeEntity at = new AsstactTypeEntity();
        at.setId(info.getId().toString());
        at.setNumber(info.getNumber());
        at.setQueryName(info.getDefaultQueryName());
        at.setTableName(info.getRealtionDataObject());
        at.setName(info.getName());
        at.setForCompany(info.isIsForCompany());
        if (info.getGlAsstActTypeGrp() != null) {
            at.setGeneralAsstactGroupId(info.getGlAsstActTypeGrp().getId().toString());
        }
        at.setHgField(info.getMappingFieldName());
        at.setHgAttribute(info.getAsstHGAttribute());
        at.setGroupTable(info.getGroupTableName());
        at.setGroupField(info.getGroupMappingFieldName());
        at.setCollect(CollectEnum.LEAF);
        at.setMultilevel(info.isIsMultilevel());
        at.setEnabledPermissionLimit(true);
        at.setPermissionItem(info.getPermissionItem());
        at.setUseLongNumber(info.isUseLongNumber());
        at.setSelected(true);
        return at;
    }
}

