/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.GLRptAccountTreeFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptQueryResult;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.fi.gl.services.IGLRptSubLedgerService;
import com.kingdee.eas.fi.gl.services.impl.GLRptAsstactBaseServiceImpl;
import com.kingdee.eas.fi.gl.services.impl.rpt.GLRptBaseConditionBuilder;
import com.kingdee.eas.fi.gl.services.impl.rpt.GLRptSubLedgerConditionBuilder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

@Component(value={"com.kingdee.eas.fi.gl.services.IGLRptSubLedgerService"})
@Description(value="\u660e\u7ec6\u5206\u7c7b\u8d26\u670d\u52a1")
public class GLRptSubLedgerServiceImpl
extends GLRptAsstactBaseServiceImpl
implements IGLRptSubLedgerService {
    public GLRptSubLedgerServiceImpl(Context ctx) {
        super(ctx);
    }

    protected IGLRptBaseFacade getBizCtrl() throws BOSException {
        return GLRptSubLedgerFacadeFactory.getLocalInstance((Context)this.ctx);
    }

    protected GLRptBaseCondition createReportCondition(Map param) throws CloneNotSupportedException {
        return new GLRptSubLedgerCondition(param);
    }

    protected GLRptBaseConditionBuilder getConditionBuilder() {
        return new GLRptSubLedgerConditionBuilder();
    }

    public Map queryTree(Map condition) throws BOSException, EASBizException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        EntityViewInfo view = this.buildQueryCondition(condition);
        GLRptQueryResult result = GLRptAccountTreeFacadeFactory.getLocalInstance((Context)this.ctx).query(view);
        DefaultMutableTreeNode root = null;
        GLRptRowSet rowSet = result.getData();
        rowSet.beforeFirst();
        if (rowSet.next()) {
            root = (DefaultMutableTreeNode)rowSet.getObject("accountTree");
        }
        List list = this.populateTree(root);
        String firstNodeId = null;
        for (Object object : list) {
            Map node = (Map)object;
            if (node.get("userObject") instanceof AccountViewInfo) {
                AccountViewInfo info = (AccountViewInfo)node.get("userObject");
                firstNodeId = info.getId().toString();
                break;
            }
            node.put("open", true);
        }
        data.put("tree", list);
        data.put("firstNodeId", firstNodeId);
        return data;
    }

    private List populateTree(DefaultMutableTreeNode root) {
        ArrayList list = new ArrayList();
        this.populateNode(root, list, "");
        return list;
    }

    private void populateNode(DefaultMutableTreeNode node, List list, String pId) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("pId", pId);
        Object userObject = node.getUserObject();
        if (userObject instanceof String) {
            item.put("id", "root");
            item.put("name", userObject);
            item.put("userObject", userObject);
        } else if (userObject instanceof AccountTypeInfo) {
            AccountTypeInfo type = (AccountTypeInfo)userObject;
            item.put("id", type.getId().toString());
            item.put("name", type.getName());
            item.put("userObject", userObject);
        } else if (userObject instanceof AccountViewInfo) {
            AccountViewInfo view = (AccountViewInfo)userObject;
            item.put("id", view.getId().toString());
            item.put("name", view.getName());
            item.put("userObject", userObject);
        }
        list.add(item);
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)en.nextElement();
            this.populateNode(child, list, (String)item.get("id"));
        }
    }

    public Map query(Map condition) throws BOSException, EASBizException {
        Map data = super.query(condition);
        List columns = (List)data.get("columns");
        int accountDCIndex = -1;
        for (int i = 0; i < columns.size(); ++i) {
            GLRptTableHeadInfo.GLRptTableColumnInfo col = (GLRptTableHeadInfo.GLRptTableColumnInfo)columns.get(i);
            if (!col.getColName().equals("accountDC")) continue;
            col.setAlign(2);
            accountDCIndex = i;
        }
        List headTitless = (List)data.get("headTitless");
        if (accountDCIndex >= 0) {
            List headTitles = (List)headTitless.get(0);
            headTitles.set(accountDCIndex, "\u65b9\u5411");
        }
        return data;
    }

    protected EntityViewInfo buildQueryCondition(Map condition) throws EASBizException, BOSException {
        EntityViewInfo view = super.buildQueryCondition(condition);
        GLRptSubLedgerCondition cond = (GLRptSubLedgerCondition)view.get("GLFixCondition");
        Map obj = (Map)condition.get("rptFilter");
        if (obj == null || !(obj instanceof Map)) {
            return view;
        }
        Map rptFilter = obj;
        if ((obj = rptFilter.get("accounts")) instanceof List) {
            List list = (List)((Object)obj);
            AccountViewCollection accounts = new AccountViewCollection();
            HashSet<String> accountIdSet = new HashSet<String>();
            for (Object item : list) {
                if (!(item instanceof Map)) continue;
                Map accountMap = (Map)item;
                AccountViewInfo account = new AccountViewInfo();
                account.setId(BOSUuid.read((String)((String)accountMap.get("id"))));
                account.setNumber((String)accountMap.get("number"));
                Map caaMap = (Map)accountMap.get("cAA");
                if (caaMap != null) {
                    AsstAccountInfo caa = new AsstAccountInfo();
                    caa.setId(BOSUuid.read((String)((String)caaMap.get("id"))));
                    account.setCAA(caa);
                }
                if (cond.getCompany() != null && cond.getCompany().isIsBizUnit()) {
                    cond.setLeafAccount(account.isIsLeaf());
                }
                accountIdSet.add(account.getId().toString());
                accounts.add(account);
            }
            cond.setAccountIdSet(accountIdSet);
            cond.setAccounts(accounts);
        }
        if (condition.get("isShowAccount") != null) {
            view.put("isShowAccount", (Object)Boolean.TRUE);
        }
        return view;
    }
}

