/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AssistCustomizedDataTypeEnum;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyCollection;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyFactory;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyInfo;
import com.kingdee.eas.fi.gl.AssistCustomizedTypeInfo;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ServiceWebUtils {
    protected static String toPeriodString(PeriodInfo period) {
        StringBuffer periodStr = new StringBuffer();
        periodStr.append(period.getId());
        periodStr.append(";").append(period.getNumber());
        periodStr.append(";").append(period.isIsAdjustPeriod());
        return periodStr.toString();
    }

    protected static PeriodInfo toPeriodInfo(String periodStr) {
        if (periodStr == null || periodStr.trim().length() == 0) {
            return null;
        }
        PeriodInfo periodInfo = new PeriodInfo();
        String[] pIt = periodStr.split(";");
        periodInfo.setId(BOSUuid.read((String)pIt[0]));
        int period = Integer.valueOf(pIt[1]);
        periodInfo.setNumber(period);
        periodInfo.setPeriodYear(period / 100);
        periodInfo.setPeriodNumber(period % 100);
        periodInfo.setIsAdjustPeriod(Boolean.valueOf(pIt[2]).booleanValue());
        return periodInfo;
    }

    public static AssistCustomizedPropertyCollection getAccountCustProp(Context ctx, String accountId) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("isNecessary"));
        sic.add(new SelectorItemInfo("isCreditNecessary"));
        sic.add(new SelectorItemInfo("isDebitNecessary"));
        sic.add(new SelectorItemInfo("customizedType.id"));
        sic.add(new SelectorItemInfo("customizedType.name"));
        sic.add(new SelectorItemInfo("customizedType.mappingPropName"));
        sic.add(new SelectorItemInfo("customizedType.dataType"));
        sic.add(new SelectorItemInfo("customizedType.defaultQueryName"));
        sic.add(new SelectorItemInfo("customizedType.precision"));
        sic.add(new SelectorItemInfo("customizedType.isForCompany"));
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("seq"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("account.id", (Object)accountId));
        fic.add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        AssistCustomizedPropertyCollection coll = AssistCustomizedPropertyFactory.getLocalInstance((Context)ctx).getAssistCustomizedPropertyCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            AssistCustomizedPropertyInfo prop = coll.get(i);
            AssistCustomizedTypeInfo type = prop.getCustomizedType();
            if (type.getDataType() != AssistCustomizedDataTypeEnum.ENUM) continue;
            try {
                List enumList = EnumUtils.getEnumList(Class.forName(type.getDefaultQueryName()));
                Iterator it = enumList.iterator();
                ArrayList eList = new ArrayList();
                while (it.hasNext()) {
                    Enum e = (Enum)it.next();
                    HashMap<String, Object> eMap = new HashMap<String, Object>();
                    eMap.put("alias", e.getAlias(ctx.getLocale()));
                    eMap.put("value", e instanceof IntEnum ? Integer.valueOf(((IntEnum)e).getValue()) : (e instanceof StringEnum ? ((StringEnum)e).getValue() : null));
                    eList.add(eMap);
                }
                type.put("enumsource", eList);
                continue;
            }
            catch (Exception e) {
                throw new BOSException("", (Throwable)e);
            }
        }
        return coll;
    }
}

