/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.services.impl.rpt;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GLRptBaseConditionBuilder {
    public Map setCustomCondition(Context ctx, GLRptBaseCondition condition) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("company", condition.getCompanys());
        map.put("companyDisplayMode", condition.getCompanyDisplayMode().getValue());
        map.put("expandCompanyLevel", condition.getExpandCompanyLevel() <= 0 ? 1 : condition.getExpandCompanyLevel());
        map.put("accountTable", condition.getAccountTableId());
        map.put("periodType", condition.getPeriodTypeId());
        map.put("periodStart", condition.getPeriodYearStart() * 100 + condition.getPeriodNumberStart());
        map.put("periodEnd", condition.getPeriodYearEnd() * 100 + condition.getPeriodNumberEnd());
        map.put("currency", condition.getCurrencyID());
        map.put("optionPosting", condition.getOptionPosting());
        map.put("optionAmountZero", condition.isOptionAmountZero());
        map.put("optionBalanceZero", condition.isOptionBalanceZero());
        map.put("optionAmountAndBalZero", condition.isOptionAmountAndBalZero());
        map.put("showQty", condition.isShowQty());
        map.put("notIncluePLVoucher", condition.isNotIncluePLVoucher());
        return map;
    }

    protected GLRptBaseCondition getSimpleCustomCondition(Context ctx, Map map) {
        GLRptBaseCondition customCondition = this.createReportCondition();
        Object comObj = map.get("company");
        if (comObj instanceof List) {
            List companyList = (List)comObj;
            CompanyOrgUnitInfo[] companyArray = new CompanyOrgUnitInfo[companyList.size()];
            int j = companyList.size();
            for (int i = 0; i < j; ++i) {
                companyArray[i] = this.map2CompanyOrgUnitInfo((Map)companyList.get(i));
            }
            customCondition.setCompanys(companyArray);
        } else {
            customCondition.setCompanys(new CompanyOrgUnitInfo[]{this.map2CompanyOrgUnitInfo((Map)comObj)});
        }
        customCondition.setSelectedCompanys(customCondition.getCompanys());
        CompanyOrgUnitInfo[] coms = customCondition.getCompanys();
        if (coms != null && coms.length == 1) {
            customCondition.switchCompany(coms[0]);
        }
        Integer companyLevel = 1;
        if (!StringUtils.isEmpty((String)((String)map.get("expandCompanyLevel")))) {
            companyLevel = Integer.parseInt((String)map.get("expandCompanyLevel"));
        }
        customCondition.setExpandCompanyLevel(companyLevel.intValue());
        customCondition.setAccountTableId((String)map.get("accountTable"));
        customCondition.setPeriodTypeId((String)map.get("periodType"));
        int periodStart = Integer.parseInt((String)map.get("periodStart"));
        int periodEnd = Integer.parseInt((String)map.get("periodEnd"));
        customCondition.setPeriodYearStart(periodStart / 100);
        customCondition.setPeriodYearEnd(periodEnd / 100);
        customCondition.setPeriodNumberStart(periodStart % 100);
        customCondition.setPeriodNumberEnd(periodEnd % 100);
        Map objectCurrency = (Map)map.get("currency");
        customCondition.setCurrencyID((String)objectCurrency.get("value"));
        customCondition.setCurrencyName((String)objectCurrency.get("alias"));
        if (GLResUtil.getRes((String)"all_currency").equals((String)objectCurrency.get("value"))) {
            customCondition.setCurrencyID("AllCurrency");
        }
        customCondition.setOptionPosting(true);
        return customCondition;
    }

    protected CompanyOrgUnitInfo map2CompanyOrgUnitInfo(Map companyMap) {
        CompanyOrgUnitInfo info = this.assembleInfoObject(companyMap, CompanyOrgUnitInfo.class);
        Map accountTableMap = (Map)info.get("accountTable");
        AccountTableInfo atInfo = this.assembleInfoObject(accountTableMap, AccountTableInfo.class);
        info.setAccountTable(atInfo);
        Map baseCurrencyMap = (Map)info.get("baseCurrency");
        CurrencyInfo currencyInfo = this.assembleInfoObject(baseCurrencyMap, CurrencyInfo.class);
        info.setBaseCurrency(currencyInfo);
        Map accountPeriodTypeMap = (Map)info.get("accountPeriodType");
        PeriodTypeInfo accountPeriodTypeInfo = this.assembleInfoObject(accountPeriodTypeMap, PeriodTypeInfo.class);
        info.setAccountPeriodType(accountPeriodTypeInfo);
        Map reportCurrencyMap = (Map)info.get("reportCurrency");
        CurrencyInfo reportCurrencyInfo = this.assembleInfoObject(reportCurrencyMap, CurrencyInfo.class);
        info.setReportCurrency(reportCurrencyInfo);
        return info;
    }

    public GLRptBaseCondition getCustomCondition(Context ctx, Map map) {
        if (map.get("simpleQuery") != null) {
            return this.getSimpleCustomCondition(ctx, map);
        }
        return this.getAdvanceCustomCondition(ctx, map);
    }

    protected GLRptBaseCondition getAdvanceCustomCondition(Context ctx, Map map) {
        GLRptBaseCondition customCondition = this.createReportCondition();
        Object comObj = map.get("company");
        if (comObj instanceof List) {
            List companyList = (List)comObj;
            CompanyOrgUnitInfo[] companyArray = new CompanyOrgUnitInfo[companyList.size()];
            int j = companyList.size();
            for (int i = 0; i < j; ++i) {
                companyArray[i] = this.map2CompanyOrgUnitInfo((Map)companyList.get(i));
            }
            customCondition.setCompanys(companyArray);
        } else {
            customCondition.setCompanys(new CompanyOrgUnitInfo[]{this.map2CompanyOrgUnitInfo((Map)comObj)});
        }
        customCondition.setSelectedCompanys(customCondition.getCompanys());
        if (map.get("companyDisplayMode") != null) {
            CompanyDisplayModeEnum displayMode = CompanyDisplayModeEnum.getEnum((int)Integer.parseInt((String)map.get("companyDisplayMode")));
            customCondition.setCompanyDisplayMode(displayMode);
            if (CompanyDisplayModeEnum.enumerate.equals((Object)displayMode)) {
                customCondition.switchCompany(this.map2CompanyOrgUnitInfo((Map)map.get("enumerateCompany")));
            } else if (map.containsKey("virtualCompany")) {
                customCondition.setCompany(this.map2CompanyOrgUnitInfo((Map)map.get("virtualCompany")));
            } else if (customCondition.getCompanys() != null) {
                customCondition.switchCompany(customCondition.getCompanys()[0]);
            }
        } else if (customCondition.getCompanys() != null) {
            customCondition.switchCompany(customCondition.getCompanys()[0]);
        }
        Integer companyLevel = 1;
        if (!StringUtils.isEmpty((String)((String)map.get("expandCompanyLevel")))) {
            companyLevel = Integer.parseInt((String)map.get("expandCompanyLevel"));
        }
        customCondition.setExpandCompanyLevel(companyLevel.intValue());
        customCondition.setAccountTableId((String)map.get("accountTable"));
        customCondition.setPeriodTypeId((String)map.get("periodType"));
        int periodStart = Integer.parseInt((String)map.get("periodStart"));
        int periodEnd = Integer.parseInt((String)map.get("periodEnd"));
        customCondition.setPeriodYearStart(periodStart / 100);
        customCondition.setPeriodYearEnd(periodEnd / 100);
        customCondition.setPeriodNumberStart(periodStart % 100);
        customCondition.setPeriodNumberEnd(periodEnd % 100);
        Map objectCurrency = (Map)map.get("currency");
        customCondition.setCurrencyID((String)objectCurrency.get("value"));
        customCondition.setCurrencyName((String)objectCurrency.get("alias"));
        if (GLResUtil.getRes((String)"all_currency").equals((String)objectCurrency.get("value"))) {
            customCondition.setCurrencyID("AllCurrency");
        }
        customCondition.setOptionPosting(map.get("optionPosting") == null ? false : (Boolean)map.get("optionPosting"));
        customCondition.setOptionAmountZero(map.get("optionAmountZero") == null ? false : (Boolean)map.get("optionAmountZero"));
        customCondition.setOptionBalanceZero(map.get("optionBalanceZero") == null ? false : (Boolean)map.get("optionBalanceZero"));
        customCondition.setOptionAmountAndBalZero(map.get("optionAmountAndBalZero") == null ? false : (Boolean)map.get("optionAmountAndBalZero"));
        customCondition.setShowQty(map.get("showQty") == null ? false : (Boolean)map.get("showQty"));
        customCondition.setNotIncluePLVoucher(map.get("notIncluePLVoucher") == null ? false : (Boolean)map.get("notIncluePLVoucher"));
        return customCondition;
    }

    protected abstract GLRptBaseCondition createReportCondition();

    protected <T> T assembleInfoObject(Map map, Class<T> infoClz) {
        if (map != null && map.size() > 0) {
            try {
                T info = infoClz.newInstance();
                Set ks = map.keySet();
                Method m = infoClz.getMethod("put", String.class, Object.class);
                Method mLocal = infoClz.getMethod("put", String.class, Object.class, Locale.class);
                for (String key : ks) {
                    Object value = map.get(key);
                    if (value instanceof Map && ((Map)value).containsKey("l2")) {
                        Map valueMap = (Map)value;
                        Set ele = valueMap.entrySet();
                        for (Map.Entry me : ele) {
                            if (me.getValue() == null) continue;
                            mLocal.invoke(info, key, ((Map)value).get(me.getKey()), new Locale((String)me.getKey(), ""));
                        }
                        continue;
                    }
                    m.invoke(info, key, value);
                }
                return info;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

