/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.pcc.bsf.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FICCAnalysisReportImpl {
    private static final String SERVICE_CENTER = "EAS_BIZ_FICenterBaseService";
    private static final String PERMISSIONITEM_NAME = "fi_periodclose_center";

    public String getOrgString(List<String> orgIds) throws BOSException, EASBizException {
        StringBuffer orgBuf = new StringBuffer();
        if (orgIds != null && orgIds.size() > 0) {
            for (int i = 0; i < orgIds.size(); ++i) {
                orgBuf.append("'").append(orgIds.get(i)).append("',");
            }
            orgBuf.deleteCharAt(orgBuf.lastIndexOf(","));
        } else {
            orgBuf.append("''");
        }
        return orgBuf.toString();
    }

    public Map getFastCompletedCompanyInfo(Context ctx, List<String> orgIds, int period) throws BOSException, EASBizException, SQLException {
        HashMap companyInfo = new HashMap();
        StringBuffer buf = new StringBuffer();
        int k = 1;
        String languageType = LocaleUtils.getShortCode((Locale)ctx.getLocale());
        buf.append("select top 3 * from (select  t.fcompanyleadday completeDate,b.fname_").append(languageType).append(" companyName from \n");
        buf.append("(select distinct a.fcompanyid,a.fcompanyleadday \n");
        buf.append("from T_PCC_TaskExecution a \n");
        buf.append(" where a.fperiod = ").append(period);
        buf.append(" and a.fschedulestatus = 4 \n");
        buf.append(" and a.fcompanyid in (").append(this.getOrgString(orgIds)).append(")  ) t \n");
        buf.append(" inner join T_Org_Company b on t.fcompanyid = b.fid");
        buf.append(" order by t.fcompanyleadday desc ) f\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
        while (rs.next()) {
            HashMap<String, Object> comInfo = new HashMap<String, Object>();
            String name = rs.getString("companyName");
            int date = rs.getInt("completeDate");
            comInfo.put("name", name);
            comInfo.put("date", date);
            companyInfo.put(k++, comInfo);
        }
        return companyInfo;
    }

    public Map getSlowCompletedCompanyInfo(Context ctx, List<String> orgIds, int period) throws BOSException, EASBizException, SQLException {
        HashMap companyInfo = new HashMap();
        StringBuffer buf = new StringBuffer();
        int k = 1;
        String languageType = LocaleUtils.getShortCode((Locale)ctx.getLocale());
        buf.append("select top 3 * from (select  t.fcompanyleadday completeDate,b.fname_").append(languageType).append(" companyName from \n");
        buf.append("(select distinct a.fcompanyid,a.fcompanyleadday \n");
        buf.append("from T_PCC_TaskExecution a \n");
        buf.append(" where a.fperiod = ").append(period);
        buf.append(" and a.fschedulestatus = 4 \n");
        buf.append(" and a.fcompanyid in (").append(this.getOrgString(orgIds)).append(")  ) t \n");
        buf.append(" inner join T_Org_Company b on t.fcompanyid = b.fid");
        buf.append(" order by t.fcompanyleadday asc ) f\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
        while (rs.next()) {
            HashMap<String, Object> comInfo = new HashMap<String, Object>();
            String name = rs.getString("companyName");
            int date = rs.getInt("completeDate");
            comInfo.put("name", name);
            comInfo.put("date", date);
            companyInfo.put(k++, comInfo);
        }
        return companyInfo;
    }

    public Map<String, Object> getCompleteCompanyNum(Context ctx, List<String> orgIds, int period) throws BOSException, EASBizException, SQLException {
        HashMap<String, Object> CompleteNum = new HashMap<String, Object>();
        StringBuffer buf = new StringBuffer();
        buf.append("select sum(case when t.fcompanyleadday>=0 then 1 else 0 end) onTime, ");
        buf.append(" sum(case when t.fcompanyleadday<0 then 1 else 0 end) overTime \n");
        buf.append("from ( select distinct a.fcompanyid, a.fcompanyleadday ");
        buf.append(" from T_PCC_TaskExecution  a where \n");
        buf.append(" a.fperiod=").append(period);
        buf.append(" and a.fschedulestatus=4 \n");
        buf.append(" and a.fcompanyid in (").append(this.getOrgString(orgIds)).append(") \n");
        buf.append(" ) t");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
        if (rs.next()) {
            int onTime = rs.getInt("onTime");
            int overTime = rs.getInt("overTime");
            CompleteNum.put("onTime", onTime);
            CompleteNum.put("overTime", overTime);
        } else {
            CompleteNum.put("onTime", 0);
            CompleteNum.put("overTime", 0);
        }
        return CompleteNum;
    }

    public List<Object> getAllCompleteCompanyNum(Context ctx, List<String> orgIds, int period) throws BOSException, EASBizException, SQLException {
        ArrayList<Object> Complete = new ArrayList<Object>();
        StringBuffer buf = new StringBuffer();
        int begPeriod = (period / 100 - 1) * 100 + period % 100;
        buf.append("select t.periodName,sum(case when t.fcompanyleadday>=0 then 1 else 0 end) onTime, \n");
        buf.append("sum(case when t.fcompanyleadday<0 then 1 else 0 end) overTime from \n");
        buf.append("( select a.fperiod periodName ,a.fcompanyid, min(a.fcompanyleadday) fcompanyleadday \n");
        buf.append(" from T_PCC_TaskExecution  a where \n");
        buf.append(" a.fperiod >= ").append(begPeriod);
        buf.append(" and a.fperiod <= ").append(period);
        buf.append(" and a.fschedulestatus=4 \n");
        buf.append(" and a.fcompanyid in (").append(this.getOrgString(orgIds)).append(") \n");
        buf.append("group by  a.fperiod,a.fcompanyid  ) ").append("t group by t.periodName order by t.periodName asc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
        while (rs.next()) {
            HashMap<String, Object> CompleteNum = new HashMap<String, Object>();
            String periodName = rs.getInt("periodName") / 100 + "\u5e74" + rs.getInt("periodName") % 100 + "\u671f";
            int onTime = rs.getInt("onTime");
            int overTime = rs.getInt("overTime");
            CompleteNum.put("periodName", periodName);
            CompleteNum.put("onTime", onTime);
            CompleteNum.put("overTime", overTime);
            Complete.add(CompleteNum);
        }
        return Complete;
    }

    public Map getFastTaskInfo(Context ctx, List<String> orgIds, int period) throws BOSException, EASBizException, SQLException {
        HashMap procInfo = new HashMap();
        StringBuffer buf = new StringBuffer();
        int k = 1;
        String task = LocaleUtils.getShortCode((Locale)ctx.getLocale());
        buf.append("select top 3 * from ( ");
        buf.append(" select  b.fname_").append(task).append(" taskName, t.completeDate from ");
        buf.append(" ( select a.ftaskid,avg(a.fleadday) completeDate from T_PCC_TaskExecution a \n");
        buf.append(" where a.fperiod = ").append(period);
        buf.append(" and a.fstatus in ( 1,2) \n");
        buf.append(" and a.fcompanyid in (").append(this.getOrgString(orgIds)).append(") \n");
        buf.append(" group by a.ftaskid ) t  inner join T_PCC_Task b on t.ftaskid = b.fid order by t.completeDate desc ) \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
        while (rs.next()) {
            HashMap<String, Object> proc = new HashMap<String, Object>();
            String name = rs.getString("taskName");
            double date = rs.getDouble("completeDate");
            if (date - (double)((int)date) > 0.0) {
                date = (int)date + 1;
            } else if (date - (double)((int)date) < 0.0) {
                date = (int)date - 1;
            } else if (date - (double)((int)date) == 0.0) {
                date = (int)date;
            }
            proc.put("name", name);
            proc.put("date", date);
            procInfo.put(k++, proc);
        }
        return procInfo;
    }

    public Map getSlowTaskInfo(Context ctx, List<String> orgIds, int period) throws BOSException, EASBizException, SQLException {
        HashMap procInfo = new HashMap();
        StringBuffer buf = new StringBuffer();
        int k = 1;
        String task = LocaleUtils.getShortCode((Locale)ctx.getLocale());
        buf.append("select top 3 * from ( ");
        buf.append(" select  b.fname_").append(task).append(" taskName, t.completeDate from ");
        buf.append(" ( select a.ftaskid,avg(a.fleadday) completeDate from T_PCC_TaskExecution a \n");
        buf.append(" where a.fperiod = ").append(period);
        buf.append(" and a.fstatus in ( 1,2) \n");
        buf.append(" and a.fcompanyid in (").append(this.getOrgString(orgIds)).append(") \n");
        buf.append(" group by a.ftaskid ) t  inner join T_PCC_Task b on t.ftaskid = b.fid order by t.completeDate asc ) \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
        while (rs.next()) {
            HashMap<String, Object> proc = new HashMap<String, Object>();
            String name = rs.getString("taskName");
            double date = rs.getDouble("completeDate");
            if (date - (double)((int)date) > 0.0) {
                date = (int)date + 1;
            } else if (date - (double)((int)date) < 0.0) {
                date = (int)date - 1;
            } else if (date - (double)((int)date) == 0.0) {
                date = (int)date;
            }
            proc.put("name", name);
            proc.put("date", date);
            procInfo.put(k++, proc);
        }
        return procInfo;
    }
}

