/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.pcc.bsf.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.pcc.FIClosingCenterFacadeFactory;
import com.kingdee.eas.fi.pcc.SchedulePlanDateEnum;
import com.kingdee.eas.fi.pcc.StageStatusEnum;
import com.kingdee.eas.fi.pcc.bsf.IFIClosingCenterService;
import com.kingdee.eas.fi.pcc.bsf.PCCUtils;
import com.kingdee.eas.fi.pcc.bsf.impl.FICCAnalysisReportImpl;
import com.kingdee.eas.fi.pcc.bsf.impl.KeyTaskInfo;
import com.kingdee.eas.fi.pcc.bsf.impl.ScheduleInfo;
import com.kingdee.eas.fi.pcc.bsf.impl.SubTaskInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.pcc.bsf.IFIClosingCenterService"})
public class FIClosingCenterServiceImpl
implements IFIClosingCenterService {
    private static final String RESOURCE_FI_CC = "com.kingdee.eas.fi.pcc.FIClosingCenterResource";
    private Context ctx = null;

    public FIClosingCenterServiceImpl(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public List<String> getOrgIds(String filter, String permissionItem, String queryPeriodNo) throws BOSException, EASBizException {
        ArrayList<String> orgIds = new ArrayList<String>();
        StringBuffer sql = this.getOrgQuerySql(permissionItem, queryPeriodNo);
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.fi.pcc.app", (String)"TaskExecutionQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)queryPK);
        EntityViewInfo view = new EntityViewInfo();
        try {
            view.setFilter(filter);
            exec.setObjectView(view);
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        String querySql = exec.getSQL();
        boolean hasUnderwayDelay = false;
        if (querySql.indexOf("WHERE") != -1) {
            String filterSql = querySql.substring(querySql.indexOf("WHERE"));
            if (filterSql != null) {
                filterSql = filterSql.replace("\"TASKEXECUTION\".FScheduleStatus = '1'", "1=1");
                filterSql = filterSql.replace("\"TASKEXECUTION\".FScheduleStatus = 1", "1=1");
                filterSql = filterSql.replace("\"TASKEXECUTION\".FStageStatus = '1'", "1=1");
                if ((filterSql = filterSql.replace("\"TASKEXECUTION\".FStageStatus = 1", "1=1")).indexOf("\"TASKEXECUTION\".FStatus = 4") != -1 || filter.indexOf("\"TASKEXECUTION\".FStatus = '4'") != -1) {
                    filterSql = filterSql.replace("\"TASKEXECUTION\".FStatus = '4'", "1=1");
                    filterSql = filterSql.replace("\"TASKEXECUTION\".FStatus = 4", "1=1");
                    hasUnderwayDelay = true;
                }
            }
            sql.append(filterSql);
        }
        sql.append(" group by tmp2.FCompanyId, SCHEDULE.FID, SCHEDULE.FPlanDateTime, TASKEXECUTION.FStatus ");
        String execSql = sql.toString().replace("\"TASKEXECUTION\".FCompanyID", "COMPANY.FID");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)execSql);
        this.addOrgIds(orgIds, rs, hasUnderwayDelay, queryPeriodNo);
        return orgIds;
    }

    private StringBuffer getOrgQuerySql(String permissionItem, String periodNumber) throws EASBizException, BOSException {
        String permOrgIds = PCCUtils.getAuthOrgIdFilter(this.ctx, permissionItem);
        StringBuffer sql = new StringBuffer();
        sql.append("select tmp2.FCompanyId, SCHEDULE.FID FSCHEDULEID, SCHEDULE.FPlanDateTime, TASKEXECUTION.FStatus FStatus from \n");
        sql.append("  (select c.FID FCompanyID, t.FID FScheduleId \n");
        sql.append("  from t_org_company c \n");
        sql.append("  inner join t_pcc_taskSchedule t on c.FID=t.FCompanyId \n");
        sql.append("  where c.FID in  (").append(permOrgIds).append(") \n");
        sql.append("    union \n");
        sql.append("  select tmp1.FCompanyID FCompanyID, t1.FID FScheduleId \n");
        sql.append("  from \n");
        sql.append("    (select c.FId FCompanyID from t_org_company c \n");
        sql.append("    left outer join T_PCC_TaskSchedule t on c.FID=t.FCompanyId \n");
        sql.append("    where c.fid in (").append(permOrgIds).append(") ");
        sql.append("      and t.fCompanyid is null \n");
        sql.append("    group by c.FID) tmp1, T_PCC_TaskSchedule t1 \n");
        sql.append("  where t1.FCompanyId is null) tmp2 \n");
        sql.append("left outer join t_pcc_taskSchedule SCHEDULE on SCHEDULE.FID=tmp2.FScheduleId \n");
        sql.append("left outer join T_PCC_TaskExecution AS TASKEXECUTION \n");
        sql.append("  on TASKEXECUTION.FCompanyId=tmp2.FCompanyId and TASKEXECUTION.FTaskId=SCHEDULE.FTaskId ");
        sql.append("  and TASKEXECUTION.FPeriod = ").append(periodNumber).append(" \n");
        sql.append("left outer join T_PCC_Stage AS STAGE on SCHEDULE.FStageId=STAGE.FID \n");
        sql.append("left outer join T_PCC_Task AS TASK ON SCHEDULE.FTaskID=TASK.FID \n");
        sql.append("left outer join T_ORG_Company AS COMPANY on tmp2.FCompanyID = COMPANY.FID \n");
        sql.append("left outer join T_PM_User AS CREATOR ON SCHEDULE.FprincipalID = CREATOR.FID \n");
        return sql;
    }

    private void addOrgIds(List<String> orgIds, IRowSet rs, boolean hasUnderwayDelay, String queryPeriodNo) throws BOSException {
        Calendar calendar = Calendar.getInstance();
        try {
            while (rs.next()) {
                String orgId = rs.getString("FCompanyId");
                if (hasUnderwayDelay) {
                    String planDateValue = rs.getString("FPlanDateTime");
                    int year = Integer.parseInt(queryPeriodNo.substring(0, 4));
                    int month = Integer.parseInt(queryPeriodNo.substring(4, 6));
                    SchedulePlanDateEnum planDate = SchedulePlanDateEnum.getEnum((String)planDateValue);
                    if (planDate != null) {
                        Calendar date = planDate.getRepresentCalendarByPeriod(planDateValue, year, month);
                        int status = rs.getInt("FStatus");
                        if (status == 1 || status == 2 || (status == 0 || status == 3) && date.after(calendar)) continue;
                    }
                }
                if (orgIds.contains(orgId)) continue;
                orgIds.add(orgId);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public Map<String, Object> getSchedules(List<String> orgIds, String queryPeriodNo) throws BOSException, EASBizException {
        String[] companyIds = new String[orgIds.size()];
        companyIds = orgIds.toArray(companyIds);
        String sql = this.getSchedulesSql(queryPeriodNo, companyIds);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        return this.readSchedules(rs);
    }

    private String getSchedulesSql(String queryPeriodNo, String[] companyIds) {
        StringBuffer sql = new StringBuffer();
        sql.append("select tmp2.FCompanyID FCompanyID, o.FName_").append(this.ctx.getLocale()).append(" FCompanyName, \n");
        sql.append("  tmp2.FStageId FStageId, s.FName_").append(this.ctx.getLocale()).append(" FStageName, \n");
        sql.append("  tmp2.FTaskCount FTaskCount, tmp3.FStageStatus FStageStatus, tmp3.FCreateTime FCreateTime, \n");
        sql.append("  tmp3.FScheduleStatus FScheduleStatus, tmp3.FAccomplishedCount FAccomplishedCount \n");
        sql.append("from ( \n");
        sql.append("  select c.FID FCompanyID, t.FStageId FStageId, count(t.FTaskId) FTaskCount \n");
        sql.append("  from t_org_company c \n");
        sql.append("  inner join t_pcc_taskSchedule t on c.FID=t.FCompanyId \n");
        sql.append("  where c.FID in  (").append(PCCUtils.arrayToSql(companyIds)).append(") group by c.FID, t.FStageId \n");
        sql.append("    union \n");
        sql.append("  select tmp1.FCompanyID FCompanyID,t1.FStageId FStageId, count(t1.FTaskId) FTaskAmount \n");
        sql.append("  from ( \n");
        sql.append("    select c.FId FCompanyID from t_org_company c \n");
        sql.append("    left outer join T_PCC_TaskSchedule t on c.FID=t.FCompanyId \n");
        sql.append("    where c.fid in (").append(PCCUtils.arrayToSql(companyIds)).append(") ");
        sql.append("      and t.fCompanyid is null \n");
        sql.append("    group by c.FID ) tmp1, T_PCC_TaskSchedule t1 \n");
        sql.append("  where t1.FCompanyId is null group by tmp1.FCompanyID, t1.FStageId ) tmp2 \n");
        sql.append("inner join t_org_company o on o.FID=tmp2.FCompanyId \n");
        sql.append("inner join t_pcc_stage s on s.FID=tmp2.FStageId \n");
        sql.append("left outer join ( \n");
        sql.append("  select e.FCompanyId FCompanyId, tmpp2.FStageId FstageId, e.FStageStatus FStageStatus, \n");
        sql.append("    e.FScheduleStatus FScheduleStatus, max(e.FCreateTime) FCreateTime, \n");
        sql.append("    count(case when e.FStatus in (").append(1).append(",");
        sql.append(2).append(") then ");
        sql.append("    e.FTaskId else null end) FAccomplishedCount \n");
        sql.append("  from \n");
        sql.append("    (select cc.FID FCompanyID, tt.FStageId FStageId, tt.FTaskId FTaskId \n");
        sql.append("    from t_org_company cc \n");
        sql.append("    inner join t_pcc_taskSchedule tt on cc.FID=tt.FCompanyId \n");
        sql.append("    where cc.FID in  (").append(PCCUtils.arrayToSql(companyIds)).append(") \n");
        sql.append("      union \n");
        sql.append("    select tmpp1.FCompanyID FCompanyID,tt1.FStageId FStageId, tt1.FTaskId FTaskId \n");
        sql.append("    from ( \n");
        sql.append("      select cc.FId FCompanyID from t_org_company cc \n");
        sql.append("      left outer join T_PCC_TaskSchedule t on cc.FID=t.FCompanyId \n");
        sql.append("      where cc.fid in (").append(PCCUtils.arrayToSql(companyIds)).append(") ");
        sql.append("        and t.fCompanyid is null \n");
        sql.append("      group by cc.FID ) tmpp1, T_PCC_TaskSchedule tt1 \n");
        sql.append("    where tt1.FCompanyId is null ) tmpp2 \n");
        sql.append("  inner join T_PCC_TaskExecution e on e.FCompanyId=tmpp2.FCompanyId and e.FTaskId=tmpp2.FTaskId \n");
        sql.append("  where e.Fperiod=").append(queryPeriodNo).append(" and e.FLastUpdateTime is not null \n");
        sql.append("  group by e.FCompanyId, tmpp2.FStageId, e.FStageStatus, e.FScheduleStatus) tmp3 \n");
        sql.append("  on tmp3.FCompanyId=tmp2.FCompanyId and tmp3.FStageId=tmp2.FStageId \n");
        sql.append("order by o.Fnumber asc, s.FSeq asc \n");
        return sql.toString();
    }

    private Map<String, Object> readSchedules(IRowSet rs) throws BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<ScheduleInfo> orgSchedules = new ArrayList<ScheduleInfo>();
        ArrayList<KeyTaskInfo> keyTasks = null;
        CompanyOrgUnitInfo orgUnit = null;
        ScheduleInfo schedule = null;
        String lastOrgId = null;
        try {
            while (rs.next()) {
                String orgId = rs.getString("FCompanyId");
                if (this.isNewOrg(lastOrgId, orgId)) {
                    keyTasks = new ArrayList<KeyTaskInfo>();
                    orgUnit = new CompanyOrgUnitInfo();
                    schedule = new ScheduleInfo();
                    orgUnit.setId(BOSUuid.read((String)rs.getString("FCompanyId")));
                    orgUnit.setName(rs.getString("FCompanyName"));
                    schedule.setKeyTasks(keyTasks);
                    schedule.setOrgUnit(orgUnit);
                    schedule.setScheduleStatus(StageStatusEnum.getEnum((int)rs.getInt("FScheduleStatus")));
                    orgSchedules.add(schedule);
                }
                keyTasks.add(KeyTaskInfo.read(rs));
                lastOrgId = orgId;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.calcMaxKeyTaskCount(orgSchedules);
        result.put("orgSchedules", orgSchedules);
        result.put("orgs", orgSchedules.size());
        return result;
    }

    private boolean isNewOrg(String lastOrgId, String orgId) {
        return lastOrgId == null || !lastOrgId.equals(orgId);
    }

    private void calcMaxKeyTaskCount(List<ScheduleInfo> orgSchedules) {
        int i;
        int maxKeyTaskCount = 0;
        for (i = 0; i < orgSchedules.size(); ++i) {
            ScheduleInfo schedule = orgSchedules.get(i);
            int size = schedule.getKeyTasks().size();
            if (size <= maxKeyTaskCount) continue;
            maxKeyTaskCount = size;
        }
        for (i = 0; i < orgSchedules.size(); ++i) {
            orgSchedules.get(i).setMaxKeyTaskCount(maxKeyTaskCount);
        }
    }

    @Override
    public List<Object> getSubTasks(String orgId, String periodNumber) throws BOSException, EASBizException {
        boolean isOrgSetting = this.isOrgSetting(this.ctx, orgId);
        StringBuffer sql = this.getSubTaskSql(orgId, periodNumber);
        if (isOrgSetting) {
            sql.append("where s.FCompanyId='").append(orgId).append("' ");
        } else {
            sql.append("where s.FCompanyId is null ");
        }
        sql.append(" order by tg.FSeq asc, s.FSeq asc ");
        ArrayList<Object> subTasks = new ArrayList<Object>();
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                subTasks.add(SubTaskInfo.read(rs, periodNumber));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return subTasks;
    }

    private StringBuffer getSubTaskSql(String orgId, String periodNumber) {
        StringBuffer sql = new StringBuffer();
        sql.append("select e.FID FID, s.FPlanDateTime FPlanDateTime, e.FStatus FStatus, \n");
        sql.append("e.FStageStatus FStageStatus, e.FScheduleStatus FScheduleStatus, \n");
        sql.append("case when e.FStatus in (").append(1).append(", ");
        sql.append(2).append(") then ");
        sql.append("  e.FCreateTime else null end FCreateTime, \n");
        sql.append("tk.FName_").append(this.ctx.getLocale()).append(" FTaskName, \n");
        sql.append("tk.Ftype Ftype, tk.FID FTaskId, s.FPrincipalId FPersonId, \n");
        sql.append("u.FName_").append(this.ctx.getLocale()).append(" FUSerName, \n");
        sql.append("tg.FName_").append(this.ctx.getLocale()).append(" FStageName \n");
        sql.append("from T_PCC_TaskSchedule s \n");
        sql.append("  left outer join ( \n");
        sql.append("  \tselect t.FID FID, t.FTaskID FTaskId from T_PCC_TaskExecution t \n");
        sql.append("    inner join t_pcc_task task on task.FID = t.FTaskId \n");
        sql.append("  \twhere (t.FLastUpdateTime is not null or task.Ftype = 0) and t.FCompanyId='").append(orgId).append("' \n");
        sql.append("   \t  and t.FPeriod=").append(periodNumber).append(" \n");
        sql.append(") tmp on tmp.FTaskId = s.FtaskId \n");
        sql.append("  left outer join T_PCC_TaskExecution e on e.FID = tmp.FID \n");
        sql.append("  left outer join t_pcc_stage tg on tg.FID = s.FStageId \n");
        sql.append("  left outer join t_pcc_task tk on tk.FID = s.FTaskId  \n");
        sql.append("  left outer join t_pm_user u on u.FID = s.FPrincipalId \n");
        sql.append("  left outer join t_bd_person p on p.FID = u.FPersonId \n");
        return sql;
    }

    @Override
    public void markTask(String orgId, int period, String taskId) throws BOSException, EASBizException {
        boolean isReverse = false;
        StringBuffer sql = new StringBuffer();
        sql.append("select FStatus FStatus from T_PCC_TaskExecution  \n");
        sql.append("where ftaskid='").append(taskId).append("' and Fperiod=").append(period);
        sql.append("  and FCompanyId='").append(orgId).append("' ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            if (rs.next() && (rs.getInt("FStatus") == 1 || rs.getInt("FStatus") == 2)) {
                isReverse = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        FIClosingCenterFacadeFactory.getLocalInstance((Context)this.ctx).markTask(orgId, taskId, period, isReverse);
    }

    private boolean isOrgSetting(Context ctx, String orgId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 fid from T_PCC_TaskSchedule where FCompanyId='").append(orgId).append("' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs != null && rs.size() > 0;
    }

    @Override
    public Map<String, Object> getCompleteTaskProcInfo(List<String> orgIds, int period) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FICCAnalysisReportImpl analysiz = new FICCAnalysisReportImpl();
        Map fastCompany = new HashMap();
        Map slowCompany = new HashMap();
        Map fastTask = new HashMap();
        Map slowTask = new HashMap();
        Map<Object, Object> completeCompany = new HashMap();
        List<Object> allCompleteCompany = new ArrayList();
        try {
            fastCompany = analysiz.getFastCompletedCompanyInfo(this.ctx, orgIds, period);
            slowCompany = analysiz.getSlowCompletedCompanyInfo(this.ctx, orgIds, period);
            fastTask = analysiz.getFastTaskInfo(this.ctx, orgIds, period);
            slowTask = analysiz.getSlowTaskInfo(this.ctx, orgIds, period);
            completeCompany = analysiz.getCompleteCompanyNum(this.ctx, orgIds, period);
            allCompleteCompany = analysiz.getAllCompleteCompanyNum(this.ctx, orgIds, period);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        result.put("fastCompany", fastCompany);
        result.put("slowCompany", slowCompany);
        result.put("fastTask", fastTask);
        result.put("slowTask", slowTask);
        result.put("completeCompany", completeCompany);
        result.put("allCompleteCompany", allCompleteCompany);
        return result;
    }
}

