/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rc.bsf.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.IService;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.service.ServiceFactory;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rc.ContrastCenterFacadeFactory;
import com.kingdee.eas.fi.rc.bsf.ContrastCenterService;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.rc.bsf.ContrastCenterService"})
public class ContrastCenterServiceImpl
extends BusinessServices
implements ContrastCenterService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.rc.bsf.impl.ContrastCenterServiceImpl");

    public ContrastCenterServiceImpl(Context context) {
        super(context);
    }

    @Override
    public OrgUnitInfo[] getContrastCompanyCollection() throws EASBizException, BOSException {
        IService service = ServiceFactory.getLocalInstance((Context)this.getContext());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("permissionItem", "fi_contrast_center");
        String result = service.invoke("EAS_BIZ_FICenterBaseService", "getFuncPermissionOrgUnitCollection", JSONUtils.convertObjectToJson((Context)this.getContext(), param));
        OrgUnitInfo[] orgUnitInfo = new OrgUnitInfo[1];
        return (OrgUnitInfo[])JSONUtils.convertJsonToObject((Context)this.getContext(), (String)result, orgUnitInfo.getClass());
    }

    @Override
    public List<SystemEnum> getSubSystemCollection() throws EASBizException, BOSException {
        ArrayList<SystemEnum> result = new ArrayList<SystemEnum>();
        String sql = "select FSubSystem from T_RC_SubSystem order by FSeq asc";
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        try {
            while (rs.next()) {
                int subSystemValue = rs.getInt("FSubSystem");
                SystemEnum subSystemEnum = SystemEnum.getEnum((int)subSystemValue);
                result.add(subSystemEnum);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public int contrast(String companyId, int system, int period) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        PeriodInfo periodInfo = this.getPeriodInfo(companyInfo, period);
        return ContrastCenterFacadeFactory.getLocalInstance((Context)this.getContext()).contrast(companyInfo, system, periodInfo);
    }

    private PeriodInfo getPeriodInfo(CompanyOrgUnitInfo companyInfo, int period) throws EASBizException, BOSException {
        int PeriodYear = period / 100;
        int PeriodNumber = period % 100;
        PeriodTypeInfo periodType = companyInfo.getAccountPeriodType();
        return PeriodFactory.getLocalInstance((Context)this.getContext()).getPeriodInfo(PeriodYear, PeriodNumber, periodType);
    }
}

