<Data version="20170616">
	<Sources>
		<BizMetaSource name="s1659601325483" bizMetaType="EASDBCenter" dbCenterId="SSC820" type="BizMeta">
			<UserSQLs>
				<UserSQL name="dm1659610316006" sqlType="KSQL"><![CDATA[SELECT 

"RISKRECORD".FID AS "ID", 
"RISKRECORD".FCreateTime AS "CREATETIME", 
"RISKRECORD".FBillNumber AS "BILLNUMBER", 
"RISKRECORD".FResult AS "RESULT", 
"RISKRECORD".FMsg AS "MSG", 
"RISKRECORD".FBatchNumber AS "BATCHNUMBER", 
"RISKRECORD".FBillId AS "BILLID", 
"RISKRECORD".FBizObjId AS "BIZOBJID", 
"RISKMODEL".FControlModel AS "RISKMODEL.CONTROLMODEL", 
"RISKMODEL".FName_l2 AS "RISKMODEL.NAME", 
"RISKMODEL".FNumber AS "RISKMODEL.NUMBER", 
"RISKRECORD".FBizObjId AS "RISKMODEL.ID", 
"BILLTYPE".FParentId AS "PARENT.ID", 
"PARENT".FName_l2 AS "PARENT.NAME", 
"BILLTYPE".FBillEntity AS "BILLTYPE.BILLENTITY", 
"BILLTYPE".FName_l2 AS "BILLTYPE.NAME", 
"BILLTYPE".FNumber AS "BILLTYPE.NUMBER", 
"RISKMODEL".FTargetBillTypeId AS "BILLTYPE.ID", 
"RISKFACTORS".FName_l2 AS "RISKFACTORS.NAME", 
"RISKFACTORS".FState AS "RISKFACTORS.STATE", 
"RISKFACTORS".FNumber AS "RISKFACTORS.NUMBER", 
"RISKMODEL".FRiskFactorsId AS "RISKFACTORS.ID", 
"BILLUSER".FNumber AS "BILLUSER.NUMBER", 
"BILLUSER".FName_l2 AS "BILLUSER.NAME", 
"RISKRECORD".FBillUserId AS "BILLUSER.ID", 
"USER".FNumber AS "USER.NUMBER", 
"USER".FName_l2 AS "USER.NAME", 
"RISKRECORD".FCreatorID AS "USER.ID", 
"RISKMODEL".FID AS "MODELORG.ORGID", 
"RISKRECORD".FBillMainOrgId AS "FULLORGUNIT.ID", 
"FULLORGUNIT".FName_l2 AS "FULLORGUNIT.NAME", 
"FULLORGUNIT".FNumber AS "FULLORGUNIT.NUMBER", 
"RISKMODEL".FCheckGroupId AS "CHECKGROUP.ID", 
"CHECKGROUP".FName_l2 AS "CHECKGROUP.NAME", 
"RISKMODEL".FCompareInOrder AS "RISKMODEL.COMPAREINORDER"

FROM T_RIS_RiskRecord AS "RISKRECORD"

LEFT OUTER JOIN T_RIS_RiskModel AS "RISKMODEL"
ON "RISKRECORD".FBizObjId = "RISKMODEL".FID

LEFT OUTER JOIN T_PM_User AS "BILLUSER"
ON "RISKRECORD".FBillUserId = "BILLUSER".FID

LEFT OUTER JOIN T_PM_User AS "USER"
ON "RISKRECORD".FCreatorID = "USER".FID

LEFT OUTER JOIN T_ORG_BaseUnit AS "FULLORGUNIT"
ON "RISKRECORD".FBillMainOrgId = "FULLORGUNIT".FID

LEFT OUTER JOIN T_RIS_BillType AS "BILLTYPE"
ON "RISKMODEL".FTargetBillTypeId = "BILLTYPE".FID

LEFT OUTER JOIN T_RIS_RiskFactors AS "RISKFACTORS"
ON "RISKMODEL".FRiskFactorsId = "RISKFACTORS".FID

LEFT OUTER JOIN T_RIS_ModelOrg AS "MODELORG"
ON "RISKRECORD".FBizObjId = "MODELORG".FOrgId

LEFT OUTER JOIN T_RIS_CheckGroup AS "CHECKGROUP"
ON "RISKMODEL".FCheckGroupId = "CHECKGROUP".FID

LEFT OUTER JOIN T_RIS_BillType AS "PARENT"
ON "BILLTYPE".FParentId = "PARENT".FID

inner join (
	 SELECT BaseUnit.Flongnumber forglongnumber FROM T_ORG_BaseUnit BaseUnit  WHERE EXISTS (  SELECT 1 FROM T_PM_UserOrgPerm USERORGPERM  WHERE UserOrgPerm.FOwner = '@USER_ID' AND UserOrgPerm.FPermItemID = '821ff1f4-de8e-4fe9-b042-6f7ab328e82dPERMITEM'AND UserOrgPerm.FPermType = 10 AND USERORGPERM.Forgid = BaseUnit.fid  UNION ALL  SELECT 1 FROM T_PM_RolePerm RolePerm  INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON RolePerm.FRoleID = UserRoleOrg.FRoleID  WHERE UserRoleOrg.FUserID = '@USER_ID' AND RolePerm.FPermItemID = '821ff1f4-de8e-4fe9-b042-6f7ab328e82dPERMITEM' AND RolePerm.FPermType = 10 AND UserRoleOrg.Forgid = BaseUnit.fid )  AND BaseUnit.FID NOT in ( select v.orgId from ( SELECT USERORGPERM.Forgid orgId FROM T_PM_UserOrgPerm UserOrgPerm  WHERE UserOrgPerm.FOwner = '@USER_ID' AND UserOrgPerm.FPermItemID = '821ff1f4-de8e-4fe9-b042-6f7ab328e82dPERMITEM' AND UserOrgPerm.FPermType = 20 UNION ALL  SELECT UserRoleOrg.Forgid orgId FROM T_PM_RolePerm RolePerm  INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON  RolePerm.FRoleID = UserRoleOrg.FRoleID  WHERE UserRoleOrg.FUserID = '@USER_ID' AND RolePerm.FPermItemID ='821ff1f4-de8e-4fe9-b042-6f7ab328e82dPERMITEM' AND RolePerm.FPermType = 20) v )
)temp ON "FULLORGUNIT".FLONGNUMBER LIKE CONCAT(temp.forglongnumber ,'%')]]></UserSQL>
			</UserSQLs>
		</BizMetaSource>
	</Sources>
	<ExtractSchedule dayAtMonthly="0" weekAtWeekly="1" time="75600" />
	<Entities>
		<Entity name="dm1659610316006" alias="风控执行日志监控查询" associateName="dm1659610316006" directModel="false" source="s1659601325483">
			<Design x="633" y="24" width="200" height="90" />
			<Properties>
				<Property name="ID" associateName="ID" alias="风控执行id" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="CREATETIME" associateName="CREATETIME" alias="执行时间" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="BILLNUMBER" associateName="BILLNUMBER" alias="单据编号" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="RESULT" associateName="RESULT" alias="执行结果_原始" dataType="NUMBER" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="MSG" associateName="MSG" alias="执行结果描述" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="BATCHNUMBER" associateName="BATCHNUMBER" alias="执行批次号" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="BILLID" associateName="BILLID" alias="单据id" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="BIZOBJID" associateName="BIZOBJID" alias="业务对象id" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="RISKMODEL_CONTROLMODEL" associateName="RISKMODEL.CONTROLMODEL" alias="控制方式_原始" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="RISKMODEL_NAME" associateName="RISKMODEL.NAME" alias="风控模型名称" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="RISKMODEL_NUMBER" associateName="RISKMODEL.NUMBER" alias="风控模型编码" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="RISKMODEL_ID" associateName="RISKMODEL.ID" alias="控制方式id" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="PARENT_ID" associateName="PARENT.ID" alias="业务模块id" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="PARENT_NAME" associateName="PARENT.NAME" alias="业务模块" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="BILLTYPE_BILLENTITY" associateName="BILLTYPE.BILLENTITY" alias="表单实体" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="BILLTYPE_NAME" associateName="BILLTYPE.NAME" alias="单据类型名称" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="BILLTYPE_NUMBER" associateName="BILLTYPE.NUMBER" alias="单据类型编码" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="BILLTYPE_ID" associateName="BILLTYPE.ID" alias="表单实体id" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="RISKFACTORS_NAME" associateName="RISKFACTORS.NAME" alias="风险因子名称" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="RISKFACTORS_STATE" associateName="RISKFACTORS.STATE" alias="风险因子状态" dataType="NUMBER" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="RISKFACTORS_NUMBER" associateName="RISKFACTORS.NUMBER" alias="风险因子编码" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="RISKFACTORS_ID" associateName="RISKFACTORS.ID" alias="风险因子id" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="BILLUSER_NUMBER" associateName="BILLUSER.NUMBER" alias="制单人编码" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="BILLUSER_NAME" associateName="BILLUSER.NAME" alias="制单人名称" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="BILLUSER_ID" associateName="BILLUSER.ID" alias="制单人id" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="USER_NUMBER" associateName="USER.NUMBER" alias="风控执行用户名" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="USER_NAME" associateName="USER.NAME" alias="风控执行用户实名" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="USER_ID" associateName="USER.ID" alias="风控执行用户id" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="MODELORG_ORGID" associateName="MODELORG.ORGID" alias="组织id" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="FULLORGUNIT_ID" associateName="FULLORGUNIT.ID" alias="主业务组织id" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="FULLORGUNIT_NAME" associateName="FULLORGUNIT.NAME" alias="主业务组织名称" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FULLORGUNIT_NUMBER" associateName="FULLORGUNIT.NUMBER" alias="主业务组织编码" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="CHECKGROUP_ID" associateName="CHECKGROUP.ID" alias="风险点分组id" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="CHECKGROUP_NAME" associateName="CHECKGROUP.NAME" alias="风险点分组名称" dataType="STRING" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="RISKMODEL_COMPAREINORDER" associateName="RISKMODEL.COMPAREINORDER" alias="本单内比较" dataType="NUMBER" appointedDataType="STRING" hide="true" hideInDataModeling="false" />
				<Property name="F1659611408161" associateName="F1659611408161" alias="风险因子" dataType="STRING" formula="IF([RISKMODEL_COMPAREINORDER]=1,&quot;本单内比较&quot;,[RISKFACTORS_NAME])" hideInDataModeling="false" />
				<Property name="F1659611431655" associateName="F1659611431655" alias="风险点分组" dataType="STRING" formula="IF([CHECKGROUP_ID]=&quot;&quot;,&quot;无&quot;,[CHECKGROUP_NAME])" hideInDataModeling="false" />
				<Property name="F1659611462073" associateName="F1659611462073" alias="执行结果" dataType="STRING" formula="CASE([RESULT] = 1 , &quot;通过&quot;,[RESULT] = 0 , &quot;不通过&quot;,[RESULT])" hideInDataModeling="false" />
				<Property name="F1662446826836" associateName="F1662446826836" alias="控制方式" dataType="STRING" formula="CASE([RISKMODEL_CONTROLMODEL] = 'POTIPS','风险数据洞察',[RISKMODEL_CONTROLMODEL] = 'BILLOPER','前端操作控制',[RISKMODEL_CONTROLMODEL] = 'FUNCONTROL','后台自动控制',[RISKMODEL_CONTROLMODEL] = 'ROBOT','机器人控制')" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
	</Entities>
	<Relations />
	<UnionEntityInnerRelations />
</Data>