/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.schema;

import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlAlterTableAddItem;
import com.kingdee.bos.sql.dom.SqlColumnDef;
import com.kingdee.bos.sql.dom.SqlInsert;
import com.kingdee.bos.sql.dom.SqlOrderByItem;
import com.kingdee.bos.sql.dom.SqlTableCheck;
import com.kingdee.bos.sql.dom.SqlTableForeignKey;
import com.kingdee.bos.sql.dom.SqlTablePrimaryKey;
import com.kingdee.bos.sql.dom.SqlTableUnique;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlNullExpr;
import com.kingdee.bos.sql.dom.stmt.SqlAlterTableStmt;
import com.kingdee.bos.sql.dom.stmt.SqlCreateIndexStmt;
import com.kingdee.bos.sql.dom.stmt.SqlCreateTableStmt;
import com.kingdee.bos.sql.dom.stmt.SqlInsertStmt;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.formater.MSTransactSQLFormater;
import com.kingdee.bos.sql.formater.SQLFormater;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.bos.sql.schema.SqlColumn;
import com.kingdee.bos.sql.schema.SqlTable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Sql2kUtil {
    public static String generateSchemaSql(Connection conn, SQLFormater formater) throws SQLException, FormaterException, ParserException {
        StringBuffer buffer = new StringBuffer();
        formater.setBuffer(buffer);
        buffer.append("\n\n\n\n/* create talbe */\n\n");
        Collection stmt = Sql2kUtil.generateCreateTableSqlDom(conn);
        formater.format(stmt);
        buffer.append("\n\n\n\n/* create primary key */\n\n");
        stmt = Sql2kUtil.generatePkSqlDom(conn);
        formater.format(stmt);
        buffer.append("\n\n\n\n/* create unique */\n\n");
        stmt = Sql2kUtil.generateUniqueSqlDom(conn);
        formater.format(stmt);
        buffer.append("\n\n\n\n/* create foreign key */\n\n");
        stmt = Sql2kUtil.generateFkSqlDom(conn);
        formater.format(stmt);
        buffer.append("\n\n\n\n/* create check */\n\n");
        stmt = Sql2kUtil.generateCheckSqlDom(conn);
        formater.format(stmt);
        buffer.append("\n\n\n\n/* create index */\n\n");
        stmt = Sql2kUtil.generateCreateIndexSqlDom(conn);
        formater.format(stmt);
        return buffer.toString();
    }

    public static String generateTableDDL(Connection conn, SqlTable table, SQLFormater formater) throws SQLException, FormaterException, ParserException {
        StringBuffer buffer = new StringBuffer();
        formater.setBuffer(buffer);
        buffer.append("\n\n\n\n/* create talbe */\n\n");
        SqlCreateTableStmt stmt = Sql2kUtil.buildCreateTableStmt(table);
        formater.formatStmt(stmt);
        buffer.append("\n\n\n\n/* create primary key */\n\n");
        Collection stmtCol = Sql2kUtil.buildPkStmt(conn, table);
        formater.format(stmtCol);
        buffer.append("\n\n\n\n/* create unique */\n\n");
        stmtCol = Sql2kUtil.buildUniqueStmt(conn, table);
        formater.format(stmtCol);
        buffer.append("\n\n\n\n/* create foreign key */\n\n");
        stmtCol = Sql2kUtil.buildFkStmt(conn, table);
        formater.format(stmtCol);
        buffer.append("\n\n\n\n/* create check */\n\n");
        stmtCol = Sql2kUtil.buildCheckStmt(conn, table);
        formater.format(stmtCol);
        buffer.append("\n\n\n\n/* create index */\n\n");
        stmtCol = Sql2kUtil.buildCreateIndexStmt(conn, table);
        formater.format(stmtCol);
        return buffer.toString();
    }

    public static String generateDataSql(Connection conn) throws SQLException, FormaterException, ParserException {
        MSTransactSQLFormater formater = new MSTransactSQLFormater();
        StringBuffer buffer = formater.getBuffer();
        buffer.append("\n\n\n\n/* insert data */\n\n");
        Collection stmt = Sql2kUtil.buildDataStmtSql(conn);
        formater.format(stmt);
        return buffer.toString();
    }

    public static Collection generatePkSqlDom(Connection conn) throws SQLException {
        ArrayList pkStmtList = new ArrayList();
        ArrayList tableList = Sql2kUtil.getUserTables(conn);
        for (SqlTable table : tableList) {
            Collection list = Sql2kUtil.buildPkStmt(conn, table);
            pkStmtList.addAll(list);
        }
        return pkStmtList;
    }

    public static Collection generateUniqueSqlDom(Connection conn) throws SQLException {
        ArrayList pkStmtList = new ArrayList();
        ArrayList tableList = Sql2kUtil.getUserTables(conn);
        for (SqlTable table : tableList) {
            Collection list = Sql2kUtil.buildUniqueStmt(conn, table);
            pkStmtList.addAll(list);
        }
        return pkStmtList;
    }

    public static Collection generateFkSqlDom(Connection conn) throws SQLException {
        ArrayList pkStmtList = new ArrayList();
        ArrayList tableList = Sql2kUtil.getUserTables(conn);
        for (SqlTable table : tableList) {
            Collection list = Sql2kUtil.buildFkStmt(conn, table);
            pkStmtList.addAll(list);
        }
        return pkStmtList;
    }

    public static Collection generateCheckSqlDom(Connection conn) throws SQLException, ParserException {
        ArrayList pkStmtList = new ArrayList();
        ArrayList tableList = Sql2kUtil.getUserTables(conn);
        for (SqlTable table : tableList) {
            Collection list = Sql2kUtil.buildCheckStmt(conn, table);
            pkStmtList.addAll(list);
        }
        return pkStmtList;
    }

    public static Collection generateCreateIndexSqlDom(Connection conn) throws SQLException {
        ArrayList pkStmtList = new ArrayList();
        ArrayList tableList = Sql2kUtil.getUserTables(conn);
        for (SqlTable table : tableList) {
            Collection list = Sql2kUtil.buildCreateIndexStmt(conn, table);
            pkStmtList.addAll(list);
        }
        return pkStmtList;
    }

    public static Collection buildDataStmtSql(Connection conn) throws SQLException {
        ArrayList pkStmtList = new ArrayList();
        ArrayList tableList = Sql2kUtil.getUserTables(conn);
        for (SqlTable table : tableList) {
            Collection list = Sql2kUtil.buildDataStmtSql(conn, table);
            pkStmtList.addAll(list);
        }
        return pkStmtList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection buildDataStmtSql(Connection conn, SqlTable table) throws SQLException {
        ArrayList<SqlInsertStmt> insertStmtList = new ArrayList<SqlInsertStmt>();
        String sql = "select * from " + table.name;
        Statement stmt = conn.createStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                Iterator colIter = table.columns.iterator();
                SqlInsert insert = new SqlInsert(table.name);
                int colIndex = 1;
                while (colIter.hasNext()) {
                    SqlColumn col = (SqlColumn)colIter.next();
                    String colName = col.name;
                    insert.columnList.add(new SqlIdentifierExpr(colName));
                    if (col.dataType.equalsIgnoreCase("bigint")) {
                        long Value = rs.getLong(colIndex);
                        if (rs.wasNull()) {
                            insert.valueList.add(SqlNullExpr.instance);
                        } else {
                            insert.valueList.add(SqlExpr.toExpr(Value));
                        }
                    } else if (col.dataType.equalsIgnoreCase("binary")) {
                        byte[] value = rs.getBytes(colIndex);
                        insert.valueList.add(SqlExpr.toExpr(value));
                    } else if (col.dataType.equalsIgnoreCase("bit")) {
                        int Value = rs.getInt(colIndex);
                        if (rs.wasNull()) {
                            insert.valueList.add(SqlNullExpr.instance);
                        } else {
                            insert.valueList.add(SqlExpr.toExpr(Value));
                        }
                    } else if (col.dataType.equalsIgnoreCase("char")) {
                        String value = rs.getString(colIndex);
                        insert.valueList.add(SqlExpr.toCharExpr(value));
                    } else if (col.dataType.equalsIgnoreCase("datetime")) {
                        Timestamp value = rs.getTimestamp(colIndex);
                        insert.valueList.add(SqlExpr.toExpr(value));
                    } else if (col.dataType.equalsIgnoreCase("decimal")) {
                        BigDecimal value = rs.getBigDecimal(colIndex);
                        insert.valueList.add(SqlExpr.toExpr(value));
                    } else if (col.dataType.equalsIgnoreCase("float")) {
                        double value = rs.getDouble(colIndex);
                        if (rs.wasNull()) {
                            insert.valueList.add(SqlNullExpr.instance);
                        } else {
                            insert.valueList.add(SqlExpr.toExpr(value));
                        }
                    } else if (col.dataType.equalsIgnoreCase("image")) {
                        byte[] value = rs.getBytes(colIndex);
                        insert.valueList.add(SqlExpr.toExpr(value));
                    } else if (col.dataType.equalsIgnoreCase("int")) {
                        int value = rs.getInt(colIndex);
                        if (rs.wasNull()) {
                            insert.valueList.add(SqlNullExpr.instance);
                        } else {
                            insert.valueList.add(SqlExpr.toExpr(value));
                        }
                    } else if (col.dataType.equalsIgnoreCase("money")) {
                        BigDecimal value = rs.getBigDecimal(colIndex);
                        insert.valueList.add(SqlExpr.toExpr(value));
                    } else if (col.dataType.equalsIgnoreCase("nchar")) {
                        String value = rs.getString(colIndex);
                        insert.valueList.add(SqlExpr.toNCharExpr(value));
                    } else if (col.dataType.equalsIgnoreCase("ntext")) {
                        String value = rs.getString(colIndex);
                        insert.valueList.add(SqlExpr.toNCharExpr(value));
                    } else if (col.dataType.equalsIgnoreCase("numeric")) {
                        BigDecimal value = rs.getBigDecimal(colIndex);
                        insert.valueList.add(SqlExpr.toExpr(value));
                    } else if (col.dataType.equalsIgnoreCase("nvarchar")) {
                        String value = rs.getString(colIndex);
                        insert.valueList.add(SqlExpr.toNCharExpr(value));
                    } else if (col.dataType.equalsIgnoreCase("real")) {
                        BigDecimal value = rs.getBigDecimal(colIndex);
                        insert.valueList.add(SqlExpr.toExpr(value));
                    } else if (col.dataType.equalsIgnoreCase("smalldatetime")) {
                        Timestamp value = rs.getTimestamp(colIndex);
                        insert.valueList.add(SqlExpr.toExpr(value));
                    } else if (col.dataType.equalsIgnoreCase("smallint")) {
                        int value = rs.getInt(colIndex);
                        if (rs.wasNull()) {
                            insert.valueList.add(SqlNullExpr.instance);
                        } else {
                            insert.valueList.add(SqlExpr.toExpr(value));
                        }
                    } else if (col.dataType.equalsIgnoreCase("smallmoney")) {
                        BigDecimal value = rs.getBigDecimal(colIndex);
                        insert.valueList.add(SqlExpr.toExpr(value));
                    } else if (col.dataType.equalsIgnoreCase("sql_variant")) {
                        String value = rs.getString(colIndex);
                        insert.valueList.add(SqlExpr.toCharExpr(value));
                    } else if (col.dataType.equalsIgnoreCase("text")) {
                        String value = rs.getString(colIndex);
                        insert.valueList.add(SqlExpr.toCharExpr(value));
                    } else if (col.dataType.equalsIgnoreCase("timestamp")) {
                        byte[] value = rs.getBytes(colIndex);
                        insert.valueList.add(SqlExpr.toExpr(value));
                    } else if (col.dataType.equalsIgnoreCase("tinyint")) {
                        int value = rs.getInt(colIndex);
                        if (rs.wasNull()) {
                            insert.valueList.add(SqlNullExpr.instance);
                        } else {
                            insert.valueList.add(SqlExpr.toExpr(value));
                        }
                    } else if (col.dataType.equalsIgnoreCase("uniqueidentifer")) {
                        String value = rs.getString(colIndex);
                        insert.valueList.add(SqlExpr.toCharExpr(value));
                    } else if (col.dataType.equalsIgnoreCase("varbinary")) {
                        byte[] value = rs.getBytes(colIndex);
                        insert.valueList.add(SqlExpr.toExpr(value));
                    } else if (col.dataType.equalsIgnoreCase("varchar")) {
                        String value = rs.getString(colIndex);
                        insert.valueList.add(SqlExpr.toCharExpr(value));
                    } else {
                        throw new SQLException("TODO");
                    }
                    ++colIndex;
                }
                insertStmtList.add(new SqlInsertStmt(insert));
            }
        }
        finally {
            KSqlUtil.cleanUp(stmt, rs);
        }
        return insertStmtList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection buildPkStmt(Connection conn, SqlTable table) throws SQLException {
        ArrayList<SqlAlterTableStmt> pkStmtList = new ArrayList<SqlAlterTableStmt>();
        String sql = "exec sp_MStablekeys N'" + table.name + "', null, 6";
        Statement stmt = conn.createStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String colName;
                int cType = rs.getInt(1);
                if (cType != 1) continue;
                SqlTablePrimaryKey pk = new SqlTablePrimaryKey();
                pk.name = rs.getString(2);
                int colCount = rs.getInt(4);
                for (int i = 8; i < 8 + colCount && (colName = rs.getString(i)) != null && colName.length() != 0; ++i) {
                    pk.columnList.add(colName);
                }
                SqlAlterTableStmt alterTableStmt = new SqlAlterTableStmt(table.name);
                alterTableStmt.item = new SqlAlterTableAddItem(pk);
                pkStmtList.add(alterTableStmt);
            }
        }
        finally {
            KSqlUtil.cleanUp(stmt, rs);
        }
        return pkStmtList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection buildUniqueStmt(Connection conn, SqlTable table) throws SQLException {
        ArrayList<SqlAlterTableStmt> uniqueStmtList = new ArrayList<SqlAlterTableStmt>();
        String sql = "exec sp_MStablekeys N'" + table.name + "', null, 6";
        Statement stmt = conn.createStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String colName;
                int cType = rs.getInt(1);
                if (cType != 2) continue;
                SqlTableUnique unique = new SqlTableUnique();
                unique.name = rs.getString(2);
                int colCount = rs.getInt(4);
                for (int i = 8; i < 8 + colCount && (colName = rs.getString(i)) != null && colName.length() != 0; ++i) {
                    unique.columnList.add(colName);
                }
                SqlAlterTableStmt alterTableStmt = new SqlAlterTableStmt(table.name);
                alterTableStmt.item = new SqlAlterTableAddItem(unique);
                uniqueStmtList.add(alterTableStmt);
            }
        }
        finally {
            KSqlUtil.cleanUp(stmt, rs);
        }
        return uniqueStmtList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection buildCheckStmt(Connection conn, SqlTable table) throws SQLException, ParserException {
        ArrayList<SqlAlterTableStmt> checkStmtList = new ArrayList<SqlAlterTableStmt>();
        String sql = "exec sp_MStablechecks N'" + table.name + "'";
        Statement stmt = conn.createStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                SqlTableCheck check = new SqlTableCheck();
                check.name = rs.getString(1);
                String exprText = rs.getString(2);
                SqlExprParser parser = new SqlExprParser(exprText);
                check.expr = parser.expr();
                SqlAlterTableStmt alterTableStmt = new SqlAlterTableStmt(table.name);
                alterTableStmt.item = new SqlAlterTableAddItem(check);
                checkStmtList.add(alterTableStmt);
            }
        }
        finally {
            KSqlUtil.cleanUp(stmt, rs);
        }
        return checkStmtList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection buildFkStmt(Connection conn, SqlTable table) throws SQLException {
        ArrayList<SqlAlterTableStmt> fkStmtList = new ArrayList<SqlAlterTableStmt>();
        String sql = "exec sp_MStablekeys N'" + table.name + "', null, 8";
        Statement stmt = conn.createStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String colName;
                int i;
                int cType = rs.getInt(1);
                if (cType != 3) continue;
                SqlTableForeignKey fk = new SqlTableForeignKey();
                fk.name = rs.getString(2);
                int colCount = rs.getInt(4);
                fk.refTableName = rs.getString(6);
                sql = "select object_name(object_id('" + fk.refTableName + "'))";
                Statement getObjNameStmt = conn.createStatement();
                ResultSet tempResult = getObjNameStmt.executeQuery(sql);
                if (!tempResult.next()) {
                    throw new SQLException("FATAL ERROR.");
                }
                fk.refTableName = tempResult.getString(1);
                for (i = 8; i < 8 + colCount && (colName = rs.getString(i)) != null && colName.length() != 0; ++i) {
                    fk.columnList.add(colName);
                }
                for (i = 24; i < 24 + colCount && (colName = rs.getString(i)) != null && colName.length() != 0; ++i) {
                    fk.refColumnList.add(colName);
                }
                tempResult.close();
                getObjNameStmt.close();
                SqlAlterTableStmt alterTableStmt = new SqlAlterTableStmt(table.name);
                alterTableStmt.item = new SqlAlterTableAddItem(fk);
                fkStmtList.add(alterTableStmt);
            }
        }
        finally {
            KSqlUtil.cleanUp(stmt, rs);
        }
        return fkStmtList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection buildCreateIndexStmt(Connection conn, SqlTable table) throws SQLException {
        ArrayList<SqlCreateIndexStmt> createIndexStmtList = new ArrayList<SqlCreateIndexStmt>();
        String sql = "exec sp_MShelpindex N'" + table.name + "'";
        Statement stmt = conn.createStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String colName;
                String indexName = rs.getString(1);
                if (indexName == null || indexName.startsWith("_WA_Sys")) continue;
                SqlCreateIndexStmt createIndexStmt = new SqlCreateIndexStmt();
                sql = "select objectproperty(object_id('" + indexName + "'),'IsConstraint')";
                Statement getObjPropStmt = conn.createStatement();
                ResultSet tempResult = getObjPropStmt.executeQuery(sql);
                if (tempResult.next()) {
                    int isConstraint = tempResult.getInt(1);
                    if (isConstraint == 1) {
                        continue;
                    }
                } else {
                    throw new SQLException("FATAL ERROR.");
                }
                createIndexStmt.indexName = indexName;
                createIndexStmt.tableName = table.name;
                int descending = rs.getInt("Descending");
                for (int i = 5; i < 21 && (colName = rs.getString(i)) != null && colName.length() != 0; ++i) {
                    int orderByMode = 0;
                    if (descending > 0 && (descending & 1 << i - 5) == 1 << i - 5) {
                        orderByMode = 1;
                    }
                    SqlOrderByItem orderItem = new SqlOrderByItem(new SqlIdentifierExpr(colName), orderByMode, -1);
                    createIndexStmt.itemList.add(orderItem);
                }
                tempResult.close();
                tempResult.close();
                createIndexStmtList.add(createIndexStmt);
            }
        }
        finally {
            KSqlUtil.cleanUp(stmt, rs);
        }
        return createIndexStmtList;
    }

    public static Collection generateCreateTableSqlDom(Connection conn) throws SQLException {
        ArrayList<SqlCreateTableStmt> stmtList = new ArrayList<SqlCreateTableStmt>();
        ArrayList tableList = Sql2kUtil.getUserTables(conn);
        for (SqlTable table : tableList) {
            SqlCreateTableStmt stmt = Sql2kUtil.buildCreateTableStmt(table);
            stmtList.add(stmt);
        }
        return stmtList;
    }

    public static SqlCreateTableStmt buildCreateTableStmt(SqlTable table) throws SQLException {
        SqlCreateTableStmt stmt = new SqlCreateTableStmt(table.name);
        for (SqlColumn col : table.columns) {
            SqlColumnDef colDef = new SqlColumnDef();
            colDef.name = col.name;
            colDef.dataType = col.dataType.toUpperCase();
            colDef.length = col.length;
            colDef.precision = col.precision;
            colDef.scale = col.scale;
            colDef.allowNull = col.isNullable;
            Sql2kUtil.convertColumnDataType(colDef);
            stmt.columnList.add(colDef);
        }
        Sql2kUtil.validateTable(stmt);
        return stmt;
    }

    public static void validateTable(SqlCreateTableStmt table) throws SQLException {
        if (table.name == null) {
            throw new SQLException("table name is null");
        }
        if (table.name.length() > 30) {
            throw new SQLException("column name greate than 30");
        }
    }

    public static void convertColumnDataType(SqlColumnDef colDef) throws SQLException {
        String dataType = colDef.dataType;
        if (!(dataType.equalsIgnoreCase("BIGINT") || dataType.equalsIgnoreCase("BIT") || dataType.equalsIgnoreCase("BINARY") || dataType.equalsIgnoreCase("CHAR") || dataType.equalsIgnoreCase("DATETIME") || dataType.equalsIgnoreCase("DECIMAL") || dataType.equalsIgnoreCase("FLOAT"))) {
            if (dataType.equalsIgnoreCase("IMAGE")) {
                colDef.dataType = "BLOB";
            } else if (!(dataType.equalsIgnoreCase("INT") || dataType.equalsIgnoreCase("MONEY") || dataType.equalsIgnoreCase("NCHAR"))) {
                if (dataType.equalsIgnoreCase("NTEXT")) {
                    colDef.dataType = "NCLOB";
                } else if (!(dataType.equalsIgnoreCase("NUMERIC") || dataType.equalsIgnoreCase("NVARCHAR") || dataType.equalsIgnoreCase("REAL") || dataType.equalsIgnoreCase("SMALLDATETIME") || dataType.equalsIgnoreCase("SMALLINT") || dataType.equalsIgnoreCase("SMALLMONEY") || dataType.equalsIgnoreCase("SQL_VARIANT"))) {
                    if (dataType.equalsIgnoreCase("TEXT")) {
                        colDef.dataType = "CLOB";
                    } else if (dataType.equalsIgnoreCase("TIMESTAMP") || dataType.equalsIgnoreCase("TINYINT") || dataType.equalsIgnoreCase("UNIQUEIDENTIFIER") || dataType.equalsIgnoreCase("VARBINARY") || dataType.equalsIgnoreCase("VARCHAR")) {
                        // empty if block
                    }
                }
            }
        }
    }

    public static String convertDataType(String dataType) throws SQLException {
        if (dataType.equalsIgnoreCase("BIGINT")) {
            throw new SQLException("incompatible datatype : '" + dataType + "'");
        }
        if (dataType.equalsIgnoreCase("BINARY")) {
            return dataType;
        }
        if (dataType.equalsIgnoreCase("CHAR")) {
            return dataType;
        }
        if (dataType.equalsIgnoreCase("DATETIME")) {
            return dataType;
        }
        if (dataType.equalsIgnoreCase("DECIMAL")) {
            return dataType;
        }
        if (dataType.equalsIgnoreCase("FLOAT")) {
            throw new SQLException("incompatible datatype : '" + dataType + "'");
        }
        if (dataType.equalsIgnoreCase("IMAGE")) {
            return "BLOB";
        }
        if (dataType.equalsIgnoreCase("INT")) {
            return dataType;
        }
        if (dataType.equalsIgnoreCase("MONEY")) {
            throw new SQLException("incompatible datatype : '" + dataType + "'");
        }
        if (dataType.equalsIgnoreCase("NCHAR")) {
            return dataType;
        }
        if (dataType.equalsIgnoreCase("NTEXT")) {
            return "NCLOB";
        }
        if (dataType.equalsIgnoreCase("NUMERIC")) {
            throw new SQLException("incompatible datatype : '" + dataType + "'");
        }
        if (dataType.equalsIgnoreCase("NVARCHAR")) {
            return dataType;
        }
        if (dataType.equalsIgnoreCase("REAL")) {
            throw new SQLException("incompatible datatype : '" + dataType + "'");
        }
        if (dataType.equalsIgnoreCase("SMALLDATETIME")) {
            throw new SQLException("incompatible datatype : '" + dataType + "'");
        }
        if (dataType.equalsIgnoreCase("SMALLINT")) {
            return dataType;
        }
        if (dataType.equalsIgnoreCase("SMALLMONEY")) {
            throw new SQLException("incompatible datatype : '" + dataType + "'");
        }
        if (dataType.equalsIgnoreCase("SQL_VARIANT")) {
            throw new SQLException("incompatible datatype : '" + dataType + "'");
        }
        if (dataType.equalsIgnoreCase("TEXT")) {
            return "CLOB";
        }
        if (dataType.equalsIgnoreCase("TIMESTAMP")) {
            throw new SQLException("incompatible datatype : '" + dataType + "'");
        }
        if (dataType.equalsIgnoreCase("TINYINT")) {
            throw new SQLException("incompatible datatype : '" + dataType + "'");
        }
        if (dataType.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
            throw new SQLException("incompatible datatype : '" + dataType + "'");
        }
        if (dataType.equalsIgnoreCase("VARBINARY")) {
            return dataType;
        }
        if (dataType.equalsIgnoreCase("VARCHAR")) {
            return dataType;
        }
        throw new SQLException("incompatible datatype : '" + dataType + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getUserTables(Connection conn) throws SQLException {
        ArrayList<SqlTable> list = new ArrayList<SqlTable>();
        Statement stmt = conn.createStatement();
        String sql = "select name, id, crdate, owner = user_name(uid) from sysobjects where xtype = 'u' and name != 'dtproperties'";
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                SqlTable table = new SqlTable();
                table.name = rs.getString(1);
                table.extendedAttributes.put("id", rs.getObject(2));
                table.extendedAttributes.put("crdate", rs.getObject(3));
                table.extendedAttributes.put("owner", rs.getObject(4));
                Sql2kUtil.getTableDetail(conn, table);
                list.add(table);
            }
        }
        finally {
            KSqlUtil.cleanUp(stmt, rs);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SqlTable getUserTable(Connection conn, String tableName) throws SQLException {
        SqlTable rtnTable = null;
        Statement stmt = conn.createStatement();
        String sql = "select name, id, crdate, owner = user_name(uid) from sysobjects where xtype = 'u' and name = '" + tableName + "'";
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                SqlTable table = new SqlTable();
                table.name = rs.getString(1);
                table.extendedAttributes.put("id", rs.getObject(2));
                table.extendedAttributes.put("crdate", rs.getObject(3));
                table.extendedAttributes.put("owner", rs.getObject(4));
                Sql2kUtil.getTableDetail(conn, table);
                rtnTable = table;
            }
        }
        finally {
            KSqlUtil.cleanUp(stmt, rs);
        }
        return rtnTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getTableDetail(Connection conn, SqlTable table) throws SQLException {
        String sql = "sp_MShelpcolumns N'" + table.name + "', null, 'id', 1";
        Statement stmt = conn.createStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                SqlColumn column = new SqlColumn();
                column.name = rs.getString(1);
                column.extendedAttributes.put("id", rs.getObject(2));
                column.dataType = rs.getString(3);
                column.length = rs.getInt(4);
                column.precision = rs.getInt(5);
                if (rs.wasNull()) {
                    column.precision = -1;
                }
                column.scale = rs.getInt(6);
                if (rs.wasNull()) {
                    column.scale = -1;
                }
                column.extendedAttributes.put("col_basetypename", rs.getObject(7));
                column.extendedAttributes.put("col_defname", rs.getObject(8));
                column.extendedAttributes.put("col_rulname", rs.getObject(9));
                column.isNullable = rs.getBoolean(10);
                column.extendedAttributes.put("col_identity", rs.getObject(11));
                column.extendedAttributes.put("col_flags", rs.getObject(12));
                column.extendedAttributes.put("col_seed", rs.getObject(13));
                column.extendedAttributes.put("col_increment", rs.getObject(14));
                column.extendedAttributes.put("col_dridefname", rs.getObject(15));
                column.extendedAttributes.put("text", rs.getObject(16));
                column.defaultExpr = rs.getString(17);
                column.extendedAttributes.put("col_iscomputed", rs.getObject(18));
                table.columns.add(column);
            }
        }
        finally {
            KSqlUtil.cleanUp(stmt, rs);
        }
    }
}

