/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.pool;

import bos.org.apache.commons.dbcp.BasicDataSource;
import com.kingdee.bos.sql.pool.PoolStatus;
import com.kingdee.bos.sql.shell.nologging.NoLoggingConfig;
import java.sql.SQLException;
import java.util.Properties;

public class DBCPDataSource
extends BasicDataSource {
    public static final String PROP_MAXACTIVE = "maxActive";
    public static final String PROP_MAXIDLE = "maxIdle";
    public static final String PROP_MINIDLE = "minIdle";
    public static final String PROP_INITIALSIZE = "initialSize";
    public static final String PROP_MAXWAIT = "maxWait";
    public static final String PROP_DEFAULTTRANSACTIONISOLATION = "defaultTransactionIsolation";
    private String name;

    public DBCPDataSource(String name) {
        this.name = name;
        this.setProperties();
    }

    public PoolStatus getStatus() {
        PoolStatus status = new PoolStatus();
        status.initialSize = this.getInitialSize();
        status.maxActive = this.getMaxActive();
        status.maxIdle = this.getMaxIdle();
        status.minIdle = this.getMinIdle();
        status.maxWait = (int)this.getMaxWait();
        status.numActive = this.getNumActive();
        status.numIdle = this.getNumIdle();
        return status;
    }

    public void setProperties() {
        Properties properties = NoLoggingConfig.getProperties();
        this.setProperties(properties);
    }

    public void setProperties(Properties properties) {
        this.setDefaultAutoCommit(true);
        this.setDefaultTransactionIsolation(2);
        String value = null;
        value = properties.getProperty(PROP_MAXACTIVE);
        if (value != null) {
            this.setMaxActive(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MAXIDLE)) != null) {
            this.setMaxIdle(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MINIDLE)) != null) {
            this.setMinIdle(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_INITIALSIZE)) != null) {
            this.setInitialSize(Integer.parseInt(value));
        }
        if ((value = properties.getProperty(PROP_MAXWAIT)) != null) {
            this.setMaxWait(Long.parseLong(value));
        }
    }

    public synchronized int getNumIdle() {
        return super.getNumIdle();
    }

    public synchronized int getDefaultTransactionIsolation() {
        return super.getDefaultTransactionIsolation();
    }

    public synchronized void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        super.setDefaultTransactionIsolation(defaultTransactionIsolation);
    }

    public synchronized String getDriverClassName() {
        return super.getDriverClassName();
    }

    public synchronized int getMaxActive() {
        return super.getMaxActive();
    }

    public synchronized void setMaxActive(int maxActive) {
        super.setMaxActive(maxActive);
    }

    public synchronized int getMaxIdle() {
        return super.getMaxIdle();
    }

    public synchronized void setMaxIdle(int maxIdle) {
        super.setMaxIdle(maxIdle);
    }

    public synchronized int getMinIdle() {
        return super.getMinIdle();
    }

    public synchronized void setMinIdle(int minIdle) {
        super.setMinIdle(minIdle);
    }

    public synchronized int getInitialSize() {
        return super.getInitialSize();
    }

    public synchronized void setInitialSize(int initialSize) {
        super.setInitialSize(initialSize);
    }

    public synchronized long getMaxWait() {
        return super.getMaxWait();
    }

    public synchronized void setMaxWait(long maxWait) {
        super.setMaxWait(maxWait);
    }

    public synchronized int getNumActive() {
        return super.getNumActive();
    }

    public synchronized String getUrl() {
        return super.getUrl();
    }

    public synchronized String getUsername() {
        return super.getUsername();
    }

    public synchronized void close() throws SQLException {
        super.close();
    }

    public synchronized void setDefaultTransactionIsolation(String value) {
        if (value != null) {
            int level = 2;
            if ("NONE".equalsIgnoreCase(value)) {
                level = 0;
            } else if ("READ_COMMITTED".equalsIgnoreCase(value)) {
                level = 2;
            } else if ("READ_UNCOMMITTED".equalsIgnoreCase(value)) {
                level = 1;
            } else if ("REPEATABLE_READ".equalsIgnoreCase(value)) {
                level = 4;
            } else if ("SERIALIZABLE".equalsIgnoreCase(value)) {
                level = 8;
            } else {
                try {
                    level = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    System.err.println("Could not parse defaultTransactionIsolation: " + value);
                    System.err.println("WARNING: defaultTransactionIsolation not set");
                    System.err.println("using default value of database driver");
                    level = 2;
                }
            }
            this.setDefaultTransactionIsolation(level);
        }
    }
}

