/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.shell.trace.server;

import com.kingdee.bos.sql.shell.trace.LogItem;
import com.kingdee.bos.sql.shell.trace.server.ITraceHandler;
import com.kingdee.bos.sql.shell.trace.server.TraceConnection;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class TraceServer
implements Runnable {
    private final ServerSocket srv;
    private ITraceHandler handler;
    private final List<TraceConnection> connList;

    public TraceServer(ServerSocket srv) {
        this.srv = srv;
        this.connList = new ArrayList<TraceConnection>();
    }

    public TraceServer(int port) throws IOException {
        this(new ServerSocket(port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeLogItem(LogItem item) {
        int i;
        ArrayList<Integer> errConnIndexList = new ArrayList<Integer>();
        int size = this.connList.size();
        for (i = 0; i < size; ++i) {
            TraceConnection conn = this.connList.get(i);
            OutputStream out = conn.getOutputStream();
            try {
                item.toByteArray(out);
                continue;
            }
            catch (IOException e) {
                errConnIndexList.add(i);
                continue;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        for (i = errConnIndexList.size() - 1; i >= 0; --i) {
            int index = (Integer)errConnIndexList.get(i);
            this.connList.remove(index);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        while (true) {
            Socket socket = null;
            try {
                socket = this.srv.accept();
                TraceConnection conn = new TraceConnection(socket, this.handler);
                this.connList.add(conn);
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }
}

