/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountRefFactory;
import com.kingdee.eas.basedata.master.account.AccountRefInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountRef;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.client.AbstractAccountComUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.JButton;

public class AccountComUI
extends AbstractAccountComUI {
    private KDTable tblSource = null;
    private AccountTableInfo targetInfo = null;
    private AccountTableInfo sourceInfo = null;
    private String strSign = null;
    private AccountRefInfo selectRefInfo = null;

    public String getUITitle() {
        String resFullName = "com.kingdee.eas.basedata.master.account.client.AccountResource.AccountF7";
        String returnValue = EASResource.getString((String)resFullName);
        return returnValue;
    }

    public void onLoad() {
        HashMap map = (HashMap)this.getUIContext();
        this.targetInfo = (AccountTableInfo)map.get("targetInfo");
        this.sourceInfo = (AccountTableInfo)map.get("sourceInfo");
        this.tblSource = (KDTable)map.get("tblSource");
        this.strSign = (String)map.get("strSign");
        if (this.strSign.equals("modify")) {
            this.setModifyData();
        }
        this.BizPromptAccount.setDisplayFormat("$name$");
        this.BizPromptAccount.setEditFormat("$number$");
        this.BizPromptAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.AccountViewQuery");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("AccountTableID.id", (Object)this.targetInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)"null"));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        evi.setFilter(filter);
        this.BizPromptAccount.setEntityViewInfo(evi);
    }

    protected JButton getDefaultButton() {
        return this.btnYes;
    }

    private void setModifyData() {
        int index = KDTableUtil.getSelectedRow((KDTable)this.tblSource);
        String strTargetId = this.tblSource.getRow(index).getCell(0).getValue().toString();
        ObjectUuidPK pk1 = new ObjectUuidPK(BOSUuid.read((String)strTargetId));
        try {
            IAccountRef iAccountRef = AccountRefFactory.getRemoteInstance();
            SelectorItemCollection items = new SelectorItemCollection();
            items.add(new SelectorItemInfo("*"));
            items.add(new SelectorItemInfo("destAccountID"));
            items.add(new SelectorItemInfo("destAccountID.name"));
            AccountRefInfo selectRefInfo = iAccountRef.getAccountRefInfo((IObjectPK)pk1, items);
            IAccountView iaccount = AccountViewFactory.getRemoteInstance();
            AccountViewInfo info = iaccount.getAccountViewInfo((IObjectPK)new ObjectUuidPK(selectRefInfo.getDestAccountID().getId()));
            this.BizPromptAccount.setData((Object)info);
        }
        catch (Exception ex) {
            MsgBox.showError((String)ex.getMessage());
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnYes_actionPerformed(ActionEvent e) throws Exception {
        AccountViewInfo accountInfo = null;
        AccountViewInfo selectInfo = null;
        IObjectPK returnPK = null;
        if (!this.checkAvail()) {
            return;
        }
        Object data = new Object();
        data = this.BizPromptAccount.getData();
        accountInfo = (AccountViewInfo)data;
        AccountRefInfo refInfo = new AccountRefInfo();
        try {
            IAccountRef iAccountRef = AccountRefFactory.getRemoteInstance();
            IAccountView iselectAccount = AccountViewFactory.getRemoteInstance();
            refInfo.setSrcTableID(this.sourceInfo);
            refInfo.setDestTableID(this.targetInfo);
            if (!this.targetInfo.getId().toString().trim().equals(accountInfo.getAccountTableID().getId().toString().trim())) {
                String resFullName = "com.kingdee.eas.basedata.master.account.client.AccountResource.MustIsTargetAccount";
                String returnValue = EASResource.getString((String)resFullName);
                MsgBox.showError((Component)((Object)this), (String)returnValue);
                return;
            }
            refInfo.setDestAccountID(accountInfo);
            for (int i = 0; i < this.tblSource.getSelectManager().size(); ++i) {
                KDTSelectBlock sb = this.tblSource.getSelectManager().get(i);
                for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                    String str = "";
                    String id = "";
                    if (this.tblSource.getRow(j).getCell(1).getValue() != null) {
                        str = (String)this.tblSource.getRow(j).getCell(1).getValue();
                    }
                    id = (String)this.tblSource.getRow(j).getCell(0).getValue();
                    ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)str));
                    SelectorItemCollection itemCols = new SelectorItemCollection();
                    itemCols.add(new SelectorItemInfo("*"));
                    itemCols.add(new SelectorItemInfo("accountTypeID"));
                    itemCols.add(new SelectorItemInfo("accountTypeID.name"));
                    selectInfo = iselectAccount.getAccountViewInfo((IObjectPK)pk, itemCols);
                    accountInfo = iselectAccount.getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountInfo.getId()), itemCols);
                    refInfo.setSrcAccountID(selectInfo);
                    if (id != null && (id.length() == 44 || id.length() == 28)) {
                        refInfo.setId(BOSUuid.read((String)id));
                    }
                    returnPK = iAccountRef.submit((CoreBaseInfo)refInfo);
                    this.setSelectColumnValue(returnPK, j, accountInfo);
                    this.setTargetAccount((IObjectPK)pk, j, accountInfo);
                }
            }
            this.getUIWindow().close();
        }
        catch (BOSException ex) {
            MsgBox.showError((String)ex.getMessage());
            return;
        }
    }

    private void setTargetAccount(IObjectPK srcpk, int selectindex, AccountViewInfo targetInfo) throws Exception {
        AccountViewCollection accountc = null;
        accountc = this.getChildColumnValue(srcpk);
        IAccountRef iref = AccountRefFactory.getRemoteInstance();
        if (accountc.size() > 0) {
            for (int i = 0; i < accountc.size(); ++i) {
                int selectIndex = 0;
                AccountViewInfo Childinfo = accountc.get(i);
                AccountRefInfo ref = new AccountRefInfo();
                selectIndex = this.getSelectIndex(Childinfo);
                AccountViewInfo srcAccount = new AccountViewInfo();
                srcAccount.setId(BOSUuid.read((String)this.tblSource.getRow(selectIndex).getCell(1).getValue().toString()));
                if (this.tblSource.getRow(selectIndex).getCell(0).getValue() != null && this.tblSource.getRow(selectIndex).getCell(0).getValue().toString().length() == 44) {
                    ref.setId(BOSUuid.read((String)this.tblSource.getRow(selectIndex).getCell(0).getValue().toString()));
                }
                ref.setSrcAccountID(srcAccount);
                ref.setSrcTableID(this.sourceInfo);
                ref.setDestAccountID(targetInfo);
                ref.setDestTableID(targetInfo.getAccountTableID());
                IObjectPK retPK = iref.submit((CoreBaseInfo)ref);
                this.setSelectColumnValue(retPK, selectIndex, targetInfo);
            }
        }
    }

    private void setSelectColumnValue(IObjectPK pk, int indexRow, AccountViewInfo info) throws Exception {
        IRow iRow = null;
        iRow = this.tblSource.getRow(indexRow);
        iRow.getCell(0).setValue((Object)pk.toString());
        iRow.getCell(5).setValue((Object)info.getId().toString());
        iRow.getCell(6).setValue((Object)info.getNumber());
        iRow.getCell(7).setValue((Object)info.getName());
        iRow.getCell(8).setValue((Object)info.getAccountTypeID().getName().trim());
    }

    private int getSelectIndex(AccountViewInfo info) {
        int index = 0;
        for (int i = 0; i < this.tblSource.getRowCount(); ++i) {
            if (!this.tblSource.getRow(i).getCell(1).getValue().toString().equals(info.getId().toString())) continue;
            index = i;
            break;
        }
        return index;
    }

    private AccountViewCollection getChildColumnValue(IObjectPK pk) throws Exception {
        AccountViewCollection infos = null;
        SelectorItemCollection itemCols = new SelectorItemCollection();
        itemCols.add(new SelectorItemInfo("*"));
        itemCols.add(new SelectorItemInfo("accountTypeID"));
        itemCols.add(new SelectorItemInfo("accountTypeID.name"));
        IAccountView iaccount = AccountViewFactory.getRemoteInstance();
        AccountViewInfo model = iaccount.getAccountViewInfo(pk);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("AccountTableID", (Object)model.getAccountTableID().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("AccountTypeID", (Object)model.getAccountTypeID().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(model.getLongNumber() + "%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("CompanyID", null));
        evi.setFilter(filter);
        infos = iaccount.getAccountViewCollection(evi);
        return infos;
    }

    private boolean checkAvail() {
        Object data = new Object();
        data = this.BizPromptAccount.getData();
        if (data == null) {
            String resFullName = "com.kingdee.eas.basedata.master.account.client.AccountResource.SelectAccount";
            String returnValue = EASResource.getString((String)resFullName);
            MsgBox.showError((String)returnValue);
            return false;
        }
        if (data instanceof AccountViewInfo) {
            AccountViewInfo info = (AccountViewInfo)data;
            if (!info.isIsLeaf()) {
                String resFullName = "com.kingdee.eas.basedata.master.account.client.AccountResource.DestNotIsLeaf";
                String returnValue = EASResource.getString((String)resFullName);
                MsgBox.showError((String)returnValue);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void btnExit_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }
}

