/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.HeadDetailException;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.client.AbstractAccountReferenceUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class AccountReferenceUI
extends AbstractAccountReferenceUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountReferenceUI.class);
    private static final String accountResource = "com.kingdee.eas.basedata.master.account.client.AccountResource";
    private static final String selectReferenceAccount = "selectReferenceAccount";
    private static final String selectUnreferenceAccount = "selectUnreferenceAccount";
    private boolean isChanged = false;
    private CtrlUnitInfo currentCu;
    private CtrlUnitInfo parentCu;
    private CompanyOrgUnitInfo currentCompany;
    private CompanyOrgUnitInfo parentCompany;
    private HashMap acctRefMap = new HashMap();
    private AccountViewCollection acctCols = new AccountViewCollection();
    private AccountViewCollection acctColsLog = new AccountViewCollection();
    public static final String RESOURCE = "com.kingdee.eas.basedata.master.account.AllAccountResource";

    public AccountReferenceUI() throws Exception {
        this.btnAllSelect.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnNoneSelect.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        KDButtonGroup kdgroup = new KDButtonGroup();
        kdgroup.add((AbstractButton)this.rbAll);
        kdgroup.add((AbstractButton)this.rbRefered);
        kdgroup.add((AbstractButton)this.rbNotRefered);
        this.rbNotRefered.setSelected(true);
        this.loadCtx();
        this.fillCmbAccountTable();
        this.tblAccount.checkParsed();
        this.tblAccount.getIndexColumn().getStyleAttributes().setHided(true);
        this.tblAccount.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                if (e.getColIndex() == 0) {
                    KDTable tblAcct = (KDTable)e.getSource();
                    IRow row = tblAcct.getRow(e.getRowIndex());
                    if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) {
                        row.getCell("selected").setValue((Object)Boolean.TRUE);
                        AccountReferenceUI.this.setParentSelectedStatus(row, true);
                    } else {
                        row.getCell("selected").setValue((Object)Boolean.FALSE);
                        AccountReferenceUI.this.setParentSelectedStatus(row, false);
                    }
                }
            }
        });
        this.loadFields();
        this.actionRefer.setEnabled(true);
        this.btnQuickQuery.setEnabled(true);
        this.setStatus();
    }

    protected void setParentSelectedStatus(IRow row, boolean selected) {
        String parentId;
        AccountReferenceInfo acctRefInfo;
        AccountViewInfo acctInfo = (AccountViewInfo)row.getCell("id").getUserObject();
        acctInfo.getId().toString();
        while (acctInfo.getParent() != null && (acctRefInfo = (AccountReferenceInfo)this.acctRefMap.get(parentId = acctInfo.getParent().getId().toString())) != null) {
            int i;
            int count;
            ArrayList children;
            IRow parentRow = acctRefInfo.getSelfRow();
            boolean parentSelected = (Boolean)parentRow.getCell("selected").getValue();
            parentRow.getStyleAttributes().setLocked(true);
            if (selected) {
                if (parentSelected) {
                    acctInfo = (AccountViewInfo)parentRow.getCell("id").getUserObject();
                    parentRow.getCell("glevel").setValue((Object)new Integer(acctInfo.getLevel() + 1));
                    break;
                }
                if (this.rbRefered.isSelected()) {
                    children = acctRefInfo.getChildren();
                    boolean checkcount = false;
                    count = children.size();
                    for (i = 0; i < count; ++i) {
                        IRow childs = (IRow)children.get(i);
                        if (childs.getStyleAttributes().isHided()) continue;
                        acctInfo = (AccountViewInfo)childs.getCell("id").getUserObject();
                        if (((Boolean)childs.getCell("selected").getValue()).booleanValue()) {
                            checkcount = true;
                            continue;
                        }
                        checkcount = false;
                        break;
                    }
                    if (checkcount) {
                        parentRow.getCell("selected").setValue((Object)selected);
                    }
                    acctInfo = (AccountViewInfo)parentRow.getCell("id").getUserObject();
                    continue;
                }
                acctInfo = (AccountViewInfo)parentRow.getCell("id").getUserObject();
                parentRow.getCell("selected").setValue((Object)selected);
                parentRow.getCell("glevel").setValue((Object)new Integer(acctInfo.getLevel() + 1));
                continue;
            }
            if (!parentSelected) {
                return;
            }
            children = acctRefInfo.getChildren();
            boolean childSelected = false;
            count = children.size();
            for (i = 0; i < count; ++i) {
                IRow child = (IRow)children.get(i);
                if (!((Boolean)child.getCell("selected").getValue()).booleanValue()) continue;
                childSelected = true;
                break;
            }
            if (childSelected) break;
            acctInfo = (AccountViewInfo)parentRow.getCell("id").getUserObject();
            parentRow.getCell("selected").setValue((Object)selected);
            parentRow.getCell("glevel").setValue((Object)new Integer(acctInfo.getGLevel()));
        }
    }

    public void setStatus() {
        int rowcount = 0;
        String accountReferenceMsg = EASResource.getString((String)accountResource, (String)"ACCOUNTREFERENCE");
        String accountCancelReferenceMsg = EASResource.getString((String)accountResource, (String)"ACCOUNTCANCELREFERENCE");
        int count = this.tblAccount.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblAccount.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            ++rowcount;
        }
        if (this.rbAll.isSelected()) {
            this.btnAllSelect.setVisible(false);
            this.btnNoneSelect.setVisible(false);
            this.btnRefer.setVisible(false);
            this.btnRefer.setSize(73, 21);
            this.tblAccount.getColumn("selected").getStyleAttributes().setHided(true);
        } else if (this.rbRefered.isSelected()) {
            this.tblAccount.getColumn("selected").getStyleAttributes().setHided(false);
            this.btnAllSelect.setVisible(true);
            this.btnNoneSelect.setVisible(true);
            if (this.tblAccount.getRowCount() > 0 && rowcount > 0) {
                this.btnRefer.setVisible(true);
                this.btnRefer.setText(accountCancelReferenceMsg);
                this.btnRefer.setSize(100, 21);
                this.btnRefer.setEnabled(true);
            } else {
                this.btnRefer.setVisible(true);
                this.btnRefer.setText(accountCancelReferenceMsg);
                this.btnRefer.setSize(100, 21);
                this.btnRefer.setEnabled(false);
            }
        } else if (this.rbNotRefered.isSelected()) {
            this.btnAllSelect.setVisible(true);
            this.btnNoneSelect.setVisible(true);
            if (this.tblAccount.getRowCount() > 0 && rowcount > 0) {
                this.btnRefer.setVisible(true);
                this.btnRefer.setText(accountReferenceMsg);
                this.btnRefer.setSize(73, 21);
                this.btnRefer.setEnabled(true);
            } else {
                this.btnRefer.setVisible(true);
                this.btnRefer.setText(accountReferenceMsg);
                this.btnRefer.setSize(73, 21);
                this.btnRefer.setEnabled(false);
            }
        }
    }

    private void loadSelectStatus() throws BOSException {
        String accountCancelRef2 = EASResource.getString((String)accountResource, (String)"ACCOUNTCANCELREF2");
        String accountReferenceMsg = EASResource.getString((String)accountResource, (String)"ACCOUNTREFERENCE");
        String accountCancelReferenceMsg = EASResource.getString((String)accountResource, (String)"ACCOUNTCANCELREFERENCE");
        if (this.rbAll.isSelected()) {
            this.selectAllAccount();
            this.btnAllSelect.setVisible(false);
            this.btnNoneSelect.setVisible(false);
            this.btnRefer.setVisible(false);
        } else if (this.rbRefered.isSelected()) {
            this.selectReferedAccount(true);
            this.btnAllSelect.setVisible(true);
            this.btnNoneSelect.setVisible(true);
            this.btnRefer.setVisible(true);
            this.btnRefer.setText(accountCancelReferenceMsg);
        } else if (this.rbNotRefered.isSelected()) {
            this.selectReferedAccount(false);
            this.btnAllSelect.setVisible(true);
            this.btnNoneSelect.setVisible(true);
            this.btnRefer.setVisible(true);
            this.btnRefer.setText(accountReferenceMsg);
        }
    }

    private void loadAllAccountToTable() {
        AccountTableInfo acctTbl = this.getCurrentAcctTbl();
        if (acctTbl != null) {
            try {
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add("id");
                selectors.add("number");
                selectors.add("name");
                selectors.add("level");
                selectors.add("controlLevel");
                selectors.add("GLevel");
                selectors.add("accountTypeID.id");
                selectors.add("accountTypeID.number");
                selectors.add("accountTypeID.name");
                selectors.add("GAA.*");
                selectors.add("GAA.id");
                selectors.add("GAA.number");
                selectors.add("GAA.name");
                selectors.add("parent");
                selectors.add("parentAA.*");
                selectors.add("isAllowCA");
                selectors.add("isLeaf");
                selectors.add("CAA.name");
                selectors.add("isCFreeze");
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
                AccountViewCollection acctCols = AccountTools.getallAccountViewByCompanyAndTable(null, this.parentCompany, acctTbl, filter, selectors);
                this.tblAccount.removeRows();
                if (acctCols != null) {
                    int count = acctCols.size();
                    for (int i = 0; i < count; ++i) {
                        AccountViewInfo acctInfo = acctCols.get(i);
                        IRow row = this.tblAccount.addRow();
                        this.loadLine(row, acctInfo);
                        if (acctInfo.getGAA() == null) continue;
                        acctInfo.getGAA();
                    }
                }
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    private void loadLine(IRow row, AccountViewInfo acctInfo) {
        AccountReferenceInfo parentRefInfo;
        row.getCell("selected").setValue((Object)Boolean.FALSE);
        row.getCell("id").setValue((Object)acctInfo.getId().toString());
        row.getCell("id").setUserObject((Object)acctInfo);
        row.getCell("number").setValue((Object)acctInfo.getNumber());
        row.getCell("name").setValue((Object)acctInfo.getName());
        row.getCell("accountType").setValue((Object)acctInfo.getAccountTypeID());
        row.getCell("glevel").setValue((Object)new Integer(acctInfo.getGLevel()));
        if (acctInfo.getCAA() != null) {
            row.getCell("gaa").setValue((Object)acctInfo.getCAA().getName());
        } else {
            row.getCell("gaa").setValue(null);
        }
        row.getCell("selected").getStyleAttributes().setLocked(false);
        row.getStyleAttributes().setHided(true);
        AccountReferenceInfo acctRefInfo = new AccountReferenceInfo();
        acctRefInfo.setSelfRow(row);
        this.acctRefMap.put(acctInfo.getId().toString(), acctRefInfo);
        if (acctInfo.getParent() != null && (parentRefInfo = (AccountReferenceInfo)this.acctRefMap.get(acctInfo.getParent().getId().toString())) != null) {
            parentRefInfo.addChild(row);
        }
    }

    private AccountTableInfo getCurrentAcctTbl() {
        if (this.cmbAccountTable.getItemCount() > 0) {
            return (AccountTableInfo)this.cmbAccountTable.getSelectedItem();
        }
        return null;
    }

    private void loadCtx() {
        this.currentCompany = (CompanyOrgUnitInfo)this.getUIContext().get("Company");
        this.parentCompany = this.currentCompany.getParent();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.tblAccount.checkParsed();
        this.loadAllAccountToTable();
        try {
            this.loadSelectStatus();
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    private void fillCmbAccountTable() throws AccountException {
        try {
            AccountTableCollection acctTableCols = AccountTools.getAllAccountTableByCompany(null, this.parentCompany);
            int count = acctTableCols.size();
            for (int i = 0; i < count; ++i) {
                this.cmbAccountTable.addItem((Object)acctTableCols.get(i));
            }
            if (this.cmbAccountTable.getItemCount() <= 0) {
                throw new AccountException(AccountException.REFERUPPERACCOUNTWHENUPPERHASNOACCTTABLE);
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.acctCols.clear();
        this.acctColsLog.clear();
        if (this.rbNotRefered.isSelected()) {
            boolean isAdd = false;
            boolean hasSelect = false;
            int count = this.tblAccount.getRowCount();
            for (int i = 0; i < count; ++i) {
                boolean isFiltered;
                boolean selectData = false;
                IRow row = this.tblAccount.getRow(i);
                isAdd = false;
                AccountViewInfo info = (AccountViewInfo)row.getCell("id").getUserObject();
                boolean bl = isFiltered = info.get("isFiltered") != null && (Boolean)info.get("isFiltered") != false;
                if (isFiltered) continue;
                if (row.getStyleAttributes().isHided()) {
                    isAdd = true;
                } else if (((Boolean)row.getCell("selected").getValue()).booleanValue()) {
                    isAdd = true;
                    hasSelect = true;
                    selectData = true;
                }
                if (!isAdd) continue;
                AccountViewInfo acctInfo = (AccountViewInfo)row.getCell("id").getUserObject();
                acctInfo.setGLevel((Integer)row.getCell("glevel").getValue());
                acctInfo.setIsUpperAllowCA(acctInfo.isIsAllowCA());
                this.acctCols.add(acctInfo);
                if (!selectData) continue;
                this.acctColsLog.add(acctInfo);
            }
            if (!hasSelect) {
                MsgBox.showInfo((String)EASResource.getString((String)accountResource, (String)selectReferenceAccount));
                SysUtil.abort();
            }
        } else {
            boolean hasSelect = false;
            int count = this.tblAccount.getRowCount();
            for (int i = 0; i < count; ++i) {
                AccountViewInfo acctInfo;
                boolean isFiltered;
                boolean selectData = false;
                IRow row = this.tblAccount.getRow(i);
                AccountViewInfo info = (AccountViewInfo)row.getCell("id").getUserObject();
                boolean bl = isFiltered = info.get("isFiltered") != null && (Boolean)info.get("isFiltered") != false;
                if (!row.getStyleAttributes().isHided()) {
                    if (((Boolean)row.getCell("selected").getValue()).booleanValue()) {
                        hasSelect = true;
                        acctInfo = (AccountViewInfo)row.getCell("id").getUserObject();
                        this.acctColsLog.add(acctInfo);
                        continue;
                    }
                    if (((Boolean)row.getCell("selected").getValue()).booleanValue() || row.getStyleAttributes().isHided()) continue;
                    acctInfo = (AccountViewInfo)row.getCell("id").getUserObject();
                    acctInfo.setGLevel((Integer)row.getCell("glevel").getValue());
                    acctInfo.setIsUpperAllowCA(acctInfo.isIsAllowCA());
                    this.acctCols.add(acctInfo);
                    continue;
                }
                if (!isFiltered) continue;
                acctInfo = (AccountViewInfo)row.getCell("id").getUserObject();
                acctInfo.setGLevel((Integer)row.getCell("glevel").getValue());
                acctInfo.setIsUpperAllowCA(acctInfo.isIsAllowCA());
                this.acctCols.add(acctInfo);
            }
            if (!hasSelect) {
                MsgBox.showInfo((String)EASResource.getString((String)accountResource, (String)selectUnreferenceAccount));
                SysUtil.abort();
            }
        }
    }

    @Override
    protected void cmbAccountTable_itemStateChanged(ItemEvent e) throws Exception {
        super.cmbAccountTable_itemStateChanged(e);
        this.loadFields();
        this.setStatus();
        this.selectReferedAccount(false);
        this.rbNotRefered.setSelected(true);
    }

    @Override
    public void actionAllSelect_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllSelect_actionPerformed(e);
        if (!(e.getSource() instanceof KDRadioButton)) {
            this.selectAllAccount();
        } else {
            int count = this.tblAccount.getRowCount();
            for (int i = 0; i < count; ++i) {
                this.tblAccount.getRow(i).getStyleAttributes().setHided(false);
            }
        }
        this.setStatus();
    }

    private void selectAllAccount() {
        if (this.rbRefered.isSelected()) {
            int count = this.tblAccount.getRowCount();
            for (int i = 0; i < count; ++i) {
                this.tblAccount.getRow(i).getCell("selected").setValue((Object)true);
            }
        } else {
            try {
                this.rbAll.setSelected(false);
                this.rbRefered.setSelected(false);
                this.selectReferedAccount(false);
                this.setStatus();
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    @Override
    public void actionNoneSelect_actionPerformed(ActionEvent e) throws Exception {
        super.actionNoneSelect_actionPerformed(e);
        this.selectNoneAccount();
    }

    private void selectNoneAccount() {
        int count = this.tblAccount.getRowCount();
        for (int i = 0; i < count; ++i) {
            this.tblAccount.getRow(i).getCell("selected").setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    public void actionRefered_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefered_actionPerformed(e);
        this.rbAll.setSelected(false);
        this.rbNotRefered.setSelected(false);
        this.selectReferedAccount(true);
        this.setStatus();
    }

    private void selectReferedAccount(boolean selected) throws BOSException {
        this.selectNoneAccount();
        AccountTableInfo acctTbl = this.getCurrentAcctTbl();
        if (acctTbl != null) {
            ArrayList upperInfoList = null;
            upperInfoList = selected ? AccountTools.getNotFreezeUpperIdByCompanyAndTbl(null, this.currentCompany, acctTbl) : AccountTools.getAllUpperAcctIdByCompanyAndTbl(null, this.currentCompany, acctTbl);
            ArrayList<String> upperIdList = new ArrayList<String>();
            int count = upperInfoList.size();
            for (int i = 0; i < count; ++i) {
                upperIdList.add(((AccountViewInfo)upperInfoList.get(i)).getUpper().getId().toString());
            }
            int count2 = this.tblAccount.getRowCount();
            for (int i = 0; i < count2; ++i) {
                IRow row = this.tblAccount.getRow(i);
                String acctId = row.getCell("id").getValue().toString();
                AccountViewInfo acctInfo = (AccountViewInfo)row.getCell("id").getUserObject();
                boolean isCFreeze = acctInfo.isIsCFreeze();
                if (selected) {
                    row.getCell("selected").setValue((Object)false);
                    if (upperIdList.contains(acctId)) {
                        row.getStyleAttributes().setHided(false);
                        if (!acctInfo.isIsLeaf() && ((AccountViewInfo)upperInfoList.get(upperIdList.indexOf(acctId))).isIsLeaf()) {
                            row.getStyleAttributes().setLocked(false);
                        }
                    } else {
                        row.getStyleAttributes().setHided(true);
                    }
                    if (!acctInfo.isIsCFreeze()) continue;
                    row.getStyleAttributes().setHided(true);
                    continue;
                }
                if (!row.getCell("selected").getStyleAttributes().isLocked()) {
                    row.getCell("selected").setValue((Object)true);
                    this.setParentSelectedStatus(row, true);
                }
                if (upperIdList.contains(acctId)) {
                    row.getStyleAttributes().setHided(true);
                    continue;
                }
                row.getStyleAttributes().setHided(false);
            }
            this.filterByCondition();
        }
    }

    @Override
    public void actionNotRefered_actionPerformed(ActionEvent e) throws Exception {
        super.actionNotRefered_actionPerformed(e);
        this.rbAll.setSelected(false);
        this.rbRefered.setSelected(false);
        this.selectReferedAccount(false);
        this.setStatus();
    }

    @Override
    public void actionRefer_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefer_actionPerformed(e);
        this.referUpperAccountViewCollection();
    }

    private void referUpperAccountViewCollection() throws EASBizException, BOSException {
        this.storeFields();
        this.verifyInput();
        AccountTableInfo acctTblInfo = this.getCurrentAcctTbl();
        String rs = null;
        if (acctTblInfo != null) {
            IAccountView acct = AccountViewFactory.getRemoteInstance();
            try {
                IObjectPK logPK = this.buildLogMsg(acctTblInfo);
                rs = acct.referUpperAccount(this.currentCompany, this.parentCompany, acctTblInfo, this.acctCols);
                if (StringUtils.isEmpty((String)rs)) {
                    LogUtil.afterLog(null, (IObjectPK)logPK);
                }
            }
            catch (HeadDetailException e) {
                HeadDetailException hde = e;
                MsgBox.showDetailAndOK((Component)((Object)this), (String)hde.getHeadMsg(), (String)hde.getDetailMsg(), (int)hde.getMsgType());
                SysUtil.abort();
            }
            this.setChanged(true);
        }
        String msgForShow = EASResource.getString((String)accountResource, (String)"ACCOUNTREFERENCESUCCESS_1");
        msgForShow = msgForShow + this.btnRefer.getText();
        msgForShow = msgForShow + EASResource.getString((String)accountResource, (String)"ACCOUNTREFERENCESUCCESS_3");
        if (this.rbRefered.isSelected() && !StringUtils.isEmpty((String)rs)) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"notAllUnrefSuccess"), (String)rs, (int)1);
        } else {
            MsgBox.showInfo((String)msgForShow);
        }
        this.loadSelectStatus();
    }

    private IObjectPK buildLogMsg(AccountTableInfo acctTblInfo) {
        String method = null;
        method = this.rbNotRefered.isSelected() ? EASResource.getString((String)RESOURCE, (String)"accountRefer") : EASResource.getString((String)RESOURCE, (String)"accountUnrefer");
        StringBuilder detailLog = new StringBuilder();
        detailLog.append(EASResource.getString((String)RESOURCE, (String)"Company") + "\u3010").append(this.currentCompany.getNumber() + "(" + this.currentCompany.getName() + ")\u3011\n").append(EASResource.getString((String)RESOURCE, (String)"accountTable") + "\u3010").append(acctTblInfo.getNumber() + "(" + acctTblInfo.getName() + ")\u3011\n").append(EASResource.getString((String)RESOURCE, (String)"chooseAccount") + "\u3010");
        for (int i = 0; i < this.acctColsLog.size(); ++i) {
            AccountViewInfo accInfo = this.acctColsLog.get(i);
            detailLog.append(accInfo.getNumber() + "(" + accInfo.getName() + ");");
        }
        detailLog.append("\u3011");
        IObjectPK logPK = LogUtil.beginLog(null, (String)method, (BOSObjectType)new BOSObjectType("9DA99826"), null, (String)detailLog.toString(), (String)"bd_account_accountView_refer", (String)this.currentCompany.getId().toString(), (String)method);
        return logPK;
    }

    private void verifyInput() {
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    @Override
    public void actionQuickQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.rbAll.isSelected()) {
            this.actionAllSelect_actionPerformed(e);
        } else if (this.rbRefered.isSelected()) {
            this.actionRefered_actionPerformed(e);
        } else {
            this.actionNotRefered_actionPerformed(e);
        }
    }

    private void filterByCondition() {
        String searchItem = this.txtSearchItem.getText();
        IRow row = null;
        int type = this.cmbField.getSelectedIndex();
        String prop = type == 0 ? "number" : "name";
        int count = this.tblAccount.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblAccount.getRow(i);
            AccountViewInfo acctInfo = (AccountViewInfo)row.getCell("id").getUserObject();
            String value = (String)acctInfo.get(prop);
            boolean isHiden = row.getStyleAttributes().isHided();
            boolean isAllSelected = this.rbAll.isSelected();
            if (!isAllSelected) {
                if (!isHiden && value != null && value.indexOf(searchItem) <= -1) {
                    row.getStyleAttributes().setHided(true);
                    acctInfo.put("isFiltered", true);
                    continue;
                }
                acctInfo.put("isFiltered", false);
                continue;
            }
            if (value != null && value.indexOf(searchItem) <= -1) {
                row.getStyleAttributes().setHided(true);
                continue;
            }
            row.getStyleAttributes().setHided(false);
        }
    }

    private class AccountReferenceInfo {
        IRow selfRow = null;
        ArrayList children = new ArrayList();

        public IRow getSelfRow() {
            return this.selfRow;
        }

        public void setSelfRow(IRow row) {
            this.selfRow = row;
        }

        public ArrayList getChildren() {
            return this.children;
        }

        public void addChild(IRow child) {
            this.children.add(child);
        }
    }
}

