/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeFactory;
import com.kingdee.eas.basedata.master.account.client.AbstractAsstAccountChangeCheckUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class AsstAccountChangeCheckUI
extends AbstractAsstAccountChangeCheckUI {
    private static final Logger logger = CoreUIObject.getLogger(AsstAccountChangeCheckUI.class);
    private static final String RES = "com.kingdee.eas.fi.gl.BalanceAnalysisResource";
    private static final String HARDRESOURCE = "com.kingdee.eas.basedata.master.account.AccountHardCodeResource";
    private boolean stop = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDScrollPane1.setBorder(BorderFactory.createLineBorder(new Color(145, 148, 140), 1));
        this.initCompany();
    }

    private void initCompany() throws Exception {
        this.promptCompany.setQueryInfo("com.kingdee.eas.fi.gl.app.CompanyOrgUnitQuery");
        this.promptCompany.setEditable(true);
        this.promptCompany.setEditFormat("$number$");
        this.promptCompany.setCommitFormat("$name$;$number$");
        this.promptCompany.setDisplayFormat("$number$-$name$");
        this.promptCompany.setEnabledMultiSelection(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("isSealup", (Object)new Integer(0)));
        StringBuffer sql = new StringBuffer();
        sql.append("select c.FID \n");
        sql.append("from T_BD_SystemStatusCtrol sc \n");
        sql.append("join T_BD_SystemStatus s \n");
        sql.append("    on s.FID = sc.FSystemStatusID and s.FName = 6 \n");
        sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
        sql.append("where c.FIsBizUnit = 1 \n");
        sql.append("    and sc.FStartPeriodID is not null \n");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        view.setFilter(filter);
        this.promptCompany.setEntityViewInfo(view);
        CompanyOrgUnitInfo company = this.getFirstOrg();
        if (company != null) {
            this.promptCompany.setValue((Object)new Object[]{company});
        } else {
            this.promptCompany.setValue((Object)new Object[0]);
        }
    }

    private CompanyOrgUnitInfo getFirstOrg() {
        IRowSet rs;
        StringBuffer sql;
        Map context = this.getUIContext();
        if (context.get("company") != null) {
            return (CompanyOrgUnitInfo)context.get("company");
        }
        String companyId = null;
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        if (company.isIsBizUnit() && !company.isIsSealUp()) {
            sql = new StringBuffer();
            sql.append("select c.FID \n");
            sql.append("from T_BD_SystemStatusCtrol sc \n");
            sql.append("join T_BD_SystemStatus s \n");
            sql.append("    on s.FID = sc.FSystemStatusID and s.FName = 6 \n");
            sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
            sql.append("where sc.FIsStart = 1 and c.FIsBizUnit = 1 and c.FIsSealup = 0 \n");
            sql.append("    and sc.FStartPeriodID is not null \n");
            sql.append("    and sc.FCurrentPeriodID is not null \n");
            sql.append("    and c.FID = '" + company.getId().toString() + "' \n");
            try {
                rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
                if (rs.next()) {
                    companyId = company.getId().toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (companyId == null) {
            sql = new StringBuffer();
            sql.append("select top 1 c.FID \n");
            sql.append("from T_BD_SystemStatusCtrol sc \n");
            sql.append("join T_BD_SystemStatus s \n");
            sql.append("    on s.FID = sc.FSystemStatusID and s.FName = 6 \n");
            sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
            sql.append("where sc.FIsStart = 1 and c.FIsBizUnit = 1 and c.FIsSealup = 0 \n");
            sql.append("    and sc.FStartPeriodID is not null \n");
            sql.append("    and sc.FCurrentPeriodID is not null \n");
            try {
                rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
                if (rs.next()) {
                    companyId = rs.getString("FID");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (companyId != null) {
            try {
                return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void enableComponent(boolean enable) {
        this.promptCompany.setEnabled(enable);
        this.txtAccount.setEnabled(enable);
        this.cbShowNoError.setEnabled(enable);
    }

    public boolean checkBeforeWindowClosing() {
        this.stop = true;
        return super.checkBeforeWindowClosing();
    }

    @Override
    public void actionComfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.btnOk.getClientProperty((Object)"canStop") != null) {
            this.stop = true;
            this.actionComfirm.setEnabled(false);
            this.btnOk.setEnabled(false);
            return;
        }
        final Object[] objects = (Object[])this.promptCompany.getValue();
        if (objects == null || objects.length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"SelectOrg"));
            return;
        }
        final int mode = objects.length == 1 ? 1 : 2;
        final HashMap params = new HashMap();
        HashSet<String> accountNumbers = new HashSet<String>();
        String strAccount = this.txtAccount.getText();
        if (strAccount != null) {
            String[] strAccounts;
            strAccount = strAccount.trim();
            for (String str : strAccounts = strAccount.split(";")) {
                if ((str = str.trim()).length() <= 0) continue;
                accountNumbers.add(str);
            }
        }
        params.put("accountNumbers", accountNumbers);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AsstAccountChangeCheckUI.this.tfInfo.setText("");
                    int ocount = 0;
                    int rcount = 0;
                    if (mode == 1) {
                        AsstAccountChangeCheckUI.this.actionComfirm.setEnabled(false);
                        AsstAccountChangeCheckUI.this.btnOk.setEnabled(false);
                    } else {
                        AsstAccountChangeCheckUI.this.btnOk.putClientProperty((Object)"canStop", (Object)true);
                        AsstAccountChangeCheckUI.this.btnOk.setText(EASResource.getString((String)AsstAccountChangeCheckUI.RES, (String)"Stop"));
                    }
                    AsstAccountChangeCheckUI.this.enableComponent(false);
                    for (int i = 0; i < objects.length; ++i) {
                        CompanyOrgUnitInfo c = (CompanyOrgUnitInfo)objects[i];
                        try {
                            AsstAccountChangeCheckUI.this.tfInfo.setText(EASResource.getString((String)AsstAccountChangeCheckUI.RES, (String)"Analysis") + " (" + (i + 1) + "/" + objects.length + ") " + c.getName() + "[" + c.getNumber() + "] ...");
                            Map result = (Map)AsstAccountChangeFactory.getRemoteInstance().check(c.getId().toString(), params);
                            List errors = (List)result.get("errors");
                            rcount += errors.size();
                            AsstAccountChangeCheckUI.this.showErrors(c, errors);
                        }
                        catch (Exception e) {
                            String balMsg = EASResource.getString((String)AsstAccountChangeCheckUI.RES, (String)"AnalysisError");
                            logger.error((Object)balMsg, (Throwable)e);
                        }
                        ++ocount;
                        if (AsstAccountChangeCheckUI.this.stop) break;
                    }
                    AsstAccountChangeCheckUI.this.tfInfo.setText(AsstAccountChangeCheckUI.this.parseHardCode("Assay") + " (" + ocount + "/" + objects.length + ") " + AsstAccountChangeCheckUI.this.parseHardCode("FindOrg") + " " + rcount + AsstAccountChangeCheckUI.this.parseHardCode("BadAccount") + "\u3002");
                }
                finally {
                    AsstAccountChangeCheckUI.this.btnOk.setText(EASResource.getString((String)AsstAccountChangeCheckUI.RES, (String)"Execute"));
                    AsstAccountChangeCheckUI.this.enableComponent(true);
                    AsstAccountChangeCheckUI.this.actionComfirm.setEnabled(true);
                    AsstAccountChangeCheckUI.this.btnOk.setEnabled(true);
                    AsstAccountChangeCheckUI.this.btnOk.putClientProperty((Object)"canStop", null);
                    AsstAccountChangeCheckUI.this.stop = false;
                }
            }
        }).start();
    }

    private void showErrors(CompanyOrgUnitInfo c, List<String> errors) {
        if (!this.cbShowNoError.isSelected() && errors.size() <= 0) {
            return;
        }
        this.showInfo(c.getName() + "(" + c.getNumber() + "):\n", Color.BLACK);
        if (errors.size() > 0) {
            for (String error : errors) {
                this.showInfo(error + "\n", Color.BLACK);
            }
        } else {
            this.showInfo(this.parseHardCode("Assay") + "\n", Color.BLACK);
        }
        this.showInfo("\n", Color.BLACK);
    }

    private void showInfo(final String info, final Color color) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleAttributeSet attributeSet = new SimpleAttributeSet();
                StyleConstants.setForeground(attributeSet, color);
                Document doc = AsstAccountChangeCheckUI.this.txtConsole.getDocument();
                try {
                    doc.insertString(doc.getLength(), info, attributeSet);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                AsstAccountChangeCheckUI.this.txtConsole.setSelectionStart(doc.getLength());
            }
        });
    }

    private String parseHardCode(String resName) {
        return EASResource.getString((String)HARDRESOURCE, (String)resName);
    }
}

