/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountViewFilterInfo;
import com.kingdee.eas.basedata.master.account.client.AbstractFilterForAccountF7UI;
import com.kingdee.eas.basedata.org.ImportCompayFieldsEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class FilterForAccountF7UI
extends AbstractFilterForAccountF7UI {
    private static final Logger logger = CoreUIObject.getLogger(FilterForAccountF7UI.class);
    private boolean isCancel = true;
    private ArrayList allAccountList = null;
    private FilterInfo filterInfo;
    private Set selectedAcctIdSet;
    private int defaultHeight = 0;
    private static final int CTRL = 128;
    private static final int SHIFT = 64;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblAllAccount.checkParsed();
        this.tblSelectedAccount.checkParsed();
        this.tblAllAccount.getStyleAttributes().setLocked(true);
        this.tblSelectedAccount.getStyleAttributes().setLocked(true);
        this.tblAllAccount.getSelectManager().setSelectMode(10);
        this.tblSelectedAccount.getSelectManager().setSelectMode(10);
        this.getParamFromUIContext();
        this.loadAllAccount();
        this.loadSelectedAccount();
        this.kDComboBox1.addItem((Object)ImportCompayFieldsEnum.NUMBER);
        this.kDComboBox1.addItem((Object)ImportCompayFieldsEnum.NAME);
    }

    public void initListener() {
        this.tblAllAccount.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                int modifiersEx = e.getModifiersEx();
                if (modifiersEx != 128 && modifiersEx != 64) {
                    int rowIndex = e.getRowIndex();
                    FilterForAccountF7UI.this.dealSelectAccount(FilterForAccountF7UI.this.tblAllAccount, rowIndex);
                }
                if (e.getClickCount() >= 2) {
                    FilterForAccountF7UI.this.moveToRight();
                }
            }
        });
        this.tblSelectedAccount.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                int modifiersEx = e.getModifiersEx();
                if (modifiersEx != 128 && modifiersEx != 64) {
                    int rowIndex = e.getRowIndex();
                    FilterForAccountF7UI.this.dealSelectAccount(FilterForAccountF7UI.this.tblSelectedAccount, rowIndex);
                }
                if (e.getClickCount() >= 2) {
                    FilterForAccountF7UI.this.moveToLeft();
                }
            }
        });
        this.queryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FilterForAccountF7UI.this.doQuerying();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private void dealSelectAccount(KDTable tblAllAccount, int rowIndex) {
        String childNumber;
        IRow row = tblAllAccount.getRow(rowIndex);
        String accNumber = (String)row.getCell("number").getValue();
        int selectCount = 0;
        for (int i = rowIndex + 1; i < tblAllAccount.getRowCount() && (childNumber = (String)tblAllAccount.getRow(i).getCell("number").getValue()).startsWith(accNumber); ++i) {
            ++selectCount;
        }
        KDTSelectManager sm = tblAllAccount.getSelectManager();
        KDTSelectBlock sb = new KDTSelectBlock(rowIndex, 0, rowIndex + selectCount, tblAllAccount.getColumnCount() - 1, 2);
        sm.select(sb, true);
    }

    private void doQuerying() throws Exception {
        String value = this.kDTextField1.getText();
        String fieldStr = null;
        int showRowCount = 0;
        int field = ((ImportCompayFieldsEnum)this.kDComboBox1.getSelectedItem()).getValue();
        switch (field) {
            case 1: {
                fieldStr = "number";
                break;
            }
            case 2: {
                fieldStr = "name";
            }
        }
        this.showAll(fieldStr);
        int rowCount = this.tblAllAccount.getRowCount();
        boolean isBlurred = this.fuzzyQuery.isSelected();
        if (!StringUtils.isEmpty((String)value)) {
            value = value.trim();
            if (this.defaultHeight == 0 && rowCount > 0) {
                this.defaultHeight = this.tblAllAccount.getRow(0).getHeight();
            }
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.tblAllAccount.getRow(i);
                String tableValue = row.getCell(fieldStr).getValue().toString();
                if (isBlurred) {
                    if (tableValue.indexOf(value) != -1) {
                        row.setHeight(this.defaultHeight);
                        this.tblAllAccount.moveRow(i, showRowCount);
                        ++showRowCount;
                        continue;
                    }
                    row.getStyleAttributes().setHided(true);
                    continue;
                }
                if (tableValue.equals(value)) {
                    row.setHeight(this.defaultHeight);
                    this.tblAllAccount.moveRow(i, showRowCount);
                    ++showRowCount;
                    continue;
                }
                row.getStyleAttributes().setHided(true);
            }
        }
    }

    private void showAll(String fieldStr) {
        this.tblAllAccount.removeRows();
        HashSet<Object> numberSet = new HashSet<Object>();
        for (int i = 0; i < this.tblSelectedAccount.getRowCount(); ++i) {
            Object numberObject = this.tblSelectedAccount.getRow(i).getCell(fieldStr).getValue();
            numberSet.add(numberObject);
        }
        for (Object o : this.allAccountList) {
            if (fieldStr.equals("number")) {
                if (numberSet.contains(((AccountViewFilterInfo)o).getNumber())) continue;
                this.loadRowData(this.tblAllAccount, (AccountViewFilterInfo)o);
                continue;
            }
            if (!fieldStr.equals("name") || numberSet.contains(((AccountViewFilterInfo)o).getName())) continue;
            this.loadRowData(this.tblAllAccount, (AccountViewFilterInfo)o);
        }
    }

    private void getParamFromUIContext() {
        this.filterInfo = (FilterInfo)this.getUIContext().get("filter");
        this.selectedAcctIdSet = (Set)this.getUIContext().get("selectedAccountIdSet");
    }

    private void loadAllAccount() {
        try {
            this.loadAllAccountToTbl(this.tblAllAccount);
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    private void loadSelectedAccount() throws EASBizException, BOSException {
        if (this.selectedAcctIdSet == null || this.selectedAcctIdSet.isEmpty()) {
            return;
        }
        int rowCount = this.tblAllAccount.getRowCount();
        block0: for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblAllAccount.getRow(i);
            AccountViewFilterInfo acctFilterInfo = (AccountViewFilterInfo)row.getCell("idSet").getUserObject();
            for (String accountId : this.selectedAcctIdSet) {
                if (!acctFilterInfo.getIdSet().contains(accountId)) continue;
                this.tblAllAccount.removeRow(i--);
                --rowCount;
                this.loadRowData(this.tblSelectedAccount, acctFilterInfo);
                continue block0;
            }
        }
    }

    private List getAllAccountList() throws EASBizException, BOSException {
        if (this.allAccountList == null) {
            this.allAccountList = AccountFacadeFactory.getRemoteInstance().getMultiOrgAccountInfoList(this.filterInfo);
        }
        if (this.allAccountList == null) {
            this.allAccountList = new ArrayList();
        }
        return this.allAccountList;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnSelect_actionPerformed(ActionEvent e) throws Exception {
        this.moveToRight();
    }

    private void moveToRight() {
        ArrayList selectedList = this.getSelectedList(this.tblAllAccount);
        this.addSelectedAccount(this.tblSelectedAccount, selectedList);
        this.tblAllAccount.getSelectManager().removeAll();
    }

    private void moveToLeft() {
        ArrayList selectedList = this.getSelectedList(this.tblSelectedAccount);
        this.addSelectedAccount(this.tblAllAccount, selectedList);
        this.tblSelectedAccount.getSelectManager().removeAll();
    }

    private ArrayList getSelectedList(KDTable srcTable) {
        ArrayList<AccountViewFilterInfo> selectedList = new ArrayList<AccountViewFilterInfo>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)srcTable);
        if (selectRows == null || srcTable.getSelectManager().getActiveRowIndex() < 0) {
            return selectedList;
        }
        IRow row = null;
        for (int i = 0; i < selectRows.length; ++i) {
            row = srcTable.getRow(selectRows[i] - i);
            if (row.getStyleAttributes().isHided()) continue;
            selectedList.add((AccountViewFilterInfo)row.getCell("idSet").getUserObject());
            srcTable.removeRow(selectRows[i] - i);
        }
        return selectedList;
    }

    private void addSelectedAccount(KDTable destTable, ArrayList selectedList) {
        if (selectedList != null && selectedList.size() != 0) {
            for (int i = 0; i < selectedList.size(); ++i) {
                AccountViewFilterInfo acctFilterInfo = (AccountViewFilterInfo)selectedList.get(i);
                this.loadRowData(destTable, acctFilterInfo);
            }
        }
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.loadAllAccountToTbl(this.tblSelectedAccount);
    }

    private void loadAllAccountToTbl(KDTable destTable) throws EASBizException, BOSException {
        if (destTable.equals(this.tblAllAccount)) {
            this.tblSelectedAccount.removeRows();
        }
        this.tblAllAccount.removeRows();
        List allAccountList = this.getAllAccountList();
        List<AccountViewFilterInfo> allAccountListNew = new ArrayList();
        if ((ImportCompayFieldsEnum)this.kDComboBox1.getSelectedItem() != null) {
            String value = this.kDTextField1.getText();
            int rowCount = allAccountList.size();
            boolean isBlurred = this.fuzzyQuery.isSelected();
            String fieldStr = null;
            boolean showRowCount = false;
            int field = ((ImportCompayFieldsEnum)this.kDComboBox1.getSelectedItem()).getValue();
            switch (field) {
                case 1: {
                    fieldStr = "number";
                    break;
                }
                case 2: {
                    fieldStr = "name";
                }
            }
            if (!StringUtils.isEmpty((String)value)) {
                value = value.trim();
                for (int i = 0; i < rowCount; ++i) {
                    String tableValue;
                    AccountViewFilterInfo item = (AccountViewFilterInfo)allAccountList.get(i);
                    String string = tableValue = "number".equals(fieldStr) ? item.getNumber() : item.getName();
                    if (isBlurred) {
                        if (tableValue.indexOf(value) == -1) continue;
                        allAccountListNew.add(item);
                        continue;
                    }
                    if (!tableValue.equals(value)) continue;
                    allAccountListNew.add(item);
                }
            } else {
                allAccountListNew = allAccountList;
            }
        } else {
            allAccountListNew = allAccountList;
        }
        boolean isExist = false;
        HashSet<Object> existSelected = new HashSet<Object>();
        if (destTable.equals(this.tblSelectedAccount)) {
            int count = this.tblSelectedAccount.getRowCount();
            for (int j = 0; j < count; ++j) {
                existSelected.add(this.tblSelectedAccount.getRow(j).getCell("number").getValue());
            }
        }
        if (allAccountListNew != null && allAccountListNew.size() != 0) {
            for (int i = 0; i < allAccountListNew.size(); ++i) {
                AccountViewFilterInfo acctFilterInfo = (AccountViewFilterInfo)allAccountListNew.get(i);
                isExist = false;
                if (destTable.equals(this.tblSelectedAccount) && existSelected.contains(acctFilterInfo.getNumber())) {
                    isExist = true;
                }
                if (isExist) continue;
                this.loadRowData(destTable, acctFilterInfo);
            }
        }
    }

    private void loadRowData(KDTable table, AccountViewFilterInfo acctFilterInfo) {
        int rowIndex = table.getRowCount();
        for (int i = 0; i < table.getRowCount(); ++i) {
            String number = (String)table.getRow(i).getCell("number").getValue();
            if (number.compareTo(acctFilterInfo.getNumber()) <= 0) continue;
            rowIndex = i;
            break;
        }
        IRow row = table.addRow(rowIndex);
        row.getCell("idSet").setValue((Object)acctFilterInfo.getIdSet());
        row.getCell("number").setValue((Object)acctFilterInfo.getNumber());
        row.getCell("name").setValue((Object)acctFilterInfo.getName());
        row.getCell("idSet").setUserObject((Object)acctFilterInfo);
    }

    @Override
    protected void btnUnSelect_actionPerformed(ActionEvent e) throws Exception {
        this.moveToLeft();
    }

    @Override
    protected void btnUnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.loadAllAccountToTbl(this.tblAllAccount);
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = false;
        this.selectedAcctIdSet = new HashSet();
        IRow row = null;
        for (int i = 0; i < this.tblSelectedAccount.getRowCount(); ++i) {
            row = this.tblSelectedAccount.getRow(i);
            this.selectedAcctIdSet.addAll(((AccountViewFilterInfo)row.getCell("idSet").getUserObject()).getIdSet());
        }
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.getUIWindow().close();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public Set getData() {
        if (!this.isCancel) {
            return this.selectedAcctIdSet;
        }
        return new HashSet();
    }
}

