/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountCurrencyFactory;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountRefCollection;
import com.kingdee.eas.basedata.master.account.AccountRefFactory;
import com.kingdee.eas.basedata.master.account.AccountRefInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountCurrency;
import com.kingdee.eas.basedata.master.account.IAccountRef;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.calc.express.IllegalParameterException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class AccountUtils {
    public static int getMaxAccountLeve(IObjectPK companyInfoPK) throws BOSException, EASBizException {
        return AccountViewFactory.getRemoteInstance().getMaxLevel(companyInfoPK);
    }

    public static int getMaxGroupControlAccountLeve(IObjectPK companyInfoPK) throws BOSException, EASBizException {
        return AccountViewFactory.getRemoteInstance().getMaxGroupControlLevel(companyInfoPK);
    }

    public static int getMaxGroupControlAccountLeve(Context ctx, IObjectPK companyInfoPK) throws BOSException, EASBizException {
        if (ctx != null) {
            return AccountViewFactory.getLocalInstance(ctx).getMaxGroupControlLevel(companyInfoPK);
        }
        return AccountViewFactory.getRemoteInstance().getMaxGroupControlLevel(companyInfoPK);
    }

    public static int getMaxAccountLeve(Context ctx, IObjectPK companyInfoPK) throws BOSException, EASBizException {
        if (ctx != null) {
            return AccountViewFactory.getLocalInstance(ctx).getMaxLevel(companyInfoPK);
        }
        return AccountViewFactory.getRemoteInstance().getMaxLevel(companyInfoPK);
    }

    public static AccountViewCollection getBankAccountViewCByCompany(CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo == null || companyInfo.getId() == null) {
            return null;
        }
        AccountViewCollection AccountViewc = null;
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)Boolean.TRUE));
        String cuId = null;
        cuId = companyInfo.getCU() != null && companyInfo.getCU().getId() != null && companyInfo.getCU().getId().toString().length() > 1 ? companyInfo.getCU().getId().toString() : AccountTools.getCuIdFromCompanyPK(null, (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        filter.setMaskString("#0 and #1");
        evi.getSorter().add(new SorterItemInfo("number"));
        try {
            AccountViewc = iAccountView.getAccountViewCollection(evi);
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        return AccountViewc;
    }

    public static AccountViewCollection getBankAccountViewCByCompany(IObjectPK companyInfoPK) throws BOSException, EASBizException {
        if (companyInfoPK == null) {
            return null;
        }
        AccountViewCollection accounts = null;
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)Boolean.TRUE));
        String cuId = AccountTools.getCuIdFromCompanyPK(null, companyInfoPK);
        if (cuId == null) {
            cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        filter.setMaskString("#0 and #1");
        evi.getSorter().add(new SorterItemInfo("number"));
        accounts = iAccountView.getAccountViewCollection(evi);
        return accounts;
    }

    public static AccountViewCollection getBankAccountViewCByCompany(CompanyOrgUnitInfo companyInfo, boolean isLeaf) throws BOSException, EASBizException {
        if (companyInfo == null || companyInfo.getId() == null) {
            return null;
        }
        AccountViewCollection AccountViewc = null;
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)Boolean.TRUE));
        String cuId = null;
        cuId = companyInfo.getCU() != null && companyInfo.getCU().getId() != null && companyInfo.getCU().getId().toString().length() > 1 ? companyInfo.getCU().getId().toString() : AccountTools.getCuIdFromCompanyPK(null, (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        if (isLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE));
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.setMaskString("#0 and #1");
        }
        evi.getSorter().add(new SorterItemInfo("number"));
        try {
            AccountViewc = iAccountView.getAccountViewCollection(evi);
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        return AccountViewc;
    }

    public static AccountViewCollection getBankAccountViewCByCompany(IObjectPK companyInfoPK, boolean isLeaf) throws BOSException, EASBizException {
        if (companyInfoPK == null) {
            return null;
        }
        AccountViewCollection accounts = null;
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)Boolean.TRUE));
        String cuId = AccountTools.getCuIdFromCompanyPK(null, companyInfoPK);
        if (cuId == null) {
            cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        if (isLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE));
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.setMaskString("#0 and #1");
        }
        evi.getSorter().add(new SorterItemInfo("number"));
        accounts = iAccountView.getAccountViewCollection(evi);
        return accounts;
    }

    public static AccountViewCollection getBankAccountViewCByCompany(IObjectPK companyInfoPK, boolean isLeaf, boolean isFreezed) throws BOSException, EASBizException {
        if (companyInfoPK == null) {
            return null;
        }
        AccountViewCollection accounts = null;
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)Boolean.TRUE));
        String cuId = AccountTools.getCuIdFromCompanyPK(null, companyInfoPK);
        if (cuId == null) {
            cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        if (isLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE));
        }
        if (isFreezed) {
            filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Boolean.TRUE, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Boolean.TRUE, CompareType.NOTEQUALS));
            if (isLeaf) {
                filter.setMaskString("(#0 and #1 and #2) and (#3 or #4)");
            } else {
                filter.setMaskString("(#0 and #1 ) and (#2 or #3)");
            }
        } else if (isLeaf) {
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.setMaskString("#0 and #1");
        }
        evi.getSorter().add(new SorterItemInfo("number"));
        accounts = iAccountView.getAccountViewCollection(evi);
        return accounts;
    }

    public static AccountViewCollection getBankAccountViewCByCompany(CompanyOrgUnitInfo companyInfo, CurrencyInfo currencyInfo) throws BOSException, EASBizException {
        if (companyInfo == null || currencyInfo == null) {
            return null;
        }
        if (companyInfo.getId() == null || currencyInfo.getId() == null) {
            return null;
        }
        AccountViewCollection AccountViewc = new AccountViewCollection();
        IAccountCurrency acctCu = AccountCurrencyFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("accountView.isBank", (Object)Boolean.TRUE));
        String cuId = null;
        cuId = companyInfo.getCU() != null && companyInfo.getCU().getId() != null && companyInfo.getCU().getId().toString().length() > 1 ? companyInfo.getCU().getId().toString() : AccountTools.getCuIdFromCompanyPK(null, (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("accountView.CU", (Object)cuId));
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)currencyInfo.getId().toString()));
        filter.setMaskString("#0 and #1 and #2");
        evi.getSelector().add("accountView.*");
        evi.getSelector().add("currency");
        evi.getSorter().add(new SorterItemInfo("accountView.number"));
        AccountCurrencyCollection acctCuCollection = acctCu.getAccountCurrencyCollection(evi);
        if (acctCuCollection != null) {
            int count = acctCuCollection.size();
            for (int i = 0; i < count; ++i) {
                AccountViewc.add(acctCuCollection.get(i).getAccountView());
            }
        }
        return AccountViewc;
    }

    public static AccountViewCollection getBankAccountViewCByCompany(IObjectPK companyInfoPK, IObjectPK currencyInfoPK) throws BOSException, EASBizException {
        if (companyInfoPK == null || currencyInfoPK == null) {
            return null;
        }
        AccountViewCollection AccountViewc = new AccountViewCollection();
        IAccountCurrency acctCu = AccountCurrencyFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("accountView.isBank", (Object)Boolean.TRUE));
        String cuId = AccountTools.getCuIdFromCompanyPK(null, companyInfoPK);
        if (cuId == null) {
            cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("accountView.CU", (Object)cuId));
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)currencyInfoPK.toString()));
        filter.setMaskString("#0 and #1 and #2");
        evi.getSelector().add("accountView.*");
        evi.getSelector().add("currency");
        evi.getSorter().add(new SorterItemInfo("accountView.number"));
        AccountCurrencyCollection acctCuCollection = acctCu.getAccountCurrencyCollection(evi);
        if (acctCuCollection != null) {
            int count = acctCuCollection.size();
            for (int i = 0; i < count; ++i) {
                AccountViewc.add(acctCuCollection.get(i).getAccountView());
            }
        }
        return AccountViewc;
    }

    public static AccountViewCollection getBankAccountViewCByCompany(CompanyOrgUnitInfo companyInfo, CurrencyInfo currencyInfo, boolean isLeaf) throws BOSException, EASBizException {
        if (companyInfo == null || currencyInfo == null) {
            return null;
        }
        if (companyInfo.getId() == null || currencyInfo.getId() == null) {
            return null;
        }
        AccountViewCollection AccountViewc = new AccountViewCollection();
        IAccountCurrency acctCu = AccountCurrencyFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("accountView.isBank", (Object)Boolean.TRUE));
        String cuId = null;
        cuId = companyInfo.getCU() != null && companyInfo.getCU().getId() != null && companyInfo.getCU().getId().toString().length() > 1 ? companyInfo.getCU().getId().toString() : AccountTools.getCuIdFromCompanyPK(null, (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("accountView.CU", (Object)cuId));
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)currencyInfo.getId().toString()));
        if (isLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("accountView.isLeaf", (Object)Boolean.TRUE));
            filter.setMaskString("#0 and #1 and #2 and #3");
        } else {
            filter.setMaskString("#0 and #1 and #2");
        }
        evi.getSelector().add("accountView.*");
        evi.getSelector().add("currency");
        evi.getSorter().add(new SorterItemInfo("accountView.number"));
        AccountCurrencyCollection acctCuCollection = acctCu.getAccountCurrencyCollection(evi);
        if (acctCuCollection != null) {
            int count = acctCuCollection.size();
            for (int i = 0; i < count; ++i) {
                AccountViewc.add(acctCuCollection.get(i).getAccountView());
            }
        }
        return AccountViewc;
    }

    public static AccountViewCollection getBankAccountViewCByCompany(IObjectPK companyInfoPK, IObjectPK currencyInfoPK, boolean isLeaf) throws BOSException, EASBizException {
        if (companyInfoPK == null || currencyInfoPK == null) {
            return null;
        }
        AccountViewCollection AccountViewc = new AccountViewCollection();
        IAccountCurrency acctCu = AccountCurrencyFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("accountView.isBank", (Object)Boolean.TRUE));
        String cuId = AccountTools.getCuIdFromCompanyPK(null, companyInfoPK);
        if (cuId == null) {
            cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("accountView.CU", (Object)cuId));
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)currencyInfoPK.toString()));
        if (isLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("accountView.isLeaf", (Object)Boolean.TRUE));
            filter.setMaskString("#0 and #1 and #2 and #3");
        } else {
            filter.setMaskString("#0 and #1 and #2");
        }
        evi.getSelector().add("accountView.*");
        evi.getSelector().add("currency");
        evi.getSorter().add(new SorterItemInfo("accountView.number"));
        AccountCurrencyCollection acctCuCollection = acctCu.getAccountCurrencyCollection(evi);
        if (acctCuCollection != null) {
            int count = acctCuCollection.size();
            for (int i = 0; i < count; ++i) {
                AccountViewc.add(acctCuCollection.get(i).getAccountView());
            }
        }
        return AccountViewc;
    }

    public static AccountViewCollection getCashAccountViewCByCompany(CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo.getId() == null) {
            return null;
        }
        AccountViewCollection AccountViewc = null;
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("isCash", (Object)Boolean.TRUE));
        String cuId = null;
        cuId = companyInfo.getCU() != null && companyInfo.getCU().getId() != null && companyInfo.getCU().getId().toString().length() > 1 ? companyInfo.getCU().getId().toString() : AccountTools.getCuIdFromCompanyPK(null, (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        filter.setMaskString("#0 and #1");
        evi.getSorter().add(new SorterItemInfo("number"));
        try {
            AccountViewc = iAccountView.getAccountViewCollection(evi);
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        return AccountViewc;
    }

    public static AccountViewCollection getCashAccountViewCByCompany(IObjectPK companyInfoPK) throws BOSException, EASBizException {
        if (companyInfoPK == null) {
            return null;
        }
        AccountViewCollection accounts = null;
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("isCash", (Object)Boolean.TRUE));
        String cuId = AccountTools.getCuIdFromCompanyPK(null, companyInfoPK);
        if (cuId == null) {
            cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        filter.setMaskString("#0 and #1");
        evi.getSorter().add(new SorterItemInfo("number"));
        accounts = iAccountView.getAccountViewCollection(evi);
        return accounts;
    }

    public static AccountViewCollection getCashAccountViewCByCompany(CompanyOrgUnitInfo companyInfo, boolean isLeaf) throws BOSException, EASBizException {
        if (companyInfo.getId() == null) {
            return null;
        }
        AccountViewCollection AccountViewc = null;
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("isCash", (Object)Boolean.TRUE));
        String cuId = null;
        cuId = companyInfo.getCU() != null && companyInfo.getCU().getId() != null && companyInfo.getCU().getId().toString().length() > 1 ? companyInfo.getCU().getId().toString() : AccountTools.getCuIdFromCompanyPK(null, (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        if (isLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE));
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.setMaskString("#0 and #1");
        }
        evi.getSorter().add(new SorterItemInfo("number"));
        try {
            AccountViewc = iAccountView.getAccountViewCollection(evi);
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        return AccountViewc;
    }

    public static AccountViewCollection getCashAccountViewCByCompany(IObjectPK companyInfoPK, boolean isLeaf) throws BOSException, EASBizException {
        if (companyInfoPK == null) {
            return null;
        }
        AccountViewCollection accounts = null;
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("isCash", (Object)Boolean.TRUE));
        String cuId = AccountTools.getCuIdFromCompanyPK(null, companyInfoPK);
        if (cuId == null) {
            cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        if (isLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE));
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.setMaskString("#0 and #1");
        }
        evi.getSorter().add(new SorterItemInfo("number"));
        accounts = iAccountView.getAccountViewCollection(evi);
        return accounts;
    }

    public static AccountViewCollection getCashAccountViewCByCompany(IObjectPK companyInfoPK, boolean isLeaf, boolean isFreeze) throws BOSException, EASBizException {
        if (companyInfoPK == null) {
            return null;
        }
        AccountViewCollection accounts = null;
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("isCash", (Object)Boolean.TRUE));
        String cuId = AccountTools.getCuIdFromCompanyPK(null, companyInfoPK);
        if (cuId == null) {
            cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        boolean flag = false;
        if (isLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE));
            flag = true;
        }
        if (isFreeze) {
            filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Boolean.TRUE, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Boolean.TRUE, CompareType.NOTEQUALS));
            if (flag) {
                filter.setMaskString("(#0 and #1 and #2) and (#3 or #4)");
            } else {
                filter.setMaskString("(#0 and #1) and (#2 or #3)");
            }
        } else if (flag) {
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.setMaskString("#0 and #1");
        }
        evi.getSorter().add(new SorterItemInfo("number"));
        accounts = iAccountView.getAccountViewCollection(evi);
        return accounts;
    }

    public static AccountViewCollection getCashAccountViewCByCompany(CompanyOrgUnitInfo companyInfo, CurrencyInfo currencyInfo) throws BOSException, EASBizException {
        if (companyInfo == null || currencyInfo == null) {
            return null;
        }
        if (companyInfo.getId() == null || currencyInfo.getId() == null) {
            return null;
        }
        AccountViewCollection AccountViewc = new AccountViewCollection();
        IAccountCurrency acctCu = AccountCurrencyFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("accountView.isCash", (Object)Boolean.TRUE));
        String cuId = null;
        cuId = companyInfo.getCU() != null && companyInfo.getCU().getId() != null && companyInfo.getCU().getId().toString().length() > 1 ? companyInfo.getCU().getId().toString() : AccountTools.getCuIdFromCompanyPK(null, (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("accountView.CU", (Object)cuId));
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)currencyInfo.getId().toString()));
        filter.setMaskString("#0 and #1 and #2");
        evi.getSelector().add("accountView.*");
        evi.getSelector().add("currency");
        evi.getSorter().add(new SorterItemInfo("accountView.number"));
        AccountCurrencyCollection acctCuCollection = acctCu.getAccountCurrencyCollection(evi);
        if (acctCuCollection != null) {
            int count = acctCuCollection.size();
            for (int i = 0; i < count; ++i) {
                AccountViewc.add(acctCuCollection.get(i).getAccountView());
            }
        }
        return AccountViewc;
    }

    public static AccountViewCollection getCashAccountViewCByCompany(IObjectPK companyInfoPK, IObjectPK currencyInfoPK) throws BOSException, EASBizException {
        if (companyInfoPK == null || currencyInfoPK == null) {
            return null;
        }
        AccountViewCollection AccountViewc = new AccountViewCollection();
        IAccountCurrency acctCu = AccountCurrencyFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("accountView.isCash", (Object)Boolean.TRUE));
        String cuId = AccountTools.getCuIdFromCompanyPK(null, companyInfoPK);
        if (cuId == null) {
            cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("accountView.CU", (Object)cuId));
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)currencyInfoPK.toString()));
        filter.setMaskString("#0 and #1 and #2");
        evi.getSelector().add("accountView.*");
        evi.getSelector().add("currency");
        evi.getSorter().add(new SorterItemInfo("accountView.number"));
        AccountCurrencyCollection acctCuCollection = acctCu.getAccountCurrencyCollection(evi);
        if (acctCuCollection != null) {
            int count = acctCuCollection.size();
            for (int i = 0; i < count; ++i) {
                AccountViewc.add(acctCuCollection.get(i).getAccountView());
            }
        }
        return AccountViewc;
    }

    public static AccountViewCollection getCashAccountViewCByCompany(CompanyOrgUnitInfo companyInfo, CurrencyInfo currencyInfo, boolean isLeaf) throws BOSException, EASBizException {
        if (companyInfo == null || currencyInfo == null) {
            return null;
        }
        if (companyInfo.getId() == null || currencyInfo.getId() == null) {
            return null;
        }
        AccountViewCollection AccountViewc = new AccountViewCollection();
        IAccountCurrency acctCu = AccountCurrencyFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("accountView.isCash", (Object)Boolean.TRUE));
        String cuId = null;
        cuId = companyInfo.getCU() != null && companyInfo.getCU().getId() != null && companyInfo.getCU().getId().toString().length() > 1 ? companyInfo.getCU().getId().toString() : AccountTools.getCuIdFromCompanyPK(null, (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("accountView.CU", (Object)cuId));
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)currencyInfo.getId().toString()));
        if (isLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("accountView.isLeaf", (Object)Boolean.TRUE));
            filter.setMaskString("#0 and #1 and #2 and #3");
        } else {
            filter.setMaskString("#0 and #1 and #2");
        }
        evi.getSelector().add("accountView.*");
        evi.getSelector().add("currency");
        evi.getSorter().add(new SorterItemInfo("accountView.number"));
        AccountCurrencyCollection acctCuCollection = acctCu.getAccountCurrencyCollection(evi);
        if (acctCuCollection != null) {
            int count = acctCuCollection.size();
            for (int i = 0; i < count; ++i) {
                AccountViewc.add(acctCuCollection.get(i).getAccountView());
            }
        }
        return AccountViewc;
    }

    public static AccountViewCollection getCashAccountViewCByCompany(IObjectPK companyInfoPK, IObjectPK currencyInfoPK, boolean isLeaf) throws BOSException, EASBizException {
        if (companyInfoPK == null || currencyInfoPK == null) {
            return null;
        }
        AccountViewCollection AccountViewc = new AccountViewCollection();
        IAccountCurrency acctCu = AccountCurrencyFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("accountView.isCash", (Object)Boolean.TRUE));
        String cuId = AccountTools.getCuIdFromCompanyPK(null, companyInfoPK);
        if (cuId == null) {
            cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("accountView.CU", (Object)cuId));
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)currencyInfoPK.toString()));
        if (isLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("accountView.isLeaf", (Object)Boolean.TRUE));
            filter.setMaskString("#0 and #1 and #2 and #3");
        } else {
            filter.setMaskString("#0 and #1 and #2");
        }
        evi.getSelector().add("accountView.*");
        evi.getSelector().add("currency");
        evi.getSorter().add(new SorterItemInfo("accountView.number"));
        AccountCurrencyCollection acctCuCollection = acctCu.getAccountCurrencyCollection(evi);
        if (acctCuCollection != null) {
            int count = acctCuCollection.size();
            for (int i = 0; i < count; ++i) {
                AccountViewc.add(acctCuCollection.get(i).getAccountView());
            }
        }
        return AccountViewc;
    }

    public static AccountViewCollection getAccountViewCByCompany(Context ctx, CompanyOrgUnitInfo companyInfo, FilterInfo userfilter) throws BOSException, EASBizException {
        if (companyInfo.getId() == null) {
            return null;
        }
        AccountViewCollection AccountViewc = null;
        IAccountView iAccountView = null;
        iAccountView = ctx != null ? AccountViewFactory.getLocalInstance(ctx) : AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        String cuId = null;
        cuId = companyInfo.getCU() != null && companyInfo.getCU().getId() != null && companyInfo.getCU().getId().toString().length() > 1 ? companyInfo.getCU().getId().toString() : AccountTools.getCuIdFromCompanyPK(ctx, (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        filter.setMaskString("#0");
        if (userfilter != null && userfilter.getFilterItems().size() > 0 && !userfilter.getMaskString().equals("")) {
            filter.mergeFilter(userfilter, "and");
        }
        evi.getSorter().add(new SorterItemInfo("number"));
        try {
            AccountViewc = iAccountView.getAccountViewCollection(evi);
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        return AccountViewc;
    }

    public static AccountViewCollection getAccountViewCByCompany(Context ctx, IObjectPK companyInfoPK, FilterInfo userfilter) throws BOSException, EASBizException {
        if (companyInfoPK == null) {
            return null;
        }
        AccountViewCollection accounts = null;
        IAccountView iAccountView = null;
        iAccountView = ctx != null ? AccountViewFactory.getLocalInstance(ctx) : AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        String cuId = AccountTools.getCuIdFromCompanyPK(null, companyInfoPK);
        if (cuId == null) {
            cuId = ctx == null ? SysContext.getSysContext().getCurrentCtrlUnit().getId().toString() : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        filter.setMaskString("#0");
        if (userfilter != null && userfilter.getFilterItems().size() > 0 && userfilter.getMaskString() != null && !userfilter.getMaskString().equals("")) {
            filter.mergeFilter(userfilter, "and");
        }
        evi.getSorter().add(new SorterItemInfo("number"));
        try {
            accounts = iAccountView.getAccountViewCollection(evi);
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        return accounts;
    }

    public static AccountViewCollection getAccountViewCByCompany(CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo.getId() == null) {
            return null;
        }
        AccountViewCollection AccountViewc = null;
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        String cuId = null;
        cuId = companyInfo.getCU() != null && companyInfo.getCU().getId() != null && companyInfo.getCU().getId().toString().length() > 1 ? companyInfo.getCU().getId().toString() : AccountTools.getCuIdFromCompanyPK(null, (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        evi.getSorter().add(new SorterItemInfo("number"));
        try {
            AccountViewc = iAccountView.getAccountViewCollection(evi);
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        return AccountViewc;
    }

    public static AccountViewCollection getAccountViewCByCompany(IObjectPK companyInfoPK) throws BOSException, EASBizException {
        if (companyInfoPK == null) {
            return null;
        }
        AccountViewCollection accounts = null;
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        String cuId = AccountTools.getCuIdFromCompanyPK(null, companyInfoPK);
        if (cuId == null) {
            cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        evi.getSorter().add(new SorterItemInfo("number"));
        try {
            accounts = iAccountView.getAccountViewCollection(evi);
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        return accounts;
    }

    public static AccountViewCollection getAccountViewCByNumber(String NumberFrom, String NumberTo, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo == null || companyInfo.getId() == null) {
            return null;
        }
        if (NumberFrom == null || NumberTo == null) {
            return null;
        }
        AccountViewCollection AccountViewc = null;
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)NumberFrom, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)NumberTo, CompareType.LESS_EQUALS));
        String cuId = null;
        cuId = companyInfo.getCU() != null && companyInfo.getCU().getId() != null && companyInfo.getCU().getId().toString().length() > 1 ? companyInfo.getCU().getId().toString() : AccountTools.getCuIdFromCompanyPK(null, (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        filter.setMaskString("#0 and #1 and #2");
        evi.getSorter().add(new SorterItemInfo("number"));
        try {
            AccountViewc = iAccountView.getAccountViewCollection(evi);
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        return AccountViewc;
    }

    public static AccountViewCollection getAccountViewCByNumber(String NumberFrom, String NumberTo, IObjectPK companyInfoPK) throws BOSException, EASBizException {
        if (companyInfoPK == null || StringUtils.isEmpty((String)NumberFrom) || StringUtils.isEmpty((String)NumberTo)) {
            return null;
        }
        AccountViewCollection accounts = null;
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)NumberFrom, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)NumberTo, CompareType.LESS_EQUALS));
        String cuId = AccountTools.getCuIdFromCompanyPK(null, companyInfoPK);
        if (cuId == null) {
            cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        filter.setMaskString("#0 and #1 and #2");
        evi.getSorter().add(new SorterItemInfo("number"));
        accounts = iAccountView.getAccountViewCollection(evi);
        return accounts;
    }

    public static AccountViewCollection getAccountViewCByNumber(Context ctx, String NumberFrom, String NumberTo, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo == null || companyInfo.getId() == null || NumberFrom == null || NumberTo == null) {
            return null;
        }
        AccountViewCollection AccountViewc = null;
        IAccountView iAccountView = null;
        try {
            iAccountView = ctx != null ? AccountViewFactory.getLocalInstance(ctx) : AccountViewFactory.getRemoteInstance();
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)NumberFrom, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)NumberTo, CompareType.LESS_EQUALS));
        String cuId = null;
        cuId = companyInfo.getCU() != null && companyInfo.getCU().getId() != null && companyInfo.getCU().getId().toString().length() > 1 ? companyInfo.getCU().getId().toString() : AccountTools.getCuIdFromCompanyPK(ctx, (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        filter.setMaskString("#0 and #1 and #2");
        evi.getSorter().add(new SorterItemInfo("number"));
        try {
            AccountViewc = iAccountView.getAccountViewCollection(evi);
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        return AccountViewc;
    }

    public static AccountViewCollection getAccountViewCByNumber(Context ctx, String NumberFrom, String NumberTo, IObjectPK companyInfoPK) throws BOSException, EASBizException {
        if (companyInfoPK == null || StringUtils.isEmpty((String)NumberFrom) || StringUtils.isEmpty((String)NumberTo)) {
            return null;
        }
        AccountViewCollection accounts = null;
        IAccountView iAccountView = null;
        iAccountView = ctx != null ? AccountViewFactory.getLocalInstance(ctx) : AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)NumberFrom, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)NumberTo, CompareType.LESS_EQUALS));
        String cuId = AccountTools.getCuIdFromCompanyPK(ctx, companyInfoPK);
        if (cuId == null) {
            cuId = ctx == null ? SysContext.getSysContext().getCurrentCtrlUnit().getId().toString() : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        filter.setMaskString("#0 and #1 and #2");
        evi.getSorter().add(new SorterItemInfo("number"));
        accounts = iAccountView.getAccountViewCollection(evi);
        return accounts;
    }

    public static AccountViewCollection getAccountViewCByNumber(Context ctx, String NumberFrom, String NumberTo, CompanyOrgUnitInfo companyInfo, FilterInfo userFilter) throws BOSException, EASBizException {
        if (companyInfo == null || companyInfo.getId() == null) {
            return null;
        }
        AccountViewCollection AccountViewc = null;
        IAccountView iAccountView = null;
        try {
            iAccountView = ctx != null ? AccountViewFactory.getLocalInstance(ctx) : AccountViewFactory.getRemoteInstance();
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)NumberFrom, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)NumberTo, CompareType.LESS_EQUALS));
        String cuId = null;
        cuId = companyInfo.getCU() != null && companyInfo.getCU().getId() != null && companyInfo.getCU().getId().toString().length() > 1 ? companyInfo.getCU().getId().toString() : AccountTools.getCuIdFromCompanyPK(ctx, (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        StringBuffer buffer = new StringBuffer("#0 and #1 and #2");
        filter.setMaskString(buffer.toString());
        if (userFilter != null) {
            filter.mergeFilter(userFilter, "and");
        } else {
            filter.setMaskString(buffer.toString());
        }
        evi.getSorter().add(new SorterItemInfo("number"));
        try {
            AccountViewc = iAccountView.getAccountViewCollection(evi);
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        return AccountViewc;
    }

    public static AccountViewCollection getAccountViewCByNumber(Context ctx, String NumberFrom, String NumberTo, IObjectPK companyInfoPK, FilterInfo userFilter) throws BOSException, EASBizException {
        if (companyInfoPK == null || StringUtils.isEmpty((String)NumberFrom) || StringUtils.isEmpty((String)NumberTo)) {
            return null;
        }
        AccountViewCollection accounts = null;
        IAccountView iAccountView = null;
        iAccountView = ctx != null ? AccountViewFactory.getLocalInstance(ctx) : AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)NumberFrom, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)NumberTo, CompareType.LESS_EQUALS));
        String cuId = AccountTools.getCuIdFromCompanyPK(null, companyInfoPK);
        if (cuId == null) {
            cuId = ctx == null ? SysContext.getSysContext().getCurrentCtrlUnit().getId().toString() : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        StringBuffer buffer = new StringBuffer("#0 and #1 and #2");
        filter.setMaskString(buffer.toString());
        if (userFilter != null) {
            filter.mergeFilter(userFilter, "and");
        } else {
            filter.setMaskString(buffer.toString());
        }
        evi.getSorter().add(new SorterItemInfo("number"));
        accounts = iAccountView.getAccountViewCollection(evi);
        return accounts;
    }

    public static AccountViewCollection getAccountViewCByNumber(AccountViewInfo ViewInfoFrom, AccountViewInfo ViewInfoTo, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo.getId() == null) {
            return null;
        }
        if (ViewInfoFrom == null || ViewInfoTo == null) {
            return null;
        }
        AccountViewCollection AccountViewc = null;
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)ViewInfoFrom.getLongNumber(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)ViewInfoTo.getLongNumber(), CompareType.LESS_EQUALS));
        String cuId = null;
        cuId = companyInfo.getCU() != null && companyInfo.getCU().getId() != null && companyInfo.getCU().getId().toString().length() > 1 ? companyInfo.getCU().getId().toString() : AccountTools.getCuIdFromCompanyPK(null, (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        filter.setMaskString("#0 and #1 and #2");
        evi.getSorter().add(new SorterItemInfo("number"));
        try {
            AccountViewc = iAccountView.getAccountViewCollection(evi);
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        return AccountViewc;
    }

    public static AccountViewCollection getAccountViewCByNumber(IObjectPK ViewInfoFromPK, IObjectPK ViewInfoToPK, IObjectPK companyInfoPK) throws BOSException, EASBizException {
        AccountViewInfo ViewInfoFrom = null;
        AccountViewInfo ViewInfoTo = null;
        if (companyInfoPK == null || ViewInfoFromPK == null || ViewInfoToPK == null) {
            return null;
        }
        AccountViewCollection accounts = null;
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        ViewInfoFrom = iAccountView.getAccountViewInfo(ViewInfoFromPK);
        ViewInfoTo = iAccountView.getAccountViewInfo(ViewInfoToPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)ViewInfoFrom.getLongNumber(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)ViewInfoTo.getLongNumber(), CompareType.LESS_EQUALS));
        String cuId = AccountTools.getCuIdFromCompanyPK(null, companyInfoPK);
        if (cuId == null) {
            cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        filter.setMaskString("#0 and #1 and #2");
        evi.getSorter().add(new SorterItemInfo("number"));
        accounts = iAccountView.getAccountViewCollection(evi);
        return accounts;
    }

    public static AccountViewInfo getAccountViewCByNumber(String Number2, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo == null || companyInfo.getId() == null) {
            return null;
        }
        if (Number2 == null) {
            return null;
        }
        AccountViewInfo accountViewInfo = null;
        AccountViewCollection AccountViewc = null;
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)Number2, CompareType.EQUALS));
        String cuId = null;
        cuId = companyInfo.getCU() != null && companyInfo.getCU().getId() != null && companyInfo.getCU().getId().toString().length() > 1 ? companyInfo.getCU().getId().toString() : AccountTools.getCuIdFromCompanyPK(null, (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        filter.setMaskString("#0 and #1");
        try {
            AccountViewc = iAccountView.getAccountViewCollection(evi);
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        if (AccountViewc.size() > 0) {
            accountViewInfo = AccountViewc.get(0);
        }
        return accountViewInfo;
    }

    public static AccountViewInfo getAccountViewCByNumber(String number, IObjectPK companyInfoPK) throws BOSException, EASBizException {
        if (companyInfoPK == null || StringUtils.isEmpty((String)number)) {
            return null;
        }
        AccountViewInfo accountViewInfo = null;
        AccountViewCollection accounts = null;
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CompanyID", (Object)companyInfoPK.toString()));
        filter.setMaskString("#0 and #1");
        accounts = iAccountView.getAccountViewCollection(evi);
        if (accounts != null && accounts.size() > 0) {
            accountViewInfo = accounts.get(0);
        }
        return accountViewInfo;
    }

    public static AccountViewInfo getAccountViewCByNumber(String number, IObjectPK companyInfoPK, IObjectPK accountTableInfoPK) throws BOSException, EASBizException {
        if (companyInfoPK == null || StringUtils.isEmpty((String)number)) {
            return null;
        }
        AccountViewInfo accountViewInfo = null;
        AccountViewCollection accounts = null;
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CompanyID.id", (Object)companyInfoPK.toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableInfoPK.toString()));
        accounts = iAccountView.getAccountViewCollection(evi);
        if (accounts != null && accounts.size() > 0) {
            accountViewInfo = accounts.get(0);
        }
        return accountViewInfo;
    }

    public static AccountViewInfo getCommAccount(Context ctx, AccountViewInfo accountView) throws BOSException, EASBizException {
        AccountViewInfo commAccount = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("CompanyID", null));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)accountView.getAccount().getId().toString()));
        filter.setMaskString("#0 and #1");
        IAccountView iAccountView = null;
        iAccountView = ctx == null ? AccountViewFactory.getRemoteInstance() : AccountViewFactory.getLocalInstance(ctx);
        AccountViewCollection accountViewC = iAccountView.getAccountViewCollection(evi);
        if (accountViewC.size() <= 0) {
            return null;
        }
        commAccount = accountViewC.get(0);
        return commAccount;
    }

    public static AccountViewInfo getCommAccount(Context ctx, IObjectPK accountViewPK) throws BOSException, EASBizException {
        AccountViewInfo accountView = null;
        AccountViewInfo commAccount = null;
        if (accountViewPK == null) {
            return null;
        }
        IAccountView iAccountView = null;
        iAccountView = ctx == null ? AccountViewFactory.getRemoteInstance() : AccountViewFactory.getLocalInstance(ctx);
        accountView = iAccountView.getAccountViewInfo(accountViewPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("CompanyID", null));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)accountView.getAccount().getId().toString()));
        filter.setMaskString("#0 and #1");
        AccountViewCollection accountViewC = iAccountView.getAccountViewCollection(evi);
        if (accountViewC.size() <= 0) {
            return null;
        }
        commAccount = accountViewC.get(0);
        return commAccount;
    }

    public static AccountViewInfo getCommAccount(Context ctx, String accountViewId) throws BOSException, EASBizException {
        AccountViewInfo commAccount = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        AccountViewInfo accountView = null;
        IAccountView iAccountView = null;
        iAccountView = ctx == null ? AccountViewFactory.getRemoteInstance() : AccountViewFactory.getLocalInstance(ctx);
        accountView = iAccountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountViewId));
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("CompanyID", null));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)accountView.getAccount().getId().toString()));
        filter.setMaskString("#0 and #1");
        AccountViewCollection accountViewC = iAccountView.getAccountViewCollection(evi);
        if (accountViewC.size() <= 0) {
            return null;
        }
        commAccount = accountViewC.get(0);
        return commAccount;
    }

    public static AccountViewInfo getCompanyAccount(Context ctx, AccountViewInfo accountView, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        AccountViewInfo companyAccount = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("CompanyID", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("account", (Object)accountView.getAccount().getId().toString()));
        filter.setMaskString("#0 and #1");
        IAccountView iAccountView = null;
        iAccountView = ctx == null ? AccountViewFactory.getRemoteInstance() : AccountViewFactory.getLocalInstance(ctx);
        AccountViewCollection accountViewC = iAccountView.getAccountViewCollection(evi);
        if (accountViewC.size() <= 0) {
            return null;
        }
        companyAccount = accountViewC.get(0);
        return companyAccount;
    }

    public static AccountViewInfo getCompanyAccount(Context ctx, IObjectPK accountViewPK, IObjectPK companyPK) throws BOSException, EASBizException {
        if (accountViewPK == null || companyPK == null) {
            return null;
        }
        AccountViewInfo accountView = null;
        AccountViewInfo companyAccount = null;
        IAccountView iAccountView = null;
        iAccountView = ctx == null ? AccountViewFactory.getRemoteInstance() : AccountViewFactory.getLocalInstance(ctx);
        accountView = iAccountView.getAccountViewInfo(accountViewPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("CompanyID", (Object)companyPK.toString()));
        filter.getFilterItems().add(new FilterItemInfo("account", (Object)accountView.getAccount().getId().toString()));
        filter.setMaskString("#0 and #1");
        AccountViewCollection accountViewC = iAccountView.getAccountViewCollection(evi);
        if (accountViewC.size() <= 0) {
            return null;
        }
        companyAccount = accountViewC.get(0);
        return companyAccount;
    }

    public static AccountViewInfo getCompanyAccount(Context ctx, String accountViewId, String companyId) throws BOSException, EASBizException {
        AccountViewInfo companyAccount = null;
        IAccountView iAccountView = null;
        ICompanyOrgUnit iCompanyOrgUnit = null;
        if (ctx == null) {
            iAccountView = AccountViewFactory.getRemoteInstance();
            iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        } else {
            iAccountView = AccountViewFactory.getLocalInstance(ctx);
            iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        }
        AccountViewInfo accountView = new AccountViewInfo();
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        accountView = iAccountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountViewId));
        company = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("CompanyID", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("account", (Object)accountView.getId().toString()));
        filter.setMaskString("#0 and #1");
        AccountViewCollection accountViewC = iAccountView.getAccountViewCollection(evi);
        if (accountViewC.size() <= 0) {
            return null;
        }
        companyAccount = accountViewC.get(0);
        return companyAccount;
    }

    public static Hashtable getAccountViewByRef(AccountViewCollection sourceAccountC, CompanyOrgUnitInfo sourceCompany, CompanyOrgUnitInfo targetCompany) throws BOSException, EASBizException {
        Hashtable<AccountViewInfo, AccountViewInfo> accountView = new Hashtable<AccountViewInfo, AccountViewInfo>();
        if (sourceCompany == null || targetCompany == null) {
            throw new AccountException(AccountException.COMPANY_NOT_NULL);
        }
        if (sourceAccountC == null) {
            throw new AccountException(AccountException.ACCOUNTCOLLECTION_NOT_NULL);
        }
        AccountViewInfo sourceAccount = new AccountViewInfo();
        AccountViewInfo targetAccount = new AccountViewInfo();
        for (int i = 0; i < sourceAccountC.size(); ++i) {
            sourceAccount = sourceAccountC.get(i);
            targetAccount = AccountUtils.getAccountViewByRef(null, sourceAccount, sourceCompany, targetCompany);
            if (targetAccount == null) continue;
            accountView.put(sourceAccount, targetAccount);
        }
        return accountView;
    }

    public static Hashtable getAccountViewByRef(Context ctx, AccountViewCollection sourceAccountC, CompanyOrgUnitInfo sourceCompany, CompanyOrgUnitInfo targetCompany) throws BOSException, EASBizException {
        Hashtable<AccountViewInfo, AccountViewInfo> accountView = new Hashtable<AccountViewInfo, AccountViewInfo>();
        if (sourceCompany == null || targetCompany == null) {
            throw new AccountException(AccountException.COMPANY_NOT_NULL);
        }
        if (sourceAccountC == null) {
            throw new AccountException(AccountException.ACCOUNTCOLLECTION_NOT_NULL);
        }
        AccountViewInfo sourceAccount = new AccountViewInfo();
        AccountViewInfo targetAccount = new AccountViewInfo();
        for (int i = 0; i < sourceAccountC.size(); ++i) {
            sourceAccount = sourceAccountC.get(i);
            targetAccount = AccountUtils.getAccountViewByRef(ctx, sourceAccount, sourceCompany, targetCompany);
            if (targetAccount == null) continue;
            accountView.put(sourceAccount, targetAccount);
        }
        return accountView;
    }

    public static AccountViewInfo getAccountViewByRef(Context ctx, AccountViewInfo sourceAccount, CompanyOrgUnitInfo sourceCompany, CompanyOrgUnitInfo targetCompany) throws BOSException, EASBizException {
        if (sourceCompany == null || targetCompany == null) {
            throw new AccountException(AccountException.COMPANY_NOT_NULL);
        }
        if (sourceAccount == null) {
            throw new AccountException(AccountException.ACCOUNTCOLLECTION_NOT_NULL);
        }
        AccountViewInfo targetAccountComm = new AccountViewInfo();
        AccountViewInfo targetAccount = new AccountViewInfo();
        IAccountView iAccountView = null;
        IAccountRef iAccountRef = null;
        ICompanyOrgUnit iCompanyOrgUnit = null;
        if (ctx == null) {
            iAccountRef = AccountRefFactory.getRemoteInstance();
            iAccountView = AccountViewFactory.getRemoteInstance();
            iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        } else {
            iAccountRef = AccountRefFactory.getLocalInstance(ctx);
            iAccountView = AccountViewFactory.getLocalInstance(ctx);
            iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        }
        targetCompany = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(targetCompany.getId()));
        EntityViewInfo evi1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        evi1.setFilter(filter1);
        filter1.getFilterItems().add(new FilterItemInfo("srcAccountID", (Object)sourceAccount.getAccount().getId().toString()));
        filter1.getFilterItems().add(new FilterItemInfo("srcTableID", (Object)sourceAccount.getAccountTableID().getId().toString()));
        filter1.getFilterItems().add(new FilterItemInfo("destTableID", (Object)targetCompany.getAccountTable().getId().toString()));
        AccountRefCollection accountRefC = iAccountRef.getAccountRefCollection(evi1);
        if (accountRefC.size() <= 0) {
            return null;
        }
        AccountRefInfo accountRef = accountRefC.get(0);
        targetAccountComm = iAccountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountRef.getDestAccountID().getId()));
        EntityViewInfo evi2 = new EntityViewInfo();
        FilterInfo filter2 = new FilterInfo();
        evi2.setFilter(filter2);
        filter2.getFilterItems().add(new FilterItemInfo("account", (Object)targetAccountComm.getId().toString()));
        filter2.getFilterItems().add(new FilterItemInfo("CompanyID", (Object)targetCompany.getId().toString()));
        AccountViewCollection accountViewTC = iAccountView.getAccountViewCollection(evi2);
        if (accountViewTC.size() <= 0) {
            return null;
        }
        targetAccount = accountViewTC.get(0);
        return targetAccount;
    }

    public static AccountViewInfo getSrcAccountViewByRef(Context ctx, AccountViewInfo destAccount, CompanyOrgUnitInfo sourceCompany, CompanyOrgUnitInfo targetCompany) throws BOSException, EASBizException {
        if (sourceCompany == null || targetCompany == null) {
            throw new AccountException(AccountException.COMPANY_NOT_NULL);
        }
        if (destAccount == null) {
            throw new AccountException(AccountException.ACCOUNTCOLLECTION_NOT_NULL);
        }
        AccountViewInfo targetAccountComm = new AccountViewInfo();
        IAccountView iAccountView = null;
        ICompanyOrgUnit iCompanyOrgUnit = null;
        if (ctx == null) {
            iAccountView = AccountViewFactory.getRemoteInstance();
            iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        } else {
            iAccountView = AccountViewFactory.getLocalInstance(ctx);
            iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        }
        sourceCompany = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(sourceCompany.getId()));
        targetAccountComm = iAccountView.getAccountViewInfo("select id,isBank,name,number,longNumber,isLeaf,dc,level where id in (select FOldAcctID from T_BD_AcctRefContrastEntry arfe inner join T_BD_AcctRefContrast arf  on arf.fid = arfe.FAcctRefContrastID where arfe.FNewAcctID = '" + destAccount.getId().toString() + "' and arf.FDisabledAcctTableID = '" + sourceCompany.getAccountTable().getId().toString() + "' and arf.FEnabledAcctTableID = '" + destAccount.getAccountTableID().getId().toString() + "')");
        return targetAccountComm;
    }

    public static AccountViewCollection getSourceAccountViewByRef(Context ctx, AccountViewInfo targetAccount, CompanyOrgUnitInfo targetCompany, CompanyOrgUnitInfo sourceCompany) throws BOSException, EASBizException {
        if (sourceCompany == null || targetCompany == null) {
            throw new AccountException(AccountException.COMPANY_NOT_NULL);
        }
        if (targetAccount == null) {
            throw new AccountException(AccountException.ACCOUNTCOLLECTION_NOT_NULL);
        }
        AccountViewCollection srcAccountViewC = new AccountViewCollection();
        AccountViewInfo sourceAccountComm = new AccountViewInfo();
        IAccountView iAccountView = null;
        IAccountRef iAccountRef = null;
        ICompanyOrgUnit iCompanyOrgUnit = null;
        if (ctx == null) {
            iAccountRef = AccountRefFactory.getRemoteInstance();
            iAccountView = AccountViewFactory.getRemoteInstance();
            iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        } else {
            iAccountRef = AccountRefFactory.getLocalInstance(ctx);
            iAccountView = AccountViewFactory.getLocalInstance(ctx);
            iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        }
        sourceCompany = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(sourceCompany.getId()));
        targetCompany = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(targetCompany.getId()));
        EntityViewInfo evi1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        evi1.setFilter(filter1);
        filter1.getFilterItems().add(new FilterItemInfo("destAccountID", (Object)targetAccount.getAccount().getId().toString()));
        filter1.getFilterItems().add(new FilterItemInfo("destTableID", (Object)targetCompany.getAccountTable().getId().toString()));
        filter1.getFilterItems().add(new FilterItemInfo("srcTableID", (Object)sourceCompany.getAccountTable().getId().toString()));
        AccountRefCollection accountRefC = iAccountRef.getAccountRefCollection(evi1);
        if (accountRefC.size() <= 0) {
            return null;
        }
        for (int i = 0; i < accountRefC.size(); ++i) {
            EntityViewInfo evi2 = new EntityViewInfo();
            FilterInfo filter2 = new FilterInfo();
            sourceAccountComm = accountRefC.get(i).getSrcAccountID();
            evi2.setFilter(filter2);
            filter2.getFilterItems().add(new FilterItemInfo("account", (Object)sourceAccountComm.getId().toString()));
            filter2.getFilterItems().add(new FilterItemInfo("CompanyID", (Object)sourceCompany.getId().toString()));
            AccountViewCollection accountViewSRC = iAccountView.getAccountViewCollection(evi2);
            if (accountViewSRC.size() <= 0) continue;
            srcAccountViewC.add(accountViewSRC.get(0));
        }
        return srcAccountViewC;
    }

    public static AccountViewCollection getSourceAccountViewByRef(Context ctx, AccountViewCollection targetAccountC, CompanyOrgUnitInfo targetCompany, CompanyOrgUnitInfo sourceCompany) throws BOSException, EASBizException {
        AccountViewCollection sourceCollection = new AccountViewCollection();
        if (sourceCompany == null || targetCompany == null) {
            throw new AccountException(AccountException.COMPANY_NOT_NULL);
        }
        if (targetAccountC == null) {
            throw new AccountException(AccountException.ACCOUNTCOLLECTION_NOT_NULL);
        }
        for (int i = 0; i < targetAccountC.size(); ++i) {
            AccountViewCollection sources = new AccountViewCollection();
            sources = AccountUtils.getSourceAccountViewByRef(ctx, targetAccountC.get(i), targetCompany, sourceCompany);
            sourceCollection.addCollection(sources);
        }
        return sourceCollection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Hashtable getSourceCompanyAccountViewByRef(Context ctx, AccountViewCollection targetAccountC, CompanyOrgUnitInfo targetCompany, CompanyOrgUnitInfo sourceCompany) throws BOSException, EASBizException {
        Hashtable<String, AccountViewCollection> hashtable = new Hashtable<String, AccountViewCollection>();
        if (sourceCompany == null) {
            throw new AccountException(AccountException.COMPANY_NOT_NULL);
        }
        if (targetAccountC == null) {
            throw new AccountException(AccountException.ACCOUNTCOLLECTION_NOT_NULL);
        }
        if (targetCompany.getAccountTable() == null || sourceCompany.getAccountTable() == null) throw new AccountException(AccountException.COMPANYNOTACCTTABLE);
        if (!targetCompany.getAccountTable().getId().toString().equals(sourceCompany.getAccountTable().getId().toString())) throw new AccountException(AccountException.COMPANYNOTACCTTABLE);
        IAccountView iAccountView = ctx != null ? AccountViewFactory.getLocalInstance(ctx) : AccountViewFactory.getRemoteInstance();
        for (int i = 0; i < targetAccountC.size(); ++i) {
            AccountViewInfo targetAccount = targetAccountC.get(i);
            AccountViewInfo sourceAccount = AccountUtils.getRefferencedAccount(iAccountView, targetAccount, targetCompany, sourceCompany);
            AccountViewCollection sources = new AccountViewCollection();
            if (sourceAccount != null) {
                sources.add(sourceAccount);
            }
            hashtable.put(targetAccountC.get(i).getId().toString(), sources);
        }
        return hashtable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Hashtable getSourceCompanyAccountViewByRef(Context ctx, IObjectPK[] targetAccountPKs, IObjectPK targetCompanyPK, IObjectPK sourceCompanyPK) throws BOSException, EASBizException {
        Hashtable<String, AccountViewCollection> hashtable = new Hashtable<String, AccountViewCollection>();
        if (targetCompanyPK == null || sourceCompanyPK == null) {
            throw new AccountException(AccountException.COMPANY_NOT_NULL);
        }
        if (targetAccountPKs == null) {
            throw new AccountException(AccountException.ACCOUNTCOLLECTION_NOT_NULL);
        }
        ICompanyOrgUnit iCompanyOrgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitInfo sourceCompany = iCompanyOrgUnit.getCompanyOrgUnitInfo(sourceCompanyPK);
        CompanyOrgUnitInfo targetCompany = iCompanyOrgUnit.getCompanyOrgUnitInfo(targetCompanyPK);
        if (targetCompany.getAccountTable() == null || sourceCompany.getAccountTable() == null) throw new AccountException(AccountException.COMPANYNOTACCTTABLE);
        if (!targetCompany.getAccountTable().getId().toString().equals(sourceCompany.getAccountTable().getId().toString())) throw new AccountException(AccountException.COMPANYNOTACCTTABLE);
        IAccountView iAccountView = ctx != null ? AccountViewFactory.getLocalInstance(ctx) : AccountViewFactory.getRemoteInstance();
        for (int i = 0; i < targetAccountPKs.length; ++i) {
            AccountViewInfo targetAccount = iAccountView.getAccountViewInfo(targetAccountPKs[i]);
            AccountViewInfo sourceAccount = AccountUtils.getRefferencedAccount(iAccountView, targetAccount, targetCompany, sourceCompany);
            AccountViewCollection sources = new AccountViewCollection();
            if (sourceAccount != null) {
                sources.add(sourceAccount);
            }
            hashtable.put(targetAccountPKs[i].toString(), sources);
        }
        return hashtable;
    }

    private static AccountViewInfo getRefferencedAccount(IAccountView iAccountView, AccountViewInfo targetAccount, CompanyOrgUnitInfo targetCompany, CompanyOrgUnitInfo sourceCompany) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)targetAccount.getAccountTableID().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)sourceCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)targetAccount.getNumber()));
        AccountViewCollection accounts = iAccountView.getAccountViewCollection(evi);
        if (accounts.size() > 0) {
            return accounts.get(0);
        }
        return null;
    }

    public static AccountViewCollection getGroupControlAccountsByCompany(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        IAccountView iAccountView = ctx != null ? AccountViewFactory.getLocalInstance(ctx) : AccountViewFactory.getRemoteInstance();
        return iAccountView.getGroupControlAccountsByCompany(companyPK);
    }

    public static IObjectPK[] checkCompanyAccouts(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        IAccountView iAccountView = ctx != null ? AccountViewFactory.getLocalInstance(ctx) : AccountViewFactory.getRemoteInstance();
        return iAccountView.checkCompanyAccouts(companyPK);
    }

    public static IObjectPK[] checkAllAccounts(Context ctx) throws BOSException, EASBizException {
        IAccountView iAccountView = ctx != null ? AccountViewFactory.getLocalInstance(ctx) : AccountViewFactory.getRemoteInstance();
        return iAccountView.checkAllAccounts();
    }

    public static IObjectPK[] repairCompanyAccounts(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        return new IObjectPK[0];
    }

    public static int getEASModeValue(Context ctx) throws EASBizException, BOSException {
        return 0;
    }

    public static boolean getAccountControlLevelParam(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
        String number = "AccountControlLevel";
        hmParamIn.put(number, null);
        IParamControl pc = null;
        pc = ctx != null ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        boolean allowCussent = true;
        if (hmAllParam.get(number) != null) {
            allowCussent = Boolean.valueOf(hmAllParam.get(number).toString());
        }
        return allowCussent;
    }

    public static AccountViewCollection getAccountViewCollectionWithDataPermission(Context ctx, String companyId, String currencyId, EntityViewInfo viewInfo) throws BOSException, EASBizException {
        ICompanyOrgUnit iCompany = null;
        iCompany = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitInfo comInfo = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        String strCUId = comInfo.getCU().getId().toString();
        String acctTableId = comInfo.getAccountTable().getId().toString();
        IAccountView iAccountView = null;
        iAccountView = ctx != null ? AccountViewFactory.getLocalInstance(ctx) : AccountViewFactory.getRemoteInstance();
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("cu.id", (Object)strCUId));
        if (acctTableId != null) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctTableId));
        }
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("accountCurrency.id"));
        selector.add(new SelectorItemInfo("accountCurrency.currency"));
        selector.add(new SelectorItemInfo("accountCurrency.currency.id"));
        selector.add(new SelectorItemInfo("accountCurrency.currency.name"));
        selector.add(new SelectorItemInfo("accountingcurrency"));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        AccountViewCollection acctViewCol = iAccountView.getAccountViewCollection(viewInfo);
        if (acctViewCol == null || acctViewCol.size() == 0) {
            return null;
        }
        if (currencyId == null) {
            return acctViewCol;
        }
        IContextHelper iContextHelper = null;
        iContextHelper = ctx != null ? ContextHelperFactory.getLocalInstance((Context)ctx) : ContextHelperFactory.getRemoteInstance();
        CurrencyInfo baseCy = iContextHelper.getCompanyBaseCurrency(comInfo);
        String localCurrencyId = "";
        if (baseCy != null) {
            localCurrencyId = baseCy.getId().toString();
        }
        if (localCurrencyId.length() == 0) {
            return acctViewCol;
        }
        AccountViewCollection retColl = new AccountViewCollection();
        AccountCurrencyCollection acctCurColl = null;
        int size = acctViewCol.size();
        block5: for (int i = 0; i < size; ++i) {
            AccountViewInfo acctInfo = acctViewCol.get(i);
            switch (acctInfo.getAccountingcurrency().getValue()) {
                case 2: {
                    retColl.add(acctInfo);
                }
                case 0: {
                    if (localCurrencyId.equals(currencyId)) {
                        retColl.add(acctInfo);
                    }
                }
                case 1: {
                    acctCurColl = acctInfo.getAccountCurrency();
                    for (int j = 0; j < acctCurColl.size(); ++j) {
                        if (!acctCurColl.get(j).getCurrency().getId().toString().equals(currencyId)) continue;
                        retColl.add(acctInfo);
                        continue block5;
                    }
                    continue block5;
                }
            }
        }
        return retColl;
    }

    public static AccountViewCollection getAccountViewCollection(Context ctx, String companyId, String currencyId, EntityViewInfo viewInfo) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((String)companyId)) {
            throw new BOSException((Throwable)new IllegalParameterException("company is null"));
        }
        EntityViewInfo view = viewInfo;
        if (viewInfo == null) {
            view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection items = filter.getFilterItems();
            items.add(new FilterItemInfo("isLeaf", (Object)Constants.TRUE));
            items.add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
            items.add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        }
        return AccountUtils.getAccountViewCollectionWithDataPermission(ctx, companyId, currencyId, view);
    }

    public static Set getAcctViewIdSet(Context ctx, String companyId, String currencyId, EntityViewInfo viewInfo) throws EASBizException, BOSException {
        HashSet<String> set = new HashSet<String>();
        AccountViewCollection acctViewColl = AccountUtils.getAccountViewCollection(ctx, companyId, currencyId, viewInfo);
        if (acctViewColl == null) {
            return null;
        }
        int size = acctViewColl.size();
        AccountViewInfo acctViewInfo = null;
        for (int i = 0; i < size; ++i) {
            acctViewInfo = acctViewColl.get(i);
            set.add(acctViewInfo.getId().toString());
        }
        return set;
    }

    public static EntityViewInfo getAccountViewEvi(String companyId, String currencyId, EntityViewInfo viewInfo) throws EASBizException, BOSException {
        Set set = AccountUtils.getAcctViewIdSet(null, companyId, currencyId, viewInfo);
        EntityViewInfo info = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (set == null || set.size() == 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", null));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        }
        info.setFilter(filter);
        return info;
    }
}

