/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.core.fi.gl.client.ClientHelper;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.master.account.AccountAssignErrorInfo;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.Account_ControlCollection;
import com.kingdee.eas.basedata.master.account.Account_ControlInfo;
import com.kingdee.eas.basedata.master.account.IAccountFacade;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.client.AbstractAccountAssignUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.EconomicTypeEnum;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.stefan.snrpc.util.StringUtil;

public class AccountAssignUI
extends AbstractAccountAssignUI {
    CtrlUnitInfo currentCu;
    CompanyOrgUnitInfo currentCompany;
    AccountTableInfo currentTable;
    Account_ControlCollection acctCtrlCols;
    AccountViewCollection accountCols;
    HashMap accountAssignCols = new HashMap();
    Account_ControlInfo acctCtrlInfo;
    ArrayList acctAssignedNumberList = new ArrayList();
    ArrayList canAssignedIdList = new ArrayList();
    ArrayList canAssignedNumberList = new ArrayList();
    protected HashMap assignedAcctNumberListPerCompany = new HashMap();
    protected HashMap assignedAcctInfoPurNumberAndCompany = new HashMap();
    private static final String ACCOUNTRESOURCE = "com.kingdee.eas.basedata.master.account.client.AccountResource";
    IColumn addcolumn = null;
    ArrayList checkList = new ArrayList();
    private String oldAcctSearchCondition = "";
    private String oldComSearchCondition = " and fnumber like '%%'";
    private boolean ctxFIIsChosen = false;
    private FilterInfo commFilter = null;
    private boolean isAllowCAByParam = false;
    private CommonQueryDialog cmpCommonQueryDialog = null;
    private boolean isCmpCommonQueryDialogLastChose = false;
    private CommonQueryDialog acctCommonQueryDialog = null;

    public AccountAssignUI() throws Exception {
        this.acctCtrlCols = new Account_ControlCollection();
        this.accountCols = new AccountViewCollection();
        this.btnAllSelect.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnAllDisSelect.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnSetAcctCtrlForRef.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.btnBatchSetControlProperty.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.btnAssign.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.selectall.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.modfiys.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnSelectAllOU.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnDisselectAllOU.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnAcctSearch.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnCompanySearch.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.rbAssigned.setEnabled(true);
        this.rbNotAssigned.setEnabled(true);
        this.btnAllSelect.setEnabled(true);
        this.btnAllDisSelect.setEnabled(true);
        this.btnAllSelect.addAssistMenuItem((Action)((Object)this.actionSelectUpper));
        this.btnAllDisSelect.addAssistMenuItem((Action)((Object)this.actionDisSelectUpper));
        this.btnAllSelect.addAssistMenuItem((Action)((Object)this.actionSelectAllCA));
        this.btnAllDisSelect.addAssistMenuItem((Action)((Object)this.actionDisSelectAllCA));
        this.btnAssign.setEnabled(true);
        this.btnAssign.setText(EASResource.getString((String)ACCOUNTRESOURCE, (String)"assign"));
        this.btnAssign.setToolTipText(EASResource.getString((String)ACCOUNTRESOURCE, (String)"assign"));
        this.tblCompanyForAssigned.checkParsed();
        this.setActionser();
        this.tblCompanyForAssigned.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                if (e.getColIndex() == 1) {
                    KDTable tblCompany = (KDTable)e.getSource();
                    IRow row = tblCompany.getRow(e.getRowIndex());
                    if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) {
                        row.getCell("selected").setValue((Object)Boolean.TRUE);
                        AccountAssignUI.this.setAcctCtrl(row);
                    } else {
                        row.getCell("selected").setValue((Object)Boolean.FALSE);
                    }
                    AccountAssignUI.this.isSelectAll(row);
                    AccountAssignUI.this.loadSelectedStatus();
                    AccountAssignUI.this.acctFastQuery();
                }
            }
        });
        this.tblAccountForAssigned.checkParsed();
        this.tblAccountForAssigned.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                if (e.getColIndex() == 0) {
                    KDTable tblAccount = (KDTable)e.getSource();
                    IRow row = tblAccount.getRow(e.getRowIndex());
                    AccountViewInfo acctInfo = (AccountViewInfo)row.getCell("account").getUserObject();
                    if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) {
                        row.getCell("selected").setValue((Object)Boolean.TRUE);
                        AccountAssignUI.this.setAcctSelected(row, acctInfo);
                    } else {
                        row.getCell("selected").setValue((Object)Boolean.FALSE);
                        row.getCell("gLevel").setValue((Object)new Integer(acctInfo.getGLevel()));
                        AccountAssignUI.this.setAcctDisSelected(row, acctInfo);
                    }
                    AccountAssignUI.this.lblAccountForAssigned.requestFocus();
                }
            }
        });
        this.btnCompanySearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AccountAssignUI.this.onClickForBtnCompanySearch();
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.btnAcctSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountAssignUI.this.onClickForBtnAcctSearch();
            }
        });
        this.loadFields();
        this.loadonset();
        this.fillFilterFields();
        this.tblAccountForAssigned.getIndexColumn().getStyleAttributes().setHided(true);
        ClientHelper.setTableKeyBoardManager((KDTable)this.tblAccountForAssigned);
        ClientHelper.setTableKeyBoardManager((KDTable)this.tblCompanyForAssigned);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.companyTextField, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.acctTextField, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        ObjectUuidPK cuPK = new ObjectUuidPK(this.currentCompany == null ? null : this.currentCompany.getCU().getId());
        this.isAllowCAByParam = Boolean.valueOf(ParamManager.getParamValue(null, (IObjectPK)cuPK, (String)"ACCOUNT004"));
    }

    private void fillFilterFields() {
        this.acctSearchField.removeAllItems();
        this.companySearchField.removeAllItems();
        this.acctSearchField.addItems((Object[])this.getAcctFilterFields());
        this.companySearchField.addItems((Object[])this.getCompanyFilterFields());
    }

    private FilterFieldItem[] getCompanyFilterFields() {
        ArrayList al = new ArrayList();
        int sizeOfAL = al.size();
        FilterFieldItem[] ffis = new FilterFieldItem[sizeOfAL];
        if (ffis.length == 0) {
            ffis = new FilterFieldItem[]{new FilterFieldItem("number", EASResource.getString((String)ACCOUNTRESOURCE, (String)"numberForAssign"), ConstDataType.STRING), new FilterFieldItem("name", EASResource.getString((String)ACCOUNTRESOURCE, (String)"nameForAssign"), ConstDataType.STRING), new FilterFieldItem("industry", EASResource.getString((String)ACCOUNTRESOURCE, (String)"industryForAssign"), ConstDataType.STRING), new FilterFieldItem("economicType", EASResource.getString((String)ACCOUNTRESOURCE, (String)"economicTypeForAssign"), ConstDataType.STRING)};
        }
        return ffis;
    }

    private FilterFieldItem[] getAcctFilterFields() {
        ArrayList al = new ArrayList();
        int sizeOfAL = al.size();
        FilterFieldItem[] ffis = new FilterFieldItem[sizeOfAL];
        if (ffis.length == 0) {
            ffis = new FilterFieldItem[]{new FilterFieldItem("number", EASResource.getString((String)ACCOUNTRESOURCE, (String)"Number"), ConstDataType.STRING), new FilterFieldItem("name", EASResource.getString((String)ACCOUNTRESOURCE, (String)"Name"), ConstDataType.STRING)};
        }
        return ffis;
    }

    protected void loadonset() {
        this.btnAssign.setEnabled(true);
        IRow row = null;
        CompanyOrgUnitCollection children = new CompanyOrgUnitCollection();
        int counts = this.tblCompanyForAssigned.getRowCount();
        for (int op = 0; op < counts; ++op) {
            row = this.tblCompanyForAssigned.getRow(op);
            CompanyOrgUnitInfo sd = (CompanyOrgUnitInfo)row.getCell("companyNumber").getUserObject();
            children.add(sd);
        }
        Map canAssignMap = null;
        try {
            canAssignMap = AccountTools.checkAccountTableCanAssignMap(null, children);
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.handleException((Exception)((Object)e));
        }
        if (canAssignMap == null) {
            return;
        }
        int counts2 = this.tblCompanyForAssigned.getRowCount();
        for (int op = 0; op < counts2; ++op) {
            boolean canAssign;
            row = this.tblCompanyForAssigned.getRow(op);
            CompanyOrgUnitInfo child = (CompanyOrgUnitInfo)row.getCell("companyNumber").getUserObject();
            boolean bl = canAssign = canAssignMap.get(child.getId().toString()) != null ? (Boolean)canAssignMap.get(child.getId().toString()) : false;
            if (canAssign) {
                row.getStyleAttributes().setHided(false);
                continue;
            }
            row.getStyleAttributes().setHided(true);
        }
    }

    protected void setActionser() throws Exception {
        this.modfiys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IRow row;
                AccountAssignUI.this.btnAssign.setEnabled(true);
                int counts = AccountAssignUI.this.tblCompanyForAssigned.getRowCount();
                for (int op = 0; op < counts; ++op) {
                    row = AccountAssignUI.this.tblCompanyForAssigned.getRow(op);
                    CompanyOrgUnitInfo sd = (CompanyOrgUnitInfo)row.getCell("companyNumber").getUserObject();
                    try {
                        boolean canAssign = AccountTools.checkAccountTableCanAssign(null, sd);
                        if (canAssign) {
                            row.getStyleAttributes().setHided(false);
                            continue;
                        }
                        row.getStyleAttributes().setHided(true);
                        continue;
                    }
                    catch (EASBizException e1) {
                        AccountAssignUI.this.handleException((Exception)((Object)e1));
                        continue;
                    }
                    catch (BOSException e2) {
                        AccountAssignUI.this.handleException((Exception)((Object)e2));
                    }
                }
                ArrayList showList = null;
                AccountAssignUI.this.getAssignedAcctIdList();
                showList = AccountAssignUI.this.acctAssignedNumberList;
                if (showList != null) {
                    String companyId = AccountAssignUI.this.checkIsSingleCompanySelected();
                    if (StringUtils.isEmpty((String)companyId)) {
                        return;
                    }
                    AccountAssignUI.this.tblAccountForAssigned.getEditManager().editingStopped();
                    int count = AccountAssignUI.this.tblAccountForAssigned.getRowCount();
                    for (int i = 0; i < count; ++i) {
                        AccountViewInfo acctInfo;
                        row = AccountAssignUI.this.tblAccountForAssigned.getRow(i);
                        if (!((Boolean)row.getCell("selected").getValue()).booleanValue() || !AccountAssignUI.this.acctAssignedNumberList.contains((acctInfo = (AccountViewInfo)((AccountViewInfo)row.getCell("account").getUserObject()).clone()).getNumber().toString())) continue;
                        acctInfo.setAccountTableID(AccountAssignUI.this.currentTable);
                        acctInfo.setGLevel((Integer)row.getCell("gLevel").getValue());
                        acctInfo.setIsUpperAllowCA((Boolean)row.getCell("isUpperAllowCA").getValue());
                        AccountAssignUI.this.accountCols.add(acctInfo);
                    }
                    AccountViewCollection acctcols = AccountAssignUI.this.getAccountCols();
                    IAccountView acct = null;
                    try {
                        acct = AccountViewFactory.getRemoteInstance();
                    }
                    catch (BOSException e1) {
                        AccountAssignUI.this.handleException((Exception)((Object)e1));
                    }
                    if (acct == null) {
                        return;
                    }
                    try {
                        acct.updateIsUpperAllowCA(companyId, acctcols);
                    }
                    catch (EASBizException e1) {
                        AccountAssignUI.this.handleException((Exception)((Object)e1));
                    }
                    catch (BOSException e1) {
                        AccountAssignUI.this.handleException((Exception)((Object)e1));
                    }
                    AccountAssignUI.this.assignedAcctNumberListPerCompany.remove(companyId);
                    AccountAssignUI.this.getAssignedAcctIdList();
                }
            }
        });
        this.selectall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountAssignUI.this.btnAssign.setEnabled(false);
                int counts = AccountAssignUI.this.tblCompanyForAssigned.getRowCount();
                for (int op = 0; op < counts; ++op) {
                    IRow row = AccountAssignUI.this.tblCompanyForAssigned.getRow(op);
                    row.getStyleAttributes().setHided(false);
                }
            }
        });
    }

    protected void setAcctCtrl(IRow row) {
        CompanyOrgUnitInfo child = (CompanyOrgUnitInfo)row.getCell("companyNumber").getUserObject();
        Object obj = row.getCell("id").getUserObject();
        Account_ControlInfo childAcctCtrlInfo = null;
        if (obj != null) {
            childAcctCtrlInfo = (Account_ControlInfo)obj;
        } else {
            try {
                childAcctCtrlInfo = AccountTools.getAcctCtrlInfo(null, this.currentTable, this.currentCompany, child);
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
            row.getCell("id").setUserObject((Object)childAcctCtrlInfo);
        }
        if (childAcctCtrlInfo != null) {
            row.getCell("id").setUserObject((Object)childAcctCtrlInfo);
            row.getCell("selected").setValue((Object)Boolean.TRUE);
            row.getCell("selected").getStyleAttributes().setLocked(false);
            row.getCell("companyNumber").setValue((Object)child.getNumber());
            row.getCell("companyNumber").setUserObject((Object)child);
            row.getCell("companyName").setValue((Object)child.getName());
        } else {
            childAcctCtrlInfo = new Account_ControlInfo();
            row.getCell("id").setUserObject((Object)childAcctCtrlInfo);
        }
        this.setAccCtrlInfo(childAcctCtrlInfo, row, false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.currentCu = (CtrlUnitInfo)this.getUIContext().get("Cu");
        this.currentCompany = (CompanyOrgUnitInfo)this.getUIContext().get("Company");
        this.currentTable = (AccountTableInfo)this.getUIContext().get("AccountTable");
        try {
            this.acctCtrlInfo = AccountTools.getAcctCtrlInfo(null, this.currentTable, this.currentCompany);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        this.loadCompanyForAssigned(this.currentCompany, this.oldComSearchCondition);
        this.loadAccountForAssigned(this.currentCompany, null);
        this.loadSelectedStatus();
    }

    protected void loadSelectedStatus() {
        this.hideTblAccountForAssigned();
        boolean isAssigned = this.rbAssigned.isSelected();
        ArrayList showList = null;
        this.getAssignedAcctIdList();
        showList = this.acctAssignedNumberList;
        if (showList != null) {
            String companyId = this.checkIsSingleCompanySelected();
            if (companyId.length() <= 0 && this.rbAssigned.isSelected()) {
                this.tblAccountForAssigned.getColumn("gLevel").getStyleAttributes().setHided(true);
                this.tblAccountForAssigned.getColumn("isUpperAllowCA").getStyleAttributes().setHided(true);
            } else {
                this.tblAccountForAssigned.getColumn("gLevel").getStyleAttributes().setHided(false);
                this.tblAccountForAssigned.getColumn("isUpperAllowCA").getStyleAttributes().setHided(false);
            }
            HashMap<String, AccountViewInfo> acctInfoMap = new HashMap<String, AccountViewInfo>();
            if (companyId.length() > 0) {
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)companyId));
                AccountViewCollection acctColl = null;
                try {
                    acctColl = (AccountViewCollection)AccountViewFactory.getRemoteInstance().getAllUpperAcctIdByCompanyAndTbl(company, this.currentTable);
                }
                catch (BOSException e) {
                    this.handleException((Exception)((Object)e));
                }
                if (acctColl != null && acctColl.size() > 0) {
                    int count = acctColl.size();
                    for (int i = 0; i < count; ++i) {
                        if (acctColl.get(i) == null) continue;
                        AccountViewInfo acctInfo = acctColl.get(i);
                        acctInfoMap.put(acctInfo.getNumber(), acctInfo);
                    }
                }
            }
            int count = this.tblAccountForAssigned.getRowCount();
            for (int i = 0; i < count; ++i) {
                IRow row = this.tblAccountForAssigned.getRow(i);
                AccountViewInfo acctInfo = (AccountViewInfo)row.getCell("account").getUserObject();
                String number = acctInfo.getNumber();
                row.getStyleAttributes().setHided(true);
                if (companyId.length() > 0) {
                    AccountViewInfo inferiorAcctInfo = (AccountViewInfo)acctInfoMap.get(number);
                    if (inferiorAcctInfo != null) {
                        row.getCell("gLevel").setValue((Object)new Integer(inferiorAcctInfo.getGLevel()));
                    }
                    if (!this.isAllowCAByParam && this.rbNotAssigned.isSelected()) {
                        if (acctInfo.isIsLeaf()) {
                            row.getCell("isUpperAllowCA").setValue((Object)new Boolean(acctInfo.isIsAllowCA()));
                        } else {
                            row.getCell("isUpperAllowCA").setValue((Object)false);
                        }
                    } else {
                        row.getCell("isUpperAllowCA").setValue((Object)new Boolean(acctInfo.isIsAllowCA()));
                    }
                } else {
                    row.getCell("gLevel").setValue((Object)new Integer(acctInfo.getGLevel()));
                    if (!this.isAllowCAByParam && this.rbNotAssigned.isSelected()) {
                        if (acctInfo.isIsLeaf()) {
                            row.getCell("isUpperAllowCA").setValue((Object)new Boolean(acctInfo.isIsAllowCA()));
                        } else {
                            row.getCell("isUpperAllowCA").setValue((Object)false);
                        }
                    } else {
                        row.getCell("isUpperAllowCA").setValue((Object)new Boolean(acctInfo.isIsAllowCA()));
                    }
                }
                if (showList.contains(number) && isAssigned) {
                    row.getStyleAttributes().setHided(false);
                    continue;
                }
                if (isAssigned || !this.rbNotAssigned.isSelected()) continue;
                if (showList.contains(number)) {
                    row.getCell("selected").setValue((Object)true);
                    this.setAcctSelected(row, acctInfo);
                    continue;
                }
                row.getStyleAttributes().setHided(false);
            }
        }
    }

    private void hideTblAccountForAssigned() {
        int count = this.tblAccountForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblAccountForAssigned.getRow(i);
            row.getStyleAttributes().setHided(true);
            row.getCell("selected").setValue((Object)false);
            AccountViewInfo acctInfo = (AccountViewInfo)row.getCell("account").getUserObject();
            row.getCell("gLevel").setValue((Object)new Integer(acctInfo.getGLevel()));
            row.getCell("isUpperAllowCA").setValue((Object)new Boolean(acctInfo.isIsAllowCA()));
            row.getCell("isUpperAllowCA").getStyleAttributes().setLocked(!acctInfo.isIsAllowCA());
        }
    }

    protected String checkIsSingleCuSelected() {
        int cuSelectedSize = 0;
        String cuId = "";
        int count = this.tblCompanyForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblCompanyForAssigned.getRow(i);
            if (((Boolean)row.getCell("selected").getValue()).booleanValue()) {
                cuId = ((CtrlUnitInfo)row.getCell("Cu").getUserObject()).getId().toString();
                ++cuSelectedSize;
            }
            if (cuSelectedSize > 1) break;
        }
        if (cuSelectedSize == 1) {
            return cuId;
        }
        return "";
    }

    protected String checkIsSingleCompanySelected() {
        int companySelectedSize = 0;
        String companyId = "";
        int count = this.tblCompanyForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblCompanyForAssigned.getRow(i);
            if (((Boolean)row.getCell("selected").getValue()).booleanValue()) {
                companyId = ((CompanyOrgUnitInfo)row.getCell("companyNumber").getUserObject()).getId().toString();
                ++companySelectedSize;
            }
            if (companySelectedSize > 1) break;
        }
        if (companySelectedSize == 1) {
            return companyId;
        }
        return "";
    }

    protected void getAssignedAcctIdList() {
        this.acctAssignedNumberList.clear();
        try {
            ArrayList<String> uncatchCompanyIDList = new ArrayList<String>();
            int count = this.tblCompanyForAssigned.getRowCount();
            for (int i = 0; i < count; ++i) {
                CompanyOrgUnitInfo company;
                String companyId;
                IRow row = this.tblCompanyForAssigned.getRow(i);
                if (!((Boolean)row.getCell("selected").getValue()).booleanValue() || StringUtils.isEmpty((String)(companyId = (company = (CompanyOrgUnitInfo)row.getCell("companyNumber").getUserObject()).getId().toString()))) continue;
                uncatchCompanyIDList.add(companyId);
            }
            IAccountFacade accountFacade = AccountFacadeFactory.getRemoteInstance();
            try {
                if (uncatchCompanyIDList != null && uncatchCompanyIDList.size() > 0) {
                    this.acctAssignedNumberList = (ArrayList)accountFacade.getIntersectAssignedAccountNumber(uncatchCompanyIDList, this.currentTable);
                }
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    protected void getCanAssignedAcctIdList() {
        this.canAssignedIdList.clear();
        if (this.accountAssignCols != null && this.accountAssignCols.size() > 0) {
            try {
                int i;
                ArrayList<String> upperIdList = null;
                int count = this.tblCompanyForAssigned.getRowCount();
                for (i = 0; i < count; ++i) {
                    IRow row = this.tblCompanyForAssigned.getRow(i);
                    if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
                    CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)row.getCell("companyNumber").getUserObject();
                    String companyId = company.getId().toString();
                    if (this.assignedAcctNumberListPerCompany.keySet().contains(companyId)) {
                        upperIdList = (ArrayList)this.assignedAcctNumberListPerCompany.get(companyId);
                        continue;
                    }
                    ArrayList upperInfoList = AccountTools.getAllUpperAcctIdByCompanyAndTbl(null, company, this.currentTable);
                    upperIdList = new ArrayList<String>();
                    HashMap acctIdToInfo = new HashMap();
                    int uCount = upperInfoList.size();
                    for (int m = 0; m < uCount; ++m) {
                        String upperId = ((AccountViewInfo)upperInfoList.get(m)).getUpper().getId().toString();
                        String number = ((AccountViewInfo)upperInfoList.get(m)).getNumber();
                        upperIdList.add(number);
                        acctIdToInfo.put(number, upperInfoList.get(m));
                    }
                    this.assignedAcctInfoPurNumberAndCompany.put(companyId, acctIdToInfo);
                    this.assignedAcctNumberListPerCompany.put(companyId, upperIdList.clone());
                }
                if (upperIdList != null) {
                    count = upperIdList.size();
                    for (i = 0; i < count; ++i) {
                        String id = (String)upperIdList.get(i);
                        if (this.accountAssignCols.containsKey(id) || this.canAssignedIdList.contains(id)) continue;
                        this.canAssignedIdList.add(id);
                    }
                }
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    protected IObjectCollection getAllAccountForAssign(IObjectValue company, IObjectValue acctTblInfo, FilterInfo filterInfo) throws BOSException {
        IAccountView acct = AccountViewFactory.getRemoteInstance();
        String companyId = ((CompanyOrgUnitInfo)company).getId().toString();
        String acctTblId = ((AccountTableInfo)acctTblInfo).getId().toString();
        AccountViewCollection acctCols = null;
        StringBuffer oqlStr = new StringBuffer();
        oqlStr.append("select id,number,name,longnumber,longname,level,glevel,controlLevel,isAllowCA,isUpperAllowCA,PARENT.id,").append("upper.id,upper.isLeaf,CAA.fid,isleaf,CU.id,companyID.id,accountTableID.id,creator.id where companyID='").append(companyId).append("' AND accountTableID='").append(acctTblId).append("'");
        oqlStr.append("  AND isCFreeze =0 ");
        if (filterInfo != null && StringUtil.isNotEmpty((String)filterInfo.toSql())) {
            oqlStr.append(" AND ").append(filterInfo.toSql());
        }
        try {
            acctCols = acct.getAccountForAssign(oqlStr.toString());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return acctCols != null && acctCols.size() > 0 ? acctCols : new AccountViewCollection();
    }

    protected void loadAccountForAssigned(CtrlUnitInfo Cu) {
        try {
            if (this.currentTable != null) {
                AccountViewCollection acctCols = (AccountViewCollection)this.getAllAccountForAssign((IObjectValue)Cu, (IObjectValue)this.currentTable, null);
                if (acctCols != null) {
                    this.tblAccountForAssigned.checkParsed();
                    this.tblAccountForAssigned.removeRows();
                    int count = acctCols.size();
                    for (int i = 0; i < count; ++i) {
                        Object obj;
                        IRow row = this.tblAccountForAssigned.addRow();
                        AccountViewInfo acctInfo = acctCols.get(i);
                        if (acctInfo.getParent() != null && (obj = this.accountAssignCols.get(acctInfo.getParent().getId().toString())) != null) {
                            AccountAssignInfo parent = (AccountAssignInfo)obj;
                            parent.addChild(row);
                        }
                        AccountAssignInfo acctAssignInfo = new AccountAssignInfo();
                        acctAssignInfo.setSelfRow(row);
                        this.accountAssignCols.put(acctInfo.getId().toString(), acctAssignInfo);
                        row.getCell("selected").setValue((Object)false);
                        row.getCell("account").setValue((Object)acctInfo.getNumber());
                        row.getCell("account").setUserObject((Object)acctInfo);
                        acctInfo.getName();
                        acctInfo.getCAA();
                        row.getCell("accountName").setValue((Object)acctInfo.getName());
                        row.getCell("gLevel").setValue((Object)new Integer(acctInfo.getGLevel()));
                        row.getCell("isLeaf").setValue((Object)new Boolean(acctInfo.isIsLeaf()));
                        row.getCell("isUpperAllowCA").setValue((Object)new Boolean(acctInfo.isIsUpperAllowCA()));
                        row.getCell("isUpperAllowCA").getStyleAttributes().setLocked(true);
                    }
                }
            } else {
                MsgBox.showError((String)EASResource.getString((String)ACCOUNTRESOURCE, (String)"nullaccount"));
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    protected void loadAccountForAssigned(CompanyOrgUnitInfo company, FilterInfo filterInfo) {
        try {
            if (this.currentTable != null) {
                AccountViewCollection acctCols = (AccountViewCollection)this.getAllAccountForAssign((IObjectValue)company, (IObjectValue)this.currentTable, filterInfo);
                if (acctCols != null) {
                    this.tblAccountForAssigned.checkParsed();
                    this.tblAccountForAssigned.removeRows();
                    int count = acctCols.size();
                    for (int i = 0; i < count; ++i) {
                        Object obj;
                        IRow row = this.tblAccountForAssigned.addRow();
                        AccountViewInfo acctInfo = acctCols.get(i);
                        if (acctInfo.getParent() != null && (obj = this.accountAssignCols.get(acctInfo.getParent().getId().toString())) != null) {
                            AccountAssignInfo parent = (AccountAssignInfo)obj;
                            parent.addChild(row);
                        }
                        AccountAssignInfo acctAssignInfo = new AccountAssignInfo();
                        acctAssignInfo.setSelfRow(row);
                        this.accountAssignCols.put(acctInfo.getId().toString(), acctAssignInfo);
                        row.getCell("selected").setValue((Object)false);
                        row.getCell("account").setValue((Object)acctInfo.getNumber());
                        row.getCell("account").setUserObject((Object)acctInfo);
                        acctInfo.getName();
                        acctInfo.getCAA();
                        row.getCell("accountName").setValue((Object)acctInfo.getName());
                        row.getCell("gLevel").setValue((Object)new Integer(acctInfo.getGLevel()));
                        row.getCell("isLeaf").setValue((Object)new Boolean(acctInfo.isIsLeaf()));
                        row.getCell("isUpperAllowCA").setValue((Object)new Boolean(acctInfo.isIsAllowCA()));
                        row.getCell("isUpperAllowCA").getStyleAttributes().setLocked(true);
                    }
                }
            } else {
                MsgBox.showError((String)EASResource.getString((String)ACCOUNTRESOURCE, (String)"nullaccount"));
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    protected void setIsUpperAllowCACellEditableStatus(IRow row) {
        if (row != null) {
            AccountViewInfo acctInfo = (AccountViewInfo)row.getCell("account").getUserObject();
            this.setIsUpperAllowCACellEditableStatus(row, acctInfo);
        }
    }

    protected void setIsUpperAllowCACellEditableStatus(IRow row, AccountViewInfo acctInfo) {
        if (row != null) {
            row.getCell("isUpperAllowCA").getStyleAttributes().setLocked(!acctInfo.isIsAllowCA());
        }
    }

    protected void disSelectAccountFromUpper(IRow row, AccountViewInfo acctInfo) {
        String parentAcctId;
        AccountAssignInfo acctAssignInfo;
        this.setDisSelectChildren(acctInfo);
        AccountViewInfo acct = acctInfo;
        IRow currentRow = row;
        while (acct.getParent() != null && (acctAssignInfo = (AccountAssignInfo)this.accountAssignCols.get(parentAcctId = acct.getParent().getId().toString())) != null) {
            currentRow = acctAssignInfo.getSelfRow();
            acct = (AccountViewInfo)currentRow.getCell("account").getUserObject();
            ArrayList children = acctAssignInfo.getChildren();
            int count = children.size();
            boolean hasSelected = false;
            for (int i = 0; i < count; ++i) {
                IRow child = (IRow)children.get(i);
                if (!((Boolean)child.getCell("selected").getValue()).booleanValue()) continue;
                hasSelected = true;
                break;
            }
            if (hasSelected) break;
            currentRow.getCell("selected").setValue((Object)Boolean.FALSE);
            currentRow.getCell("gLevel").setValue((Object)new Integer(acct.getGLevel()));
        }
    }

    protected void setDisSelectedStatusWithAccountFromUpper(IRow row) {
        AccountViewInfo acct;
        if (row != null && (acct = (AccountViewInfo)row.getCell("account").getUserObject()).getUpper() != null) {
            row.getCell("selected").setValue((Object)Boolean.FALSE);
            row.getCell("gLevel").setValue((Object)new Integer(acct.getGLevel()));
            AccountAssignInfo acctAssignInfo = (AccountAssignInfo)this.accountAssignCols.get(acct.getId().toString());
            ArrayList children = acctAssignInfo.getChildren();
            int count = children.size();
            for (int i = 0; i < count; ++i) {
                this.setDisSelectedStatusWithAccountFromUpper((IRow)children.get(i));
            }
        }
    }

    protected void selectAccountFromUpper(IRow row, AccountViewInfo acctInfo) {
        String parentAcctId;
        AccountAssignInfo acctAssignInfo;
        IRow currentRow = row;
        AccountViewInfo acct = acctInfo;
        try {
            if (!acct.isIsLeaf()) {
                currentRow.getCell("selected").setValue((Object)Boolean.FALSE);
                currentRow.getCell("gLevel").setValue((Object)new Integer(acct.getGLevel()));
                if (!currentRow.getStyleAttributes().isHided() && this.rbNotAssigned.isSelected()) {
                    MsgBox.showInfo((Component)((Object)this), (String)(acct.getNumber() + EASResource.getString((String)ACCOUNTRESOURCE, (String)"ACCOUNT_ASSIGN_ERR_NOLEAF")));
                }
                if (this.rbAssigned.isSelected()) {
                    AccountAssignInfo acctAssignInfo2 = (AccountAssignInfo)this.accountAssignCols.get(acct.getId().toString());
                    IRow rowTmp = null;
                    boolean subAllSelect = true;
                    for (int i = 0; i < acctAssignInfo2.getChildren().size(); ++i) {
                        rowTmp = (IRow)acctAssignInfo2.getChildren().get(i);
                        AccountViewInfo childAcct = (AccountViewInfo)rowTmp.getCell("account").getUserObject();
                        if (((Boolean)rowTmp.getCell("selected").getValue()).booleanValue() || !this.acctAssignedNumberList.contains(childAcct.getNumber())) continue;
                        MsgBox.showInfo((Component)((Object)this), (String)(acct.getNumber() + EASResource.getString((String)ACCOUNTRESOURCE, (String)"ACCOUNT_CANCELASSIGN_ERR_NOLEAF")));
                        subAllSelect = false;
                        break;
                    }
                    if (subAllSelect) {
                        currentRow.getCell("selected").setValue((Object)Boolean.TRUE);
                    }
                }
                return;
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        while (acct.getParent() != null && (acctAssignInfo = (AccountAssignInfo)this.accountAssignCols.get(parentAcctId = acct.getParent().getId().toString())) != null) {
            currentRow = acctAssignInfo.getSelfRow();
            AccountViewInfo parentInfo = (AccountViewInfo)currentRow.getCell("account").getUserObject();
            if (this.rbNotAssigned.isSelected() && !this.acctAssignedNumberList.contains(parentInfo.getNumber())) {
                currentRow.getStyleAttributes().setHided(false);
            }
            if (this.rbAssigned.isSelected()) {
                ArrayList children = acctAssignInfo.getChildren();
                int count = children.size();
                boolean hasNotSelected = false;
                for (int i = 0; i < count; ++i) {
                    IRow child = (IRow)children.get(i);
                    AccountViewInfo childAcct = (AccountViewInfo)child.getCell("account").getUserObject();
                    if (((Boolean)child.getCell("selected").getValue()).booleanValue() || !this.acctAssignedNumberList.contains(childAcct.getNumber())) continue;
                    hasNotSelected = true;
                    break;
                }
                if (hasNotSelected) break;
            }
            acct = (AccountViewInfo)currentRow.getCell("account").getUserObject();
            if (!this.rbAssigned.isSelected()) {
                currentRow.getCell("selected").setValue((Object)Boolean.TRUE);
            }
            boolean isHiden = currentRow.getStyleAttributes().isHided();
            if (this.rbAssigned.isSelected() && this.acctAssignedNumberList.contains(acct.getNumber()) && isHiden) {
                currentRow.getStyleAttributes().setHided(false);
            }
            this.setIsUpperAllowCACellEditableStatus(currentRow, acct);
            this.setAcctCtrlLevel(acctAssignInfo);
        }
    }

    protected void setSelectedStatusWithAccountFromUpper(IRow row) {
        AccountViewInfo acct;
        if (row != null && (acct = (AccountViewInfo)row.getCell("account").getUserObject()).getUpper() != null) {
            row.getCell("selected").setValue((Object)Boolean.TRUE);
            row.getCell("gLevel").setValue((Object)new Integer(acct.getGLevel()));
            this.setIsUpperAllowCACellEditableStatus(row, acct);
            AccountAssignInfo acctAssignInfo = (AccountAssignInfo)this.accountAssignCols.get(acct.getId().toString());
            ArrayList children = acctAssignInfo.getChildren();
            int count = children.size();
            for (int i = 0; i < count; ++i) {
                this.setSelectedStatusWithAccountFromUpper((IRow)children.get(i));
            }
        }
    }

    protected void setDisSelectChildren(AccountViewInfo acctInfo) {
        if (acctInfo != null) {
            AccountAssignInfo acctAssignInfo = (AccountAssignInfo)this.accountAssignCols.get(acctInfo.getId().toString());
            ArrayList children = acctAssignInfo.getChildren();
            int count = children.size();
            for (int i = 0; i < count; ++i) {
                IRow child = (IRow)children.get(i);
                child.getCell("selected").setValue((Object)Boolean.FALSE);
                AccountViewInfo childAcctInfo = (AccountViewInfo)child.getCell("account").getUserObject();
                child.getCell("gLevel").setValue((Object)new Integer(childAcctInfo.getGLevel()));
                this.setDisSelectChildren(childAcctInfo);
            }
        }
    }

    protected void loadCuForAssigned(CtrlUnitInfo Cu) {
        if (Cu != null) {
            try {
                CtrlUnitCollection children = AccountTools.getChildCu(null, Cu);
                if (children != null) {
                    Account_ControlInfo defaualt = AccountTools.getAcctCtrlInfo(null, this.currentTable, this.currentCu, true);
                    Map childAcctCtrlInfoMap = AccountTools.getAcctCtrlInfoMap(null, this.currentTable, Cu, children);
                    Map canAssignMap = AccountTools.checkAccountTableCanAssignMap(null, children);
                    this.tblCompanyForAssigned.checkParsed();
                    this.tblCompanyForAssigned.removeRows();
                    int count = children.size();
                    for (int i = 0; i < count; ++i) {
                        boolean canAssign;
                        IRow row = this.tblCompanyForAssigned.addRow();
                        CtrlUnitInfo child = children.get(i);
                        Account_ControlInfo childAcctCtrlInfo = (Account_ControlInfo)childAcctCtrlInfoMap.get(child.getId().toString());
                        if (childAcctCtrlInfo == null && (childAcctCtrlInfo = new Account_ControlInfo()) != null) {
                            childAcctCtrlInfo.setId(null);
                            childAcctCtrlInfo.setSrcCu(this.currentCu);
                            childAcctCtrlInfo.setDestCu(child);
                        }
                        if (childAcctCtrlInfo != null) {
                            row.getCell("id").setUserObject((Object)childAcctCtrlInfo);
                            row.getCell("selected").setValue((Object)Boolean.FALSE);
                            row.getCell("selected").getStyleAttributes().setLocked(false);
                            row.getCell("Cu").setValue((Object)child.getNumber());
                            row.getCell("Cu").setUserObject((Object)child);
                            row.getCell("CuName").setValue((Object)child.getName());
                            row.getCell("dc").setValue((Object)new Boolean(childAcctCtrlInfo.getDc() == 1));
                            row.getCell("isChangeCurrency").setValue((Object)new Boolean(childAcctCtrlInfo.getIsChangeCurrency() == 1));
                            row.getCell("currencyId").setValue((Object)new Boolean(childAcctCtrlInfo.getCurrencyID() == 1));
                            row.getCell("ac").setValue((Object)new Boolean(childAcctCtrlInfo.getAc() == 1));
                            row.getCell("acNotice").setValue((Object)new Boolean(childAcctCtrlInfo.getAcNotice() == 1));
                            row.getCell("bw").setValue((Object)new Boolean(childAcctCtrlInfo.getBw() == 1));
                            row.getCell("isQty").setValue((Object)new Boolean(childAcctCtrlInfo.getIsQty() == 1));
                            row.getCell("control").setValue((Object)new Boolean(childAcctCtrlInfo.getControl() == 1));
                            this.initAcctCtrlInfo(this.acctCtrlInfo, row);
                        } else {
                            row.getCell("selected").setValue((Object)Boolean.FALSE);
                            row.getCell("Cu").setValue((Object)child.getNumber());
                            row.getCell("Cu").setUserObject((Object)child);
                            row.getCell("CuName").setValue((Object)child.getName());
                            row.getCell("dc").setValue((Object)false);
                            row.getCell("isChangeCurrency").setValue((Object)false);
                            row.getCell("currencyId").setValue((Object)false);
                            row.getCell("ac").setValue((Object)false);
                            row.getCell("acNotice").setValue((Object)false);
                            row.getCell("bw").setValue((Object)false);
                            row.getCell("isQty").setValue((Object)false);
                            row.getCell("control").setValue((Object)false);
                            this.lockCtrlInfo(row);
                        }
                        boolean bl = canAssign = canAssignMap.get(child.getId().toString()) != null ? (Boolean)canAssignMap.get(child.getId().toString()) : false;
                        if (!canAssign) {
                            row.getCell("selected").setValue((Object)Boolean.FALSE);
                            this.checkList.add(child.getName());
                            continue;
                        }
                        row.getCell("selected").getStyleAttributes().setLocked(false);
                    }
                }
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    protected void loadCompanyForAssigned(CompanyOrgUnitInfo company, String filter) {
        if (company == null) {
            return;
        }
        try {
            boolean isDisplayAll = this.isDisplayAll.isSelected();
            boolean isDisplaySealUp = this.isDisplaySealUp.isSelected();
            this.reloadCompany(company, AccountTools.getChildCompany(null, company, isDisplayAll, filter, isDisplaySealUp));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    private void reloadCompany(CompanyOrgUnitInfo company, CompanyOrgUnitCollection children) throws BOSException {
        this.tblCompanyForAssigned.checkParsed();
        this.tblCompanyForAssigned.removeRows();
        if (children != null && children.size() > 0) {
            Account_ControlInfo defaualt = AccountTools.getAcctCtrlInfo(null, this.currentTable, this.currentCompany, true);
            Map childAcctCtrlInfoMap = AccountTools.getAcctCtrlInfoMap(null, this.currentTable, company, children);
            Map canAssignMap = AccountTools.checkAccountTableCanAssignMap(null, children);
            CompanyOrgUnitInfo child = null;
            int count = children.size();
            for (int i = 0; i < count; ++i) {
                boolean canAssign;
                IRow row = this.tblCompanyForAssigned.addRow();
                child = children.get(i);
                Account_ControlInfo childAcctCtrlInfo = (Account_ControlInfo)childAcctCtrlInfoMap.get(child.getId().toString());
                if (childAcctCtrlInfo == null) {
                    childAcctCtrlInfo = new Account_ControlInfo();
                    childAcctCtrlInfo.setId(null);
                    childAcctCtrlInfo.setSrcCompany(this.currentCompany);
                    childAcctCtrlInfo.setDestCompany(child);
                }
                if (childAcctCtrlInfo != null) {
                    row.getCell("id").setUserObject((Object)childAcctCtrlInfo);
                    row.getCell("selected").setValue((Object)Boolean.FALSE);
                    row.getCell("selected").getStyleAttributes().setLocked(false);
                    row.getCell("companyNumber").setValue((Object)child.getNumber());
                    row.getCell("companyNumber").setUserObject((Object)child);
                    row.getCell("companyName").setValue((Object)child.getName());
                    row.getCell("dc").setValue((Object)new Boolean(childAcctCtrlInfo.getDc() == 1));
                    row.getCell("isChangeCurrency").setValue((Object)new Boolean(childAcctCtrlInfo.getIsChangeCurrency() == 1));
                    row.getCell("currencyId").setValue((Object)new Boolean(childAcctCtrlInfo.getCurrencyID() == 1));
                    row.getCell("ac").setValue((Object)new Boolean(childAcctCtrlInfo.getAc() == 1));
                    row.getCell("acNotice").setValue((Object)new Boolean(childAcctCtrlInfo.getAcNotice() == 1));
                    row.getCell("bw").setValue((Object)new Boolean(childAcctCtrlInfo.getBw() == 1));
                    row.getCell("isQty").setValue((Object)new Boolean(childAcctCtrlInfo.getIsQty() == 1));
                    row.getCell("control").setValue((Object)new Boolean(childAcctCtrlInfo.getControl() == 1));
                    this.setAccCtrlInfo(childAcctCtrlInfo, row, true);
                }
                boolean bl = canAssign = canAssignMap.get(child.getId().toString()) != null ? (Boolean)canAssignMap.get(child.getId().toString()) : false;
                if (!canAssign) {
                    row.getCell("selected").setValue((Object)Boolean.FALSE);
                    row.getStyleAttributes().setHided(true);
                    this.checkList.add(child.getName());
                    continue;
                }
                row.getCell("selected").getStyleAttributes().setLocked(false);
            }
        } else if (StringUtils.isEmpty((String)this.companyTextField.getText())) {
            String msg = null;
            msg = EASResource.getString((String)ACCOUNTRESOURCE, (String)"noValidSubCompany");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
    }

    protected void lockCtrlInfo(IRow row) {
        row.getCell("dc").getStyleAttributes().setLocked(true);
        row.getCell("isChangeCurrency").getStyleAttributes().setLocked(true);
        row.getCell("currencyId").getStyleAttributes().setLocked(true);
        row.getCell("ac").getStyleAttributes().setLocked(true);
        row.getCell("acNotice").getStyleAttributes().setLocked(true);
        row.getCell("bw").getStyleAttributes().setLocked(true);
        row.getCell("isQty").getStyleAttributes().setLocked(true);
        row.getCell("control").getStyleAttributes().setLocked(true);
    }

    protected void initAcctCtrlInfo(Account_ControlInfo acctCtrlInfo, IRow row) {
        if (acctCtrlInfo != null) {
            if (acctCtrlInfo.getDc() == 1) {
                row.getCell("dc").setValue((Object)true);
                row.getCell("dc").getStyleAttributes().setLocked(true);
            } else {
                row.getCell("dc").getStyleAttributes().setLocked(false);
            }
            if (acctCtrlInfo.getIsChangeCurrency() == 1) {
                row.getCell("isChangeCurrency").setValue((Object)true);
                row.getCell("isChangeCurrency").getStyleAttributes().setLocked(true);
            } else {
                row.getCell("isChangeCurrency").getStyleAttributes().setLocked(false);
            }
            if (acctCtrlInfo.getCurrencyID() == 1) {
                row.getCell("currencyId").setValue((Object)true);
                row.getCell("currencyId").getStyleAttributes().setLocked(true);
            } else {
                row.getCell("currencyId").getStyleAttributes().setLocked(false);
            }
            if (acctCtrlInfo.getAc() == 1) {
                row.getCell("ac").setValue((Object)true);
                row.getCell("ac").getStyleAttributes().setLocked(true);
            } else {
                row.getCell("ac").getStyleAttributes().setLocked(false);
            }
            if (acctCtrlInfo.getAcNotice() == 1) {
                row.getCell("acNotice").setValue((Object)true);
                row.getCell("acNotice").getStyleAttributes().setLocked(true);
            } else {
                row.getCell("acNotice").getStyleAttributes().setLocked(false);
            }
            if (acctCtrlInfo.getBw() == 1) {
                row.getCell("bw").setValue((Object)true);
                row.getCell("bw").getStyleAttributes().setLocked(true);
            } else {
                row.getCell("bw").getStyleAttributes().setLocked(false);
            }
            if (acctCtrlInfo.getIsQty() == 1) {
                row.getCell("isQty").setValue((Object)true);
                row.getCell("isQty").getStyleAttributes().setLocked(true);
            } else {
                row.getCell("isQty").getStyleAttributes().setLocked(false);
            }
            if (acctCtrlInfo.getControl() == 1) {
                row.getCell("control").setValue((Object)true);
                row.getCell("control").getStyleAttributes().setLocked(true);
            } else {
                row.getCell("control").getStyleAttributes().setLocked(false);
            }
        }
    }

    @Override
    public void storeFields() {
        this.storeCompanyAssigned();
        this.storeAccountAssigned();
    }

    protected void storeAccountAssigned() {
        boolean assign = this.rbAssigned.isSelected();
        this.accountCols.clear();
        int count = this.tblAccountForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            AccountViewInfo acctInfo;
            IRow row = this.tblAccountForAssigned.getRow(i);
            if (!assign) {
                if (row.getStyleAttributes().isHided() || !((Boolean)row.getCell("selected").getValue()).booleanValue() || this.acctAssignedNumberList.contains((acctInfo = (AccountViewInfo)((AccountViewInfo)row.getCell("account").getUserObject()).clone()).getNumber())) continue;
                acctInfo.getCAA();
                acctInfo.setGLevel((Integer)row.getCell("gLevel").getValue());
                acctInfo.setIsUpperAllowCA((Boolean)row.getCell("isUpperAllowCA").getValue());
                this.accountCols.add(acctInfo);
                continue;
            }
            if (!((Boolean)row.getCell("selected").getValue()).booleanValue() || !this.acctAssignedNumberList.contains((acctInfo = (AccountViewInfo)((AccountViewInfo)row.getCell("account").getUserObject()).clone()).getNumber())) continue;
            acctInfo.setAccountTableID(this.currentTable);
            acctInfo.setGLevel((Integer)row.getCell("gLevel").getValue());
            acctInfo.setIsUpperAllowCA((Boolean)row.getCell("isUpperAllowCA").getValue());
            this.accountCols.add(acctInfo);
        }
    }

    protected void storeCuAssigned() {
        IRow row;
        this.acctCtrlCols.clear();
        CtrlUnitCollection children = new CtrlUnitCollection();
        int count = this.tblCompanyForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblCompanyForAssigned.getRow(i);
            if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
            String sname = row.getCell("CuName").getValue().toString();
            CtrlUnitInfo child = (CtrlUnitInfo)row.getCell("Cu").getUserObject();
            if (this.checkList.contains(sname)) continue;
            children.add(child);
        }
        Map childAcctCtrlInfoMap = null;
        if (children.size() > 0) {
            try {
                childAcctCtrlInfoMap = AccountTools.getAcctCtrlInfoMap(null, this.currentTable, this.currentCu, children);
            }
            catch (BOSException e) {
                e.printStackTrace();
                this.handleException((Exception)((Object)e));
            }
            if (childAcctCtrlInfoMap == null) {
                return;
            }
        }
        int count2 = this.tblCompanyForAssigned.getRowCount();
        for (int i = 0; i < count2; ++i) {
            row = this.tblCompanyForAssigned.getRow(i);
            if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
            String sname = row.getCell("CuName").getValue().toString();
            CtrlUnitInfo child = (CtrlUnitInfo)row.getCell("Cu").getUserObject();
            if (this.checkList.contains(sname)) continue;
            Account_ControlInfo acctCtrlInfo = null;
            acctCtrlInfo = (Account_ControlInfo)childAcctCtrlInfoMap.get(child.getId().toString());
            Object obj = row.getCell("id").getUserObject();
            if (acctCtrlInfo == null && obj != null) {
                acctCtrlInfo = (Account_ControlInfo)obj;
            }
            acctCtrlInfo.setSrcCu(this.currentCu);
            acctCtrlInfo.setAccountTableID(this.currentTable);
            acctCtrlInfo.setDestCu((CtrlUnitInfo)row.getCell("Cu").getUserObject());
            acctCtrlInfo.setDc((Boolean)row.getCell("dc").getValue() != false ? 1 : 0);
            acctCtrlInfo.setIsChangeCurrency((Boolean)row.getCell("isChangeCurrency").getValue() != false ? 1 : 0);
            acctCtrlInfo.setCurrencyID((Boolean)row.getCell("currencyId").getValue() != false ? 1 : 0);
            acctCtrlInfo.setAc((Boolean)row.getCell("ac").getValue() != false ? 1 : 0);
            acctCtrlInfo.setAcNotice((Boolean)row.getCell("acNotice").getValue() != false ? 1 : 0);
            acctCtrlInfo.setBw((Boolean)row.getCell("bw").getValue() != false ? 1 : 0);
            acctCtrlInfo.setIsQty((Boolean)row.getCell("isQty").getValue() != false ? 1 : 0);
            acctCtrlInfo.setControl((Boolean)row.getCell("control").getValue() != false ? 1 : 0);
            if (this.rbAssigned.isSelected()) {
                acctCtrlInfo.setAssign(false);
            } else {
                acctCtrlInfo.setAssign(true);
            }
            this.acctCtrlCols.add(acctCtrlInfo);
        }
    }

    protected void storeCompanyAssigned() {
        IRow row;
        this.acctCtrlCols.clear();
        CompanyOrgUnitCollection children = new CompanyOrgUnitCollection();
        int count = this.tblCompanyForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblCompanyForAssigned.getRow(i);
            if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
            String sname = row.getCell("companyName").getValue().toString();
            CompanyOrgUnitInfo child = (CompanyOrgUnitInfo)row.getCell("companyNumber").getUserObject();
            if (this.checkList.contains(sname)) continue;
            children.add(child);
        }
        Map childAcctCtrlInfoMap = null;
        if (children.size() > 0) {
            try {
                childAcctCtrlInfoMap = AccountTools.getAcctCtrlInfoMap(null, this.currentTable, this.currentCompany, children);
            }
            catch (BOSException e) {
                e.printStackTrace();
                this.handleException((Exception)((Object)e));
            }
            if (childAcctCtrlInfoMap == null) {
                return;
            }
        }
        this.ctxFIIsChosen = false;
        int count2 = this.tblCompanyForAssigned.getRowCount();
        for (int i = 0; i < count2; ++i) {
            String strCtxFIId;
            row = this.tblCompanyForAssigned.getRow(i);
            if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
            String sname = row.getCell("companyName").getValue().toString();
            CompanyOrgUnitInfo child = (CompanyOrgUnitInfo)row.getCell("companyNumber").getUserObject();
            if (this.checkList.contains(sname)) continue;
            Account_ControlInfo acctCtrlInfo = null;
            acctCtrlInfo = (Account_ControlInfo)childAcctCtrlInfoMap.get(child.getId().toString());
            Object obj = row.getCell("id").getUserObject();
            if (acctCtrlInfo == null && obj != null) {
                acctCtrlInfo = (Account_ControlInfo)obj;
            }
            CompanyOrgUnitInfo destCompany = (CompanyOrgUnitInfo)row.getCell("companyNumber").getUserObject();
            if (!this.ctxFIIsChosen && (strCtxFIId = SysContext.getSysContext().getCurrentFIUnit().getId().toString()).equals(destCompany.getId().toString())) {
                this.ctxFIIsChosen = true;
            }
            acctCtrlInfo.setSrcCompany(this.currentCompany);
            acctCtrlInfo.setDestCompany(destCompany);
            acctCtrlInfo.setAccountTableID(this.currentTable);
            acctCtrlInfo.setDc((Boolean)row.getCell("dc").getValue() != false ? 1 : 0);
            acctCtrlInfo.setIsChangeCurrency((Boolean)row.getCell("isChangeCurrency").getValue() != false ? 1 : 0);
            acctCtrlInfo.setCurrencyID((Boolean)row.getCell("currencyId").getValue() != false ? 1 : 0);
            acctCtrlInfo.setAc((Boolean)row.getCell("ac").getValue() != false ? 1 : 0);
            acctCtrlInfo.setAcNotice((Boolean)row.getCell("acNotice").getValue() != false ? 1 : 0);
            acctCtrlInfo.setBw((Boolean)row.getCell("bw").getValue() != false ? 1 : 0);
            acctCtrlInfo.setIsQty((Boolean)row.getCell("isQty").getValue() != false ? 1 : 0);
            acctCtrlInfo.setControl((Boolean)row.getCell("control").getValue() != false ? 1 : 0);
            if (this.rbAssigned.isSelected()) {
                acctCtrlInfo.setAssign(false);
            } else {
                acctCtrlInfo.setAssign(true);
            }
            this.acctCtrlCols.add(acctCtrlInfo);
        }
    }

    @Override
    public void actionAssign_actionPerformed(ActionEvent e) throws Exception {
        boolean check = false;
        int rowcount = this.tblCompanyForAssigned.getRowCount();
        for (int i = 0; i < rowcount; ++i) {
            IRow row = this.tblCompanyForAssigned.getRow(i);
            if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
            check = true;
            break;
        }
        if (check) {
            CompanyOrgUnitInfo info;
            int i;
            String result;
            MessageFormat mf;
            String msg;
            String errorMsg;
            String companyNumber;
            String companyName;
            AccountAssignErrorInfo errorInfo;
            StringBuffer detail;
            this.verify();
            Account_ControlCollection cols = this.getAcctCtrlCols();
            AccountViewCollection acctcols = this.getAccountCols();
            if (cols == null || acctcols == null) {
                return;
            }
            if (cols.size() == 0 || acctcols.size() == 0) {
                if (this.rbAssigned.isSelected()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)ACCOUNTRESOURCE, (String)"AccountUnAssign_SelectOne"));
                }
                if (this.rbNotAssigned.isSelected()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)ACCOUNTRESOURCE, (String)"AccountAssign_SelectOne"));
                }
                return;
            }
            boolean isAssign = cols.get(0).isAssign();
            if (!isAssign) {
                StringBuffer confirmStr = new StringBuffer();
                confirmStr.append(EASResource.getString((String)ACCOUNTRESOURCE, (String)"cancelAssignConfirm")).append(cols.size()).append(EASResource.getString((String)ACCOUNTRESOURCE, (String)"cancelAssignConfirm1")).append(acctcols.size()).append(EASResource.getString((String)ACCOUNTRESOURCE, (String)"cancelAssignConfirm2"));
                if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)confirmStr.toString()))) {
                    return;
                }
            }
            IAccountView acct = AccountViewFactory.getRemoteInstance();
            List errorList = acct.assignAccountToChild(cols, acctcols, this.isDisplayAll.isSelected());
            if (isAssign && (errorList == null || errorList.size() == 0)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)ACCOUNTRESOURCE, (String)"ACCOUNTASSIGNSUCCESS"));
                CompanyOrgUnitInfo ctxFI = SysContext.getSysContext().getCurrentFIUnit();
                if (this.ctxFIIsChosen && ctxFI.getAccountTable() == null) {
                    String msg2 = EASResource.getString((String)ACCOUNTRESOURCE, (String)"CurrentCompanyAccountTableChanged");
                    MsgBox.showInfo((Component)((Object)this), (String)msg2);
                    ctxFI.setAccountTable(this.currentTable);
                    SysContext.getSysContext().setCurrentFIUnit(ctxFI);
                }
            } else if (isAssign) {
                detail = new StringBuffer();
                for (int i2 = 0; i2 < errorList.size(); ++i2) {
                    errorInfo = (AccountAssignErrorInfo)errorList.get(i2);
                    companyName = errorInfo.getCompany().getName();
                    companyNumber = errorInfo.getCompany().getNumber();
                    errorMsg = errorInfo.getEx().getMessage();
                    if (errorInfo.isRelatedCompanyError()) {
                        msg = EASResource.getString((String)ACCOUNTRESOURCE, (String)"ComNo_ComName_SubCom_Error");
                        mf = new MessageFormat(msg);
                        result = mf.format(new String[]{":" + companyNumber + ";", ":" + companyName + ";", ":" + errorMsg});
                        detail.append(result + "\n");
                        continue;
                    }
                    msg = EASResource.getString((String)ACCOUNTRESOURCE, (String)"ComNo_ComName_Error");
                    mf = new MessageFormat(msg);
                    result = mf.format(new String[]{":" + companyNumber + ";", ":" + companyName + ";", ":" + errorMsg});
                    detail.append(result + "\n");
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)ACCOUNTRESOURCE, (String)"PartFail"), (String)detail.toString(), (int)1);
            } else if (!(isAssign || errorList != null && errorList.size() != 0)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.AllAccountResource", (String)"CancelAssisgnSuccess"));
            } else if (!isAssign) {
                detail = new StringBuffer();
                for (int i3 = 0; i3 < errorList.size(); ++i3) {
                    errorInfo = (AccountAssignErrorInfo)errorList.get(i3);
                    companyName = errorInfo.getCompany().getName();
                    companyNumber = errorInfo.getCompany().getNumber();
                    errorMsg = errorInfo.getEx().getMessage();
                    if (errorInfo.isRelatedCompanyError()) {
                        msg = EASResource.getString((String)ACCOUNTRESOURCE, (String)"ComNo_ComName_SubCom_Error");
                        mf = new MessageFormat(msg);
                        result = mf.format(new String[]{":" + companyNumber + ";", ":" + companyName + ";", ":" + errorMsg});
                        detail.append(result + "\n");
                        continue;
                    }
                    msg = EASResource.getString((String)ACCOUNTRESOURCE, (String)"ComNo_ComName_Error");
                    mf = new MessageFormat(msg);
                    result = mf.format(new String[]{":" + companyNumber + ";", ":" + companyName + ";", ":" + errorMsg});
                    detail.append(result + "\n");
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)ACCOUNTRESOURCE, (String)"PartUnassignFail"), (String)detail.toString(), (int)1);
            }
            this.loadCompanyForAssigned(this.currentCompany, this.oldComSearchCondition);
            this.loadonset();
            this.assignedAcctNumberListPerCompany.clear();
            this.assignedAcctInfoPurNumberAndCompany.clear();
            this.loadSelectedStatus();
            HashMap<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
            int count = cols.size();
            for (i = 0; i < count; ++i) {
                Account_ControlInfo acctCtrlInfo = cols.get(i);
                info = acctCtrlInfo.getDestCompany();
                companyMap.put(info.getId().toString(), info);
            }
            count = this.tblCompanyForAssigned.getRowCount();
            for (i = 0; i < count; ++i) {
                IRow row = this.tblCompanyForAssigned.getRow(i);
                info = (CompanyOrgUnitInfo)row.getCell("companyNumber").getUserObject();
                if (!companyMap.containsKey(info.getId().toString())) continue;
                row.getCell("selected").setValue((Object)Boolean.TRUE);
            }
            this.rbAssigned.setSelected(true);
            this.btnAssign.setText(EASResource.getString((String)ACCOUNTRESOURCE, (String)"cancelAssign"));
            this.btnAssign.setToolTipText(EASResource.getString((String)ACCOUNTRESOURCE, (String)"cancelAssign"));
            this.rbNotAssigned.setSelected(false);
            this.tblAccountForAssigned.getLayoutManager().scrollRowToShow(0);
            this.loadSelectedStatus();
            this.acctFastQuery();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)ACCOUNTRESOURCE, (String)"peleaseselectone"));
        }
    }

    protected void verify() {
        this.storeFields();
        this.verifyInput();
    }

    protected void verifyInput() {
    }

    public AccountViewCollection getAccountCols() {
        return this.accountCols;
    }

    public Account_ControlCollection getAcctCtrlCols() {
        return this.acctCtrlCols;
    }

    @Override
    public void actionSetAcctCtrlForRefer_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> uiCtx = new HashMap<String, Object>();
        uiCtx.put("Owner", (Object)this);
        uiCtx.put("Company", this.currentCompany);
        uiCtx.put("AccountTable", this.currentTable);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow assignDlg = uiFactory.create("com.kingdee.eas.basedata.master.account.client.AcctCtrlEditUI", uiCtx);
        assignDlg.show();
    }

    @Override
    public void actionSetControlProperty_actionPerformed(ActionEvent e) throws Exception {
        boolean isSelectNull = true;
        int rowcount = this.tblCompanyForAssigned.getRowCount();
        for (int i = 0; i < rowcount; ++i) {
            IRow row = this.tblCompanyForAssigned.getRow(i);
            if (!((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
            isSelectNull = false;
            break;
        }
        if (isSelectNull) {
            MsgBox.showInfo((String)EASResource.getString((String)ACCOUNTRESOURCE, (String)"peleaseselectone"));
            return;
        }
        HashMap<String, AccountAssignUI> uiCtx = new HashMap<String, AccountAssignUI>();
        uiCtx.put("Owner", this);
        uiCtx.put("tableMain", (AccountAssignUI)this.tblCompanyForAssigned);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow assignDlg = uiFactory.create("com.kingdee.eas.basedata.master.account.client.AcctBatchSetCtlPropEditUI", uiCtx);
        assignDlg.show();
    }

    protected void setAcctSelected(IRow row, AccountViewInfo acctInfo) {
        row.getCell("gLevel").setValue((Object)new Integer(acctInfo.getControlLevel()));
        this.setIsUpperAllowCACellEditableStatus(row, acctInfo);
        this.selectAccountFromUpper(row, acctInfo);
    }

    protected void setAcctCtrlLevel(AccountAssignInfo acctAssignInfo) {
        if (acctAssignInfo == null || acctAssignInfo.getSelfRow() == null) {
            return;
        }
        IRow row = acctAssignInfo.getSelfRow();
        AccountViewInfo acctInfo = (AccountViewInfo)row.getCell("account").getUserObject();
        ArrayList children = acctAssignInfo.getChildren();
        int count = children.size();
        boolean hasSelected = false;
        for (int i = 0; i < count; ++i) {
            IRow child = (IRow)children.get(i);
            if (!((Boolean)child.getCell("selected").getValue()).booleanValue()) continue;
            hasSelected = true;
            break;
        }
        if (!hasSelected) {
            row.getCell("gLevel").setValue((Object)new Integer(acctInfo.getControlLevel()));
        }
    }

    @Override
    public void actionAssigned_actionPerformed(ActionEvent e) throws Exception {
        this.rbNotAssigned.setSelected(false);
        this.btnAssign.setText(EASResource.getString((String)ACCOUNTRESOURCE, (String)"cancelAssign"));
        this.btnAssign.setToolTipText(EASResource.getString((String)ACCOUNTRESOURCE, (String)"cancelAssign"));
        this.loadSelectedStatus();
        this.acctFastQuery();
    }

    @Override
    public void actionNotAssigned_actionPerformed(ActionEvent e) throws Exception {
        this.rbAssigned.setSelected(false);
        this.btnAssign.setText(EASResource.getString((String)ACCOUNTRESOURCE, (String)"assign"));
        this.btnAssign.setToolTipText(EASResource.getString((String)ACCOUNTRESOURCE, (String)"assign"));
        this.loadSelectedStatus();
        this.acctFastQuery();
    }

    @Override
    public void actionAllSelect_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        int i;
        int count = this.tblAccountForAssigned.getRowCount();
        for (i = 0; i < count; ++i) {
            row = this.tblAccountForAssigned.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            row.getCell("selected").setValue((Object)true);
        }
        count = this.tblAccountForAssigned.getRowCount();
        for (i = 0; i < count; ++i) {
            row = this.tblAccountForAssigned.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            AccountViewInfo acctInfo = (AccountViewInfo)row.getCell("account").getUserObject();
            this.setAcctCtrlLevel((AccountAssignInfo)this.accountAssignCols.get(acctInfo.getId().toString()));
            this.setIsUpperAllowCACellEditableStatus(row);
            if (!acctInfo.isIsLeaf()) {
                if (!this.rbNotAssigned.isSelected()) continue;
                if (i < this.tblAccountForAssigned.getRowCount() - 2) {
                    AccountViewInfo belowAcctInfo = (AccountViewInfo)this.tblAccountForAssigned.getRow(i + 1).getCell("account").getUserObject();
                    if (belowAcctInfo.getLongNumber().indexOf(acctInfo.getLongNumber()) >= 0) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)(acctInfo.getNumber() + EASResource.getString((String)ACCOUNTRESOURCE, (String)"ACCOUNT_ASSIGN_ERR_NOLEAF")));
                    row.getCell("selected").setValue((Object)Boolean.FALSE);
                    continue;
                }
                MsgBox.showInfo((Component)((Object)this), (String)(acctInfo.getNumber() + EASResource.getString((String)ACCOUNTRESOURCE, (String)"ACCOUNT_ASSIGN_ERR_NOLEAF")));
                row.getCell("selected").setValue((Object)Boolean.FALSE);
                continue;
            }
            this.selectAccountFromUpper(row, acctInfo);
        }
    }

    @Override
    public void actionAllDisselect_actionPerformed(ActionEvent e) throws Exception {
        AccountViewInfo acctInfo;
        IRow row;
        int i;
        int count = this.tblAccountForAssigned.getRowCount();
        for (i = 0; i < count; ++i) {
            row = this.tblAccountForAssigned.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            row.getCell("selected").setValue((Object)false);
            acctInfo = (AccountViewInfo)row.getCell("account").getUserObject();
            row.getCell("gLevel").setValue((Object)new Integer(acctInfo.getGLevel()));
            row.getCell("isUpperAllowCA").getStyleAttributes().setLocked(!acctInfo.isIsAllowCA());
        }
        count = this.tblAccountForAssigned.getRowCount();
        for (i = 0; i < count; ++i) {
            row = this.tblAccountForAssigned.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            acctInfo = (AccountViewInfo)row.getCell("account").getUserObject();
            this.setAcctCtrlLevel((AccountAssignInfo)this.accountAssignCols.get(acctInfo.getId().toString()));
            this.setIsUpperAllowCACellEditableStatus(row);
        }
    }

    @Override
    public void actionSelectUpper_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        int i;
        ArrayList<Object> list = new ArrayList<Object>();
        int count = this.tblAccountForAssigned.getRowCount();
        for (i = 0; i < count; ++i) {
            AccountViewInfo acctInfo;
            row = this.tblAccountForAssigned.getRow(i);
            if (row.getStyleAttributes().isHided() || (acctInfo = (AccountViewInfo)row.getCell("account").getUserObject()).getUpper() != null) continue;
            list.add(row);
            list.add(acctInfo);
            list.add(row.getCell("selected").getValue());
        }
        this.actionAllSelect_actionPerformed(e);
        count = list.size() / 3;
        for (i = 0; i < count; ++i) {
            row = (IRow)list.get(i * 3);
            if (list.get(i * 3 + 2) != null && ((Boolean)list.get(i * 3 + 2)).booleanValue()) continue;
            row.getCell("selected").setValue(list.get(i * 3 + 2));
            this.setAcctDisSelected(row, (AccountViewInfo)list.get(i * 3 + 1));
        }
    }

    @Override
    public void actionDisSelectUpper_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        int i;
        ArrayList<Object> list = new ArrayList<Object>();
        int count = this.tblAccountForAssigned.getRowCount();
        for (i = 0; i < count; ++i) {
            AccountViewInfo acctInfo;
            row = this.tblAccountForAssigned.getRow(i);
            if (row.getStyleAttributes().isHided() || (acctInfo = (AccountViewInfo)row.getCell("account").getUserObject()).getUpper() != null) continue;
            list.add(row);
            list.add(acctInfo);
            list.add(row.getCell("selected").getValue());
        }
        this.actionAllDisselect_actionPerformed(e);
        count = list.size() / 3;
        for (i = 0; i < count; ++i) {
            row = (IRow)list.get(i * 3);
            if (list.get(i * 3 + 2) != null && !((Boolean)list.get(i * 3 + 2)).booleanValue()) continue;
            row.getCell("selected").setValue(list.get(i * 3 + 2));
            this.setAcctSelected(row, (AccountViewInfo)list.get(i * 3 + 1));
        }
    }

    protected void setAcctDisSelected(IRow row, AccountViewInfo acctInfo) {
        this.disSelectAccountFromUpper(row, acctInfo);
    }

    @Override
    public void actionSelectAllOU_actionPerformed(ActionEvent e) throws Exception {
        int count = this.tblCompanyForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblCompanyForAssigned.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            row.getCell("selected").setValue((Object)true);
            this.isSelectAll(row);
        }
        this.storeAccountAssigned();
        this.hideTblAccountForAssigned();
        this.rbAssigned.setSelected(false);
        this.rbNotAssigned.setSelected(false);
    }

    @Override
    public void actionDisselectAllOU_actionPerformed(ActionEvent e) throws Exception {
        int count = this.tblCompanyForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblCompanyForAssigned.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            row.getCell("selected").setValue((Object)false);
            this.isSelectAll(row);
        }
        this.getAssignedAcctIdList();
        this.storeAccountAssigned();
        this.loadSelectedStatus();
    }

    @Override
    public void actionDisplayAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionDisplayAll_actionPerformed(e);
        String text = this.companyTextField.getText();
        if (this.isCmpCommonQueryDialogLastChose) {
            this.loadCompanyForAssignedWithFilter();
        } else {
            this.loadCompanyForAssigned(this.currentCompany, this.oldComSearchCondition);
        }
    }

    @Override
    public void actionSelectAllCA_actionPerformed(ActionEvent e) throws Exception {
        IRow row = null;
        int count = this.tblAccountForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblAccountForAssigned.getRow(i);
            if (row.getStyleAttributes().isHided() || row.getCell("isUpperAllowCA").getStyleAttributes().isLocked()) continue;
            row.getCell("isUpperAllowCA").setValue((Object)true);
        }
    }

    @Override
    public void actionDisSelectAllCA_actionPerformed(ActionEvent e) throws Exception {
        IRow row = null;
        int count = this.tblAccountForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblAccountForAssigned.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            row.getCell("isUpperAllowCA").setValue((Object)false);
        }
    }

    private void onClickForBtnCompanySearch() throws Exception {
        if (this.cmpCommonQueryDialog == null) {
            this.cmpCommonQueryDialog = new CommonQueryDialog();
            this.cmpCommonQueryDialog.setOwner((Component)((Object)this));
            this.cmpCommonQueryDialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
            this.cmpCommonQueryDialog.setShowSorter(false);
            this.cmpCommonQueryDialog.setShowToolbar(false);
            this.cmpCommonQueryDialog.setDisShowRowCount(true);
            this.cmpCommonQueryDialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.basedata.master.account.app.AccountAssignCompanyOrgUnitFilterQuery"));
        }
        if (this.cmpCommonQueryDialog.show()) {
            this.loadCompanyForAssignedWithFilter();
            this.loadSelectedStatus();
            this.isCmpCommonQueryDialogLastChose = true;
        }
    }

    private void loadCompanyForAssignedWithFilter() throws Exception {
        FilterInfo filterInfo = null;
        if (this.cmpCommonQueryDialog != null) {
            filterInfo = this.cmpCommonQueryDialog.getEntityViewInfoResult().getFilter();
        }
        if (filterInfo == null || StringUtil.isEmpty((String)filterInfo.toSql())) {
            this.loadCompanyForAssigned(this.currentCompany, null);
        } else {
            boolean isDisplayAll;
            ICompanyOrgUnit instance = CompanyOrgUnitFactory.getRemoteInstance();
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo normal = new FilterInfo();
            boolean isDisplaySealUp = this.isDisplaySealUp.isSelected();
            if (!isDisplaySealUp) {
                normal.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)0));
            }
            if (isDisplayAll = this.isDisplayAll.isSelected()) {
                normal.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(this.currentCompany.getLongNumber() + "!%"), CompareType.LIKE));
            } else {
                normal.getFilterItems().add(new FilterItemInfo("parent.id", (Object)this.currentCompany.getId().toString(), CompareType.EQUALS));
            }
            filterInfo.mergeFilter(normal, "and");
            ev.setFilter(filterInfo);
            ev.setSorter(new SorterItemCollection("order by longnumber asc"));
            this.reloadCompany(this.currentCompany, instance.getCompanyOrgUnitCollection(ev));
        }
    }

    private void onClickForBtnAcctSearch() {
        if (this.acctCommonQueryDialog == null) {
            this.acctCommonQueryDialog = new CommonQueryDialog();
            this.acctCommonQueryDialog.setOwner((Component)((Object)this));
            this.acctCommonQueryDialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
            this.acctCommonQueryDialog.setShowSorter(false);
            this.acctCommonQueryDialog.setShowToolbar(false);
            this.acctCommonQueryDialog.setDisShowRowCount(true);
            this.acctCommonQueryDialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.basedata.master.account.app.AccountAssignFilterQuery"));
        }
        if (this.acctCommonQueryDialog.show()) {
            this.loadAccountForAssigned(this.currentCompany, null);
            if (!this.rbAssigned.isSelected() && !this.rbNotAssigned.isSelected()) {
                return;
            }
            this.commFilter = this.acctCommonQueryDialog.getEntityViewInfoResult().getFilter();
            this.acctCommQuery();
        }
    }

    private void acctCommQuery() {
        if (this.commFilter == null) {
            return;
        }
        FilterItemCollection filterItemCol = this.commFilter.getFilterItems();
        if (filterItemCol.size() < 1) {
            this.loadSelectedStatus();
            return;
        }
        boolean includeNumber = false;
        boolean includeName = false;
        for (int i = 0; i < filterItemCol.size(); ++i) {
            FilterItemInfo filterItemInfo = filterItemCol.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("number")) {
                includeNumber = true;
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("name")) continue;
            includeName = true;
        }
        if (includeNumber && includeName) {
            MsgBox.showError((String)EASResource.getString((String)ACCOUNTRESOURCE, (String)"NAME_NUM_UNUSE"));
            SysUtil.abort();
            return;
        }
        if (this.currentTable == null || StringUtils.isEmpty((String)this.commFilter.toSql())) {
            return;
        }
        try {
            int i;
            IRow row;
            AccountViewCollection acctCols = (AccountViewCollection)this.getAllAccountForAssign((IObjectValue)this.currentCompany, (IObjectValue)this.currentTable, this.acctCommonQueryDialog.getEntityViewInfoResult().getFilter());
            this.loadSelectedStatus();
            if (acctCols.size() < 1) {
                int count = this.tblAccountForAssigned.getRowCount();
                for (int i2 = 0; i2 < count; ++i2) {
                    row = this.tblAccountForAssigned.getRow(i2);
                    row.getStyleAttributes().setHided(true);
                }
                return;
            }
            ArrayList<String> valueList = new ArrayList<String>();
            if (includeNumber) {
                for (i = 0; i < acctCols.size(); ++i) {
                    valueList.add(acctCols.get(i).getNumber());
                }
            } else {
                for (i = 0; i < acctCols.size(); ++i) {
                    valueList.add(acctCols.get(i).getName());
                }
            }
            int count = this.tblAccountForAssigned.getRowCount();
            for (i = 0; i < count; ++i) {
                row = this.tblAccountForAssigned.getRow(i);
                if (row.getStyleAttributes().isHided()) continue;
                AccountViewInfo acctInfo = (AccountViewInfo)row.getCell("account").getUserObject();
                boolean flag = false;
                if (includeNumber) {
                    for (String value : valueList) {
                        if (!acctInfo.getNumber().equals(value)) continue;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    row.getStyleAttributes().setHided(true);
                    continue;
                }
                for (String value : valueList) {
                    if (!acctInfo.getName().equals(value)) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                row.getStyleAttributes().setHided(true);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void acctFastQuery() {
        this.acctCommQuery();
        String text = StringUtils.trim((String)this.acctTextField.getText());
        String newCondition = this.acctSearchField.getSelectedItem().toString() + text;
        String filter = ((FilterFieldItem)this.acctSearchField.getSelectedItem()).getName();
        this.oldAcctSearchCondition = newCondition;
        List<String> filterList = Arrays.asList(text.split(";"));
        int count = this.tblAccountForAssigned.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblAccountForAssigned.getRow(i);
            AccountViewInfo acctInfo = (AccountViewInfo)row.getCell("account").getUserObject();
            if ("number".equals(filter) && !row.getStyleAttributes().isHided() && filterList.size() > 0) {
                boolean flag = false;
                for (String key : filterList) {
                    if (!acctInfo.getNumber().contains(key)) continue;
                    flag = true;
                    break;
                }
                if (!flag) {
                    row.getStyleAttributes().setHided(true);
                }
            }
            if (!"name".equals(filter) || row.getStyleAttributes().isHided() || acctInfo.getName().contains(text)) continue;
            row.getStyleAttributes().setHided(true);
        }
    }

    private void isSelectAll(IRow row) {
        boolean selectall = this.isSelectAll.isSelected();
        boolean isChecked = Boolean.parseBoolean(row.getCell("selected").getValue().toString());
        if (selectall) {
            if (isChecked) {
                this.setCtrlInfoTrue(row);
            } else {
                this.setCtrlInfoFalse(row);
                this.lockCtrlInfo(row, true);
            }
        } else {
            this.lockCtrlInfo(row, !isChecked);
            if (!isChecked) {
                this.setCtrlInfoFalse(row);
            }
        }
    }

    private void setCtrlInfoTrue(IRow row) {
        row.getCell("dc").setValue((Object)Boolean.TRUE);
        row.getCell("isChangeCurrency").setValue((Object)Boolean.TRUE);
        row.getCell("currencyId").setValue((Object)Boolean.TRUE);
        row.getCell("ac").setValue((Object)Boolean.TRUE);
        row.getCell("acNotice").setValue((Object)Boolean.TRUE);
        row.getCell("bw").setValue((Object)Boolean.TRUE);
        row.getCell("isQty").setValue((Object)Boolean.TRUE);
        row.getCell("control").setValue((Object)Boolean.TRUE);
    }

    private void setCtrlInfoFalse(IRow row) {
        row.getCell("dc").setValue((Object)Boolean.FALSE);
        row.getCell("isChangeCurrency").setValue((Object)Boolean.FALSE);
        row.getCell("currencyId").setValue((Object)Boolean.FALSE);
        row.getCell("ac").setValue((Object)Boolean.FALSE);
        row.getCell("acNotice").setValue((Object)Boolean.FALSE);
        row.getCell("bw").setValue((Object)Boolean.FALSE);
        row.getCell("isQty").setValue((Object)Boolean.FALSE);
        row.getCell("control").setValue((Object)Boolean.FALSE);
    }

    protected void lockCtrlInfo(IRow row, boolean isLocked) {
        if (isLocked) {
            row.getCell("dc").getStyleAttributes().setLocked(true);
            row.getCell("isChangeCurrency").getStyleAttributes().setLocked(true);
            row.getCell("currencyId").getStyleAttributes().setLocked(true);
            row.getCell("ac").getStyleAttributes().setLocked(true);
            row.getCell("acNotice").getStyleAttributes().setLocked(true);
            row.getCell("bw").getStyleAttributes().setLocked(true);
            row.getCell("isQty").getStyleAttributes().setLocked(true);
            row.getCell("control").getStyleAttributes().setLocked(true);
        } else {
            row.getCell("dc").getStyleAttributes().setLocked(false);
            row.getCell("isChangeCurrency").getStyleAttributes().setLocked(false);
            row.getCell("currencyId").getStyleAttributes().setLocked(false);
            row.getCell("ac").getStyleAttributes().setLocked(false);
            row.getCell("acNotice").getStyleAttributes().setLocked(false);
            row.getCell("bw").getStyleAttributes().setLocked(false);
            row.getCell("isQty").getStyleAttributes().setLocked(false);
            row.getCell("control").getStyleAttributes().setLocked(false);
        }
    }

    protected void setAccCtrlInfo(Account_ControlInfo acctCtrlInfo, IRow row, boolean isLocked) {
        if (acctCtrlInfo != null) {
            row.getCell("dc").setValue((Object)new Boolean(acctCtrlInfo.getDc() == 1));
            row.getCell("isChangeCurrency").setValue((Object)new Boolean(acctCtrlInfo.getIsChangeCurrency() == 1));
            row.getCell("currencyId").setValue((Object)new Boolean(acctCtrlInfo.getCurrencyID() == 1));
            row.getCell("ac").setValue((Object)new Boolean(acctCtrlInfo.getAc() == 1));
            row.getCell("acNotice").setValue((Object)new Boolean(acctCtrlInfo.getAcNotice() == 1));
            row.getCell("bw").setValue((Object)new Boolean(acctCtrlInfo.getBw() == 1));
            row.getCell("isQty").setValue((Object)new Boolean(acctCtrlInfo.getIsQty() == 1));
            row.getCell("control").setValue((Object)new Boolean(acctCtrlInfo.getControl() == 1));
        } else {
            this.setCtrlInfoFalse(row);
        }
        this.lockCtrlInfo(row, isLocked);
    }

    @Override
    protected void companyTextField_keyPressed(KeyEvent e) throws Exception {
        if (e.getKeyCode() == 10) {
            String text = this.companyTextField.getText();
            String filter = ((FilterFieldItem)this.companySearchField.getSelectedItem()).getName();
            StringBuffer newCondition = new StringBuffer();
            if ("number".equals(filter)) {
                newCondition.append(" and fnumber like '%").append(text).append("%'");
            } else if ("name".equals(filter)) {
                Locale l = SysContext.getSysContext().getLocale();
                newCondition.append(" and fname_").append(l.toString()).append(" like '%").append(text).append("%'");
            } else if ("industry".equals(filter)) {
                Locale l = SysContext.getSysContext().getLocale();
                newCondition.append(" and fIndustry in (").append("select fid from T_BD_Industry where fname_").append(l.toString()).append(" like '%").append(text).append("%' )");
            } else if ("economicType".equals(filter)) {
                String FEconomicType = "";
                Map map = EconomicTypeEnum.getEnumMap();
                for (String key : map.keySet()) {
                    if (((EconomicTypeEnum)map.get(key)).getAlias().indexOf(text) <= -1) continue;
                    int enumValue = EconomicTypeEnum.getEnum((String)key).getValue();
                    FEconomicType = FEconomicType + "," + enumValue;
                }
                if (!StringUtils.isEmpty((String)FEconomicType)) {
                    FEconomicType = FEconomicType.substring(1);
                    newCondition.append(" and FEconomicType in (").append(FEconomicType).append(")");
                } else {
                    newCondition.append(" and 1=2");
                }
            }
            this.oldComSearchCondition = newCondition.toString();
            if (StringUtils.isEmpty((String)text)) {
                this.loadCompanyForAssigned(this.currentCompany, null);
            } else {
                this.loadCompanyForAssigned(this.currentCompany, this.oldComSearchCondition);
            }
            this.loadSelectedStatus();
        }
        this.isCmpCommonQueryDialogLastChose = false;
    }

    @Override
    protected void acctTextField_keyPressed(KeyEvent e) throws Exception {
        if (e.getKeyCode() == 10) {
            this.loadAccountForAssigned(this.currentCompany, null);
            this.loadSelectedStatus();
            this.acctFastQuery();
        }
    }

    @Override
    public void actionDisplaySealUp_actionPerformed(ActionEvent e) throws Exception {
        if (this.isCmpCommonQueryDialogLastChose) {
            this.loadCompanyForAssignedWithFilter();
        } else {
            this.loadCompanyForAssigned(this.currentCompany, this.oldComSearchCondition);
        }
    }

    protected class AccountAssignInfo {
        IRow selfRow = null;
        ArrayList children = new ArrayList();

        public IRow getSelfRow() {
            return this.selfRow;
        }

        public void setSelfRow(IRow row) {
            this.selfRow = row;
        }

        public ArrayList getChildren() {
            return this.children;
        }

        public void addChild(IRow child) {
            this.children.add(child);
        }
    }

    public class FilterFieldItem {
        private String ffiName;
        private String ffiDisplayName;
        private ConstDataType fficdt;

        public FilterFieldItem(String name, String displayName, ConstDataType cdt) {
            this.ffiName = name;
            this.ffiDisplayName = displayName;
            this.fficdt = cdt;
        }

        public String toString() {
            return this.ffiDisplayName;
        }

        public String getName() {
            return this.ffiName;
        }

        public ConstDataType getType() {
            return this.fficdt;
        }
    }
}

