/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.Administrator;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.LinkedHashSet;

public class AccountClientUtils {
    public static final String ACCOUNT_RESOURCE = "com.kingdee.eas.basedata.master.account.client.AccountResource";
    public static final String ACCTREFCONTRAST_RESOURCE = "com.kingdee.eas.basedata.master.account.AcctRefContrastResource";
    public static final String ACCOUNT = "account";
    public static final String ADDNEW = "addnew";
    public static final String EDIT = "edit";
    public static final String VIEW = "view";
    public static final String UI_TITLE_SEPRATOR = " - ";
    public static final String CONFIRM_ADD_NEW_TYPE = "confirmAddnewType";

    public static void setupUITitle(CoreUIObject ui, String bindedEntityName) {
        if (ui != null) {
            if (ui.getOprtState().equalsIgnoreCase(OprtState.ADDNEW)) {
                ui.setUITitle(bindedEntityName + UI_TITLE_SEPRATOR + EASResource.getString((String)ACCOUNT_RESOURCE, (String)ADDNEW));
            } else if (ui.getOprtState().equalsIgnoreCase(OprtState.EDIT)) {
                ui.setUITitle(bindedEntityName + UI_TITLE_SEPRATOR + EASResource.getString((String)ACCOUNT_RESOURCE, (String)EDIT));
            } else if (ui.getOprtState().equalsIgnoreCase(OprtState.VIEW) || ui.getOprtState().equalsIgnoreCase("FINDVIEW")) {
                ui.setUITitle(bindedEntityName + UI_TITLE_SEPRATOR + EASResource.getString((String)ACCOUNT_RESOURCE, (String)VIEW));
            } else {
                ui.setUITitle(bindedEntityName);
            }
        }
    }

    public static boolean isCurrentUserAdministrator() throws EASBizException, BOSException {
        UserInfo currentUser = SysContext.getSysContext().getCurrentUserInfo();
        return Administrator.isCUAdmin(null, (IObjectPK)new ObjectUuidPK(currentUser.getId()));
    }

    public static boolean isCurrentCURootCU() throws EASBizException, BOSException {
        return SysContext.getSysContext().getCurrentCtrlUnit().getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4");
    }

    public static void checkCompanyAccountTable(CoreUI ui, CompanyOrgUnitInfo curCompany) {
        if (curCompany == null) {
            throw new RuntimeException("Company can not be null.");
        }
        if (curCompany.getAccountTable() == null) {
            MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)ACCOUNT_RESOURCE, (String)"CurrentCompanyHasNoStartAccountTable"));
            SysUtil.abort();
        }
    }

    public static OrgUnitInfo[] getAuthorizedBizOrgUnits(IObjectPK userPK, OrgType orgType, String permissionItem) {
        OrgUnitCollection collection = AccountClientUtils.getAuthOrgByPermItem(userPK, orgType, permissionItem);
        OrgUnitCollection bizOrgs = AccountClientUtils.getOrgUnitInfosByType(collection, orgType);
        if (bizOrgs == null) {
            return null;
        }
        int size = bizOrgs.size();
        OrgUnitInfo[] results = new OrgUnitInfo[size];
        if (size > 0) {
            Object[] objects = bizOrgs.toArray();
            System.arraycopy(objects, 0, results, 0, size);
        }
        return results;
    }

    public static OrgUnitCollection getAuthOrgByPermItem(IObjectPK userPK, OrgType orgType, String permItem) {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission permission = null;
        FullOrgUnitCollection result = null;
        try {
            permission = PermissionFactory.getRemoteInstance();
            result = permission.getAuthorizedOrg(userPK, orgType, null, permItem);
        }
        catch (EASBizException e) {
            return collection;
        }
        catch (BOSException e) {
            return collection;
        }
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    public static boolean hasFunctionPermission(IObjectPK userPK, IObjectPK orgPK, String permItemName) {
        boolean hasPermission = false;
        IPermission permission = null;
        try {
            permission = PermissionFactory.getRemoteInstance();
            hasPermission = permission.hasFunctionPermission(userPK, orgPK, permItemName);
        }
        catch (EASBizException e) {
            return hasPermission;
        }
        catch (BOSException e) {
            return hasPermission;
        }
        return hasPermission;
    }

    public static OrgUnitCollection getOrgUnitInfosByType(OrgUnitCollection orgs, OrgType orgType) {
        OrgUnitCollection results = new OrgUnitCollection();
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        view.setFilter(filter);
        try {
            ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getRemoteInstance();
            CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
            if (collection != null && collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    results.add((OrgUnitInfo)collection.get(i));
                }
            }
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

