/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountRefCollection;
import com.kingdee.eas.basedata.master.account.AccountRefFactory;
import com.kingdee.eas.basedata.master.account.AccountRefInfo;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountRef;
import com.kingdee.eas.basedata.master.account.IAccountTable;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.client.AbstractAccountCompareUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;

public class AccountCompareUI
extends AbstractAccountCompareUI {
    public void onLoad() throws Exception {
        super.onLoad();
        this.setupUITitle();
        this.loadAccountTable();
        this.createTableTitle();
        this.initTableProperty();
        this.setAccountSourceRef();
        this.setAccountTargetRef();
        if (this.tblSource.getRowCount() > 0) {
            this.tblSource.getSelectManager().select(0, 0);
        } else {
            this.cboSource.setSelectedIndex(0);
        }
        this.setAccountTargetRef();
    }

    public void setupUITitle() {
        String resFullName = "com.kingdee.eas.basedata.master.account.client.AccountResource.AccountCompare";
        String returnValue = EASResource.getString((String)resFullName);
        this.setUITitle(returnValue);
    }

    private void initTableProperty() {
        this.tblSource.setAutoscrolls(true);
        KDTSelectManager selectManager = this.tblSource.getSelectManager();
        selectManager.setSelectMode(10);
        this.tblSource.getColumn(2).setWidth(150);
        this.tblSource.getColumn(3).setWidth(150);
        this.tblSource.getColumn(4).setWidth(150);
        this.tblSource.getColumn(6).setWidth(150);
        this.tblSource.getColumn(7).setWidth(150);
        this.tblSource.getColumn(8).setWidth(150);
    }

    private void loadAccountTable() throws Exception {
        AccountTableInfo tableInfo = null;
        AccountTableCollection tableInfos = null;
        DefaultComboBoxModel<AccountTableInfo> sourceModel = new DefaultComboBoxModel<AccountTableInfo>();
        DefaultComboBoxModel<AccountTableInfo> targetModel = new DefaultComboBoxModel<AccountTableInfo>();
        tableInfos = this.getAccountTableInfos(true);
        if (tableInfos != null) {
            Iterator infoTer = tableInfos.iterator();
            while (infoTer.hasNext()) {
                tableInfo = (AccountTableInfo)infoTer.next();
                sourceModel.addElement(tableInfo);
                targetModel.addElement(tableInfo);
            }
            this.cboSource.setModel(sourceModel);
            this.cboTarget.setModel(targetModel);
            if (tableInfos.size() == 0) {
                String resFullName = "com.kingdee.eas.basedata.master.account.client.AccountResource.AccountTableIsNull";
                String strName = EASResource.getString((String)resFullName);
                MsgBox.showInfo((Component)((Object)this), (String)strName);
                super.abort();
            }
        }
    }

    private void setTargetAccountTable(AccountTableCollection infos) {
        DefaultComboBoxModel<AccountTableInfo> targetModel = new DefaultComboBoxModel<AccountTableInfo>();
        AccountTableInfo tableInfo = null;
        if (infos.size() == 0) {
            return;
        }
        try {
            Iterator infoTer = infos.iterator();
            while (infoTer.hasNext()) {
                tableInfo = (AccountTableInfo)infoTer.next();
                targetModel.addElement(tableInfo);
            }
            this.cboTarget.setModel(targetModel);
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
        }
    }

    private AccountTableCollection getAccountTableInfos(boolean isFirst) {
        Object tableInfo = null;
        AccountTableCollection tableInfos = null;
        try {
            IAccountTable iAccountTable = AccountTableFactory.getRemoteInstance();
            if (isFirst) {
                tableInfos = iAccountTable.getAccountTableCollection();
            } else {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                AccountTableInfo sourceInfo = (AccountTableInfo)this.cboSource.getSelectedItem();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sourceInfo.getId().toString(), CompareType.NOTEQUALS));
                view.setFilter(filterInfo);
                tableInfos = iAccountTable.getAccountTableCollection(view);
            }
        }
        catch (BOSException ex) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
            return null;
        }
        return tableInfos;
    }

    private void createTableTitle() {
        int headRowCount = 2;
        this.tblSource.setFormatXml((String)null);
        this.tblSource.checkParsed();
        String resFullName = "com.kingdee.eas.basedata.master.account.client.AccountResource.SourceAccountTable";
        String SourceAccountTable = EASResource.getString((String)resFullName);
        resFullName = "com.kingdee.eas.basedata.master.account.client.AccountResource.TargetAccountTable";
        String TargetAccountTable = EASResource.getString((String)resFullName);
        String[] strHeaders0 = new String[]{SourceAccountTable, TargetAccountTable};
        resFullName = "com.kingdee.eas.basedata.master.account.client.AccountResource.ID";
        String ID = EASResource.getString((String)resFullName);
        resFullName = "com.kingdee.eas.basedata.master.account.client.AccountResource.Name";
        String Name = EASResource.getString((String)resFullName);
        resFullName = "com.kingdee.eas.basedata.master.account.client.AccountResource.Number";
        String Number2 = EASResource.getString((String)resFullName);
        resFullName = "com.kingdee.eas.basedata.master.account.client.AccountResource.AccountTypeName";
        String AccountTypeName = EASResource.getString((String)resFullName);
        String[] strHeaders1 = new String[]{ID, ID, Number2, Name, AccountTypeName, ID, Number2, Name, AccountTypeName};
        for (int j = 0; j < strHeaders1.length; ++j) {
            IColumn iSourceCol = this.tblSource.addColumn(j);
        }
        IRow iSourceRow = this.tblSource.addHeadRow(0);
        iSourceRow.getCell(2).setValue((Object)strHeaders0[0]);
        iSourceRow.getCell(6).setValue((Object)strHeaders0[1]);
        for (int i = 1; i < headRowCount; ++i) {
            iSourceRow = this.tblSource.addHeadRow(i);
            for (int j = 0; j < strHeaders1.length; ++j) {
                iSourceRow.getCell(j).setValue((Object)strHeaders1[j]);
            }
        }
        this.tblSource.getColumn(0).setWidth(0);
        this.tblSource.getColumn(0).setResizeable(false);
        this.tblSource.getColumn(1).setWidth(0);
        this.tblSource.getColumn(1).setResizeable(false);
        this.tblSource.getColumn(2).getStyleAttributes().setLocked(true);
        this.tblSource.getColumn(3).getStyleAttributes().setLocked(true);
        this.tblSource.getColumn(4).getStyleAttributes().setLocked(true);
        this.tblSource.getColumn(5).setWidth(0);
        this.tblSource.getColumn(5).setResizeable(false);
        this.tblSource.getColumn(6).getStyleAttributes().setLocked(true);
        this.tblSource.getColumn(7).getStyleAttributes().setLocked(true);
        this.tblSource.getColumn(8).getStyleAttributes().setLocked(true);
        this.tblSource.getHeadMergeManager().setMergeMode(1);
        KDTMergeManager mm = this.tblSource.getHeadMergeManager();
        mm.mergeBlock(0, 2, 0, 4);
        mm.mergeBlock(0, 6, 0, 8);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void cboTarget_itemStateChanged(ItemEvent e) throws Exception {
        this.setAccountTargetRef();
    }

    private void setAccountTargetRef() {
        AccountTableInfo tableTargetInfo = (AccountTableInfo)this.cboTarget.getSelectedItem();
        AccountTableInfo tableSourceInfo = (AccountTableInfo)this.cboSource.getSelectedItem();
        AccountRefCollection accountRefInfos = null;
        AccountViewInfo accountInfo = null;
        AccountRefInfo refInfo = null;
        try {
            IAccountRef iAccountRef = AccountRefFactory.getRemoteInstance();
            IAccountView iAccount = AccountViewFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("srcTableID", (Object)tableSourceInfo.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("destTableID", (Object)tableTargetInfo.getId().toString(), CompareType.EQUALS));
            filterInfo.setMaskString("#0 and #1");
            view.setFilter(filterInfo);
            accountRefInfos = iAccountRef.getAccountRefCollection(view);
            if (accountRefInfos.size() == 0) {
                this.clearAccountRef();
                return;
            }
            this.clearAccountRef();
            Iterator ter = accountRefInfos.iterator();
            while (ter.hasNext()) {
                refInfo = (AccountRefInfo)ter.next();
                for (int i = 0; i < this.tblSource.getRowCount(); ++i) {
                    if (!refInfo.getSrcAccountID().getId().toString().equals(this.tblSource.getRow(i).getCell(1).getValue().toString())) continue;
                    ObjectUuidPK pk = new ObjectUuidPK(refInfo.getDestAccountID().getId());
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("*"));
                    sic.add(new SelectorItemInfo("accountTypeID.name"));
                    accountInfo = iAccount.getAccountViewInfo((IObjectPK)pk, sic);
                    this.tblSource.getRow(i).getCell(0).setValue((Object)refInfo.getId().toString());
                    this.tblSource.getRow(i).getCell(5).setValue((Object)accountInfo.getId());
                    this.tblSource.getRow(i).getCell(6).setValue((Object)accountInfo.getNumber());
                    this.tblSource.getRow(i).getCell(7).setValue((Object)accountInfo.getName());
                    this.tblSource.getRow(i).getCell(8).setValue((Object)accountInfo.getAccountTypeID().getName());
                }
            }
        }
        catch (BOSException ex) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
        }
        catch (Exception err) {
            String resFullName = "com.kingdee.eas.basedata.master.account.client.AccountResource.ViewDataError";
            String returnValue = EASResource.getString((String)resFullName);
            ExceptionHandler.handle((Component)((Object)this), (String)(returnValue + err.getMessage()), (Throwable)err);
        }
    }

    private void clearAccountRef() {
        for (int i = 0; i < this.tblSource.getRowCount(); ++i) {
            this.tblSource.getRow(i).getCell(0).setValue((Object)"");
            this.tblSource.getRow(i).getCell(5).setValue((Object)"");
            this.tblSource.getRow(i).getCell(6).setValue((Object)"");
            this.tblSource.getRow(i).getCell(7).setValue((Object)"");
            this.tblSource.getRow(i).getCell(8).setValue((Object)"");
        }
    }

    private AccountViewCollection getAccountCollection(AccountTableInfo info) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        AccountViewCollection accountInfos = null;
        filterInfo.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)info.getId().toString().trim(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("companyID", null, CompareType.EQUALS));
        view.setFilter(filterInfo);
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("accountTypeID.name"));
        view.getSorter().add(new SorterItemInfo("number"));
        try {
            IAccountView iAccount = AccountViewFactory.getRemoteInstance();
            accountInfos = iAccount.getAccountViewCollection(view);
        }
        catch (BOSException ex) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
            return null;
        }
        return accountInfos;
    }

    private void clearTableBody(KDTable table) {
        for (int i = table.getRowCount(); i > 0; --i) {
            table.removeRow(i - 1);
        }
    }

    private void listAccounts(AccountViewCollection infos, KDTable table) {
        this.clearTableBody(table);
        int rowCount = infos.size();
        int currentRow = 0;
        Iterator ter = infos.iterator();
        while (ter.hasNext()) {
            AccountViewInfo info = (AccountViewInfo)ter.next();
            IRow row = table.addRow(currentRow);
            row.getCell(1).setValue((Object)info.getId().toString());
            row.getCell(2).setValue((Object)info.getNumber());
            row.getCell(3).setValue((Object)info.getName());
            row.getCell(4).setValue((Object)info.getAccountTypeID().getName());
            ++currentRow;
            Color bgcolor = new Color(217, 217, 210);
            row.getCell(2).getStyleAttributes().setBackground(bgcolor);
            row.getCell(3).getStyleAttributes().setBackground(bgcolor);
            row.getCell(4).getStyleAttributes().setBackground(bgcolor);
        }
    }

    @Override
    protected void cboSource_itemStateChanged(ItemEvent e) throws Exception {
        super.cboSource_itemStateChanged(e);
        this.setAccountSourceRef();
        if (this.tblSource.getRowCount() > 0) {
            this.tblSource.getSelectManager().select(0, 0);
        }
    }

    private void setAccountSourceRef() {
        try {
            AccountTableCollection Infos = this.getAccountTableInfos(false);
            if (Infos != null) {
                this.setTargetAccountTable(Infos);
            }
            if (this.cboSource.getSelectedItem() != null) {
                AccountTableInfo tableInfo = (AccountTableInfo)this.cboSource.getSelectedItem();
                AccountViewCollection tableInfos = this.getAccountCollection(tableInfo);
                this.listAccounts(tableInfos, this.tblSource);
            }
            this.setAccountTargetRef();
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
        }
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (!this.verifyData2()) {
            return;
        }
        this.addNew("addnew");
    }

    @Override
    public void actionModify_actionPerformed(ActionEvent e) throws Exception {
        if (!this.verifyData2()) {
            return;
        }
        KDTSelectBlock selectBlock = this.tblSource.getSelectManager().get();
        if (selectBlock.getBeginRow() != selectBlock.getEndRow()) {
            String resFullName = "com.kingdee.eas.basedata.master.account.client.AccountResource.OnlyEditOne";
            String returnValue = EASResource.getString((String)resFullName);
            MsgBox.showInfo((Component)((Object)this), (String)returnValue);
            return;
        }
        try {
            int index = KDTableUtil.getSelectedRow((KDTable)this.tblSource);
            if (this.tblSource.getRow(index).getCell(0).getValue() == null) {
                String resFullName = "com.kingdee.eas.basedata.master.account.client.AccountResource.AccountRefNotExist";
                String returnValue = EASResource.getString((String)resFullName);
                MsgBox.showInfo((Component)((Object)this), (String)returnValue);
                return;
            }
            if (this.tblSource.getRow(index).getCell(0).getValue() != null) {
                if (((String)this.tblSource.getRow(index).getCell(0).getValue()).length() == 0) {
                    String resFullName = "com.kingdee.eas.basedata.master.account.client.AccountResource.AccountRefNotExist";
                    String returnValue = EASResource.getString((String)resFullName);
                    MsgBox.showInfo((Component)((Object)this), (String)returnValue);
                    return;
                }
                this.addNew("modify");
            }
        }
        catch (Exception err) {
            String resFullName = "com.kingdee.eas.basedata.master.account.client.AccountResource.ViewDataError";
            String returnValue = EASResource.getString((String)resFullName);
            ExceptionHandler.handle((Component)((Object)this), (String)(returnValue + err.getMessage()), (Throwable)err);
        }
    }

    private void addNew(String addOrUpdate) {
        KDTSelectManager selectManager = this.tblSource.getSelectManager();
        AccountTableInfo tableTargetInfo = (AccountTableInfo)this.cboTarget.getSelectedItem();
        AccountTableInfo sourceInfo = (AccountTableInfo)this.cboSource.getSelectedItem();
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("targetInfo", tableTargetInfo);
        ctx.put("tblSource", this.tblSource);
        ctx.put("strSign", addOrUpdate);
        ctx.put("sourceInfo", sourceInfo);
        ctx.put("Owner", (Object)this);
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.basedata.master.account.client.AccountComUI", ctx);
            uiWindow.show();
        }
        catch (UIException ex1) {
            ex1.printStackTrace();
        }
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        if (!this.verifyData2()) {
            return;
        }
        KDTSelectBlock sb = null;
        IAccountRef iAccountRef = null;
        if (!this.confirmRemove()) {
            return;
        }
        iAccountRef = AccountRefFactory.getRemoteInstance();
        for (int i = 0; i < this.tblSource.getSelectManager().size(); ++i) {
            sb = this.tblSource.getSelectManager().get(i);
            if (sb.getBottom() - sb.getTop() + 1 == 1) {
                String str = (String)this.tblSource.getRow(sb.getBottom()).getCell(0).getValue();
                if (str == null || str.equals("")) {
                    String resFullName = "com.kingdee.eas.basedata.master.account.client.AccountResource.AccountRefNotExist";
                    String returnValue = EASResource.getString((String)resFullName);
                    MsgBox.showInfo((Component)((Object)this), (String)returnValue);
                    return;
                }
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)str));
                iAccountRef.delete((IObjectPK)pk);
                this.clearAccountRef(sb.getBottom());
                continue;
            }
            for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                String str = (String)this.tblSource.getRow(j).getCell(0).getValue();
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)str));
                iAccountRef.delete((IObjectPK)pk);
                this.clearAccountRef(j);
            }
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.setAccountTargetRef();
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    private void clearAccountRef(int row) {
        this.tblSource.getRow(row).getCell(0).setValue((Object)"");
        this.tblSource.getRow(row).getCell(5).setValue((Object)"");
        this.tblSource.getRow(row).getCell(6).setValue((Object)"");
        this.tblSource.getRow(row).getCell(7).setValue((Object)"");
        this.tblSource.getRow(row).getCell(8).setValue((Object)"");
    }

    private boolean verifyData2() throws Exception {
        super.verifyData();
        boolean retval = true;
        KDTSelectBlock selectBlock = this.tblSource.getSelectManager().get();
        if (selectBlock != null) {
            if (selectBlock.getBeginRow() < 0) {
                String resFullName = "com.kingdee.eas.basedata.master.account.client.AccountResource.MustSelectSourceAccount";
                String returnValue = EASResource.getString((String)resFullName);
                MsgBox.showInfo((Component)((Object)this), (String)returnValue);
                retval = false;
                return retval;
            }
        } else {
            String resFullName = "com.kingdee.eas.basedata.master.account.client.AccountResource.MustSelectSourceAccount";
            String returnValue = EASResource.getString((String)resFullName);
            MsgBox.showInfo((Component)((Object)this), (String)returnValue);
            retval = false;
            return retval;
        }
        return retval;
    }

    protected void initWorkButton() {
        this.btnNewCompare.setText(null);
        this.btnNewCompare.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnModifyCompare.setText(null);
        this.btnModifyCompare.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnDeleteCompare.setText(null);
        this.btnDeleteCompare.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnRefresh.setText(null);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
    }
}

