/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.client;

import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.master.account.AccountCashEnum;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountRefContrast;
import com.kingdee.eas.basedata.master.account.client.AbstractAccountRefModifyUI;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AccountRefModifyUI
extends AbstractAccountRefModifyUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountRefModifyUI.class);
    AccountRefContrastInfo accountRefContrastInfo = null;

    public void onLoad() throws Exception {
        super.onLoad();
        String companyid = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        boolean hasBank = AccountTools.getDefaultGLParam(null, companyid, "AccountRefBank");
        if (hasBank) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.AllAccountResource", (String)"RefModify"));
            SysUtil.abort();
        }
        this.initMyIcon();
        this.initData();
    }

    private void initData() throws Exception {
        this.kDTable1.removeRows();
        String id = (String)this.getUIContext().get("RefId");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("enabledAcctTable.id"));
        sic.add(new SelectorItemInfo("enabledAcctTable.number"));
        sic.add(new SelectorItemInfo("enabledAcctTable.name"));
        sic.add(new SelectorItemInfo("disabledAcctTable.number"));
        sic.add(new SelectorItemInfo("disabledAcctTable.name"));
        this.accountRefContrastInfo = ((IAccountRefContrast)this.getBizInterface()).getAccountRefContrastInfo((IObjectPK)new ObjectUuidPK(id), sic);
        this.bpOldTable.setValue((Object)this.accountRefContrastInfo.getDisabledAcctTable());
        this.bpNewTable.setValue((Object)this.accountRefContrastInfo.getEnabledAcctTable());
        String cashOrBank = "isBank";
        if (!AccountCashEnum.BANK.equals(this.cbCash.getSelectedItem())) {
            cashOrBank = "isCash";
        }
        FilterInfo queryFilter = new FilterInfo();
        queryFilter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)this.accountRefContrastInfo.getDisabledAcctTable().getId().toString()));
        queryFilter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.accountRefContrastInfo.getCU().getId().toString()));
        queryFilter.getFilterItems().add(new FilterItemInfo(cashOrBank, (Object)Boolean.TRUE));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = view.getSelector();
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        view.setFilter(queryFilter);
        SorterItemCollection sorter = view.getSorter();
        sorter.add(new SorterItemInfo("number"));
        AccountViewCollection accountdataCol = AccountViewFactory.getRemoteInstance().getAccountViewCollection(view);
        if (accountdataCol != null && accountdataCol.size() > 0) {
            for (int i = 0; i < accountdataCol.size(); ++i) {
                IRow rowAss = this.kDTable1.addRow();
                AccountViewInfo acct = accountdataCol.get(i);
                rowAss.getCell("oldAcct").setUserObject((Object)acct.getId().toString());
                rowAss.getCell("oldAcctName").setUserObject((Object)acct);
                rowAss.getCell("select").setValue((Object)Boolean.FALSE);
                rowAss.getCell("oldAcct").setValue((Object)acct.getNumber());
                rowAss.getCell("oldAcctName").setValue((Object)acct.getName());
            }
        }
        view = new EntityViewInfo();
        selector = view.getSelector();
        selector.add(new SelectorItemInfo("oldAcct.number"));
        selector.add(new SelectorItemInfo("oldAcct.name"));
        selector.add(new SelectorItemInfo("newAcct.number"));
        selector.add(new SelectorItemInfo("newAcct.name"));
        selector.add(new SelectorItemInfo("oldAcctName"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("acctRefContrast.id", (Object)id));
        fic.add(new FilterItemInfo("oldAcct." + cashOrBank, (Object)Boolean.TRUE));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("oldAcct.number"));
        AccountRefContrastEntryCollection dataCol = AccountRefContrastEntryFactory.getRemoteInstance().getAccountRefContrastEntryCollection(view);
        if (dataCol != null && dataCol.size() > 0) {
            int rowcount = this.kDTable1.getRowCount();
            block1: for (int j = 0; j < rowcount; ++j) {
                IRow rowAss = this.kDTable1.getRow(j);
                for (int i = 0; i < dataCol.size(); ++i) {
                    AccountRefContrastEntryInfo info = dataCol.get(i);
                    String accountid = (String)rowAss.getCell("oldAcct").getUserObject();
                    if (!info.getOldAcct().getId().toString().endsWith(accountid)) continue;
                    rowAss.setUserObject((Object)info);
                    if (info.getNewAcct() == null) continue;
                    rowAss.getCell("newAcct").setValue((Object)info.getNewAcct());
                    rowAss.getCell("newAcctName").setValue((Object)info.getNewAcct().getName());
                    continue block1;
                }
            }
        }
        KDBizPromptBox kDBizPromptBoxNumber = new KDBizPromptBox();
        kDBizPromptBoxNumber.setQueryInfo("com.kingdee.eas.basedata.master.account.app.AccountViewQuery");
        kDBizPromptBoxNumber.setDisplayFormat("$number$");
        kDBizPromptBoxNumber.setEditFormat("$number$");
        kDBizPromptBoxNumber.setCommitFormat("$number$");
        kDBizPromptBoxNumber.setEditable(true);
        EntityViewInfo viewInfo = new EntityViewInfo();
        filter = new FilterInfo();
        FilterItemInfo companyAccountFilterItemInfo = new FilterItemInfo("CU.id", (Object)this.accountRefContrastInfo.getCU().getId().toString());
        FilterItemInfo companyAccountFilterItemInfo2 = new FilterItemInfo("accountTableID.id", (Object)this.accountRefContrastInfo.getEnabledAcctTable().getId().toString());
        filter.getFilterItems().add(companyAccountFilterItemInfo);
        filter.getFilterItems().add(companyAccountFilterItemInfo2);
        filter.getFilterItems().add(new FilterItemInfo(cashOrBank, (Object)Boolean.TRUE));
        viewInfo.setFilter(filter);
        kDBizPromptBoxNumber.setSelector((KDPromptSelector)new AccountPromptBox((IUIObject)this, this.accountRefContrastInfo.getEnabledAcctTable(), filter, false, false));
        kDBizPromptBoxNumber.setEntityViewInfo(viewInfo);
        ObjectValueRender numberRender = new ObjectValueRender();
        numberRender.setFormat(new IDataFormat(){

            public String format(Object object) {
                DataBaseInfo info = (DataBaseInfo)object;
                return info.getNumber();
            }
        });
        this.kDTable1.getColumn("newAcct").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxNumber));
        this.kDTable1.getColumn("newAcct").setRenderer((IBasicRender)numberRender);
    }

    private void initMyIcon() {
        this.kDTable1.checkParsed();
        this.bpOldTable.setEnabled(false);
        this.bpOldTable.setDisplayFormat("$number$ $name$");
        this.bpNewTable.setEnabled(false);
        this.bpNewTable.setDisplayFormat("$number$ $name$");
        this.actionSelectAll.setEnabled(true);
        this.actionClearAll.setEnabled(true);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClear.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.actionClearRef.setEnabled(true);
        this.actionSaveRef.setEnabled(true);
        this.btnCkearRef.setIcon(EASResource.getIcon((String)"imgTbtn_modifyattribute"));
        this.btnSaveRef.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.kDTable1.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                if (!(e.getValue() instanceof DataBaseInfo)) {
                    return;
                }
                DataBaseInfo info = (DataBaseInfo)e.getValue();
                if (info != null && e.getColIndex() == AccountRefModifyUI.this.kDTable1.getColumnIndex("newAcct")) {
                    AccountRefModifyUI.this.kDTable1.getCell(e.getRowIndex(), "newAcctName").setValue((Object)info.getName());
                }
            }

            public void editValueChanged(KDTEditEvent e) {
            }
        });
        this.cbCash.addItem((Object)AccountCashEnum.BANK);
        this.cbCash.addItem((Object)AccountCashEnum.CASH);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.doSelect(true);
    }

    @Override
    protected void cbCash_actionPerformed(ActionEvent e) throws Exception {
        this.initData();
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.doSelect(false);
    }

    @Override
    public void actionSaveRef_actionPerformed(ActionEvent e) throws Exception {
        List list = this.getSelectedKeyValues();
        ((IAccountRefContrast)this.getBizInterface()).saveRef(list);
        this.kDTable1.removeRows();
        this.initData();
    }

    @Override
    public void actionClearRef_actionPerformed(ActionEvent e) throws Exception {
        List list = this.getSelectedKeyValues();
        ((IAccountRefContrast)this.getBizInterface()).clearRef(list);
        this.kDTable1.removeRows();
        this.initData();
    }

    public static void queryByCondition(EntityViewInfo currentCondition, CoreUIObject owner, String id) throws Exception {
        UIContext uiContext = new UIContext((Object)owner);
        uiContext.put((Object)"RefId", (Object)id);
        String mode = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)mode).create(AccountRefModifyUI.class.getName(), (Map)uiContext, null);
        uiWindow.show();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AccountRefContrastFactory.getRemoteInstance();
    }

    private void doSelect(boolean select) {
        int rowCount = this.kDTable1.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow rowAss = this.kDTable1.getRow(i);
            rowAss.getCell("select").setValue((Object)select);
        }
    }

    protected List getSelectedKeyValues() {
        ArrayList<AccountRefContrastEntryInfo> idList = new ArrayList<AccountRefContrastEntryInfo>();
        int rowCount = this.kDTable1.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            AccountViewInfo newacct;
            IRow rowAss = this.kDTable1.getRow(i);
            boolean isSelected = (Boolean)rowAss.getCell("select").getValue();
            if (!isSelected) continue;
            AccountRefContrastEntryInfo info = (AccountRefContrastEntryInfo)rowAss.getUserObject();
            if (info == null) {
                info = new AccountRefContrastEntryInfo();
                AccountViewInfo old = (AccountViewInfo)rowAss.getCell("oldAcctName").getUserObject();
                info.setOldAcct(old);
                info.setOldAcctName(old.getName());
                info.setOldAcctNumber(old.getNumber());
                info.setAcctRefContrast(this.accountRefContrastInfo);
                info.setSeq(i);
            }
            if ((newacct = (AccountViewInfo)rowAss.getCell("newAcct").getValue()) == null) continue;
            info.setNewAcct(newacct);
            idList.add(info);
        }
        return idList;
    }
}

