/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.ICacheService;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountTypeFactory;
import com.kingdee.eas.basedata.master.account.AccountTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountType;
import com.kingdee.eas.basedata.master.account.client.AbstractAccountTypeEditUI;
import com.kingdee.eas.basedata.master.account.client.AccountClientUtils;
import com.kingdee.eas.basedata.master.account.common.AccountConstant;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JButton;

public class AccountTypeEditUI
extends AbstractAccountTypeEditUI {
    private static final String ACCOUNT_TYPE = "accountType";
    private AccountTypeInfo typeInfo = null;
    private AccountTableInfo tableInfo = null;
    private CompanyOrgUnitInfo company = null;

    private void loadCtx() {
        if (this.getUIContext().get("ParentNode") != null && this.getUIContext().get("ParentNode") instanceof AccountTypeInfo) {
            this.typeInfo = (AccountTypeInfo)this.getUIContext().get("ParentNode");
        }
        this.tableInfo = (AccountTableInfo)this.getUIContext().get("tableInfo");
        this.company = (CompanyOrgUnitInfo)this.getUIContext().get("currentCompany");
        if (this.company == null) {
            this.company = SysContext.getSysContext().getCurrentFIUnit();
        }
    }

    public void onLoad() throws Exception {
        this.loadCtx();
        super.onLoad();
        boolean ret = AccountTools.checkAccountTableIsSelfConstructed(null, this.tableInfo);
        this.actionAddNew.setEnabled(ret);
        this.actionEdit.setEnabled(ret);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnEdit.setEnabled(true);
        } else {
            this.btnEdit.setEnabled(false);
        }
        String flag = ParamManager.getParamValue(null, (String)AccountConstant.GovermentAccountingSystem);
        if (!"true".equalsIgnoreCase(flag)) {
            this.comboProperty.removeItem((Object)AccountProperty.NETASSET);
            this.comboProperty.removeItem((Object)AccountProperty.REVENUE);
            this.comboProperty.removeItem((Object)AccountProperty.EXPENSE);
            this.comboProperty.removeItem((Object)AccountProperty.BUDGET_OUTLAYS);
            this.comboProperty.removeItem((Object)AccountProperty.BUDGET_RECEIPTS);
            this.comboProperty.removeItem((Object)AccountProperty.BUDGET_SURPLUS);
        }
        if ("true".equalsIgnoreCase(flag)) {
            this.comboProperty.removeItem((Object)AccountProperty.REVENUE);
            this.comboProperty.removeItem((Object)AccountProperty.EXPENSE);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.comboProperty.setEnabled(true);
        this.txtNumber.setEnabled(true);
        if (this.getOprtState().equals(OprtState.EDIT)) {
            try {
                IAccountType iaccountType = AccountTypeFactory.getRemoteInstance();
                if (iaccountType.isReferencedByAccount((IObjectPK)new ObjectUuidPK(this.editData.getId())) || AccountTools.checkAccountTableHasAssignToChild(null, this.tableInfo)) {
                    this.comboProperty.setEnabled(false);
                    this.txtNumber.setEnabled(false);
                } else if (this.typeInfo != null && this.typeInfo.getParent() != null) {
                    this.comboProperty.setEnabled(false);
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        } else if (this.getOprtState().equals(OprtState.ADDNEW) && this.typeInfo != null) {
            this.comboProperty.setEnabled(false);
        }
        AccountClientUtils.setupUITitle((CoreUIObject)this, EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)ACCOUNT_TYPE));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected JButton getDefaultButton() {
        return this.btnSubmit;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        IAccountType iAccountType = AccountTypeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        return iAccountType;
    }

    @Override
    protected IObjectValue createNewData() {
        AccountTypeInfo info = new AccountTypeInfo();
        info.setName(null);
        info.setNumber(null);
        info.setDescription(null);
        if (this.typeInfo != null) {
            info.setProperty(this.typeInfo.getProperty());
        } else {
            info.setProperty(AccountProperty.ASSET);
        }
        info.setParent(this.typeInfo);
        info.setAccountTableID(this.tableInfo);
        return info;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        boolean isReferrenced;
        boolean ret = AccountTools.checkAccountTableIsSelfConstructed(null, this.company, this.tableInfo);
        if (!ret) {
            throw new AccountException(AccountException.MODIFYTYPEINTABLENOTSELF);
        }
        super.actionEdit_actionPerformed(e);
        if (this.getOprtState().equals(OprtState.ADDNEW) && this.typeInfo != null && this.typeInfo.isIsLeaf() && (isReferrenced = AccountTypeFactory.getRemoteInstance().isReferencedByAccount((IObjectPK)new ObjectUuidPK(this.typeInfo.getId()))) && !MsgBox.isYes((int)MsgBox.showConfirm2(null, (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"confirmAddnewType")))) {
            super.abort();
        }
        ICacheService cacheService = CacheServiceFactory.getInstance();
        cacheService.discardType(new AccountViewInfo().getBOSType());
        super.actionSubmit_actionPerformed(e);
        if (this.typeInfo != null && this.typeInfo.isIsLeaf()) {
            this.typeInfo.setIsLeaf(false);
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        boolean ret = AccountTools.checkAccountTableIsSelfConstructed(null, this.company, this.tableInfo);
        if (!ret) {
            throw new AccountException(AccountException.MODIFYTYPEINTABLENOTSELF);
        }
        super.actionRemove_actionPerformed(e);
    }

    protected boolean confirmRemove() {
        String selectID = this.editData.getId().toString();
        boolean canremove = false;
        try {
            canremove = AccountTypeFactory.getRemoteInstance().hasParent((IObjectPK)new ObjectUuidPK(selectID));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (canremove) {
            String moveType = EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"MOVEACCOUNTTYPE");
            int result = MsgBox.showConfirm2((Component)((Object)this), (String)moveType);
            if (result != 0) {
                return false;
            }
        } else {
            canremove = super.confirmRemove();
        }
        return canremove;
    }

    protected void removeByPK(IObjectPK pk) throws Exception {
        super.removeByPK(pk);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"AccountTypeDeleteSuccess"));
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        boolean ret = AccountTools.checkAccountTableIsSelfConstructed(null, this.company, this.tableInfo);
        if (!ret) {
            throw new AccountException(AccountException.MODIFYTYPEINTABLENOTSELF);
        }
        super.actionEdit_actionPerformed(e);
        try {
            IAccountType iaccountType = AccountTypeFactory.getRemoteInstance();
            if (iaccountType.isReferencedByAccount((IObjectPK)new ObjectUuidPK(this.editData.getId())) || AccountTools.checkAccountTableHasAssignToChild(null, this.tableInfo)) {
                this.comboProperty.setEnabled(false);
                this.txtNumber.setEnabled(false);
            } else if (this.typeInfo != null && this.typeInfo.getParent() != null) {
                this.comboProperty.setEnabled(false);
            }
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.company != null && action != null) {
            ObjectUuidPK orgPk = new ObjectUuidPK(this.company.getId());
            action.putValue("ORG.PK", (Object)orgPk);
            return orgPk;
        }
        return super.getOrgPK(action);
    }
}

