/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectGroupInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.client.AbstractOtherCostObjectEditUI;
import com.kingdee.eas.basedata.assistant.client.CostObjectListUI;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.OrgClientUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class OtherCostObjectEditUI
extends AbstractOtherCostObjectEditUI {
    private static final Logger logger = CoreUIObject.getLogger(OtherCostObjectEditUI.class);
    private CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
    private static final String resClassName = "com.kingdee.eas.basedata.assistant.client.AssistantResource4";

    public OtherCostObjectEditUI() throws Exception {
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnSave.setVisible(false);
        this.menuBiz.setVisible(false);
        OrgClientUtils.setOrgPrompt((IUIObject)this, (KDBizPromptBox)this.prmtCompany, (OrgType[])new OrgType[]{OrgType.Company}, (boolean)false);
    }

    public void onLoad() throws Exception {
        OtherCostObjectEditUI.checkLoginCompanyOrgIsVirtual();
        super.onLoad();
        this.setTitle();
        if ("COPY".equals(this.getOprtState())) {
            ActionEvent event = (ActionEvent)this.getUIContext().get("ActionEvent");
            this.actionCopy_actionPerformed(event);
        }
    }

    public static void checkLoginCompanyOrgIsVirtual() {
        CompanyOrgUnitInfo companyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (companyOrgUnitInfo == null || !companyOrgUnitInfo.isIsBizUnit()) {
            MsgBox.showError((String)OtherCostObjectEditUI.getResource("CannotOperationInVirtualOrgUnit"));
            SysUtil.abort();
        }
    }

    public static String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.assistant.CostObjectResource", (String)key);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.initData();
        this.prmtCompany.setEditable(false);
        this.prmtCompany.setEnabled(false);
        this.menuBar.setVisible(false);
        this.menuItemSave.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.comboRelatedType.setEnabled(false);
        this.comboRelatedType.setEnabled(false);
    }

    private void initData() {
        try {
            this.getCurrentCompany();
        }
        catch (EASBizException e) {
            super.handUIException((Throwable)e);
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        this.comboRelatedType.setEnabled(false);
        if (this.prmtCompany.getData() == null) {
            this.txtNumber.setEnabled(false);
            this.txtName.setEnabled(false);
            this.txtStandardRation.setEnabled(false);
            this.txtDescription.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
            this.txtName.setEnabled(true);
            this.txtStandardRation.setEnabled(true);
            this.txtDescription.setEnabled(true);
        }
        CostObjectListUI costObjectListUI = (CostObjectListUI)((Object)this.getUIContext().get("Owner"));
        if ("ADDNEW".equals(this.getOprtState())) {
            CostObjectGroupInfo groupInfo = (CostObjectGroupInfo)costObjectListUI.getSelectedTreeNode().getUserObject();
            this.editData.setCostObjectGroup(groupInfo);
            this.comboRelatedType.setSelectedItem((Object)groupInfo.getRelatedType());
        }
        super.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    private void setTitle() {
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"112_OtherCostObjectEditUI"));
    }

    private void getCurrentCompany() throws EASBizException, BOSException {
        String companyid = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        if (companyid != null && !companyid.equals("")) {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            this.companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
            this.prmtCompany.setData((Object)this.companyInfo);
        } else {
            this.prmtCompany.setData(null);
        }
    }

    protected IObjectValue createNewData() {
        CostObjectInfo info = new CostObjectInfo();
        info.setCompany(this.companyInfo);
        info.setStandardRation(SysConstant.BIGZERO);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CostObjectFactory.getRemoteInstance();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        double standard;
        super.beforeStoreFields(e);
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            this.txtNumber.requestFocus();
            throw new DataBaseException(DataBaseException.NUMBERNOTNULL);
        }
        if (this.txtName.getSelectedItem() == null) {
            this.txtName.requestFocus();
            throw new CustomerSupplierException(CustomerSupplierException.NAMENOTNULL);
        }
        if (this.txtStandardRation.getText() != null && this.txtStandardRation.getText().trim().length() > 0 && (standard = Double.parseDouble(this.txtStandardRation.getText().trim().replaceAll(",", ""))) < 0.0) {
            this.txtStandardRation.requestFocus();
            String msg = EASResource.getString((String)resClassName, (String)"standardNegative");
            MsgBox.showError((String)msg);
            SysUtil.abort();
        }
    }

    protected void setFieldsNull(AbstractObjectValue value) {
        super.setFieldsNull(value);
        value.put("number", null);
    }
}

