/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CORelatedType;
import com.kingdee.eas.basedata.assistant.CostObjectEntryCollection;
import com.kingdee.eas.basedata.assistant.CostObjectEntryInfo;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectGroupInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.client.AbstractOverheadCostObjectEditUI;
import com.kingdee.eas.basedata.assistant.client.CostObjectListUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.IRefChecker;
import com.kingdee.eas.common.RefCheckerFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.util.HashSet;

public class OverheadCostObjectEditUI
extends AbstractOverheadCostObjectEditUI {
    private static final long serialVersionUID = 1495962817114398282L;
    protected CompanyOrgUnitInfo currCompany = null;

    public void onLoad() throws Exception {
        this.currCompany = SysContext.getSysContext().getCurrentFIUnit();
        if (this.currCompany == null || !this.currCompany.isIsBizUnit()) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.CostObjectResource", (String)"CannotOperationInVirtualOrgUnit"));
            SysUtil.abort();
        }
        this.table.checkParsed();
        super.onLoad();
        this.actionAddLine.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionRemoveLine.setVisible(false);
        if ("VIEW".equals(this.getOprtState())) {
            this.actionEdit.setVisible(false);
            this.actionSave.setVisible(false);
        }
        if ("ADDNEW".equals(this.getOprtState()) && this.table.getRowCount() < 1) {
            this.table.addRow();
        }
        this.initEntryTableListener();
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        CostObjectListUI costObjectListUI = (CostObjectListUI)((Object)this.getUIContext().get("Owner"));
        if (costObjectListUI.getSelectedTreeNode().getUserObject() != null && costObjectListUI.getSelectedTreeNode().getUserObject() instanceof CostObjectGroupInfo) {
            CostObjectGroupInfo groupInfo = (CostObjectGroupInfo)costObjectListUI.getSelectedTreeNode().getUserObject();
            this.editData.setCostObjectGroup(groupInfo);
        }
        super.storeFields();
        this.initOldData((IObjectValue)this.editData);
        if ("COPY".equals(this.getOprtState())) {
            ActionEvent event = (ActionEvent)this.getUIContext().get("ActionEvent");
            this.actionCopy_actionPerformed(event);
        }
    }

    private void initEntryTableListener() throws Exception {
        KDBizPromptBox prmtAUXOverhead = new KDBizPromptBox();
        ExtendParser AUXOverheadParser = new ExtendParser(prmtAUXOverhead);
        prmtAUXOverhead.setCommitParser((IParser)AUXOverheadParser);
        prmtAUXOverhead.setQueryInfo("com.kingdee.eas.basedata.ncm.app.AUXOverheadQuery");
        prmtAUXOverhead.setDisplayFormat("$number$");
        prmtAUXOverhead.setEditFormat("$number$");
        prmtAUXOverhead.setCommitFormat("$number$");
        prmtAUXOverhead.setVisible(true);
        prmtAUXOverhead.setEditable(false);
        prmtAUXOverhead.setRequired(true);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(this.getAUXOverheadFilter());
        prmtAUXOverhead.setEntityViewInfo(view);
        this.table.getColumn("RelatedNumber").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtAUXOverhead));
        prmtAUXOverhead.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                DataBaseInfo info;
                int rowIndex = OverheadCostObjectEditUI.this.table.getSelectManager().getActiveRowIndex();
                if (rowIndex < 0) {
                    SysUtil.abort();
                }
                IRow curRow = OverheadCostObjectEditUI.this.table.getRow(rowIndex);
                if (event.getNewValue() instanceof DataBaseInfo && (info = (DataBaseInfo)event.getNewValue()) != null) {
                    curRow.getCell("RelatedID").setValue((Object)info.getId());
                    curRow.getCell("RelatedNumber").setValue((Object)info.getNumber());
                    curRow.getCell("RelatedName").setValue((Object)info.getName());
                }
            }
        });
    }

    private FilterInfo getAUXOverheadFilter() throws Exception {
        FilterInfo filter = new FilterInfo();
        String companyId = this.currCompany.getId().toString();
        StringBuffer kSql = new StringBuffer();
        kSql.append(" SELECT DISTINCT aux.fid AS auxid \n");
        kSql.append(" FROM   t_ncm_auxoverhead aux \n");
        kSql.append("        INNER JOIN t_ncm_auxoverheadcompanyinfo auxcompany \n");
        kSql.append("          ON aux.fid = auxcompany.fauxoverheadid \n");
        kSql.append("        INNER JOIN t_org_costcenter costcenter \n");
        kSql.append("          ON auxcompany.fcostcenterid = costcenter.fid \n");
        kSql.append(" WHERE  auxcompany.fcompanyid = '" + companyId + "' \n");
        kSql.append("        AND NOT EXISTS (SELECT costobjectentry.fid \n");
        kSql.append("                        FROM   t_bd_costobjectentry costobjectentry \n");
        kSql.append("\t\t\t\t\t\t \t\tinner join t_bd_costobject costobject \n");
        kSql.append("\t\t\t\t\t\t\t\ton costobject.fid = costobjectentry.fparentid \n");
        kSql.append("                        WHERE  costobjectentry.frelatedid = aux.fid \n");
        kSql.append("\t\t\t\t\t\t\t\tand costobject.fcompanyid = '" + companyId + "')\n");
        ISQLExecutor executor = SQLExecutorFactory.getRemoteInstance((String)kSql.toString());
        IRowSet rows = executor.executeSQL();
        if (rows == null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"##########", CompareType.EQUALS));
            return filter;
        }
        HashSet<String> auxIds = new HashSet<String>();
        while (rows.next()) {
            auxIds.add(rows.getString("auxid"));
        }
        if (auxIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", auxIds, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"##########", CompareType.EQUALS));
        }
        return filter;
    }

    protected IObjectValue createNewData() {
        CostObjectInfo info = new CostObjectInfo();
        info.setRelatedType(CORelatedType.Overhead);
        info.setCompany(this.currCompany);
        info.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        info.setIsSys(false);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CostObjectFactory.getRemoteInstance();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if ("COPY".equals(this.getOprtState())) {
            return;
        }
        try {
            IRefChecker checker;
            this.loadEntrysFields(this.editData);
            if ("EDIT".equals(this.getOprtState()) && (checker = RefCheckerFactory.getRemoteInstance()).isReferenced(this.editData.getEntries().get(0).getRelatedID())) {
                this.numberText.setEditable(false);
                this.table.setEditable(false);
            }
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    protected void loadEntrysFields(CostObjectInfo costObjectInfo) throws BOSException, EASBizException {
        if (costObjectInfo != null) {
            CostObjectEntryCollection entrys = costObjectInfo.getEntries();
            this.table.removeRows();
            if (entrys.size() == 0) {
                this.table.addRow();
                return;
            }
            for (int i = 0; i < entrys.size(); ++i) {
                CostObjectEntryInfo entryInfo = entrys.get(i);
                IRow row = this.table.addRow();
                row.getCell("RelatedID").setValue((Object)entryInfo.getRelatedID());
                row.getCell("RelatedNumber").setValue((Object)entryInfo.getRelatedNumber());
                row.getCell("RelatedName").setValue((Object)entryInfo.getRelatedName());
            }
        }
    }

    @Override
    public void storeFields() {
        this.editData.getEntries().clear();
        super.storeFields();
        this.storeEntrysFields(this.editData);
    }

    protected void storeEntrysFields(CostObjectInfo costObjectInfo) {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            CostObjectEntryInfo entryInfo = new CostObjectEntryInfo();
            IRow row = this.table.getRow(i);
            entryInfo.setParent(costObjectInfo);
            entryInfo.setRelatedID(BOSUuid.read((String)row.getCell("RelatedID").getValue().toString()));
            entryInfo.setRelatedNumber(row.getCell("RelatedNumber").getValue().toString());
            entryInfo.setRelatedName(row.getCell("RelatedName").getValue().toString());
            if (costObjectInfo.getRelatedId() == null || StringUtils.isEmpty((String)costObjectInfo.getRelatedId().toString())) {
                costObjectInfo.setRelatedId(BOSUuid.read((String)row.getCell("RelatedID").getValue().toString()));
                costObjectInfo.setRelatedName(row.getCell("RelatedName").getValue().toString());
            }
            costObjectInfo.getEntries().add(entryInfo);
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (UIRuleUtil.isNull((String)this.numberText.getText())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.numberLabelContainer.getBoundLabelText()});
        }
        if (UIRuleUtil.isNull((Object)((MultiLangItem)this.nameMultiLangBox.getDefaultLangItemData()).getData())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.nameLabelContainer.getBoundLabelText()});
        }
        int entryCounter = this.table.getRowCount();
        if (entryCounter <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"113_OverheadCostObjectEditUI"));
            SysUtil.abort();
        }
        if (entryCounter > 1) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"114_OverheadCostObjectEditUI"));
            SysUtil.abort();
        }
        if (UIRuleUtil.isNull((Object)this.table.getRow(0).getCell("RelatedNumber").getValue())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"115_OverheadCostObjectEditUI"));
            SysUtil.abort();
        }
        if (UIRuleUtil.isNull((Object)this.table.getRow(0).getCell("RelatedName").getValue())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"116_OverheadCostObjectEditUI"));
            SysUtil.abort();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("relatedType"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("entries.RelatedID"));
        sic.add(new SelectorItemInfo("entries.RelatedNumber"));
        sic.add(new SelectorItemInfo("entries.RelatedName"));
        sic.add(new SelectorItemInfo("CostObjectGroup.*"));
        return sic;
    }

    public boolean isModify() {
        int countOld;
        if (this.editData == null) {
            return false;
        }
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            this.handleControlException();
            this.abort();
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        if ("COPY".equals(this.getOprtState())) {
            return false;
        }
        if (!StringUtils.equals((String)this.editData.getNumber(), (String)this.numberText.getText())) {
            return true;
        }
        if (!StringUtils.equals((String)this.editData.getName(), (String)((String)this.nameMultiLangBox.getSelectedItemData()))) {
            return true;
        }
        if (!StringUtils.equals((String)this.editData.getDescription(), (String)((String)this.commentMultiLangArea.getSelectedItemData()))) {
            return true;
        }
        CostObjectEntryCollection newCollection = this.editData.getEntries();
        int countNew = newCollection.size();
        if (countNew != (countOld = this.table.getRowCount())) {
            return true;
        }
        if (countNew == 1) {
            CostObjectEntryInfo tempNew = newCollection.get(0);
            Object relatedNumber = this.table.getRow(0).getCell("RelatedNumber").getValue();
            if (relatedNumber instanceof DataBaseInfo) {
                relatedNumber = ((DataBaseInfo)relatedNumber).getNumber();
            }
            if (!StringUtils.equals((String)tempNew.getRelatedNumber(), (String)((String)relatedNumber))) {
                return true;
            }
        }
        return false;
    }

    protected void setFieldsNull(AbstractObjectValue value) {
        super.setFieldsNull(value);
        value.put("number", null);
        CostObjectInfo info = (CostObjectInfo)value;
        if (info.getEntries() != null && info.getEntries().size() > 0) {
            for (int i = 0; i < info.getEntries().size(); ++i) {
                info.getEntries().get(i).setRelatedID(null);
                info.getEntries().get(i).setRelatedNumber(null);
                info.getEntries().get(i).setRelatedName(null);
            }
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.initEntryTableListener();
    }
}

